/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.iff.Superchunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabeledTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.MessageConstants;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import java.io.DataInputStream;
import java.io.IOException;

public class AssocDataListChunk
extends Superchunk {
    private static final int TYPE_LENGTH = 4;

    public AssocDataListChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm, RepInfo info) {
        super(module, hdr, dstrm, info);
    }

    public boolean readChunk(RepInfo info) throws IOException {
        ChunkHeader chunkh;
        WaveModule module = (WaveModule)this._module;
        String typeID = module.read4Chars(this._dstream);
        this.bytesLeft -= 4L;
        if (!"adtl".equals(typeID)) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_9, String.format(MessageConstants.WAVE_HUL_9_SUB.getMessage(), typeID), this._module.getNByte() - 4L));
            info.setWellFormed(false);
            return false;
        }
        while ((chunkh = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String id = chunkh.getID();
            int chunkSize = (int)chunkh.getSize();
            if ("labl".equals(id)) {
                chunk = new LabelChunk(this._module, chunkh, this._dstream);
            } else if ("note".equals(id)) {
                chunk = new NoteChunk(this._module, chunkh, this._dstream);
            } else if ("ltxt".equals(id)) {
                chunk = new LabeledTextChunk(this._module, chunkh, this._dstream);
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, (long)chunkSize, this._module);
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.WAVE_HUL_10.getId(), (String)String.format(MessageConstants.WAVE_HUL_10.getMessage(), id));
                info.setMessage((Message)new InfoMessage(message));
                continue;
            }
            if (chunk.readChunk(info)) continue;
            return false;
        }
        return true;
    }
}

