/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CartChunk
extends Chunk {
    private static final int N_TIMER_TAGS = 8;

    public CartChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        byte[] buf4 = new byte[4];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf4, (ModuleBase)module);
        String version = this.byteBufString(buf4);
        byte[] buf64 = new byte[64];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String title = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String artist = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String cutID = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String clientID = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String category = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String classification = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String outCue = this.byteBufString(buf64);
        byte[] buf10 = new byte[10];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf10, (ModuleBase)module);
        String startDate = this.byteBufString(buf10);
        byte[] buf8 = new byte[8];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf8, (ModuleBase)module);
        String startTime = this.byteBufString(buf8);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf10, (ModuleBase)module);
        String endDate = this.byteBufString(buf10);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf8, (ModuleBase)module);
        String endTime = this.byteBufString(buf8);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String producerAppID = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String producerAppVersion = this.byteBufString(buf64);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
        String userDef = this.byteBufString(buf64);
        int levelReference = module.readSignedInt(this._dstream);
        ArrayList<Property> timerTags = new ArrayList<Property>(8);
        for (int i = 0; i < 8; ++i) {
            String timerTagUsage = module.read4Chars(this._dstream).trim();
            long timerTagValue = module.readUnsignedInt(this._dstream);
            if (timerTagUsage.length() <= 0) continue;
            Property[] ttprop = new Property[]{new Property("Usage", PropertyType.STRING, (Object)timerTagUsage), new Property("Value", PropertyType.LONG, (Object)new Long(timerTagValue))};
            timerTags.add(new Property("PostTimer", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)ttprop));
        }
        module.skipBytes(this._dstream, 276L, module);
        byte[] buf1k = new byte[1024];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf1k, (ModuleBase)module);
        String url = this.byteBufString(buf1k);
        String tagText = "";
        if (this.bytesLeft > 2048L) {
            byte[] bufTagText = new byte[(int)this.bytesLeft - 2048];
            ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])bufTagText, (ModuleBase)module);
            tagText = this.byteBufString(bufTagText);
        }
        ArrayList<Property> plist = new ArrayList<Property>(20);
        if (version.length() > 0) {
            plist.add(new Property("Version", PropertyType.STRING, (Object)version));
        }
        if (title.length() > 0) {
            plist.add(new Property("Title", PropertyType.STRING, (Object)title));
        }
        if (artist.length() > 0) {
            plist.add(new Property("Artist", PropertyType.STRING, (Object)artist));
        }
        if (cutID.length() > 0) {
            plist.add(new Property("CutID", PropertyType.STRING, (Object)cutID));
        }
        if (clientID.length() > 0) {
            plist.add(new Property("ClientID", PropertyType.STRING, (Object)clientID));
        }
        if (category.length() > 0) {
            plist.add(new Property("Category", PropertyType.STRING, (Object)category));
        }
        if (classification.length() > 0) {
            plist.add(new Property("Classification", PropertyType.STRING, (Object)classification));
        }
        if (outCue.length() > 0) {
            plist.add(new Property("OutCue", PropertyType.STRING, (Object)outCue));
        }
        if (startDate.length() > 0) {
            plist.add(new Property("StartDate", PropertyType.STRING, (Object)startDate));
        }
        if (startTime.length() > 0) {
            plist.add(new Property("StartTime", PropertyType.STRING, (Object)startTime));
        }
        if (endDate.length() > 0) {
            plist.add(new Property("EndDate", PropertyType.STRING, (Object)endDate));
        }
        if (endTime.length() > 0) {
            plist.add(new Property("EndTime", PropertyType.STRING, (Object)startTime));
        }
        if (producerAppID.length() > 0) {
            plist.add(new Property("ProducerAppID", PropertyType.STRING, (Object)producerAppID));
        }
        if (producerAppVersion.length() > 0) {
            plist.add(new Property("ProducerAppVersion", PropertyType.STRING, (Object)producerAppVersion));
        }
        if (userDef.length() > 0) {
            plist.add(new Property("UserDef", PropertyType.STRING, (Object)userDef));
        }
        plist.add(new Property("LevelReference", PropertyType.INTEGER, (Object)new Integer(levelReference)));
        if (timerTags.size() > 0) {
            plist.add(new Property("PostTimers", PropertyType.PROPERTY, PropertyArity.LIST, timerTags));
        }
        if (url.length() > 0) {
            plist.add(new Property("URL", PropertyType.STRING, (Object)url));
        }
        if (tagText.length() > 0) {
            plist.add(new Property("TagText", PropertyType.STRING, (Object)tagText));
        }
        module.addWaveProperty(new Property("Cart", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        return true;
    }
}

