/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CueChunk
extends Chunk {
    public CueChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        int nPoints = (int)module.readUnsignedInt(this._dstream);
        ArrayList<Property> points = new ArrayList<Property>(nPoints);
        for (int i = 0; i < nPoints; ++i) {
            long dwIdent = module.readUnsignedInt(this._dstream);
            long dwPos = module.readUnsignedInt(this._dstream);
            String fccID = module.read4Chars(this._dstream);
            long dwChunkStart = module.readUnsignedInt(this._dstream);
            long dwBlockStart = module.readUnsignedInt(this._dstream);
            long dwSampleOffset = module.readUnsignedInt(this._dstream);
            Property[] cueProps = new Property[]{new Property("ID", PropertyType.LONG, (Object)dwIdent), new Property("Position", PropertyType.LONG, (Object)dwPos), new Property("DataChunkID", PropertyType.STRING, (Object)fccID), new Property("ChunkStart", PropertyType.LONG, (Object)dwChunkStart), new Property("BlockStart", PropertyType.LONG, (Object)dwBlockStart), new Property("SampleOffset", PropertyType.LONG, (Object)dwSampleOffset)};
            points.add(new Property("CuePoint", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)cueProps));
        }
        module.addWaveProperty(new Property("CuePoints", PropertyType.PROPERTY, PropertyArity.LIST, points));
        return true;
    }
}

