/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class DataSize64Chunk
extends Chunk {
    private static final int MINIMUM_CHUNK_LENGTH = 24;

    public DataSize64Chunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        long riffSize = module.readSignedLong(this._dstream);
        module.setExtendedRiffSize(riffSize);
        long dataSize = module.readSignedLong(this._dstream);
        module.addExtendedChunkSize("data", dataSize);
        long sampleCount = module.readSignedLong(this._dstream);
        module.setExtendedSampleLength(sampleCount);
        if (this.chunkSize > 24L) {
            long tableSize = module.readUnsignedInt(this._dstream);
            int i = 0;
            while ((long)i < tableSize) {
                String chunkId = module.read4Chars(this._dstream);
                long chunkSize = module.readSignedLong(this._dstream);
                module.addExtendedChunkSize(chunkId, chunkSize);
                ++i;
            }
        }
        return true;
    }
}

