/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoChunk;
import edu.harvard.hul.ois.jhove.module.wave.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;

public class ListInfoTextChunk
extends Chunk {
    private ListInfoChunk _parent;
    private List _listInfoProps;
    String _chunkID;

    public ListInfoTextChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm, List listInfoProps, ListInfoChunk parent) {
        super(module, hdr, dstrm);
        this._parent = parent;
        this._chunkID = hdr.getID();
        this._listInfoProps = listInfoProps;
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        byte[] buf = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        String txt = new String(buf);
        txt = txt.trim();
        String propName = null;
        if ("IARL".equals(this._chunkID)) {
            propName = "ArchivalLocation";
        } else if ("IART".equals(this._chunkID)) {
            propName = "Artist";
        } else if ("ICMS".equals(this._chunkID)) {
            propName = "Commissioned";
        } else if ("ICMT".equals(this._chunkID)) {
            propName = "Comments";
        } else if ("ICOP".equals(this._chunkID)) {
            propName = "Copyright";
        } else if ("ICRD".equals(this._chunkID)) {
            propName = "CreationDate";
        } else if ("ICRP".equals(this._chunkID)) {
            propName = "Cropped";
        } else if ("IDIM".equals(this._chunkID)) {
            propName = "Dimensions";
        } else if ("IDPI".equals(this._chunkID)) {
            propName = "DotsPerInch";
        } else if ("IENG".equals(this._chunkID)) {
            propName = "Engineer";
        } else if ("IGNR".equals(this._chunkID)) {
            propName = "Genre";
        } else if ("IKEY".equals(this._chunkID)) {
            propName = "Keywords";
        } else if ("ILGT".equals(this._chunkID)) {
            propName = "Lightness";
        } else if ("IMED".equals(this._chunkID)) {
            propName = "Medium";
        } else if ("INAM".equals(this._chunkID)) {
            propName = "Name";
        } else if ("IPLT".equals(this._chunkID)) {
            propName = "PaletteSetting";
        } else if ("IPRD".equals(this._chunkID)) {
            propName = "Product";
        } else if ("ISBJ".equals(this._chunkID)) {
            propName = "Subject";
        } else if ("ISFT".equals(this._chunkID)) {
            propName = "Software";
        } else if ("ISHP".equals(this._chunkID)) {
            propName = "Sharpness";
        } else if ("ISRC".equals(this._chunkID)) {
            propName = "Source";
        } else if ("ISRF".equals(this._chunkID)) {
            propName = "SourceForm";
        } else if ("ITCH".equals(this._chunkID)) {
            propName = "Technician";
        }
        if (propName != null) {
            this._listInfoProps.add(new Property(propName, PropertyType.STRING, (Object)txt));
        } else {
            JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.WAVE_HUL_19.getId(), (String)String.format(MessageConstants.WAVE_HUL_19.getMessage(), this._chunkID));
            info.setMessage((Message)new InfoMessage(message));
        }
        return true;
    }
}

