/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova;

import com.easyinnova.tiff.io.TiffInputStream;
import com.easyinnova.tiff.model.ReadIccConfigIOException;
import com.easyinnova.tiff.model.ReadTagsIOException;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.model.TiffObject;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.profiles.TiffEPProfile;
import com.easyinnova.tiff.profiles.TiffITProfile;
import com.easyinnova.tiff.reader.TiffReader;
import com.easyinnova.tiff.writer.TiffWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TiffReaderWriter {
    public static void main(String[] args) throws IOException {
        boolean args_error;
        ArrayList<String> files = new ArrayList<String>();
        String output_file = null;
        boolean bl = args_error = args.length == 0;
        for (int i = 0; i < args.length && !args_error; ++i) {
            String arg = args[i];
            if (arg == "-o") {
                if (i + 1 < args.length) {
                    output_file = args[++i];
                    continue;
                }
                args_error = true;
                continue;
            }
            if (arg == "-help") {
                TiffReaderWriter.displayHelp();
                break;
            }
            if (arg.startsWith("-")) {
                args_error = true;
                continue;
            }
            File f = new File(arg);
            if (f.isFile()) {
                files.add(arg);
                continue;
            }
            if (!f.isDirectory()) continue;
            File[] listOfFiles = f.listFiles();
            for (int j = 0; j < listOfFiles.length; ++j) {
                if (!listOfFiles[j].isFile()) continue;
                files.add(listOfFiles[j].getPath());
            }
        }
        if (args_error) {
            TiffReaderWriter.displayHelp();
        } else {
            for (String filename : files) {
                try {
                    TiffReader tr = new TiffReader();
                    int result = tr.readFile(filename, true);
                    TiffReaderWriter.reportResults(tr, result, filename, output_file);
                    TiffInputStream inputdata = new TiffInputStream(new File(filename));
                    TiffWriter tw = new TiffWriter(inputdata);
                    TiffDocument tm = tr.getModel();
                    int[] val = new int[]{2, 1};
                    tw.SetModel(tm);
                    String filenameout = "out.tif";
                    try {
                        tw.write(filenameout);
                        System.out.println("File '" + filenameout + "' written successfully");
                    }
                    catch (Exception exception) {
                    }
                }
                catch (ReadTagsIOException e) {
                    System.out.println("Error loading TIFF dependencies");
                }
                catch (ReadIccConfigIOException e) {
                    System.out.println("Error loading ICC Profile dependencies");
                }
            }
            System.out.println("Finished");
        }
    }

    private static void reportResults(TiffReader tiffReader, int result, String filename, String output_file) {
        TiffDocument to = tiffReader.getModel();
        if (output_file == null) {
            switch (result) {
                case -1: {
                    System.out.println("File '" + filename + "' does not exist");
                    break;
                }
                case -2: {
                    System.out.println("IO Exception in file '" + filename + "'");
                    break;
                }
                case 0: {
                    if (tiffReader.getBaselineValidation().correct) {
                        System.out.println("Everything ok in file '" + filename + "'");
                        System.out.println("IFDs: " + to.getIfdCount());
                        System.out.println("SubIFDs: " + to.getSubIfdCount());
                        to.printMetadata();
                        TiffEPProfile bpep = new TiffEPProfile(to);
                        bpep.validate();
                        bpep.getValidation().printErrors();
                        TiffITProfile bpit = new TiffITProfile(to, 0);
                        bpit.validate();
                        bpit.getValidation().printErrors();
                        int nifd = 1;
                        for (TiffObject o : to.getImageIfds()) {
                            IFD ifd = (IFD)o;
                            if (ifd == null) continue;
                            System.out.println("IFD " + nifd++ + " TAGS:");
                            ifd.printTags();
                        }
                    } else {
                        System.out.println("Errors in file '" + filename + "'");
                        if (to != null) {
                            System.out.println("IFDs: " + to.getIfdCount());
                            System.out.println("SubIFDs: " + to.getSubIfdCount());
                            to.printMetadata();
                        }
                        tiffReader.getBaselineValidation().printErrors();
                    }
                    tiffReader.getBaselineValidation().printWarnings();
                    break;
                }
                default: {
                    System.out.println("Unknown result (" + result + ") in file '" + filename + "'");
                }
            }
        }
    }

    static void displayHelp() {
        System.out.println("Usage: TiffReader [options] <file1> <file2> ... <fileN>");
        System.out.println("Options: -help displays help");
    }
}

