/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker.rules;

import com.easyinnova.implementation_checker.model.TiffNode;
import com.easyinnova.implementation_checker.model.TiffTag;
import com.easyinnova.implementation_checker.rules.Filter;
import java.util.List;

public class RuleElement {
    String fieldName;
    String index;
    Filter filter;
    TiffNode node;
    TiffNode model;
    public boolean valid = true;
    String multiplier;
    String elevator;

    public RuleElement(String field, TiffNode nodeBase, TiffNode model) {
        this.node = nodeBase;
        this.model = model;
        this.filter = null;
        this.fieldName = field;
        if (this.fieldName.contains("*")) {
            this.multiplier = this.fieldName.substring(0, this.fieldName.indexOf("*"));
            this.fieldName = this.fieldName.substring(this.fieldName.indexOf("*") + 1);
        }
        if (this.fieldName.contains("^")) {
            this.elevator = this.fieldName.substring(0, this.fieldName.indexOf("^"));
            this.fieldName = this.fieldName.substring(this.fieldName.indexOf("^") + 1);
        }
        if (!this.fieldName.startsWith("$") && !this.fieldName.startsWith("'")) {
            while (this.fieldName.contains(".") || this.fieldName.contains("[") || this.fieldName.contains("(")) {
                String remaining;
                String filter;
                int indexDot = this.fieldName.indexOf(".");
                int indexCla = this.fieldName.indexOf("[");
                int indexPar = this.fieldName.indexOf("(");
                if (!(indexDot <= -1 || indexCla != -1 && indexDot >= indexCla || indexPar != -1 && indexDot >= indexPar)) {
                    if (indexDot == 0) {
                        if (this.node != null) {
                            this.fieldName = this.fieldName.substring(1);
                            this.filter = null;
                            continue;
                        }
                        this.valid = false;
                        break;
                    }
                    String parent = this.fieldName.substring(0, indexDot);
                    if (parent.length() > 0) {
                        if (this.node != null) {
                            this.node = this.node.getChild(parent);
                        } else {
                            this.valid = false;
                            break;
                        }
                    }
                    this.fieldName = this.fieldName.substring(indexDot + 1);
                    continue;
                }
                if (indexCla > -1 && (indexPar == -1 || indexCla < indexPar)) {
                    filter = this.fieldName.substring(indexCla + 1);
                    remaining = filter.substring(filter.indexOf("]") + 1).trim();
                    filter = filter.substring(0, filter.indexOf("]")).trim();
                    this.filter = new Filter(filter);
                    String currentfield = this.fieldName.substring(0, indexCla).trim();
                    if (remaining.length() == 0) {
                        this.fieldName = currentfield;
                        continue;
                    }
                    if (this.node == null) {
                        this.valid = false;
                        break;
                    }
                    this.node = this.node.getChild(currentfield, this.filter);
                    this.filter = null;
                    this.fieldName = remaining;
                    continue;
                }
                filter = this.fieldName.substring(indexPar + 1);
                remaining = filter.substring(filter.indexOf(")") + 1).trim();
                this.index = filter.substring(0, filter.indexOf(")")).trim();
                this.fieldName = remaining;
            }
        }
    }

    String getName() {
        String val = this.fieldName;
        if (this.fieldName.contains("%")) {
            val = val.substring(0, val.indexOf("%"));
        }
        if (this.fieldName.contains("*")) {
            val = val.substring(0, val.indexOf("*"));
        }
        return val.trim();
    }

    String operate(String value) {
        String op;
        String val = value;
        if (this.fieldName.contains("%")) {
            op = this.fieldName.substring(this.fieldName.indexOf("%") + 1);
            val = Integer.parseInt(value) % Integer.parseInt(op) + "";
        }
        if (this.fieldName.contains("*")) {
            op = this.fieldName.substring(this.fieldName.indexOf("*") + 1);
            val = Integer.parseInt(value) * Integer.parseInt(op) + "";
        }
        return val;
    }

    public List<TiffNode> getChildren() {
        if (this.node == null) {
            return null;
        }
        return this.node.getChildren(this.getName(), this.filter);
    }

    String operateMultiplier(String val) {
        String value = val;
        if (this.elevator != null) {
            value = (int)Math.pow(Double.parseDouble(this.elevator), Double.parseDouble(val)) + "";
        }
        if (this.multiplier != null) {
            value = (int)(Double.parseDouble(value) * (double)Integer.parseInt(this.multiplier)) + "";
        }
        return value;
    }

    public String getValue() {
        if (this.fieldName.startsWith("$") && this.fieldName.endsWith("$")) {
            String[] parts;
            String val = this.fieldName.replace("$", "");
            TiffNode node = null;
            for (String nodeName : parts = val.split("\\.")) {
                if (node == null) {
                    if (this.model == null) {
                        this.model.toString();
                    }
                    if (this.model.getContext().equals(nodeName)) {
                        node = this.model;
                    }
                } else {
                    node = node.getChild(nodeName);
                }
                if (node != null) continue;
                return null;
            }
            val = node.getValue();
            return this.operateMultiplier(val);
        }
        if (this.fieldName.startsWith("'") && this.fieldName.endsWith("'")) {
            String val = this.fieldName.substring(1);
            val = val.substring(0, val.length() - 1);
            return this.operateMultiplier(val);
        }
        try {
            int ival = Integer.parseInt(this.fieldName);
            return this.operateMultiplier(ival + "");
        }
        catch (Exception ival) {
            if (this.fieldName.equals("true") || this.fieldName.equals("false")) {
                return this.fieldName;
            }
            if (this.node == null) {
                return null;
            }
            if (this.index != null) {
                TiffTag ttag = (TiffTag)this.node;
                String tagvalue = ttag.getValue().replace("[", "").replace("]", "");
                return tagvalue.split(",")[Integer.parseInt(this.index)];
            }
            if (!this.node.hasChild(this.getName(), this.filter)) {
                if (this.getName().equals("class") && this.node.getValue().contains(":")) {
                    return this.node.getValue().substring(0, this.node.getValue().indexOf(":"));
                }
                if (this.getName().equals("description") && this.node.getValue().contains(":")) {
                    return this.node.getValue().substring(this.node.getValue().indexOf(":") + 1);
                }
                return null;
            }
            String op1value = this.node.getChild(this.getName(), this.filter).getValue();
            String value = this.operate(op1value);
            if (value != null) {
                if (value.contains("/")) {
                    try {
                        int inum = Integer.parseInt(value.substring(0, value.indexOf("/")));
                        int iden = Integer.parseInt(value.substring(value.indexOf("/") + 1));
                        if (inum == 0 && iden == 0) {
                            return "0";
                        }
                        return (float)inum / (float)iden + "";
                    }
                    catch (Exception inum) {
                        // empty catch block
                    }
                }
                if (value.startsWith("[") && value.endsWith("]")) {
                    String val = value.substring(1);
                    val = val.substring(0, val.length() - 1);
                    value = val = val.split(",")[0];
                }
            } else {
                value = "";
            }
            return this.operateMultiplier(value);
        }
    }
}

