/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker.rules.model;

import com.easyinnova.implementation_checker.rules.model.IncludeType;
import com.easyinnova.implementation_checker.rules.model.RulesType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlRootElement(name="implementationCheckerObject")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="implementationCheckerObjectType", propOrder={"title", "iso", "description", "version", "author", "date", "include", "rules"})
public class ImplementationCheckerObjectType {
    @XmlElement(required=true)
    protected String title;
    @XmlElement(required=true)
    protected String iso;
    @XmlElement(required=true)
    protected String description;
    @XmlElement(required=true)
    protected String version;
    @XmlElement(required=true)
    protected String author;
    @XmlElement(required=true)
    @XmlSchemaType(name="date")
    protected XMLGregorianCalendar date;
    protected List<IncludeType> include;
    @XmlElement(required=true)
    protected List<RulesType> rules;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getIso() {
        return this.iso;
    }

    public void setIso(String value) {
        this.iso = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = value;
    }

    public XMLGregorianCalendar getDate() {
        return this.date;
    }

    public void setDate(XMLGregorianCalendar value) {
        this.date = value;
    }

    public List<IncludeType> getInclude() {
        if (this.include == null) {
            this.include = new ArrayList<IncludeType>();
        }
        return this.include;
    }

    public List<RulesType> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<RulesType>();
        }
        return this.rules;
    }

    public List<RulesType> getOwnRules() {
        ArrayList<RulesType> ownRules = new ArrayList<RulesType>();
        if (this.rules != null) {
            for (RulesType rule : this.rules) {
                if (rule.isIncluded()) continue;
                ownRules.add(rule);
            }
        }
        return ownRules;
    }

    public void removeRule(String id) {
        RulesType delete = null;
        for (RulesType rulesType : this.rules) {
            if (!rulesType.getId().equals(id)) continue;
            delete = rulesType;
        }
        if (delete != null) {
            this.rules.remove(delete);
        }
    }

    public RulesType getRulesById(String id) {
        for (RulesType rulesType : this.rules) {
            if (!rulesType.getId().equals(id)) continue;
            return rulesType;
        }
        return null;
    }

    public void makeCopy(ImplementationCheckerObjectType copy) {
        this.title = copy.getTitle();
        this.iso = copy.getIso();
        this.author = copy.getAuthor();
        this.description = copy.getDescription();
        this.version = copy.getVersion();
        this.date = copy.getDate();
        this.include = new ArrayList<IncludeType>();
        this.include.addAll(copy.getInclude());
        this.rules = new ArrayList<RulesType>();
        this.rules.addAll(copy.getRules());
    }

    public void removeIncludedRules() {
        this.rules = this.getOwnRules();
    }
}

