/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker.rules.model;

import com.easyinnova.implementation_checker.rules.model.AssertType;
import com.easyinnova.implementation_checker.rules.model.ReferenceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ruleType", propOrder={"title", "description", "reference", "_assert"})
public class RuleType
implements Serializable {
    @XmlElement(required=true)
    protected Title title;
    @XmlElement(required=true)
    protected Description description;
    @XmlElement(required=true)
    protected List<ReferenceType> reference;
    @XmlElement(name="assert", required=true)
    protected AssertType _assert;
    @XmlAttribute(name="id", required=true)
    protected String id;
    @XmlAttribute(name="context", required=true)
    protected String context;
    @XmlAttribute(name="level", required=true)
    protected String level;
    @XmlAttribute(name="experimental")
    protected boolean experimental;

    public boolean isCritical() {
        return this.getLevel() != null && this.getLevel().equals("critical");
    }

    public boolean isWarning() {
        return this.getLevel() != null && this.getLevel().equals("warning");
    }

    public boolean isError() {
        return this.getLevel() != null && this.getLevel().equals("error");
    }

    public boolean isInfo() {
        return this.getLevel() != null && this.getLevel().equals("info");
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title value) {
        this.title = value;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description value) {
        this.description = value;
    }

    public List<ReferenceType> getReference() {
        if (this.reference == null) {
            this.reference = new ArrayList<ReferenceType>();
        }
        return this.reference;
    }

    public String getReferenceText() {
        String s = "";
        for (ReferenceType ref : this.getReference()) {
            String refPage;
            if (s.length() > 0) {
                s = s + "\n";
            }
            if (ref.getDocument() != null && ref.getDocument().toString().length() > 0) {
                s = s + ref.getDocument().toString() + ": ";
            }
            if (!ref.getSection().isEmpty()) {
                s = s + ref.getSection() + ". ";
            }
            if ((refPage = ref.getPage()) == null) {
                refPage = ref.getPages();
            }
            if (refPage == null) {
                refPage = "";
            }
            s = s + "Page " + refPage;
        }
        return s;
    }

    public AssertType getAssert() {
        return this._assert;
    }

    public void setAssert(AssertType value) {
        this._assert = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String value) {
        this.context = value;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String value) {
        this.level = value;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"value"})
    public static class Title
    implements Serializable {
        @XmlValue
        protected String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"value"})
    public static class Description
    implements Serializable {
        @XmlValue
        protected String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

