/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import com.easyinnova.tiff.io.TiffInputStream;
import java.io.IOException;

public class InputBuffer {
    private byte[] buffer;
    private int maxBufferSize = 100000;
    private int currentBufferSize;
    private long bufferOffset;
    private TiffInputStream input;

    public InputBuffer(TiffInputStream input) {
        this.input = input;
        this.bufferOffset = 0L;
        this.currentBufferSize = 0;
        if (this.maxBufferSize >= 0) {
            this.buffer = new byte[this.maxBufferSize];
        }
    }

    private boolean checkBuffer(long offset) throws IOException {
        if (offset - this.bufferOffset < 0L || offset - this.bufferOffset >= (long)this.currentBufferSize) {
            this.bufferOffset = offset;
            int index = 0;
            this.input.seek(offset);
            try {
                for (long pos = offset; pos < offset + (long)this.maxBufferSize; ++pos) {
                    int ch = this.input.read();
                    if (ch <= -1) continue;
                    this.buffer[index] = (byte)ch;
                    ++index;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.currentBufferSize = index;
            return true;
        }
        return false;
    }

    public void seek(long offset) throws IOException {
        if (this.maxBufferSize <= 0) {
            this.input.seek(offset);
        } else {
            this.checkBuffer(offset);
        }
    }

    public int read(long offset) throws IOException {
        int b;
        if (this.maxBufferSize <= 0) {
            b = this.input.read();
        } else {
            this.checkBuffer(offset);
            b = this.buffer[(int)(offset - this.bufferOffset)];
        }
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public byte readByte(long offset) throws IOException {
        byte b;
        if (this.maxBufferSize <= 0) {
            b = (byte)this.input.read();
        } else {
            if (this.checkBuffer(offset)) {
                // empty if block
            }
            b = this.buffer[(int)(offset - this.bufferOffset)];
        }
        return b;
    }

    public boolean seekSuccessful(long offset) {
        return offset - this.bufferOffset >= 0L && offset - this.bufferOffset < (long)this.currentBufferSize;
    }
}

