/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private final RandomAccessFile randomAccessFile;
    private long limit = -1L;
    private String path;

    public RandomAccessFileInputStream(File file) throws FileNotFoundException {
        this.path = file.getPath();
        this.randomAccessFile = new RandomAccessFile(file, "r");
    }

    public RandomAccessFileInputStream(RandomAccessFile raf) throws FileNotFoundException {
        this(raf, "");
    }

    public RandomAccessFileInputStream(RandomAccessFile raf, String path) throws FileNotFoundException {
        this.path = path;
        this.randomAccessFile = raf;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.randomAccessFile.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomAccessFile.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        long a = (this.limit >= 0L ? Math.min(this.limit, this.randomAccessFile.length()) : this.randomAccessFile.length()) - this.randomAccessFile.getFilePointer();
        return (int)Math.min(Integer.MAX_VALUE, Math.max(a, 0L));
    }

    @Override
    public synchronized void reset() throws IOException {
        this.limit = -1L;
        this.randomAccessFile.seek(0L);
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    public void seek(long pos) throws IOException {
        this.randomAccessFile.seek(pos);
    }

    public void limit(long limit) {
        this.limit = limit;
    }

    public long size() {
        try {
            return this.randomAccessFile.length();
        }
        catch (Exception ex) {
            return 0L;
        }
    }
}

