/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.model.MetadataObject;
import com.easyinnova.tiff.model.TiffObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Metadata
implements Serializable {
    private static final long serialVersionUID = 2946L;
    private HashMap<String, MetadataObject> metadata = new HashMap();

    public void add(String name, TiffObject value, String path, String schema) {
        if (!this.metadata.containsKey(name)) {
            this.metadata.put(name, new MetadataObject());
        }
        this.metadata.get(name).getObjectList().add(value);
        this.metadata.get(name).setPath(path);
        this.metadata.get(name).setSchema(schema);
    }

    public void add(String name, TiffObject value) {
        if (!this.metadata.containsKey(name)) {
            this.metadata.put(name, new MetadataObject());
        }
        this.metadata.get(name).getObjectList().add(value);
    }

    public void add(String name, TiffObject value, boolean isDC, String path) {
        if (!this.metadata.containsKey(name)) {
            this.metadata.put(name, new MetadataObject());
            this.metadata.get(name).setIsDublinCore(isDC);
            this.metadata.get(name).setPath(path);
        }
        this.metadata.get(name).getObjectList().add(value);
    }

    public boolean contains(String name) {
        return this.metadata.containsKey(name);
    }

    public TiffObject get(String name) {
        TiffObject result = null;
        String container = null;
        ArrayList<TiffObject> found = new ArrayList<TiffObject>();
        if (this.contains(name)) {
            if (this.metadata.get(name).getObjectList().size() == 1) {
                found.add(this.getFirst(name));
            } else {
                for (TiffObject to : this.metadata.get(name).getObjectList()) {
                    found.add(to);
                }
            }
        } else {
            for (String key : this.metadata.keySet()) {
                boolean similar = key.toLowerCase().equals(name.toLowerCase());
                if (!similar) {
                    boolean bl = similar = name.toLowerCase().equals("date") && key.toLowerCase().equals("datetime");
                }
                if (!similar) {
                    boolean bl = similar = name.toLowerCase().equals("date") && key.toLowerCase().equals("creatordate");
                }
                if (!similar) {
                    boolean bl = similar = name.toLowerCase().equals("description") && key.toLowerCase().equals("imagedescription");
                }
                if (!similar) {
                    boolean bl = similar = name.toLowerCase().equals("creator") && key.toLowerCase().equals("artist");
                }
                if (!similar) {
                    boolean bl = similar = name.toLowerCase().equals("creator") && key.toLowerCase().equals("creatortool");
                }
                if (!similar) continue;
                for (TiffObject to : this.metadata.get(key).getObjectList()) {
                    found.add(to);
                }
            }
        }
        if (found.size() == 1) {
            result = (TiffObject)found.get(0);
        } else {
            for (TiffObject to : found) {
                if (result == null) {
                    result = to;
                    container = to.getContainer();
                    continue;
                }
                if (to.getContainer() == null || container != null && !to.getContainer().equals("EXIF") && (!to.getContainer().equals("XMP") || !container.equals("IPTC"))) continue;
                result = to;
                container = to.getContainer();
            }
        }
        return result;
    }

    private TiffObject getFirst(String name) {
        return this.metadata.get(name).getObjectList().get(0);
    }

    public List<TiffObject> getList(String name) {
        return this.metadata.get(name).getObjectList();
    }

    public MetadataObject getMetadataObject(String name) {
        return this.metadata.get(name);
    }

    public Set<String> keySet() {
        return this.metadata.keySet();
    }

    public void addMetadata(Metadata meta) {
        for (String k : meta.keySet()) {
            for (TiffObject to : meta.getList(k)) {
                this.add(k, to, meta.getMetadataObject(k).isDublinCore(), meta.getMetadataObject(k).getPath());
            }
        }
    }
}

