/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import com.easyinnova.tiff.model.ByteOrder;
import com.easyinnova.tiff.model.Metadata;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffObject;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.model.types.IccProfile;
import com.easyinnova.tiff.model.types.abstractTiffType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TiffDocument
implements Serializable {
    private static final long serialVersionUID = 2946L;
    private int magicNumber;
    private IFD firstIFD = null;
    private Metadata metadata = null;
    private ByteOrder byteOrder;
    private int firstIFDOffset;
    private long size;
    private boolean fatalError = false;
    private String fatalErrorMessage;

    public void addIfd0(IFD ifd) {
        this.firstIFD = ifd;
    }

    public void setFirstIFDOffset(int offset) {
        this.firstIFDOffset = offset;
    }

    public int getFirstIFDOffset() {
        return this.firstIFDOffset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean getFatalError() {
        return this.fatalError;
    }

    public String getFatalErrorMEssage() {
        return this.fatalErrorMessage;
    }

    public void setFatalError(boolean error, String message) {
        this.fatalError = error;
        this.fatalErrorMessage = message;
    }

    public IccProfile getIccProfile() {
        if (this.getMetadata() != null && this.getMetadata().contains("ICCProfile")) {
            List<TiffObject> lobj = this.getMetadata().getList("ICCProfile");
            for (TiffObject obj : lobj) {
                if (!(obj instanceof IccProfile)) continue;
                return (IccProfile)obj;
            }
        }
        return null;
    }

    public long getSize() {
        return this.size;
    }

    public int getIfdCount() {
        int c = 0;
        if (this.metadata != null && this.metadata.contains("IFD")) {
            c = this.getMetadataList("IFD").size();
        }
        return c;
    }

    public int getIfdImagesCount() {
        int c = 0;
        if (this.metadata.contains("IFD")) {
            List<TiffObject> l = this.getMetadataList("IFD");
            int n = 0;
            for (TiffObject to : l) {
                IFD ifd;
                if (!(to instanceof IFD) || !(ifd = (IFD)to).isImage()) continue;
                ++n;
            }
            c = n;
        }
        return c;
    }

    public int getMainImagesCount() {
        int count = 0;
        ArrayList<TiffObject> list = new ArrayList<TiffObject>();
        list.addAll(this.getMetadataList("IFD"));
        list.addAll(this.getMetadataList("SubIFDs"));
        for (TiffObject to : list) {
            IFD ifd;
            if (!(to instanceof IFD) || !(ifd = (IFD)to).isImage() || ifd.isThumbnail()) continue;
            ++count;
        }
        return count;
    }

    public int getThumbnailsImagesCount() {
        int count = 0;
        ArrayList<TiffObject> list = new ArrayList<TiffObject>();
        list.addAll(this.getMetadataList("IFD"));
        list.addAll(this.getMetadataList("SubIFDs"));
        for (TiffObject to : list) {
            IFD ifd;
            if (!(to instanceof IFD) || !(ifd = (IFD)to).isImage() || !ifd.isThumbnail()) continue;
            ++count;
        }
        return count;
    }

    public int getSubIfdCount() {
        int c = 0;
        if (this.metadata != null && this.metadata.contains("SubIFDs")) {
            c = this.getMetadataList("SubIFDs").size();
        }
        return c;
    }

    public int getIfdAndSubIfdCount() {
        return this.getMetadataList("IFD").size() + this.getMetadataList("SubIFDs").size();
    }

    public List<TiffObject> getIfds() {
        List<TiffObject> l = new ArrayList<TiffObject>();
        if (this.metadata != null && this.metadata.contains("IFD")) {
            l = this.getMetadataList("IFD");
        }
        return l;
    }

    public List<TiffObject> getImageIfds() {
        ArrayList<TiffObject> l = new ArrayList<TiffObject>();
        for (IFD oifd = this.firstIFD; oifd != null; oifd = oifd.getNextIFD()) {
            if (!oifd.isImage()) continue;
            if (oifd.hasSubIFD()) {
                try {
                    long length = oifd.getMetadata().get("ImageLength").getFirstNumericValue();
                    long width = oifd.getMetadata().get("ImageWidth").getFirstNumericValue();
                    long sublength = oifd.getsubIFD().getMetadata().get("ImageLength").getFirstNumericValue();
                    long subwidth = oifd.getsubIFD().getMetadata().get("ImageWidth").getFirstNumericValue();
                    if (sublength > length && subwidth > width) {
                        l.add(oifd.getsubIFD());
                        continue;
                    }
                    l.add(oifd);
                }
                catch (Exception ex) {
                    l.add(oifd);
                }
                continue;
            }
            l.add(oifd);
        }
        return l;
    }

    public List<TiffObject> getSubIfds() {
        List<TiffObject> l = new ArrayList<TiffObject>();
        if (this.metadata != null && this.metadata.contains("SubIFDs")) {
            l = this.getMetadataList("SubIFDs");
        }
        return l;
    }

    public ByteOrder getEndianess() {
        return this.byteOrder;
    }

    public List<TiffObject> getIfdsAndSubIfds() {
        ArrayList<TiffObject> all = new ArrayList<TiffObject>();
        all.addAll(this.getMetadataList("IFD"));
        all.addAll(this.getMetadataList("SubIFDs"));
        return all;
    }

    public IFD getFirstIFD() {
        return this.firstIFD;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(int magic) {
        this.magicNumber = magic;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String getMetadataSingleString(String name) {
        String s = "";
        if (this.metadata == null) {
            this.createMetadataDictionary();
        }
        if (this.metadata.contains(name)) {
            s = this.metadata.get(name).toString();
        }
        return s;
    }

    public List<TiffObject> getMetadataList(String name) {
        List<TiffObject> l = new ArrayList<TiffObject>();
        if (this.metadata == null) {
            this.createMetadataDictionary();
        }
        if (this.metadata.contains(name)) {
            l = this.metadata.getList(name);
        }
        return l;
    }

    public void createMetadataDictionary() {
        this.metadata = new Metadata();
        if (this.firstIFD != null) {
            this.addMetadataFromIFD(this.firstIFD, "IFD", false);
        }
    }

    private void addMetadataFromIFD(IFD ifd, String key, boolean exif) {
        this.metadata.add(key, ifd);
        for (TagValue tag : ifd.getMetadata().getTags()) {
            if (tag.getCardinality() == 1) {
                abstractTiffType t = tag.getValue().get(0);
                if (t.isIFD()) {
                    this.addMetadataFromIFD((IFD)t, key, true);
                    continue;
                }
                if (t.containsMetadata()) {
                    try {
                        Metadata meta = t.createMetadata();
                        this.metadata.addMetadata(meta);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (exif) {
                    t.setContainer("EXIF");
                }
                this.metadata.add(tag.getName(), t);
                continue;
            }
            if (exif) {
                tag.setContainer("EXIF");
            }
            this.metadata.add(tag.getName(), tag);
        }
        if (ifd.hasNextIFD()) {
            this.addMetadataFromIFD(ifd.getNextIFD(), key, false);
        }
    }

    public void printMetadata() {
        if (this.metadata == null) {
            this.createMetadataDictionary();
        }
        System.out.println("METADATA");
        for (String name : this.metadata.keySet()) {
            String mult = "";
            if (this.getMetadataList(name).size() > 1) {
                mult = "(x" + this.getMetadataList(name).size() + ")";
            }
            if (this.metadata.getMetadataObject(name).isDublinCore()) {
                System.out.println("[DC]");
            }
            System.out.println(name + mult + ": " + this.getMetadataSingleString(name));
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean removeTag(String tagName) {
        boolean result = false;
        for (IFD ifd = this.firstIFD; ifd != null; ifd = ifd.getNextIFD()) {
            if (!ifd.containsTagId(TiffTags.getTagId(tagName))) continue;
            ifd.removeTag(tagName);
        }
        this.createMetadataDictionary();
        return result;
    }

    public boolean addTag(String tagName, String tagValue) {
        boolean result = false;
        if (this.firstIFD != null) {
            if (this.firstIFD.containsTagId(TiffTags.getTagId(tagName))) {
                this.firstIFD.removeTag(tagName);
            }
            this.firstIFD.addTag(tagName, tagValue);
            this.createMetadataDictionary();
        }
        return result;
    }
}

