/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model;

import java.io.Serializable;

public class ValidationEvent
implements Serializable {
    private static final long serialVersionUID = 2946L;
    private String description;
    private String value;
    private String location;
    private int level;

    public ValidationEvent() {
        this.description = "";
        this.value = null;
        this.level = 1;
    }

    public ValidationEvent(String desc, String value) {
        this.description = desc;
        this.value = value;
    }

    public ValidationEvent(String desc, String value, String loc) {
        this.description = desc;
        this.value = value;
        this.location = loc;
    }

    public void printError() {
        System.out.print(this.description);
        if (this.value != null) {
            System.out.print(" (" + this.value + ")");
        }
        System.out.println();
    }

    public void printWarning() {
        System.out.print("Warning: ");
        System.out.print(this.description);
        if (this.value != null) {
            System.out.print(" (" + this.value + ")");
        }
        System.out.println();
    }

    public int getLevel() {
        return this.level;
    }

    public String getLocation() {
        if (this.location == null) {
            return "";
        }
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInvalidValue() {
        return this.value;
    }

    public String toString() {
        return this.description;
    }
}

