/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model.types;

import com.easyinnova.tiff.model.IfdTags;
import com.easyinnova.tiff.model.ImageStrips;
import com.easyinnova.tiff.model.ImageTiles;
import com.easyinnova.tiff.model.Metadata;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.abstractTiffType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class IFD
extends abstractTiffType {
    private IfdTags tags = new IfdTags();
    private IFD nextIFD = null;
    private IFD parentIFD;
    private IFD subIFD;
    private transient ImageStrips imageStrips;
    private transient ImageTiles imageTiles;
    private boolean isImage;
    private int nextOffset;
    private int offset;

    public IFD(boolean isImage) {
        this.isImage = isImage;
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(int offset) {
        this.nextOffset = offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        int length = 2 + this.getTags().getTags().size() * 12 + 4;
        return length;
    }

    public void setParent(IFD parent) {
        this.parentIFD = parent;
    }

    public IfdTags getTags() {
        return this.tags;
    }

    public IFD getParent() {
        return this.parentIFD;
    }

    public long getImageSize() {
        long x = 0L;
        long y = 0L;
        if (this.tags.containsTagId(TiffTags.getTagId("ImageLength"))) {
            x = this.tags.get("ImageLength").getFirstNumericValue();
        }
        if (this.tags.containsTagId(TiffTags.getTagId("ImageWidth"))) {
            y = this.tags.get("ImageWidth").getFirstNumericValue();
        }
        return x * y;
    }

    public void setsubIFD(IFD subIFD) {
        this.subIFD = subIFD;
    }

    public IFD getsubIFD() {
        return this.subIFD;
    }

    public boolean hasParent() {
        return this.parentIFD != null;
    }

    public boolean hasSubIFD() {
        return this.tags.containsTagId(330);
    }

    public boolean isThumbnail() {
        if (this.tags.containsTagId(254) && this.tags.get(254).getCardinality() > 0) {
            return BigInteger.valueOf(this.tags.get(254).getFirstNumericValue()).testBit(0);
        }
        if (this.tags.containsTagId(255) && this.tags.get(255).getCardinality() > 0) {
            return this.tags.get(255).getFirstNumericValue() == 2L;
        }
        if (this.hasSubIFD() && this.getImageSize() < this.getsubIFD().getImageSize()) {
            return true;
        }
        return this.hasParent() && this.getImageSize() < this.getParent().getImageSize();
    }

    public List<IFD> getSubIFD() {
        ArrayList<IFD> l = new ArrayList<IFD>();
        if (this.hasSubIFD()) {
            for (abstractTiffType o : this.tags.get(330).getValue()) {
                l.add((IFD)o);
            }
        }
        return l;
    }

    @Override
    public Metadata createMetadata() {
        Metadata metadata = new Metadata();
        for (TagValue tag : this.getMetadata().getTags()) {
            if (tag.getCardinality() != 1) continue;
            abstractTiffType t = tag.getValue().get(0);
            if (t.isIFD()) {
                Metadata metadata2 = ((IFD)t).createMetadata();
                for (String key : metadata2.keySet()) {
                    metadata.add(key, metadata2.get(key));
                }
                continue;
            }
            if (!t.containsMetadata()) continue;
            try {
                Metadata meta = t.createMetadata();
                metadata.addMetadata(meta);
            }
            catch (Exception exception) {
            }
        }
        return metadata;
    }

    public void setNextIFD(IFD ifd) {
        this.nextIFD = ifd;
    }

    public boolean hasNextIFD() {
        return this.nextIFD != null;
    }

    public TagValue getTag(String name) {
        TagValue tv = null;
        int id = TiffTags.getTagId(name);
        if (this.tags.containsTagId(id)) {
            tv = this.tags.get(id);
        }
        return tv;
    }

    public void addTag(TagValue tv) {
        this.tags.addTag(tv);
    }

    public IfdTags getMetadata() {
        return this.tags;
    }

    public boolean containsTagId(int tagid) {
        return this.tags.containsTagId(tagid);
    }

    public void printTags() {
        for (TagValue ie : this.tags.getTags()) {
            try {
                String name = "" + ie.getId();
                if (TiffTags.hasTag(ie.getId())) {
                    name = TiffTags.getTag(ie.getId()).getName();
                }
                String val = ie.toString();
                String type = TiffTags.tagTypes.get(ie.getType());
                System.out.println(name + "(" + ie.getType() + "->" + type + "): " + val);
            }
            catch (Exception ex) {
                System.out.println("Tag error");
            }
        }
    }

    public String toString() {
        String s = "";
        s = this.hasParent() ? "SubIFD" : (this.isImage ? "IFD" : this.tags.toString());
        return s;
    }

    public IFD getNextIFD() {
        return this.nextIFD;
    }

    public ImageStrips getImageStrips() {
        return this.imageStrips;
    }

    public ImageTiles getImageTiles() {
        return this.imageTiles;
    }

    public void setImageStrips(ImageStrips strips) {
        this.imageStrips = strips;
    }

    public void setImageTiles(ImageTiles imageTiles) {
        this.imageTiles = imageTiles;
    }

    public void setIsImage(boolean b) {
        this.isImage = b;
    }

    @Override
    public void setIsIFD(boolean b) {
        super.setIsIFD(b);
    }

    public boolean isImage() {
        return this.isImage;
    }

    public boolean hasStrips() {
        return this.imageStrips != null;
    }

    public boolean hasTiles() {
        return this.imageTiles != null;
    }

    public void removeTag(String tagName) {
        this.tags.removeTag(tagName);
    }

    public void addTag(String tagName, String tagValue) {
        this.tags.addTag(tagName, tagValue);
    }

    public void addTag(String tagName, int[] tagValue) {
        this.tags.addTag(tagName, tagValue);
    }

    public static enum ImageRepresentation {
        STRIPS,
        TILES,
        UNDEFINED;

    }
}

