/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model.types;

import com.easyinnova.tiff.io.TiffOutputStream;
import com.easyinnova.tiff.model.Metadata;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.types.Text;
import com.easyinnova.tiff.model.types.abstractTiffType;
import com.nmote.iim4j.IIMDataSetInfoFactory;
import com.nmote.iim4j.IIMFile;
import com.nmote.iim4j.IIMReader;
import com.nmote.iim4j.IIMWriter;
import com.nmote.iim4j.dataset.DataSet;
import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.dataset.DefaultDataSet;
import com.nmote.iim4j.dataset.InvalidDataSetException;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.stream.DefaultIIMOutputStream;
import com.nmote.iim4j.stream.FileIIMInputStream;
import com.nmote.iim4j.stream.SubIIMInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class IPTC
extends abstractTiffType {
    public static final int[] SEGMENT_MARKER = new int[]{28, 2};
    private List<abstractTiffType> originalValue;
    private transient IIMFile iimFile;

    public void setOriginal(List<abstractTiffType> value) {
        this.originalValue = value;
    }

    public List<abstractTiffType> getOriginal() {
        return this.originalValue;
    }

    @Override
    public Metadata createMetadata() {
        Metadata metadata = new Metadata();
        try {
            for (DataSet ds : this.iimFile.getDataSets()) {
                Object value = "";
                try {
                    value = ds.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataSetInfo info = ds.getInfo();
                metadata.add(info.getName(), new Text(value.toString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metadata;
    }

    public String toString() {
        String s = "";
        for (DataSet ds : this.iimFile.getDataSets()) {
            Object value = "";
            try {
                value = ds.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DataSetInfo info = ds.getInfo();
            s = s + info.toString() + " " + info.getName() + ": " + value + "\n";
        }
        return s;
    }

    public void removeTag(String tagName) {
        int ids = -1;
        for (DataSet ds : this.iimFile.getDataSets()) {
            if (!ds.getInfo().getName().equals(tagName)) continue;
            ids = ds.getInfo().getDataSetNumber();
        }
        if (ids != -1) {
            this.iimFile.remove(ids);
        }
    }

    public void editCopyright(String value) {
        this.editTag("Copyright Notice", value);
    }

    public void editCreator(String value) {
        this.editTag("Writer/Editor", value);
    }

    public void editDescription(String value) {
        this.editTag("Caption/Abstract", value);
    }

    String zeros(int value, int digits) {
        String s = value + "";
        while (s.length() < digits) {
            s = "0" + s;
        }
        return s;
    }

    public void editDatetime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        this.editTag("Date Created", this.zeros(year, 4) + "" + this.zeros(month, 2) + this.zeros(day, 2));
        this.editTag("Time Created", this.zeros(hour, 2) + "" + this.zeros(minute, 2) + this.zeros(second, 2) + "+000000");
    }

    public String getCopyright() {
        return this.getTag("Copyright Notice");
    }

    public String getCreator() {
        return this.getTag("Writer/Editor");
    }

    public String getDescription() {
        return this.getTag("Caption/Abstract");
    }

    public Date getDatetime() {
        String dateField = this.getTag("Date Created");
        String timeField = this.getTag("Time Created");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd hhmmss+SSSSSS");
        Date date = null;
        try {
            date = sdf.parse(dateField + " " + timeField);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    public String getTag(String name) {
        for (DataSet ds : this.iimFile.getDataSets()) {
            if (!ds.getInfo().getName().equals(name)) continue;
            try {
                return ds.getValue().toString();
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void editTag(String name, String value) {
        int ids = -1;
        DataSet dataSet = null;
        for (DataSet ds : this.iimFile.getDataSets()) {
            if (!ds.getInfo().getName().equals(name)) continue;
            ids = ds.getInfo().getDataSetNumber();
            dataSet = ds;
        }
        if (ids != -1) {
            this.iimFile.remove(ids);
            DefaultDataSet ds = new DefaultDataSet(dataSet.getInfo(), value.getBytes());
            this.iimFile.add(ds);
        }
    }

    @Override
    public void read(TagValue tv, String filename) {
        this.originalValue = tv.getValue();
        File file = new File(filename);
        IIMReader reader = null;
        SubIIMInputStream subStream = null;
        try {
            int offset = tv.getReadOffset();
            int length = tv.getReadlength();
            subStream = new SubIIMInputStream(new FileIIMInputStream(file), offset, length);
            reader = new IIMReader(subStream, new IIMDataSetInfoFactory());
            IIMFile iimFileReader = new IIMFile();
            iimFileReader.readFrom(reader, 0);
            ArrayList<DataSet> lds = new ArrayList<DataSet>();
            for (DataSet ds : iimFileReader.getDataSets()) {
                ds.getData();
                lds.add(ds);
            }
            this.iimFile = new IIMFile();
            this.iimFile.setDataSets(lds);
            tv.reset();
            tv.add(this);
            reader.close();
            subStream.close();
        }
        catch (IOException e) {
            try {
                reader.close();
                subStream.close();
            }
            catch (Exception exception) {}
        }
        catch (InvalidDataSetException e) {
            try {
                reader.close();
                subStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void write(TiffOutputStream data) throws IOException {
        try {
            byte[] bytes;
            ByteArrayOutputStream sw = new ByteArrayOutputStream();
            IIMWriter writer = new IIMWriter(new DefaultIIMOutputStream(sw));
            this.iimFile.writeTo(writer);
            writer.close();
            for (byte b : bytes = sw.toByteArray()) {
                data.put(b);
            }
            data.put((byte)0);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public int getLength() {
        try {
            ByteArrayOutputStream sw = new ByteArrayOutputStream();
            IIMWriter writer = new IIMWriter(new DefaultIIMOutputStream(sw));
            this.iimFile.writeTo(writer);
            writer.close();
            return sw.size();
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.getOriginal().size();
        }
    }

    @Override
    public boolean containsMetadata() {
        return true;
    }
}

