/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.model.types;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.options.SerializeOptions;
import com.easyinnova.tiff.io.TiffOutputStream;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.types.abstractTiffType;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;

public class XmlType
extends abstractTiffType {
    private static final long serialVersionUID = 1102624980909600286L;
    protected transient StringReader xmlReader = null;
    private String xml = null;
    private byte[] bytes;

    private void loadXml() throws XMLStreamException {
        this.xmlReader = new StringReader(this.xml);
    }

    public StringReader getReader() {
        return this.xmlReader;
    }

    public String toString() {
        return this.xml.replace('\n', ' ');
    }

    public String getXml() {
        return this.xml;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void read(TagValue tv) throws Exception {
        this.xml = "";
        this.bytes = new byte[tv.getCardinality()];
        for (int i = 0; i < tv.getCardinality(); ++i) {
            this.bytes[i] = tv.getValue().get(i).toByte();
        }
        this.xml = new String(this.bytes, "UTF-8");
        this.loadXml();
        tv.clear();
        tv.add(this);
    }

    public void writeXml(TiffOutputStream data) throws IOException, XMPException {
        SerializeOptions options = new SerializeOptions();
        for (byte b : this.bytes) {
            data.put(b);
        }
    }
}

