/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.profiles;

import com.easyinnova.tiff.model.IfdTags;
import com.easyinnova.tiff.model.ReadTagsIOException;
import com.easyinnova.tiff.model.Tag;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.model.TiffObject;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.model.types.Rational;
import com.easyinnova.tiff.model.types.abstractTiffType;
import com.easyinnova.tiff.profiles.GenericProfile;
import com.easyinnova.tiff.profiles.Profile;

public class BaselineProfile
extends GenericProfile
implements Profile {
    private ImageType type = ImageType.UNDEFINED;
    private int photometric;
    private boolean strips = false;
    private boolean tiles = false;
    private int tagOrderTolerance = 1;
    private int rowsPerStripTolerance = 1;

    public BaselineProfile(TiffDocument doc) {
        super(doc);
    }

    @Override
    public void validate() {
        int n = 0;
        try {
            for (TiffObject o : this.model.getImageIfds()) {
                IFD ifd = (IFD)o;
                IfdTags metadata = ifd.getMetadata();
                this.validateMetadata(metadata);
                this.checkImage(ifd, n, metadata);
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateMetadata(IfdTags metadata) {
        int prevTagId = 0;
        try {
            TiffTags.getTiffTags();
        }
        catch (ReadTagsIOException readTagsIOException) {
            // empty catch block
        }
        for (TagValue ie : metadata.getTags()) {
            if (!TiffTags.tagMap.containsKey(ie.getId())) {
                this.validation.addWarning("Ignoring undefined tag id " + ie.getId(), "", "Metadata");
            } else if (!TiffTags.tagTypes.containsKey(ie.getType())) {
                this.validation.addWarning("Ignoring unknown tag type " + ie.getType(), "", "Metadata");
            } else {
                Tag t = TiffTags.getTag(ie.getId());
                String stype = TiffTags.tagTypes.get(ie.getType());
                if (ie.getId() == 320) {
                    long calc;
                    long bps = 0L;
                    if (metadata.containsTagId(258)) {
                        bps = metadata.get(258).getFirstNumericValue();
                    }
                    if ((calc = 3L * (long)Math.pow(2.0, bps)) != (long)ie.getCardinality()) {
                        this.validation.addError("Invalid cardinality for tag " + TiffTags.getTag(ie.getId()).getName() + "[" + ie.getCardinality() + "]", "Metadata", stype);
                    }
                }
                try {
                    int card = Integer.parseInt(t.getCardinality());
                    if (card != ie.getCardinality()) {
                        this.validation.addError("Cardinality for tag " + TiffTags.getTag(ie.getId()).getName() + " must be " + card, "Metadata", ie.getCardinality());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ie.getId() < prevTagId) {
                if (this.tagOrderTolerance > 0) {
                    this.validation.addWarning("Tags are not in ascending order", "", "Metadata");
                } else {
                    this.validation.addErrorLoc("Tags are not in ascending order", "Metadata");
                }
            }
            prevTagId = ie.getId();
        }
    }

    public void checkImage(IFD ifd, int n, IfdTags metadata) {
        this.CheckCommonFields(ifd, n, metadata);
        if (!metadata.containsTagId(TiffTags.getTagId("PhotometricInterpretation"))) {
            this.validation.addErrorLoc("Missing Photometric Interpretation", "IFD" + n);
        } else if (metadata.get(TiffTags.getTagId("PhotometricInterpretation")).getValue().size() != 1) {
            this.validation.addErrorLoc("Invalid Photometric Interpretation", "IFD" + n);
        } else {
            this.photometric = (int)metadata.get(TiffTags.getTagId("PhotometricInterpretation")).getFirstNumericValue();
            switch (this.photometric) {
                case 0: 
                case 1: {
                    if (!metadata.containsTagId(TiffTags.getTagId("BitsPerSample")) || metadata.get(TiffTags.getTagId("BitsPerSample")).getFirstNumericValue() == 1L) {
                        this.type = ImageType.BILEVEL;
                        this.CheckBilevelImage(metadata, n);
                        break;
                    }
                    this.type = ImageType.GRAYSCALE;
                    this.CheckGrayscaleImage(metadata, n);
                    break;
                }
                case 2: {
                    this.type = ImageType.RGB;
                    this.CheckRGBImage(metadata, n);
                    break;
                }
                case 3: {
                    this.type = ImageType.PALETTE;
                    this.CheckPalleteImage(metadata, n);
                    break;
                }
                case 4: {
                    this.type = ImageType.TRANSPARENCY_MASK;
                    this.CheckTransparencyMask(metadata, n);
                    break;
                }
                case 5: {
                    this.type = ImageType.CMYK;
                    this.CheckCMYK(metadata, n);
                    break;
                }
                case 6: {
                    this.type = ImageType.YCbCr;
                    this.CheckYCbCr(metadata, n);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.type = ImageType.CIELab;
                    this.CheckCIELab(metadata, n);
                    break;
                }
                default: {
                    this.validation.addWarning("Unknown Photometric Interpretation", "" + this.photometric, "IFD" + n);
                }
            }
        }
    }

    private void CheckBilevelImage(IfdTags metadata, int n) {
        long comp = metadata.get(TiffTags.getTagId("Compression")).getFirstNumericValue();
        if (comp < 1L) {
            this.validation.addError("Invalid Compression", "IFD" + n, comp);
        }
    }

    private void CheckGrayscaleImage(IfdTags metadata, int n) {
        long comp;
        long bps = metadata.get(TiffTags.getTagId("BitsPerSample")).getFirstNumericValue();
        if (bps < 1L) {
            this.validation.addError("Invalid Bits per Sample", "IFD" + n, bps);
        }
        if ((comp = metadata.get(TiffTags.getTagId("Compression")).getFirstNumericValue()) < 1L) {
            this.validation.addError("Invalid Compression", "IFD" + n, comp);
        }
    }

    private void CheckPalleteImage(IfdTags metadata, int nifd) {
        long comp;
        if (!metadata.containsTagId(TiffTags.getTagId("ColorMap"))) {
            this.validation.addErrorLoc("Missing Color Map", "IFD" + nifd);
        } else {
            int n = metadata.get(TiffTags.getTagId("ColorMap")).getCardinality();
            if (n != 3 * (int)Math.pow(2.0, metadata.get(TiffTags.getTagId("BitsPerSample")).getFirstNumericValue())) {
                this.validation.addError("Incorrect Color Map Cardinality", "IFD" + nifd, metadata.get(320).getCardinality());
            }
        }
        long bps = metadata.get(TiffTags.getTagId("BitsPerSample")).getFirstNumericValue();
        if (bps != 4L && bps != 8L) {
            this.validation.addError("Invalid Bits per Sample", "IFD" + nifd, bps);
        }
        if ((comp = metadata.get(TiffTags.getTagId("Compression")).getFirstNumericValue()) < 1L) {
            this.validation.addError("Invalid Compression", "IFD" + nifd, comp);
        }
    }

    private void CheckTransparencyMask(IfdTags metadata, int n) {
        if (!metadata.containsTagId(TiffTags.getTagId("SamplesPerPixel"))) {
            this.validation.addErrorLoc("Missing Samples Per Pixel", "IFD" + n);
        } else {
            long spp = metadata.get(TiffTags.getTagId("SamplesPerPixel")).getFirstNumericValue();
            if (spp != 1L) {
                this.validation.addError("Invalid Samples Per Pixel", "IFD" + n, spp);
            }
        }
        if (!metadata.containsTagId(TiffTags.getTagId("BitsPerSample"))) {
            this.validation.addErrorLoc("Missing BitsPerSample", "IFD" + n);
        } else {
            long bps = metadata.get(TiffTags.getTagId("BitsPerSample")).getFirstNumericValue();
            if (bps != 1L) {
                this.validation.addError("Invalid BitsPerSample", "IFD" + n, bps);
            }
        }
    }

    private void CheckCMYK(IfdTags metadata, int n) {
        if (!metadata.containsTagId(TiffTags.getTagId("SamplesPerPixel"))) {
            this.validation.addErrorLoc("Missing Samples Per Pixel", "IFD" + n);
        }
        if (!metadata.containsTagId(TiffTags.getTagId("BitsPerSample"))) {
            this.validation.addErrorLoc("Missing BitsPerSample", "IFD" + n);
        }
    }

    private void CheckYCbCr(IfdTags metadata, int n) {
        if (!metadata.containsTagId(TiffTags.getTagId("SamplesPerPixel"))) {
            this.validation.addErrorLoc("Missing Samples Per Pixel", "IFD" + n);
        } else {
            long spp = metadata.get(TiffTags.getTagId("SamplesPerPixel")).getFirstNumericValue();
            if (spp != 3L) {
                this.validation.addError("Invalid Samples Per Pixel", "IFD" + n, spp);
            }
        }
        if (!metadata.containsTagId(TiffTags.getTagId("BitsPerSample"))) {
            this.validation.addErrorLoc("Missing BitsPerSample", "IFD" + n);
        } else {
            for (abstractTiffType vi : metadata.get(TiffTags.getTagId("BitsPerSample")).getValue()) {
                if (vi.toInt() == 8) continue;
                this.validation.addError("Invalid BitsPerSample", "IFD" + n, vi.toInt());
                break;
            }
        }
    }

    private void CheckCIELab(IfdTags metadata, int n) {
        if (!metadata.containsTagId(TiffTags.getTagId("BitsPerSample"))) {
            this.validation.addErrorLoc("Missing BitsPerSample", "IFD" + n);
        } else {
            for (abstractTiffType vi : metadata.get(TiffTags.getTagId("BitsPerSample")).getValue()) {
                if (vi.toInt() == 8) continue;
                this.validation.addError("Invalid BitsPerSample", "IFD" + n, vi.toInt());
                break;
            }
        }
    }

    private void CheckRGBImage(IfdTags metadata, int n) {
        long comp;
        long samples = metadata.get(TiffTags.getTagId("SamplesPerPixel")).getFirstNumericValue();
        if (samples < 3L) {
            this.validation.addError("Invalid Samples per Pixel", "IFD" + n, samples);
        }
        if ((comp = metadata.get(TiffTags.getTagId("Compression")).getFirstNumericValue()) < 1L) {
            this.validation.addError("Invalid Compression", "IFD" + n, comp);
        }
    }

    private void CheckCommonFields(IFD ifd, int n, IfdTags metadata) {
        long val;
        int id = TiffTags.getTagId("ImageWidth");
        if (!metadata.containsTagId(id)) {
            this.validation.addError("Missing required field", "IFD" + n, TiffTags.getTag(id).getName());
        } else {
            val = metadata.get(id).getFirstNumericValue();
            if (val <= 0L) {
                this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
            }
        }
        id = TiffTags.getTagId("ImageLength");
        if (!metadata.containsTagId(id)) {
            this.validation.addError("Missing required field", "IFD" + n, TiffTags.getTag(id).getName());
        } else {
            val = metadata.get(id).getFirstNumericValue();
            if (val <= 0L) {
                this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
            }
        }
        id = TiffTags.getTagId("ResolutionUnit");
        if (metadata.containsTagId(id) && (val = metadata.get(id).getFirstNumericValue()) != 1L && val != 2L && val != 3L) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
        }
        if (metadata.containsTagId(id = TiffTags.getTagId("XResolution")) && (val = ((Rational)metadata.get(id).getValue().get(0)).getFloatValue()) <= 0.0f) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
        }
        if (metadata.containsTagId(id = TiffTags.getTagId("YResolution")) && (val = ((Rational)metadata.get(id).getValue().get(0)).getFloatValue()) <= 0.0f) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
        }
        if (metadata.containsTagId(id = TiffTags.getTagId("PlanarConfiguration")) && (val = metadata.get(id).getFirstNumericValue()) != 1L && val != 2L) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
        }
        if (metadata.containsTagId(id = TiffTags.getTagId("Orientation")) && ((val = metadata.get(id).getFirstNumericValue()) <= 0L || val > 8L)) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, val);
        }
        this.strips = ifd.hasStrips();
        this.tiles = ifd.hasTiles();
        if (!this.strips && !this.tiles) {
            this.validation.addErrorLoc("Missing image organization tags", "IFD" + n);
            this.validation.setFatalError(true, "Missing image organization tags");
        } else if (this.strips && this.tiles) {
            this.validation.addErrorLoc("Image in both strips and tiles", "IFD" + n);
        } else if (this.strips) {
            this.CheckStrips(metadata, n);
        } else if (this.tiles) {
            this.CheckTiles(ifd, metadata, n);
        }
        if (metadata.containsTagId(TiffTags.getTagId("BitsPerSample")) && metadata.containsTagId(TiffTags.getTagId("SampesPerPixel"))) {
            int bps;
            long spp = metadata.get(TiffTags.getTagId("SamplesPerPixel")).getFirstNumericValue();
            if (spp != (long)(bps = metadata.get(TiffTags.getTagId("BitsPerSample")).getValue().size())) {
                this.validation.addErrorLoc("Samples per Pixel and Bits per Sample count do not match", "IFD" + n);
                if (bps == 1) {
                    // empty if block
                }
            }
            if (metadata.containsTagId(TiffTags.getTagId("ExtraSamples"))) {
                int ext = metadata.get(TiffTags.getTagId("ExtraSamples")).getValue().size();
                if (ext + 3 != bps) {
                    this.validation.addError("Incorrect Extra Samples Count", "IFD" + n, ext);
                } else if (ext > 0 && bps <= 3) {
                    this.validation.addError("Unnecessary Extra Samples", "IFD" + n, ext);
                }
            }
            if (bps > 1) {
                TagValue lbps = metadata.get(TiffTags.getTagId("BitsPerSample"));
                if (lbps == null || lbps.getValue() == null) {
                    this.validation.addErrorLoc("Invalid Bits per Sample", "IFD" + n);
                } else {
                    boolean distinct_bps_samples = false;
                    for (int i = 1; i < lbps.getCardinality(); ++i) {
                        if (lbps.getValue().get(i).toInt() == lbps.getValue().get(i - 1).toInt()) continue;
                        distinct_bps_samples = true;
                    }
                    if (distinct_bps_samples) {
                        this.validation.addErrorLoc("Distinct Bits per Sample values", "IFD" + n);
                    }
                }
            }
        }
    }

    private void CheckStrips(IfdTags metadata, int n) {
        int id = TiffTags.getTagId("StripOffsets");
        long offset = metadata.get(id).getFirstNumericValue();
        int nso = metadata.get(id).getCardinality();
        if (offset <= 0L) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, offset);
        }
        id = TiffTags.getTagId("StripBYTECount");
        offset = metadata.get(id).getFirstNumericValue();
        int nsc = metadata.get(id).getCardinality();
        if (offset <= 0L) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, offset);
        }
        if (nso != nsc) {
            this.validation.addErrorLoc("Inconsistent strip lengths", "IFD" + n);
        }
        int pixelSize = 0;
        for (int i = 0; i < metadata.get("BitsPerSample").getCardinality(); ++i) {
            pixelSize += metadata.get("BitsPerSample").getValue().get(i).toInt();
        }
        if (metadata.get("Compression").getFirstNumericValue() == 1L && pixelSize >= 8) {
            int calculatedImageLength = 0;
            for (int i = 0; i < nsc; ++i) {
                calculatedImageLength += metadata.get(id).getValue().get(i).toInt();
            }
            if ((long)calculatedImageLength != metadata.get("ImageLength").getFirstNumericValue() * metadata.get("ImageWidth").getFirstNumericValue() * (long)pixelSize / 8L) {
                this.validation.addErrorLoc("Calculated and declared image size do not match", "IFD" + n);
            }
        }
        if (!metadata.containsTagId(id = TiffTags.getTagId("RowsPerStrip"))) {
            if (this.rowsPerStripTolerance > 0) {
                this.validation.addWarning("Missing required field", TiffTags.getTag(id).getName(), "IFD" + n);
            } else {
                this.validation.addError("Missing required field", "IFD" + n, TiffTags.getTag(id).getName());
            }
        } else {
            offset = metadata.get(id).getFirstNumericValue();
            if (offset <= 0L) {
                this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, offset);
            }
        }
    }

    private void CheckTiles(IFD ifd, IfdTags metadata, int n) {
        int id = TiffTags.getTagId("TileOffsets");
        long offset = metadata.get(id).getFirstNumericValue();
        int no = metadata.get(id).getCardinality();
        if (offset <= 0L) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, offset);
        }
        id = TiffTags.getTagId("TileBYTECounts");
        offset = metadata.get(id).getFirstNumericValue();
        int nc = metadata.get(id).getCardinality();
        if (offset <= 0L) {
            this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, offset);
        }
        if (no != nc) {
            this.validation.addErrorLoc("Inconsistent tile lengths", "IFD" + n);
        }
        long tileWidth = 0L;
        id = TiffTags.getTagId("TileWidth");
        if (!metadata.containsTagId(id)) {
            this.validation.addErrorLoc("Missing required field for tiles " + TiffTags.getTag(id).getName(), "IFD" + n);
        } else {
            tileWidth = metadata.get(id).getFirstNumericValue();
            if (tileWidth <= 0L) {
                this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, tileWidth);
            }
        }
        id = TiffTags.getTagId("TileLength");
        long tileLength = 0L;
        if (!metadata.containsTagId(id)) {
            this.validation.addErrorLoc("Missing required field for tiles " + TiffTags.getTag(id).getName(), "IFD" + n);
        } else {
            tileLength = metadata.get(id).getFirstNumericValue();
            if (tileLength <= 0L) {
                this.validation.addError("Invalid value for field " + TiffTags.getTag(id).getName(), "IFD" + n, tileLength);
            }
        }
        long tilesPerImage = (metadata.get(TiffTags.getTagId("ImageWidth")).getFirstNumericValue() + tileWidth - 1L) / tileWidth * ((metadata.get(TiffTags.getTagId("ImageLength")).getFirstNumericValue() + tileLength - 1L) / tileLength);
        id = TiffTags.getTagId("PlanarConfiguration");
        int idspp = TiffTags.getTagId("SamplesPerPixel");
        if (metadata.containsTagId(id) && metadata.containsTagId(idspp)) {
            long planar = metadata.get(id).getFirstNumericValue();
            long spp = metadata.get(idspp).getFirstNumericValue();
            if (planar == 2L) {
                long spp_tpi = spp * tilesPerImage;
                if ((long)ifd.getImageTiles().getTiles().size() < spp_tpi) {
                    this.validation.addErrorLoc("Insufficient tiles", "IFD" + n);
                }
            }
        }
    }

    public ImageType getType() {
        return this.type;
    }

    public static enum ImageType {
        BILEVEL,
        GRAYSCALE,
        PALETTE,
        TRANSPARENCY_MASK,
        RGB,
        CMYK,
        YCbCr,
        CIELab,
        UNDEFINED;

    }
}

