/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.profiles;

import com.easyinnova.tiff.model.IfdTags;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.profiles.GenericProfile;
import com.easyinnova.tiff.profiles.Profile;

public class TiffEPProfile
extends GenericProfile
implements Profile {
    public TiffEPProfile(TiffDocument doc) {
        super(doc);
    }

    @Override
    public void validate() {
        try {
            IFD ifd = this.model.getFirstIFD();
            int n = 0;
            while (ifd != null) {
                this.validateIfd(ifd, n);
                ifd = ifd.getNextIFD();
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateIfd(IFD ifd, int n) {
        int sensing;
        int focal;
        int comp;
        IfdTags metadata;
        boolean hasSubIfd = ifd.hasSubIFD();
        boolean thumbnail = hasSubIfd && ifd.getsubIFD().getImageSize() > ifd.getImageSize();
        boolean structureOk = false;
        if (!hasSubIfd) {
            this.validation.addErrorLoc("Missing Sub IFD", "IFD" + n);
            metadata = ifd.getMetadata();
        } else if (!thumbnail) {
            this.validation.addErrorLoc("Sub IFD image is not bigger than the main image", "IFD" + n);
            metadata = ifd.getMetadata();
        } else {
            metadata = ifd.getsubIFD().getMetadata();
            structureOk = true;
        }
        this.checkRequiredTag(metadata, "ImageLength", 1, "IFD" + n);
        this.checkRequiredTag(metadata, "ImageWidth", 1, "IFD" + n);
        int spp = -1;
        if (this.checkRequiredTag(metadata, "SamplesPerPixel", 1, "IFD" + n)) {
            spp = (int)metadata.get("SamplesPerPixel").getFirstNumericValue();
            this.checkRequiredTag(metadata, "BitsPerSample", spp, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "ImageDescription", -1, "IFD" + n);
        }
        if (this.checkRequiredTag(metadata, "Compression", 1, "IFD" + n) && (comp = (int)metadata.get("Compression").getFirstNumericValue()) == 1) {
            this.checkForbiddenTag(metadata, "CompressedBitsPerPixel", "IFD" + n);
        }
        this.checkRequiredTag(metadata, "XResolution", 1, "IFD" + n);
        this.checkRequiredTag(metadata, "YResolution", 1, "IFD" + n);
        if (n == 0) {
            this.checkRequiredTag(metadata, "Make", -1, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "Model", -1, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "Software", -1, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "Copyright", -1, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "DateTimeOriginal", 20, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "DateTime", 20, "IFD" + n);
        }
        if (n == 0) {
            this.checkRequiredTag(metadata, "TIFFEPStandardID", 4, "IFD" + n);
        }
        if (this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L, 1L}, "IFD" + n)) {
            int nst;
            if (structureOk) {
                this.checkRequiredTag(ifd.getMetadata(), "NewSubfileType", 1, new long[]{1L}, "IFD" + n);
                this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L}, "IFD" + n);
            }
            if ((nst = (int)metadata.get("NewSubfileType").getFirstNumericValue()) != 0 && n == 0) {
                this.checkRequiredTag(metadata, "SubIFDs", -1, "IFD" + n);
            }
        }
        if (this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{1L, 2L, 6L, 32803L, 32767L}, "IFD" + n)) {
            int photo = (int)metadata.get("PhotometricInterpretation").getFirstNumericValue();
            if (photo != 6) {
                this.checkForbiddenTag(metadata, "YCbCrCoefficients", "IFD" + n);
                this.checkForbiddenTag(metadata, "YCbCrSubSampling", "IFD" + n);
                this.checkForbiddenTag(metadata, "YCbCrPositioning", "IFD" + n);
                this.checkForbiddenTag(metadata, "ReferenceBlackWhite", "IFD" + n);
            }
            if (photo == 2 || photo == 3) {
                if (spp != 3) {
                    this.validation.addError("Invalid SampesPerPixel value fo TiffEP", "IFD" + n, spp);
                }
            } else if (photo == 1 || photo == 32803) {
                if (spp != 1) {
                    this.validation.addError("Invalid SampesPerPixel value fo TiffEP", "IFD" + n, spp);
                }
                if (photo == 32803) {
                    this.checkRequiredTag(metadata, "CFARepeatPatternDim", 2, "IFD" + n);
                    this.checkRequiredTag(metadata, "CFAPattern", -1, "IFD" + n);
                }
            }
        }
        this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{1L, 2L}, "IFD" + n);
        this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{1L, 2L, 3L}, "IFD" + n);
        if (metadata.containsTagId(TiffTags.getTagId("Orientation"))) {
            this.checkRequiredTag(metadata, "Orientation", 1, new long[]{1L, 3L, 6L, 8L, 9L}, "IFD" + n);
        }
        if (!thumbnail) {
            if (ifd.hasStrips()) {
                this.checkRequiredTag(metadata, "StripBYTECount", -1, "IFD" + n);
                this.checkRequiredTag(metadata, "StripOffsets", -1, "IFD" + n);
                this.checkRequiredTag(metadata, "RowsPerStrip", 1, "IFD" + n);
                if (ifd.hasTiles()) {
                    this.validation.addErrorLoc("Image in both strips and tiles", "IFD" + n);
                }
            } else if (ifd.hasTiles()) {
                this.checkRequiredTag(metadata, "TileLength", 1, "IFD" + n);
                this.checkRequiredTag(metadata, "TileOffsets", 1, "IFD" + n);
                this.checkRequiredTag(metadata, "TileWidth", -1, "IFD" + n);
            }
        } else {
            this.checkRequiredTag(metadata, "StripBYTECount", -1, "IFD" + n);
            this.checkRequiredTag(metadata, "StripOffsets", -1, "IFD" + n);
            this.checkRequiredTag(metadata, "RowsPerStrip", 1, "IFD" + n);
            this.checkForbiddenTag(metadata, "TileLength", "IFD" + n);
            this.checkForbiddenTag(metadata, "TileOffsets", "IFD" + n);
            this.checkForbiddenTag(metadata, "TileWidth", "IFD" + n);
        }
        int nycbcr = 0;
        if (metadata.containsTagId(TiffTags.getTagId("YCbCrCoefficients"))) {
            ++nycbcr;
        }
        if (metadata.containsTagId(TiffTags.getTagId("YCbCrSubSampling"))) {
            ++nycbcr;
        }
        if (metadata.containsTagId(TiffTags.getTagId("YCbCrPositioning"))) {
            ++nycbcr;
        }
        if (metadata.containsTagId(TiffTags.getTagId("ReferenceBlackWhite"))) {
            ++nycbcr;
        }
        if (nycbcr > 0 && nycbcr != 4) {
            this.checkRequiredTag(metadata, "YCbCrCoefficients", 3, "IFD" + n);
            this.checkRequiredTag(metadata, "YCbCrSubSampling", 2, "IFD" + n);
            this.checkRequiredTag(metadata, "YCbCrPositioning", 1, "IFD" + n);
            this.checkRequiredTag(metadata, "ReferenceBlackWhite", 6, "IFD" + n);
        }
        if (thumbnail) {
            this.checkForbiddenTag(metadata, "YCbCrCoefficients", "IFD" + n);
            this.checkForbiddenTag(metadata, "YCbCrSubSampling", "IFD" + n);
            this.checkForbiddenTag(metadata, "YCbCrPositioning", "IFD" + n);
            this.checkForbiddenTag(metadata, "ReferenceBlackWhite", "IFD" + n);
        }
        this.checkForbiddenTag(metadata, "PrimaryChromaticities", "IFD" + n);
        this.checkForbiddenTag(metadata, "WhitePoint", "IFD" + n);
        this.checkForbiddenTag(metadata, "TransferFunction", "IFD" + n);
        if (metadata.containsTagId(TiffTags.getTagId("FocalPlaneResolutionUnit")) && ((focal = (int)metadata.get("FocalPlaneResolutionUnit").getFirstNumericValue()) < 1 || focal > 5)) {
            this.validation.addErrorLoc("Invalid value fot TiffEP tag FocalPlaneResolutionUnit", "IFD" + n);
        }
        if (metadata.containsTagId(TiffTags.getTagId("SensingMethod")) && ((sensing = (int)metadata.get("SensingMethod").getFirstNumericValue()) < 0 || sensing > 8)) {
            this.validation.addErrorLoc("Invalid value fot TiffEP tag SensingMethod", "IFD" + n);
        }
    }

    @Deprecated
    private void validateSubIfd(IFD ifd, int n) {
        int comp;
        boolean thumbnail = ifd.getParent().getImageSize() > ifd.getImageSize();
        IfdTags metadata = ifd.getMetadata();
        this.checkRequiredTag(metadata, "ImageLength", 1, "SubIFD" + n);
        this.checkRequiredTag(metadata, "ImageWidth", 1, "SubIFD" + n);
        int spp = -1;
        if (this.checkRequiredTag(metadata, "SamplesPerPixel", 1, "SubIFD" + n)) {
            spp = (int)metadata.get("SamplesPerPixel").getFirstNumericValue();
            this.checkRequiredTag(metadata, "BitsPerSample", spp, "SubIFD" + n);
        }
        if (this.checkRequiredTag(metadata, "Compression", 1, "SubIFD" + n) && (comp = (int)metadata.get("Compression").getFirstNumericValue()) == 1) {
            this.checkForbiddenTag(metadata, "CompressedBitsPerPixel", "IFD" + n);
        }
        this.checkRequiredTag(metadata, "XResolution", 1, "SubIFD" + n);
        this.checkRequiredTag(metadata, "YResolution", 1, "SubIFD" + n);
        this.checkForbiddenTag(metadata, "SubIFDs", "IFD" + n);
        if (thumbnail) {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{1L}, "SubIFD" + n);
        } else {
            this.checkRequiredTag(metadata, "NewSubfileType", 1, new long[]{0L}, "SubIFD" + n);
        }
        if (this.checkRequiredTag(metadata, "PhotometricInterpretation", 1, new long[]{1L, 2L, 6L, 32803L, 32767L}, "SubIFD" + n)) {
            int photo = (int)metadata.get("PhotometricInterpretation").getFirstNumericValue();
            if (photo != 6) {
                this.checkForbiddenTag(metadata, "YCbCrCoefficients", "SubIFD" + n);
                this.checkForbiddenTag(metadata, "YCbCrSubSampling", "SubIFD" + n);
                this.checkForbiddenTag(metadata, "YCbCrPositioning", "SubIFD" + n);
                this.checkForbiddenTag(metadata, "ReferenceBlackWhite", "SubIFD" + n);
            }
            if (photo == 2 || photo == 3) {
                if (spp != 3) {
                    this.validation.addError("Invalid SampesPerPixel value fo TiffEP", "SubIFD" + n, spp);
                }
            } else if (photo == 1 || photo == 32803) {
                if (spp != 1) {
                    this.validation.addError("Invalid SampesPerPixel value fo TiffEP", "SubIFD" + n, spp);
                }
                if (photo == 32803) {
                    this.checkRequiredTag(metadata, "CFARepeatPatternDim", 2, "SubIFD" + n);
                    this.checkRequiredTag(metadata, "CFAPattern", -1, "SubIFD" + n);
                }
            }
        }
        this.checkRequiredTag(metadata, "PlanarConfiguration", 1, new long[]{1L, 2L}, "SubIFD" + n);
        this.checkRequiredTag(metadata, "ResolutionUnit", 1, new long[]{1L, 2L, 3L}, "SubIFD" + n);
        if (!thumbnail) {
            if (ifd.hasStrips()) {
                this.checkRequiredTag(metadata, "StripBYTECount", -1, "SubIFD" + n);
                this.checkRequiredTag(metadata, "StripOffsets", -1, "SubIFD" + n);
                this.checkRequiredTag(metadata, "RowsPerStrip", 1, "SubIFD" + n);
                if (ifd.hasTiles()) {
                    this.validation.addErrorLoc("Image in both strips and tiles", "SubIFD");
                }
            } else if (ifd.hasTiles()) {
                this.checkRequiredTag(metadata, "TileLength", 1, "SubIFD" + n);
                this.checkRequiredTag(metadata, "TileOffsets", 1, "SubIFD" + n);
                this.checkRequiredTag(metadata, "TileWidth", -1, "SubIFD" + n);
            }
        } else {
            this.checkRequiredTag(metadata, "StripBYTECount", -1, "SubIFD" + n);
            this.checkRequiredTag(metadata, "StripOffsets", -1, "SubIFD" + n);
            this.checkRequiredTag(metadata, "RowsPerStrip", 1, "SubIFD" + n);
            this.checkForbiddenTag(metadata, "TileLength", "SubIFD" + n);
            this.checkForbiddenTag(metadata, "TileOffsets", "SubIFD" + n);
            this.checkForbiddenTag(metadata, "TileWidth", "SubIFD" + n);
        }
        int nycbcr = 0;
        if (metadata.containsTagId(TiffTags.getTagId("YCbCrCoefficients"))) {
            ++nycbcr;
        }
        if (metadata.containsTagId(TiffTags.getTagId("YCbCrSubSampling"))) {
            ++nycbcr;
        }
        if (metadata.containsTagId(TiffTags.getTagId("YCbCrPositioning"))) {
            ++nycbcr;
        }
        if (metadata.containsTagId(TiffTags.getTagId("ReferenceBlackWhite"))) {
            ++nycbcr;
        }
        if (nycbcr > 0 && nycbcr != 4) {
            this.checkRequiredTag(metadata, "YCbCrCoefficients", 3, "SubIFD" + n);
            this.checkRequiredTag(metadata, "YCbCrSubSampling", 2, "SubIFD" + n);
            this.checkRequiredTag(metadata, "YCbCrPositioning", 1, "SubIFD" + n);
            this.checkRequiredTag(metadata, "ReferenceBlackWhite", 6, "SubIFD" + n);
        }
        if (thumbnail) {
            this.checkForbiddenTag(metadata, "YCbCrCoefficients", "IFD" + n);
            this.checkForbiddenTag(metadata, "YCbCrSubSampling", "IFD" + n);
            this.checkForbiddenTag(metadata, "YCbCrPositioning", "IFD" + n);
            this.checkForbiddenTag(metadata, "ReferenceBlackWhite", "IFD" + n);
        }
        this.checkForbiddenTag(metadata, "PrimaryChromaticities", "IFD" + n);
        this.checkForbiddenTag(metadata, "WhitePoint", "IFD" + n);
        this.checkForbiddenTag(metadata, "TransferFunction", "IFD" + n);
    }

    private boolean checkRequiredTag(IfdTags metadata, String tagName, int cardinality, long[] possibleValues, String ext) {
        boolean ok = true;
        int tagid = TiffTags.getTagId(tagName);
        if (!metadata.containsTagId(tagid)) {
            this.validation.addErrorLoc("Missing required tag for TiffEP " + tagName, ext);
            ok = false;
        } else if (cardinality != -1 && metadata.get(tagid).getCardinality() != cardinality) {
            this.validation.addError("Invalid cardinality for TiffEP tag " + tagName, ext, metadata.get(tagid).getCardinality());
        } else if (cardinality == 1 && possibleValues != null) {
            long val = metadata.get(tagid).getFirstNumericValue();
            boolean contained = false;
            for (int i = 0; i < possibleValues.length && !contained; ++i) {
                contained = possibleValues[i] == val;
            }
            if (!contained) {
                this.validation.addError("Invalid value for TiffEP tag " + tagName, ext, val);
            }
        }
        return ok;
    }

    private boolean checkRequiredTag(IfdTags metadata, String tagName, int cardinality, String ext) {
        return this.checkRequiredTag(metadata, tagName, cardinality, null, ext);
    }

    private void checkForbiddenTag(IfdTags metadata, String tagName, String ext) {
        int tagid = TiffTags.getTagId(tagName);
        if (metadata.containsTagId(tagid)) {
            this.validation.addErrorLoc("Forbidden tag for TiffEP found " + tagName, ext);
        }
    }
}

