/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.reader;

import com.easyinnova.tiff.model.ImageStrips;
import com.easyinnova.tiff.model.ImageTiles;
import com.easyinnova.tiff.model.Strip;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.Tile;
import com.easyinnova.tiff.model.types.IFD;
import java.util.ArrayList;

public class IfdReader {
    IFD ifd;
    int nextIfdOffset;

    public int getNextIfdOffset() {
        return this.nextIfdOffset;
    }

    public IFD getIfd() {
        return this.ifd;
    }

    public void setIfd(IFD ifd) {
        this.ifd = ifd;
    }

    public void setNextIfdOffset(int offset) {
        this.nextIfdOffset = offset;
    }

    public void readImage() {
        if (this.ifd.containsTagId(TiffTags.getTagId("StripOffsets")) || this.ifd.containsTagId(TiffTags.getTagId("StripBYTECount"))) {
            this.readStrips();
        }
        if (this.ifd.containsTagId(TiffTags.getTagId("TileOffsets")) || this.ifd.containsTagId(TiffTags.getTagId("TileBYTECounts"))) {
            this.readTiles();
        }
    }

    private void readTiles() {
        ImageTiles imageTiles = new ImageTiles();
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        if (this.ifd.containsTagId(TiffTags.getTagId("TileOffsets")) && this.ifd.containsTagId(TiffTags.getTagId("TileBYTECounts")) && this.ifd.containsTagId(TiffTags.getTagId("TileLength")) && this.ifd.containsTagId(TiffTags.getTagId("TileWidth"))) {
            long totalWidth = this.ifd.getTag("ImageWidth").getFirstNumericValue();
            long totalLength = this.ifd.getTag("ImageLength").getFirstNumericValue();
            long tilesWidth = this.ifd.getTag("TileWidth").getFirstNumericValue();
            long tilesHeight = this.ifd.getTag("TileLength").getFirstNumericValue();
            int actualWidth = 0;
            long actualHeight = tilesHeight;
            for (int i = 0; i < this.ifd.getTag("TileOffsets").getValue().size(); ++i) {
                try {
                    int to = this.ifd.getTag("TileOffsets").getValue().get(i).toInt();
                    Tile tile = new Tile();
                    tile.setOffset(to);
                    tile.setWidth((int)tilesWidth);
                    tile.setHeight((int)tilesHeight);
                    long padX = 0L;
                    long padY = 0L;
                    boolean newLine = false;
                    actualWidth = (int)((long)actualWidth + tilesWidth);
                    if ((long)actualWidth > totalWidth) {
                        padX = tilesWidth - (long)actualWidth % totalWidth;
                        newLine = true;
                    }
                    if (actualHeight > totalLength) {
                        padY = tilesHeight - actualHeight % totalLength;
                    }
                    tile.setPadding((int)padX, (int)padY);
                    if (newLine) {
                        actualHeight += tilesHeight;
                        actualWidth = 0;
                    }
                    tiles.add(tile);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            imageTiles.setTiles(tiles);
            imageTiles.setTileHeight((int)tilesHeight);
            imageTiles.setTileWidth((int)tilesWidth);
        }
        this.ifd.setImageTiles(imageTiles);
    }

    private void readStrips() {
        ImageStrips imageStrips = new ImageStrips();
        ArrayList<Strip> strips = new ArrayList<Strip>();
        long rps = 0L;
        if (this.ifd.containsTagId(TiffTags.getTagId("StripOffsets")) && this.ifd.containsTagId(TiffTags.getTagId("StripBYTECount"))) {
            long tsbc = this.ifd.getTag("StripBYTECount").getFirstNumericValue();
            long rowLength = tsbc / (rps = !this.ifd.containsTagId(TiffTags.getTagId("RowsPerStrip")) || this.ifd.getTag("RowsPerStrip").getCardinality() == 0 ? 1L : this.ifd.getTag("RowsPerStrip").getFirstNumericValue());
            if (rowLength == 0L) {
                rowLength = 1L;
            }
            for (int i = 0; i < this.ifd.getTag("StripOffsets").getValue().size(); ++i) {
                try {
                    int so = this.ifd.getTag("StripOffsets").getValue().get(i).toInt();
                    int sbc = this.ifd.getTag("StripBYTECount").getValue().get(i).toInt();
                    Strip strip = new Strip();
                    strip.setOffset(so);
                    strip.setLength(sbc);
                    strip.setStripRows((int)((long)sbc / rowLength));
                    strips.add(strip);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        imageStrips.setStrips(strips);
        imageStrips.setRowsPerStrip(rps);
        this.ifd.setImageStrips(imageStrips);
    }
}

