/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.reader;

import com.easyinnova.tiff.io.TiffInputStream;
import com.easyinnova.tiff.model.ByteOrder;
import com.easyinnova.tiff.model.IccProfileCreators;
import com.easyinnova.tiff.model.ReadIccConfigIOException;
import com.easyinnova.tiff.model.ReadTagsIOException;
import com.easyinnova.tiff.model.Tag;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.ValidationResult;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.model.types.abstractTiffType;
import com.easyinnova.tiff.profiles.BaselineProfile;
import com.easyinnova.tiff.profiles.TiffEPProfile;
import com.easyinnova.tiff.profiles.TiffITProfile;
import com.easyinnova.tiff.reader.IfdReader;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;

public class TiffReader {
    TiffDocument tiffModel = null;
    TiffInputStream data;
    int tagValueSize = 4;
    ValidationResult validation;
    int duplicateTagTolerance = 10;
    int nextIFDTolerance = 0;
    int byteOrderErrorTolerance = 0;

    public TiffReader() throws ReadTagsIOException, ReadIccConfigIOException {
        TiffTags.getTiffTags();
        IccProfileCreators.getIccProfileCreators();
    }

    public TiffDocument getModel() {
        return this.tiffModel;
    }

    public TiffInputStream getStream() {
        return this.data;
    }

    public ValidationResult getBaselineValidation() {
        return this.validation;
    }

    public ValidationResult getTiffEPValidation() {
        TiffEPProfile bpep = new TiffEPProfile(this.tiffModel);
        bpep.validate();
        return bpep.getValidation();
    }

    public ValidationResult getTiffITValidation(int profile) {
        TiffITProfile bpit = new TiffITProfile(this.tiffModel, profile);
        bpit.validate();
        return bpit.getValidation();
    }

    public int readFile(String filename) {
        return this.readFile(filename, true);
    }

    public int readFile(String filename, boolean validate) {
        int result = 0;
        try {
            if (Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
                this.data = new TiffInputStream(new File(filename));
                result = this.validate(validate);
            } else {
                result = -1;
                this.tiffModel.setFatalError(true, "File not found");
            }
        }
        catch (Exception ex) {
            result = -2;
            this.tiffModel.setFatalError(true, "IO Exception");
        }
        return result;
    }

    public int readFile(RandomAccessFile raf, boolean validate) {
        int result = 0;
        try {
            this.data = new TiffInputStream(raf);
            result = this.validate(validate);
        }
        catch (Exception ex) {
            result = -2;
            this.tiffModel.setFatalError(true, "IO Exception");
        }
        return result;
    }

    private int validate(boolean validate) {
        int result = 0;
        try {
            this.tiffModel = new TiffDocument();
            this.validation = new ValidationResult(validate);
            this.tiffModel.setSize(this.data.size());
            boolean correctHeader = this.readHeader();
            if (correctHeader) {
                if (this.tiffModel.getMagicNumber() < 42) {
                    this.validation.addError("Incorrect tiff magic number", "Header", this.tiffModel.getMagicNumber());
                } else if (this.tiffModel.getMagicNumber() == 43) {
                    this.validation.addErrorLoc("Big tiff file not yet supported", "Header");
                } else if (this.validation.isCorrect()) {
                    this.readIFDs();
                    if (validate) {
                        BaselineProfile bp = new BaselineProfile(this.tiffModel);
                        bp.validate();
                        this.getBaselineValidation().add(bp.getValidation());
                    }
                }
            }
            if (this.getBaselineValidation().getFatalError()) {
                this.tiffModel.setFatalError(true, this.getBaselineValidation().getFatalErrorMessage());
            }
            this.data.close();
        }
        catch (Exception ex) {
            result = -2;
            this.tiffModel.setFatalError(true, "IO Exception");
        }
        return result;
    }

    private boolean readHeader() {
        boolean correct = true;
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        int c1 = 0;
        int c2 = 0;
        try {
            c1 = this.data.readByte().toInt();
            c2 = this.data.readByte().toInt();
        }
        catch (Exception ex) {
            this.validation.addErrorLoc("Header IO Exception", "Header");
        }
        if (c1 == 73 && c2 == 73) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (c1 == 77 && c2 == 77) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (this.byteOrderErrorTolerance > 0 && c1 == 105 && c2 == 105) {
            this.validation.addWarning("Byte Order in lower case", "" + c1 + c2, "Header");
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (this.byteOrderErrorTolerance > 0 && c1 == 109 && c2 == 109) {
            this.validation.addWarning("Byte Order in lower case", "" + c1 + c2, "Header");
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (this.byteOrderErrorTolerance > 1) {
            this.validation.addWarning("Non-sense Byte Order. Trying Little Endian.", "" + c1 + c2, "Header");
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            this.validation.addErrorLoc("Invalid Byte Order " + c1 + c2, "Header");
            correct = false;
        }
        if (correct) {
            this.tiffModel.setByteOrder(byteOrder);
            this.data.setByteOrder(byteOrder);
            try {
                int magic = this.data.readShort().toInt();
                this.tiffModel.setMagicNumber(magic);
            }
            catch (Exception ex) {
                this.validation.addErrorLoc("Magic number parsing error", "Header");
                correct = false;
            }
        }
        return correct;
    }

    private void readIFDs() {
        int offset0 = 0;
        try {
            offset0 = this.data.readLong(4L).toInt();
            this.tiffModel.setFirstIFDOffset(offset0);
            if (offset0 == 0) {
                this.validation.addErrorLoc("There is no first IFD", "Header");
            } else if ((long)offset0 > this.data.size()) {
                this.validation.addErrorLoc("Incorrect offset", "Header");
            }
        }
        catch (Exception ex) {
            this.validation.addErrorLoc("IO exception", "Header");
        }
        if (this.validation.isCorrect()) {
            int nifd = 1;
            try {
                IfdReader ifd0 = this.readIFD(offset0, true, 0);
                HashSet<Integer> usedOffsets = new HashSet<Integer>();
                usedOffsets.add(offset0);
                if (ifd0.getIfd() == null) {
                    this.validation.addErrorLoc("Parsing error in first IFD", "IFD0");
                } else {
                    IFD iifd = ifd0.getIfd();
                    iifd.setNextOffset(ifd0.getNextIfdOffset());
                    this.tiffModel.addIfd0(iifd);
                    IfdReader current_ifd = ifd0;
                    boolean stop = false;
                    while (current_ifd.getNextIfdOffset() > 0 && !stop) {
                        if (usedOffsets.contains(current_ifd.getNextIfdOffset())) {
                            this.validation.addErrorLoc("IFD offset already used", "IFD" + nifd);
                            stop = true;
                            continue;
                        }
                        if ((long)current_ifd.getNextIfdOffset() > this.data.size()) {
                            this.validation.addErrorLoc("Incorrect offset", "IFD" + nifd);
                            stop = true;
                            continue;
                        }
                        usedOffsets.add(current_ifd.getNextIfdOffset());
                        IfdReader next_ifd = this.readIFD(current_ifd.getNextIfdOffset(), true, nifd);
                        if (next_ifd == null) {
                            this.validation.addErrorLoc("Parsing error in IFD " + nifd, "IFD" + nifd);
                            stop = true;
                        } else {
                            iifd = next_ifd.getIfd();
                            iifd.setNextOffset(next_ifd.getNextIfdOffset());
                            current_ifd.getIfd().setNextIFD(iifd);
                            current_ifd = next_ifd;
                        }
                        ++nifd;
                    }
                }
            }
            catch (Exception ex) {
                this.validation.addErrorLoc("IFD parsing error", "IFD" + nifd);
            }
            try {
                this.tiffModel.createMetadataDictionary();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private IfdReader readIFD(int offset, boolean isImage, int n) {
        IfdReader ir;
        block19: {
            IFD ifd = new IFD(isImage);
            ifd.setOffset(offset);
            ir = new IfdReader();
            ir.setIfd(ifd);
            int nextIfdOffset = 0;
            try {
                if (offset % 2 != 0) {
                    this.validation.addErrorLoc("Bad word alignment in the offset of the IFD", "IFD" + n);
                }
                int index = offset;
                int directoryEntries = this.data.readShort(offset).toInt();
                if (directoryEntries < 1) {
                    this.validation.addError("Incorrect number of IFD entries", "IFD" + n, directoryEntries);
                    this.validation.setFatalError(true, "Incorrect number of IFD entries");
                    break block19;
                }
                if (directoryEntries > 500) {
                    if (n < 0) {
                        this.validation.addError("Incorrect number of IFD entries", "SubIFD" + -n, directoryEntries);
                        this.validation.setFatalError(true, "Incorrect number of IFD entries");
                    } else {
                        this.validation.addError("Incorrect number of IFD entries", "IFD" + n, directoryEntries);
                        this.validation.setFatalError(true, "Incorrect number of IFD entries");
                    }
                    break block19;
                }
                index += 2;
                for (int i = 0; i < directoryEntries; ++i) {
                    TagValue tv;
                    int tagid = 0;
                    int tagType = -1;
                    int tagN = -1;
                    try {
                        tagid = this.data.readShort(index).toInt();
                        tagType = this.data.readShort(index + 2).toInt();
                        tagN = this.data.readLong(index + 4).toInt();
                        boolean ok = this.checkType(tagid, tagType, n);
                        if (!ok && tagN > 1000) {
                            tagN = 1000;
                        }
                        tv = this.getValue(tagType, tagN, tagid, index + 8, ifd, n);
                        if (ifd.containsTagId(tagid)) {
                            if (this.duplicateTagTolerance > 0) {
                                this.validation.addWarning("Duplicate tag", "" + tagid, "IFD" + n);
                            } else {
                                this.validation.addError("Duplicate tag", "IFD" + n, tagid);
                            }
                        }
                        ifd.addTag(tv);
                    }
                    catch (Exception ex) {
                        this.validation.addErrorLoc("Parse error in tag #" + i + " (" + tagid + ")", "IFD" + n);
                        tv = new TagValue(tagid, tagType);
                        tv.setReadOffset(index + 8);
                        tv.setReadLength(tagN);
                        ifd.addTag(tv);
                    }
                    index += 12;
                }
                nextIfdOffset = 0;
                try {
                    nextIfdOffset = this.data.readLong(index).toInt();
                }
                catch (Exception ex) {
                    nextIfdOffset = 0;
                    if (this.nextIFDTolerance > 0) {
                        this.validation.addWarning("Unreadable next IFD offset", "", "IFD" + n);
                    }
                    this.validation.addErrorLoc("Unreadable next IFD offset", "IFD" + n);
                }
                if (nextIfdOffset > 0 && nextIfdOffset < 7) {
                    this.validation.addError("Invalid next IFD offset", "IFD" + n, nextIfdOffset);
                    nextIfdOffset = 0;
                }
                ir.setNextIfdOffset(nextIfdOffset);
                ir.readImage();
                if (isImage && !ifd.hasStrips() && !ifd.hasTiles()) {
                    this.validation.setFatalError(true, "Incorrect image");
                }
            }
            catch (Exception ex) {
                this.validation.addErrorLoc("IO Exception", "IFD" + n);
                return null;
            }
        }
        return ir;
    }

    private boolean checkType(int tagid, int tagType, int n) {
        if (TiffTags.hasTag(tagid) && !TiffTags.getTag(tagid).getName().equals("IPTC")) {
            boolean found = false;
            String stagType = TiffTags.getTagTypeName(tagType);
            if (stagType != null) {
                if (stagType.equals("SUBIFD")) {
                    stagType = "IFD";
                }
                if (stagType.equals("UNDEFINED")) {
                    stagType = "BYTE";
                }
                for (String vType : TiffTags.getTag(tagid).getType()) {
                    String vType2 = vType;
                    if (vType2.equals("UNDEFINED")) {
                        vType2 = "BYTE";
                    }
                    if (!vType2.equals(stagType)) continue;
                    found = true;
                }
            }
            if (!found) {
                this.validation.addError("Incorrect type for tag " + TiffTags.getTag(tagid).getName(), "IFD" + n, stagType);
                return false;
            }
            return true;
        }
        return false;
    }

    protected TagValue getValue(int tagtype, int n, int id, int beginOffset, IFD parentIFD, int nifd) {
        Tag t;
        int type = tagtype;
        if (id == 330 && type != 13) {
            type = 13;
        }
        TagValue tv = new TagValue(id, type);
        tv.setTagOffset(beginOffset - 8);
        int offset = beginOffset;
        int typeSize = TiffTags.getTypeSize(type);
        boolean ok = true;
        if (typeSize * n > this.tagValueSize) {
            try {
                offset = this.data.readLong(offset).toInt();
                if (offset % 2 != 0) {
                    this.validation.addErrorLoc("Bad word alignment in the offset of tag " + id, "IFD" + n);
                }
            }
            catch (Exception ex) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + n);
                ok = false;
            }
        }
        tv.setReadOffset(offset);
        tv.setReadLength(n);
        if (ok) {
            try {
                for (int i = 0; i < n; ++i) {
                    switch (type) {
                        case 1: {
                            tv.add(this.data.readByte(offset));
                            break;
                        }
                        case 2: {
                            tv.add(this.data.readAscii(offset));
                            break;
                        }
                        case 6: {
                            tv.add(this.data.readSByte(offset));
                            break;
                        }
                        case 7: {
                            tv.add(this.data.readUndefined(offset));
                            break;
                        }
                        case 3: {
                            tv.add(this.data.readShort(offset));
                            break;
                        }
                        case 8: {
                            tv.add(this.data.readSShort(offset));
                            break;
                        }
                        case 4: {
                            tv.add(this.data.readLong(offset));
                            break;
                        }
                        case 9: {
                            tv.add(this.data.readSLong(offset));
                            break;
                        }
                        case 5: {
                            tv.add(this.data.readRational(offset));
                            break;
                        }
                        case 10: {
                            tv.add(this.data.readSRational(offset));
                            break;
                        }
                        case 11: {
                            tv.add(this.data.readFloat(offset));
                            break;
                        }
                        case 12: {
                            tv.add(this.data.readDouble(offset));
                            break;
                        }
                        case 13: {
                            int ifdOffset = this.data.readLong(offset).toInt();
                            if (ifdOffset % 2 != 0) {
                                this.validation.addErrorLoc("Bad word alignment in the offset of the sub IFD", "IFD" + n);
                            }
                            IfdReader ifd = this.readIFD(ifdOffset, true, -nifd);
                            IFD subIfd = ifd.getIfd();
                            subIfd.setParent(parentIFD);
                            parentIFD.setsubIFD(subIfd);
                            tv.add(subIfd);
                        }
                    }
                    offset += typeSize;
                }
            }
            catch (Exception ex) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
                ok = false;
            }
        }
        if (type == 2) {
            tv.readString();
        }
        if (ok && TiffTags.hasTag(id) && (t = TiffTags.getTag(id)).hasTypedef() && !t.getTypedef().equals("SubIFD")) {
            String tagclass = t.getTypedef();
            try {
                abstractTiffType instanceOfMyClass = (abstractTiffType)Class.forName("com.easyinnova.tiff.model.types." + tagclass).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (instanceOfMyClass.isIFD()) {
                    long ifdOffset = tv.getFirstNumericValue();
                    try {
                        if (ifdOffset % 2L != 0L) {
                            this.validation.addErrorLoc("Bad word alignment in the offset of Exif", "IFD" + n);
                        }
                        IfdReader ifd = this.readIFD((int)ifdOffset, false, -1);
                        IFD exifIfd = ifd.getIfd();
                        exifIfd.setIsIFD(true);
                        tv.clear();
                        tv.add(exifIfd);
                    }
                    catch (Exception ex) {
                        this.validation.addErrorLoc("Parse error in Exif", "IFD" + nifd);
                    }
                } else if (tv.getId() == 33723) {
                    instanceOfMyClass.read(tv, this.data.getFilePath());
                } else {
                    instanceOfMyClass.read(tv);
                }
            }
            catch (ClassNotFoundException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (NoSuchMethodException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (SecurityException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (InstantiationException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (IllegalAccessException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (IllegalArgumentException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (InvocationTargetException e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
            catch (Exception e) {
                this.validation.addErrorLoc("Parse error getting tag " + id + " value", "IFD" + nifd);
            }
        }
        if (ok) {
            tv.setReadValue();
        }
        return tv;
    }
}

