/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.writer;

import com.easyinnova.tiff.io.TiffInputStream;
import com.easyinnova.tiff.io.TiffOutputStream;
import com.easyinnova.tiff.model.ByteOrder;
import com.easyinnova.tiff.model.IfdTags;
import com.easyinnova.tiff.model.TagValue;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.model.TiffTags;
import com.easyinnova.tiff.model.types.Double;
import com.easyinnova.tiff.model.types.Float;
import com.easyinnova.tiff.model.types.IFD;
import com.easyinnova.tiff.model.types.IPTC;
import com.easyinnova.tiff.model.types.Long;
import com.easyinnova.tiff.model.types.Rational;
import com.easyinnova.tiff.model.types.SLong;
import com.easyinnova.tiff.model.types.SRational;
import com.easyinnova.tiff.model.types.SShort;
import com.easyinnova.tiff.model.types.XMP;
import com.easyinnova.tiff.model.types.XmlType;
import com.easyinnova.tiff.model.types.abstractTiffType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class TiffWriter {
    TiffDocument model = new TiffDocument();
    TiffOutputStream data;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    TiffInputStream input;

    public TiffWriter(TiffInputStream in) {
        this.input = in;
    }

    public void SetModel(TiffDocument model) {
        this.model = model;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void write(String filename) throws Exception {
        this.data = new TiffOutputStream(this.input);
        this.data.setByteOrder(this.byteOrder);
        try {
            this.data.create(filename);
            this.writeHeader();
            this.writeIfds();
            this.data.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.data != null) {
                this.data.close();
            }
            throw ex;
        }
    }

    public void writeHeader() throws IOException {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.data.put((byte)73);
            this.data.put((byte)73);
        } else if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.data.put((byte)77);
            this.data.put((byte)77);
        }
        this.data.putShort((short)42);
    }

    public void writeIfds() throws IOException {
        IFD first = this.model.getFirstIFD();
        IFD current = first;
        if (current != null) {
            this.data.putInt((int)this.data.position() + 4);
        }
        while (current != null) {
            this.writeIFD(current);
            current = current.getNextIFD();
        }
    }

    private int classifyTags(IFD ifd, ArrayList<TagValue> oversized, ArrayList<TagValue> undersized) {
        int tagValueSize = 4;
        int n = 0;
        for (TagValue tag : ifd.getMetadata().getTags()) {
            int tagsize = this.getTagSize(tag);
            if (tagsize > tagValueSize) {
                oversized.add(tag);
            } else {
                undersized.add(tag);
            }
            ++n;
        }
        return n;
    }

    public void writeIFD(IFD ifd) throws IOException {
        ArrayList<TagValue> oversizedTags = new ArrayList<TagValue>();
        ArrayList<TagValue> undersizedTags = new ArrayList<TagValue>();
        int ntags = this.classifyTags(ifd, oversizedTags, undersizedTags);
        HashMap<Integer, Integer> pointers = new HashMap<Integer, Integer>();
        this.data.putShort((short)ntags);
        ArrayList<TagValue> ltags = ifd.getTags().getTags();
        Collections.sort(ltags, new Comparator<TagValue>(){

            @Override
            public int compare(TagValue a1, TagValue a2) {
                return a1.getId() - a2.getId();
            }
        });
        for (TagValue tv : ltags) {
            int n = tv.getCardinality();
            int id = tv.getId();
            int tagtype = tv.getType();
            this.data.putShort((short)id);
            this.data.putShort((short)tagtype);
            if (id == 700 && tv.getValue().size() > 0) {
                n = ((XMP)tv.getValue().get(0)).getLength();
            }
            if (id == 34675) {
                n = tv.getReadlength();
            }
            if (id == 33723 && tv.getValue().size() > 0) {
                abstractTiffType att = tv.getValue().get(0);
                if (att instanceof IPTC) {
                    IPTC iptc = (IPTC)att;
                    n = iptc.getLength();
                } else {
                    n = tv.getCardinality();
                }
            }
            this.data.putInt(n);
            pointers.put(id, (int)this.data.position());
            int startpos = (int)this.data.position();
            if (oversizedTags.contains(tv)) {
                this.data.putInt(1);
                continue;
            }
            this.writeTagValue(tv);
            while ((int)this.data.position() - startpos < 4) {
                this.data.put((byte)0);
            }
        }
        long positionNextIfdOffset = this.data.position();
        this.data.putInt(0);
        for (TagValue tv : oversizedTags) {
            int currentPosition = (int)this.data.position();
            if (currentPosition % 2 != 0) {
                ++currentPosition;
            }
            this.data.seek((Integer)pointers.get(tv.getId()));
            this.data.putInt(currentPosition);
            this.data.seek(currentPosition);
            this.writeTagValue(tv);
        }
        if (ifd.hasStrips()) {
            ArrayList<Integer> offsets;
            long stripOffsetsPointer = this.data.position();
            if (stripOffsetsPointer % 2L != 0L) {
                this.data.put((byte)0);
                stripOffsetsPointer = (int)this.data.position();
            }
            if ((offsets = this.writeStripData(ifd)).size() > 1) {
                stripOffsetsPointer = this.data.position();
                for (int off : offsets) {
                    this.data.putInt(off);
                }
            }
            int currentPosition = (int)this.data.position();
            this.data.seek((Integer)pointers.get(273));
            this.data.putInt((int)stripOffsetsPointer);
            this.data.seek(currentPosition);
        } else if (ifd.hasTiles()) {
            ArrayList<Integer> offsets;
            long tilesOffsetsPointer = this.data.position();
            if (tilesOffsetsPointer % 2L != 0L) {
                this.data.put((byte)0);
                tilesOffsetsPointer = (int)this.data.position();
            }
            if ((offsets = this.writeTileData(ifd)).size() > 1) {
                tilesOffsetsPointer = this.data.position();
                for (int off : offsets) {
                    this.data.putInt(off);
                }
            }
            int currentPosition = (int)this.data.position();
            this.data.seek((Integer)pointers.get(324));
            this.data.putInt((int)tilesOffsetsPointer);
            this.data.seek(currentPosition);
        }
        if (ifd.hasNextIFD()) {
            int currentPosition = (int)this.data.position();
            if (currentPosition % 2 != 0) {
                ++currentPosition;
            }
            this.data.seek((int)positionNextIfdOffset);
            this.data.putInt(currentPosition);
            this.data.seek(currentPosition);
        }
    }

    private int getTagSize(TagValue tag) {
        int n = tag.getCardinality();
        int id = tag.getId();
        int type = tag.getType();
        if (id == 330) {
            n = 1000;
        }
        if (id == 700 && tag.getValue().size() > 0) {
            n = tag.getValue().get(0).toString().length();
        }
        if (id == 33723) {
            n = tag.getReadlength();
        }
        if (id == 34665) {
            n = 1000;
        }
        if (id == 34675) {
            n = tag.getReadlength();
        }
        int typeSize = TiffTags.getTypeSize(type);
        int tagSize = typeSize * n;
        return tagSize;
    }

    private void writeTagValue(TagValue tag) throws IOException {
        int id = tag.getId();
        block16: for (abstractTiffType tt : tag.getValue()) {
            if (id == 700) {
                XMP xmp = (XMP)tt;
                try {
                    xmp.write(this.data);
                    continue;
                }
                catch (Exception ex) {
                    XmlType xml = (XmlType)tt;
                    try {
                        xml.writeXml(this.data);
                        continue;
                    }
                    catch (Exception exx) {
                        exx.printStackTrace();
                        throw new IOException();
                    }
                }
            }
            if (id == 33723) {
                abstractTiffType att = tag.getValue().get(0);
                if (att instanceof IPTC) {
                    IPTC iptc = (IPTC)att;
                    iptc.write(this.data);
                    continue;
                }
                for (int i = 0; i < tag.getValue().size(); ++i) {
                    this.data.put(tag.getValue().get(i).toByte());
                }
                this.data.put((byte)0);
                continue;
            }
            if (id == 330) {
                IFD subifd = (IFD)tag.getValue().get(0);
                this.writeIFD(subifd);
                continue;
            }
            if (id == 34665) {
                IFD exif = (IFD)tag.getValue().get(0);
                this.writeIFD(exif);
                continue;
            }
            if (id == 34675) {
                for (int off = tag.getReadOffset(); off < tag.getReadOffset() + tag.getReadlength(); ++off) {
                    this.data.put(this.input.readByte(off).toByte());
                }
                this.data.put((byte)0);
                continue;
            }
            switch (tag.getType()) {
                case 3: {
                    this.data.putShort((short)tt.toInt());
                    continue block16;
                }
                case 8: {
                    this.data.putSShort((SShort)tt);
                    continue block16;
                }
                case 4: {
                    this.data.putLong((Long)tt);
                    continue block16;
                }
                case 9: {
                    this.data.putSLong((SLong)tt);
                    continue block16;
                }
                case 11: {
                    this.data.putFloat((Float)tt);
                    continue block16;
                }
                case 13: {
                    this.data.putInt(tt.toInt());
                    continue block16;
                }
                case 5: {
                    this.data.putRational((Rational)tt);
                    continue block16;
                }
                case 10: {
                    this.data.putSRational((SRational)tt);
                    continue block16;
                }
                case 12: {
                    this.data.putDouble((Double)tt);
                    continue block16;
                }
                case 2: {
                    this.data.put(tt.toByte());
                    continue block16;
                }
            }
            this.data.put(tt.toByte());
        }
    }

    private ArrayList<Integer> writeStripData(IFD ifd) throws IOException {
        ArrayList<Integer> newStripOffsets = new ArrayList<Integer>();
        IfdTags metadata = ifd.getMetadata();
        TagValue stripOffsets = metadata.get(273);
        TagValue stripSizes = metadata.get(279);
        for (int i = 0; i < stripOffsets.getCardinality(); ++i) {
            try {
                int pos = (int)this.data.position();
                newStripOffsets.add(pos);
                int start = stripOffsets.getValue().get(i).toInt();
                int size = stripSizes.getValue().get(i).toInt();
                this.input.seekOffset(start);
                for (int off = start; off < start + size; ++off) {
                    byte v = this.input.readDirectByte();
                    this.data.put(v);
                }
                if (this.data.position() % 2L == 0L) continue;
                this.data.put((byte)0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newStripOffsets;
    }

    private ArrayList<Integer> writeTileData(IFD ifd) throws IOException {
        ArrayList<Integer> newTileOffsets = new ArrayList<Integer>();
        IfdTags metadata = ifd.getMetadata();
        TagValue tileOffsets = metadata.get(324);
        TagValue tileSizes = metadata.get(325);
        for (int i = 0; i < tileOffsets.getCardinality(); ++i) {
            int pos = (int)this.data.position();
            if (pos % 2 != 0) {
                this.data.put((byte)0);
                pos = (int)this.data.position();
            }
            newTileOffsets.add(pos);
            this.input.seekOffset(tileOffsets.getValue().get(i).toInt());
            for (int j = 0; j < tileSizes.getValue().get(i).toInt(); ++j) {
                byte v = this.input.readDirectByte();
                this.data.put(v);
            }
            if (this.data.position() % 2L == 0L) continue;
            this.data.put((byte)0);
        }
        return newTileOffsets;
    }
}

