/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j;

import com.nmote.iim4j.IIMReader;
import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.dataset.DefaultDataSet;
import com.nmote.iim4j.stream.IIMInputStream;
import com.nmote.iim4j.stream.IIMOutputStream;
import java.io.EOFException;
import java.io.IOException;

class CachedDataSet
extends DefaultDataSet {
    private IIMInputStream input;
    private long pos;
    private int length;

    public CachedDataSet(IIMInputStream input, long pos, int length, DataSetInfo info) {
        super(info);
        this.input = input;
        this.pos = pos;
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        CachedDataSet cachedDataSet = this;
        synchronized (cachedDataSet) {
            byte[] data = super.getData();
            if (data == null && this.input != null) {
                try {
                    IIMInputStream iIMInputStream = this.input;
                    synchronized (iIMInputStream) {
                        this.input.seek(this.pos);
                        data = IIMReader.readFully(this.input, this.length);
                    }
                    super.setData(data);
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to read DataSet data: " + e);
                }
                finally {
                    this.input = null;
                }
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDataTo(IIMOutputStream out) throws IOException {
        CachedDataSet cachedDataSet = this;
        synchronized (cachedDataSet) {
            byte[] data = super.getData();
            if (data != null) {
                out.write(data);
            } else if (this.input != null) {
                IIMInputStream iIMInputStream = this.input;
                synchronized (iIMInputStream) {
                    int r;
                    this.input.seek(this.pos);
                    byte[] buffer = new byte[Math.min(this.length, 2048)];
                    for (int copied = 0; copied < this.length; copied += r) {
                        r = this.input.read(buffer);
                        if (r < 0) {
                            throw new EOFException("premature end-of-file reached");
                        }
                        out.write(buffer);
                    }
                }
            } else {
                throw new IOException("invalid state");
            }
        }
    }

    public int getLength() {
        return this.length;
    }
}

