/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j;

import com.nmote.iim4j.IIM;
import com.nmote.iim4j.IIMDataSetInfoFactory;
import com.nmote.iim4j.IIMFormatException;
import com.nmote.iim4j.IIMReader;
import com.nmote.iim4j.IIMWriter;
import com.nmote.iim4j.LoggerAdapter;
import com.nmote.iim4j.dataset.DataSet;
import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.dataset.DataSetInfoFactory;
import com.nmote.iim4j.dataset.DefaultDataSet;
import com.nmote.iim4j.dataset.InvalidDataSetException;
import com.nmote.iim4j.dataset.UnsupportedDataSetException;
import com.nmote.iim4j.serialize.DefaultSerializationContext;
import com.nmote.iim4j.serialize.SerializationContext;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.serialize.Serializer;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIMFile
extends DefaultSerializationContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 100L;
    private SerializationContext activeSerializationContext = this;
    private List<DataSet> dataSets = new ArrayList<DataSet>();
    private DataSetInfoFactory dsiFactory;
    private LoggerAdapter log;
    private boolean recoverFromIIMFormat = true;
    private boolean recoverFromInvalidDataSet = true;
    private boolean recoverFromUnsupportedDataSet = true;
    private SerializationContext serializationContext;
    private boolean stopAfter9_10 = true;

    public IIMFile() {
        this(IIMDataSetInfoFactory.VERSION_4);
    }

    public IIMFile(DataSetInfoFactory dsiFactory) {
        this.dsiFactory = dsiFactory;
    }

    public void add(DataSet dataSet) {
        this.dataSets.add(dataSet);
    }

    public void add(int ds, Object value) throws SerializationException, InvalidDataSetException {
        if (value == null) {
            return;
        }
        DataSetInfo dsi = this.dsiFactory.create(ds);
        byte[] data = dsi.getSerializer().serialize(value, this.activeSerializationContext);
        DefaultDataSet dataSet = new DefaultDataSet(dsi, data);
        this.dataSets.add(dataSet);
    }

    public void addDateTimeHelper(int ds, Date date) throws SerializationException, InvalidDataSetException {
        if (date == null) {
            return;
        }
        DataSetInfo dsi = this.dsiFactory.create(ds);
        SimpleDateFormat df = new SimpleDateFormat(dsi.getSerializer().toString());
        String value = df.format(date);
        byte[] data = dsi.getSerializer().serialize(value, this.activeSerializationContext);
        DefaultDataSet dataSet = new DefaultDataSet(dsi, data);
        this.add(dataSet);
    }

    public void addDateTimeHelper(int dsDate, int dsTime, Date date) throws SerializationException, InvalidDataSetException {
        if (date == null) {
            return;
        }
        this.addDateTimeHelper(dsDate, date);
        this.addDateTimeHelper(dsTime, date);
    }

    public IIMFile clone() {
        IIMFile file = new IIMFile(this.dsiFactory);
        file.dataSets = new ArrayList<DataSet>(this.dataSets);
        file.serializationContext = this.serializationContext == this ? file : this.serializationContext;
        file.activeSerializationContext = this.activeSerializationContext == this ? file : this.activeSerializationContext;
        return file;
    }

    public Object get(int dataSet) throws SerializationException {
        Object result = null;
        for (DataSet ds : this.dataSets) {
            DataSetInfo info = ds.getInfo();
            if (info.getDataSetNumber() != dataSet) continue;
            result = this.getData(ds);
            break;
        }
        return result;
    }

    public List<Object> getAll(int dataSet) throws SerializationException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DataSet ds : this.dataSets) {
            DataSetInfo info = ds.getInfo();
            if (info.getDataSetNumber() != dataSet) continue;
            result.add(this.getData(ds));
        }
        return result;
    }

    public List<DataSet> getDataSets() {
        return this.dataSets;
    }

    public Date getDateTimeHelper(int dateDataSet, int timeDataSet) {
        DataSet dateDS = null;
        DataSet timeDS = null;
        Iterator<DataSet> i = this.dataSets.iterator();
        while ((dateDS == null || timeDS == null) && i.hasNext()) {
            DataSet ds = i.next();
            DataSetInfo info = ds.getInfo();
            if (info.getDataSetNumber() == dateDataSet) {
                dateDS = ds;
                continue;
            }
            if (info.getDataSetNumber() != timeDataSet) continue;
            timeDS = ds;
        }
        Date result = null;
        if (dateDS != null && timeDS != null) {
            DataSetInfo dateDSI = dateDS.getInfo();
            DataSetInfo timeDSI = timeDS.getInfo();
            SimpleDateFormat format = new SimpleDateFormat(dateDSI.getSerializer().toString() + timeDSI.getSerializer().toString());
            StringBuffer date = new StringBuffer(20);
            try {
                date.append(this.getData(dateDS));
                date.append(this.getData(timeDS));
                result = format.parse(date.toString());
            }
            catch (ParseException e) {
            }
            catch (SerializationException e) {
                // empty catch block
            }
        }
        return result;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public boolean isRecoverFromIIMFormat() {
        return this.recoverFromIIMFormat;
    }

    public boolean isRecoverFromInvalidDataSet() {
        return this.recoverFromInvalidDataSet;
    }

    public boolean isRecoverFromUnsupportedDataSet() {
        return this.recoverFromUnsupportedDataSet;
    }

    public boolean isStopAfter9_10() {
        return this.stopAfter9_10;
    }

    public void readFrom(IIMReader reader) throws IOException, InvalidDataSetException {
        this.readFrom(reader, Integer.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    public void readFrom(IIMReader reader, int recover) throws IOException, InvalidDataSetException {
        doLog = this.log != null;
        block5: while (true) lbl-1000:
        // 4 sources

        {
            try {
                while ((ds = reader.read()) != null) {
                    if (doLog) {
                        this.log.debug("Read data set " + ds);
                    }
                    if ((s = (info = ds.getInfo()).getSerializer()) != null && info.getDataSetNumber() == IIM.DS(1, 90)) {
                        this.setCharacterSet((String)s.deserialize(ds.getData(), this.activeSerializationContext));
                    }
                    this.dataSets.add(ds);
                    if (!this.stopAfter9_10 || info.getDataSetNumber() != IIM.DS(9, 10)) continue;
                    break block5;
                }
            }
            catch (IIMFormatException e) {
                block14: {
                    if (!this.recoverFromIIMFormat || recover-- <= 0) break block14;
                    r = reader.recover();
                    if (doLog) {
                        this.log.debug(r != false ? "Recoved from " + e : "Failed to recover from " + e);
                    }
                    if (r) ** GOTO lbl-1000
                    break;
                }
                throw e;
            }
            catch (UnsupportedDataSetException e) {
                block15: {
                    if (!this.recoverFromUnsupportedDataSet || recover-- <= 0) break block15;
                    r = reader.recover();
                    if (doLog) {
                        this.log.debug(r != false ? "Recoved from " + e : "Failed to recover from " + e);
                    }
                    if (r) ** GOTO lbl-1000
                    break;
                }
                throw e;
            }
            catch (InvalidDataSetException e) {
                if (this.recoverFromInvalidDataSet && recover-- > 0) {
                    r = reader.recover();
                    if (!doLog) continue;
                    this.log.debug(r != false ? "Recoved from " + e : "Failed to recover from " + e);
                    if (r) continue;
                    break;
                }
                throw e;
            }
            catch (IOException e) {
                if (recover-- > 0 && !this.dataSets.isEmpty()) {
                    if (doLog) {
                        this.log.error("IOException while reading, however some data sets where recovered, " + e);
                    }
                    return;
                }
                throw e;
            }
            break;
        }
    }

    public boolean remove(int dataSet) {
        boolean result = false;
        Iterator<DataSet> i = this.dataSets.iterator();
        while (i.hasNext()) {
            DataSet ds = i.next();
            DataSetInfo info = ds.getInfo();
            if (info.getDataSetNumber() != dataSet) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean removeRecord(int record) {
        boolean result = false;
        Iterator<DataSet> i = this.dataSets.iterator();
        while (i.hasNext()) {
            DataSet ds = i.next();
            DataSetInfo info = ds.getInfo();
            if (info.getDataSetNumber() >> 8 != record) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public void setLog(LoggerAdapter log) {
        this.log = log;
    }

    public void setRecoverFromIIMFormat(boolean recoverFromIIMFormat) {
        this.recoverFromIIMFormat = recoverFromIIMFormat;
    }

    public void setRecoverFromInvalidDataSet(boolean recoverFromInvalidDataSet) {
        this.recoverFromInvalidDataSet = recoverFromInvalidDataSet;
    }

    public void setRecoverFromUnsupportedDataSet(boolean recoverFromUnsupportedDataSet) {
        this.recoverFromUnsupportedDataSet = recoverFromUnsupportedDataSet;
    }

    public void setSerializationContext(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
        this.activeSerializationContext = serializationContext != null ? serializationContext : this;
    }

    public void setStopAfter9_10(boolean stopAfter9_10) {
        this.stopAfter9_10 = stopAfter9_10;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IIMFile(");
        b.append("dataSets=");
        b.append(this.dataSets);
        b.append(')');
        return b.toString();
    }

    public void writeTo(IIMWriter writer) throws IOException {
        boolean doLog = this.log != null;
        for (DataSet ds : this.dataSets) {
            writer.write(ds);
            if (!doLog) continue;
            this.log.debug("Wrote data set " + ds);
        }
    }

    private Object getData(DataSet ds) throws SerializationException {
        DataSetInfo info = ds.getInfo();
        Serializer s = info.getSerializer();
        Object result = s != null ? (Object)s.deserialize(ds.getData(), this.activeSerializationContext) : ds.getData();
        return result;
    }
}

