/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j;

import com.nmote.iim4j.CachedDataSet;
import com.nmote.iim4j.IIMDataSetInfoFactory;
import com.nmote.iim4j.IIMFormatException;
import com.nmote.iim4j.dataset.DataSet;
import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.dataset.DataSetInfoFactory;
import com.nmote.iim4j.dataset.DefaultDataSet;
import com.nmote.iim4j.dataset.InvalidDataSetException;
import com.nmote.iim4j.stream.IIMInputStream;
import java.io.EOFException;
import java.io.IOException;

public class IIMReader {
    private long pos = 0L;
    private IIMInputStream input;
    private DataSetInfoFactory dsiFactory;

    public IIMReader(IIMInputStream input) {
        this(input, IIMDataSetInfoFactory.VERSION_4);
    }

    public IIMReader(IIMInputStream input, DataSetInfoFactory dsiFactory) {
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        if (dsiFactory == null) {
            throw new NullPointerException("dsiFactory == null");
        }
        this.input = input;
        this.dsiFactory = dsiFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet read() throws IOException, InvalidDataSetException {
        if (this.input == null) {
            throw new IOException("input was closed");
        }
        IIMInputStream iIMInputStream = this.input;
        synchronized (iIMInputStream) {
            int tag;
            boolean cached = this.input.isCached();
            if (cached) {
                this.input.seek(this.pos);
            }
            if ((tag = this.input.read()) == -1) {
                this.close();
                return null;
            }
            if (tag != 28) {
                throw new IIMFormatException("expected TAG 0x1C");
            }
            int recordNumber = this.readAndThrowEOF();
            int dataSetNumber = this.readAndThrowEOF();
            DataSetInfo info = this.dsiFactory.create(recordNumber << 8 | dataSetNumber);
            int oc1 = this.readAndThrowEOF();
            int oc2 = this.readAndThrowEOF();
            DefaultDataSet result = null;
            int length = oc1 << 8 | oc2;
            if (length > Short.MAX_VALUE) {
                int count = length & Short.MAX_VALUE;
                if (count < 1) {
                    throw new IIMFormatException("too short extended data set count: " + count);
                }
                if (count > 4) {
                    throw new IIMFormatException("too long extended data set count: " + count);
                }
                length = this.readAndThrowEOF();
                for (int i = 1; i < count; ++i) {
                    length = length << 8 | this.readAndThrowEOF();
                }
            }
            if (cached) {
                result = new CachedDataSet(this.input, this.input.position(), length, info);
                this.input.seek(this.input.position() + (long)length);
            } else {
                result = new DefaultDataSet(info, IIMReader.readFully(this.input, length));
            }
            this.pos = this.input.position();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws IOException {
        if (!this.input.isCached()) {
            throw new IllegalStateException("can't recover using input that isn't cached");
        }
        IIMInputStream iIMInputStream = this.input;
        synchronized (iIMInputStream) {
            this.input.seek(this.pos + 1L);
            int tag = this.input.read();
            while (tag != 28) {
                if (tag == -1) {
                    this.close();
                    return false;
                }
                tag = this.input.read();
            }
            this.pos = this.input.position() - 1L;
            this.input.seek(this.pos);
            return true;
        }
    }

    static byte[] readFully(IIMInputStream input, int length) throws IOException {
        int r;
        byte[] data = new byte[length];
        for (int offset = 0; offset < length; offset += r) {
            r = input.read(data, offset, length - offset);
            if (r != -1) continue;
            throw new EOFException();
        }
        return data;
    }

    private int readAndThrowEOF() throws IOException {
        int r = this.input.read();
        if (r == -1) {
            throw new EOFException();
        }
        return r;
    }

    public void close() throws IOException {
        try {
            if (this.input != null && !this.input.isCached()) {
                this.input.close();
            }
        }
        finally {
            this.input = null;
        }
    }
}

