/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.dataset;

import com.nmote.iim4j.dataset.DataSet;
import com.nmote.iim4j.dataset.DataSetInfo;
import com.nmote.iim4j.serialize.DefaultSerializationContext;
import com.nmote.iim4j.serialize.SerializationException;

public class DefaultDataSet
implements DataSet {
    private DataSetInfo info;
    private byte[] data;

    public DefaultDataSet(DataSetInfo info, byte[] data) {
        this.setInfo(info);
        this.setData(data);
    }

    protected DefaultDataSet(DataSetInfo info) {
        this.setInfo(info);
    }

    public DataSetInfo getInfo() {
        return this.info;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        this.data = data;
    }

    public void setInfo(DataSetInfo info) {
        if (info == null) {
            throw new NullPointerException("info == null");
        }
        this.info = info;
    }

    public int getLength() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataSet(");
        b.append(this.info);
        b.append(", name=").append(this.info.getName());
        b.append(", length=").append(this.getLength());
        try {
            Object dd = this.info.getSerializer().deserialize(this.getData(), new DefaultSerializationContext());
            if (dd instanceof byte[]) {
                dd = "[bytes]";
            }
            b.append(", data=").append(dd);
        }
        catch (Exception e) {
            b.append(", data=").append("<error: ").append(e.toString()).append('>');
        }
        b.append(')');
        return b.toString();
    }

    public Object getValue() throws SerializationException {
        Object value = this.info.getSerializer().deserialize(this.getData(), new DefaultSerializationContext());
        return value;
    }
}

