/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.serialize;

import com.nmote.iim4j.serialize.SerializationContext;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.serialize.Serializer;

public class BinaryNumberSerializer
implements Serializer {
    private final int length;

    public BinaryNumberSerializer(String def) {
        this.length = def != null ? Integer.parseInt(def) : Integer.MAX_VALUE;
    }

    public Object deserialize(byte[] data, SerializationContext ctx) throws SerializationException {
        if (data.length > 4) {
            throw new SerializationException("data too long: " + data.length);
        }
        int r = 0;
        for (int i = 0; i < data.length; ++i) {
            r = r << 8 | data[i];
        }
        return new Integer(r);
    }

    public byte[] serialize(Object o, SerializationContext ctx) throws SerializationException {
        int n = ((Number)o).intValue();
        if (n < 0) {
            throw new SerializationException("negative number: " + n);
        }
        byte[] result = new byte[this.length];
        for (int i = result.length - 1; n > 0 && i >= 0; n >>= 8, --i) {
            result[i] = (byte)(n & 0xFF);
        }
        if (n > 0) {
            throw new SerializationException("number too large to fit in " + this.length + ": " + o);
        }
        return result;
    }
}

