/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.serialize;

import com.nmote.iim4j.serialize.SerializationContext;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.serialize.Serializer;
import java.io.UnsupportedEncodingException;

public class CodedCharsetSerializer
implements Serializer {
    private final int maxLength;

    public CodedCharsetSerializer(String def) {
        this.maxLength = def != null ? Integer.parseInt(def) : Integer.MAX_VALUE;
    }

    public Object deserialize(byte[] data, SerializationContext ctx) throws SerializationException {
        try {
            String s = new String(data, "ISO-8859-1");
            if ("CP-1250".equalsIgnoreCase(s)) {
                s = "Cp1250";
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("unsupported character set");
        }
    }

    public byte[] serialize(Object o, SerializationContext ctx) throws SerializationException {
        try {
            String s = (String)o;
            if (s.equalsIgnoreCase("Cp1250")) {
                s = "CP-1250";
            }
            return s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("unsupported character set");
        }
    }
}

