/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.serialize;

import com.nmote.iim4j.serialize.SerializationContext;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.serialize.Serializer;
import java.io.UnsupportedEncodingException;

public class NumberSerializer
implements Serializer {
    private final int length;

    public NumberSerializer(String def) {
        this.length = def != null ? Integer.parseInt(def) : Integer.MAX_VALUE;
    }

    public Object deserialize(byte[] data, SerializationContext ctx) throws SerializationException {
        try {
            return new Integer(new String(data, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("impossible");
        }
    }

    public byte[] serialize(Object o, SerializationContext ctx) throws SerializationException {
        try {
            String s = ((Integer)o).toString();
            if (s.length() < this.length) {
                StringBuffer b = new StringBuffer(this.length);
                NumberSerializer.appendFill0(b, s, this.length);
                s = b.toString();
            }
            return s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("impossible");
        }
    }

    private static void appendFill0(StringBuffer b, String s, int n) {
        for (int i = n - s.length(); i > 0; --i) {
            b.append('0');
        }
        b.append(s);
    }
}

