/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.serialize;

import com.nmote.iim4j.serialize.SerializationContext;
import com.nmote.iim4j.serialize.SerializationException;
import com.nmote.iim4j.serialize.Serializer;
import java.io.UnsupportedEncodingException;

public class StringSerializer
implements Serializer {
    private final int maxLength;

    public StringSerializer(String def) {
        this.maxLength = def != null ? Integer.parseInt(def) : Integer.MAX_VALUE;
    }

    public Object deserialize(byte[] data, SerializationContext ctx) throws SerializationException {
        try {
            return new String(data, ctx.getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("unsupported character set: " + ctx.getCharacterSet());
        }
    }

    public byte[] serialize(Object o, SerializationContext ctx) throws SerializationException {
        try {
            return ((String)o).getBytes(ctx.getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("unsupported character set: " + ctx.getCharacterSet());
        }
    }
}

