/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.srs;

import com.nmote.iim4j.srs.SubjectReference;
import com.nmote.iim4j.srs.SubjectReferenceSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubjectReferenceSystem
implements SubjectReferenceSystem {
    private SortedMap<String, SubjectReference> references = new TreeMap<String, SubjectReference>();
    private Map<String, String> names = new HashMap<String, String>();
    private Map<String, String> descriptions = new HashMap<String, String>();

    @Override
    public SubjectReference get(String number) {
        SubjectReference result = (SubjectReference)this.references.get(number);
        if (result == null) {
            result = new SubjectReference(number);
        }
        return result;
    }

    @Override
    public SubjectReference getParent(SubjectReference ref) {
        SubjectReference parent = ref.isSubjectDetailDefined() ? this.get(ref.getNumber().substring(0, 5) + "000") : (ref.isSubjectMatterDefined() ? this.get(ref.getNumber().substring(0, 2) + "000000") : null);
        return parent;
    }

    @Override
    public String getName(SubjectReference ref) {
        return this.names.get(ref.getNumber());
    }

    @Override
    public String getDescription(SubjectReference ref) {
        return this.descriptions.get(ref.getNumber());
    }

    @Override
    public Collection<SubjectReference> getChildren(SubjectReference ref) {
        Collection<SubjectReference> result;
        String suffix;
        String prefix;
        if (ref == null) {
            throw new NullPointerException("ref == null");
        }
        if (ref.isSubjectDetailDefined()) {
            prefix = null;
            suffix = null;
        } else if (ref.isSubjectMatterDefined()) {
            prefix = ref.getNumber().substring(0, 5);
            suffix = "";
        } else {
            prefix = ref.getNumber().substring(0, 2);
            suffix = "000";
        }
        if (prefix != null) {
            result = new ArrayList();
            for (String key : this.references.keySet()) {
                if (!key.startsWith(prefix) || !key.endsWith(suffix) || ref != null && key.equals(ref.getNumber())) continue;
                result.add(this.get(key));
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    public void add(SubjectReferenceSystem srs, SubjectReference sr) {
        this.add(sr.getNumber(), srs.getName(sr), srs.getDescription(sr));
    }

    public void add(String number, String name, String description) {
        if (number == null) {
            throw new NullPointerException("number == null");
        }
        if (number.length() != 8) {
            throw new IllegalArgumentException("invalid subject reference number length (expected 8): " + number);
        }
        Long.parseLong(number);
        this.references.put(number, new SubjectReference(number));
        if (name != null) {
            this.names.put(number, name);
        }
        if (description != null) {
            this.descriptions.put(number, description);
        }
    }

    public void addIPTC(String iptc) {
        String[] parts = Pattern.compile(":", 16).split(iptc);
        if (iptc.length() != 5) {
            throw new IllegalArgumentException("invalid subject reference: " + iptc);
        }
        if (!"IPTC".equals(parts[0])) {
            throw new IllegalArgumentException("unknown IPR: " + parts[0]);
        }
        this.addIfNotDefined(parts[1].substring(0, 2) + "000000", parts[2]);
        this.addIfNotDefined(parts[1].substring(0, 5) + "000", parts[3]);
        this.addIfNotDefined(parts[1], parts[4]);
    }

    private void addIfNotDefined(String number, String name) {
        if (!this.references.containsKey(number)) {
            this.add(number, name, null);
        }
    }

    @Override
    public Collection<SubjectReference> getTopSubjectReferences() {
        ArrayList<SubjectReference> result = new ArrayList<SubjectReference>();
        for (SubjectReference ref : this.references.values()) {
            if (ref.isSubjectDetailDefined() || ref.isSubjectMatterDefined()) continue;
            result.add(ref);
        }
        return result;
    }

    @Override
    public Collection<SubjectReference> getAllSubjectReferences() {
        return this.references.values();
    }
}

