/*
 * Decompiled with CFR 0.152.
 */
package com.nmote.iim4j.srs;

import com.nmote.iim4j.srs.SubjectReferenceSystem;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectReference
implements Serializable,
Comparable<SubjectReference> {
    private static final long serialVersionUID = 100L;
    protected String number;

    private static String toIPTCHelper(String s) {
        int idx;
        String result = s != null ? ((idx = s.lastIndexOf(58)) != -1 ? s.substring(idx + 1) : s) : "";
        return result;
    }

    public SubjectReference(String number) {
        if (number.length() != 8) {
            throw new IllegalArgumentException("Subject reference length not equal 8: " + number);
        }
        this.number = number;
    }

    @Override
    public int compareTo(SubjectReference ref) {
        return this.number.compareTo(ref.number);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SubjectReference && ((SubjectReference)obj).getNumber().equals(this.getNumber());
    }

    public String getNumber() {
        return this.number;
    }

    public String getSubjectDetailNumber() {
        return this.number.substring(5, 8);
    }

    public String getSubjectMatterNumber() {
        return this.number.substring(2, 5);
    }

    public String getSubjectNumber() {
        return this.number.substring(0, 2);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public boolean isSubjectDetailDefined() {
        return !"000".equals(this.getSubjectDetailNumber());
    }

    public boolean isSubjectMatterDefined() {
        return !"000".equals(this.getSubjectMatterNumber());
    }

    public String toIPTC(SubjectReferenceSystem srs) {
        StringBuffer b = new StringBuffer();
        b.append("IPTC:");
        b.append(this.getNumber());
        b.append(":");
        if (this.getNumber().endsWith("000000")) {
            b.append(SubjectReference.toIPTCHelper(srs.getName(this)));
            b.append("::");
        } else if (this.getNumber().endsWith("000")) {
            b.append(SubjectReference.toIPTCHelper(srs.getName(srs.get(this.getNumber().substring(0, 2) + "000000"))));
            b.append(":");
            b.append(SubjectReference.toIPTCHelper(srs.getName(this)));
            b.append(":");
        } else {
            b.append(SubjectReference.toIPTCHelper(srs.getName(srs.get(this.getNumber().substring(0, 2) + "000000"))));
            b.append(":");
            b.append(SubjectReference.toIPTCHelper(srs.getName(srs.get(this.getNumber().substring(0, 5) + "000"))));
            b.append(":");
            b.append(SubjectReference.toIPTCHelper(srs.getName(this)));
        }
        return b.toString();
    }

    public String toString() {
        return this.number.toString();
    }
}

