/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker;

import com.easyinnova.implementation_checker.rules.model.ImplementationCheckerObjectType;
import com.easyinnova.implementation_checker.rules.model.IncludeType;
import com.easyinnova.implementation_checker.rules.model.RuleType;
import com.easyinnova.implementation_checker.rules.model.RulesType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ImplementationCheckerLoader {
    static HashMap<String, ImplementationCheckerObjectType> preLoadedValidatorsSingleton = new HashMap();
    private static List<String> isoNames;
    private static List<String> isoPaths;

    public static String getDefaultIso() {
        return "TIFF_Baseline_Core_6_0";
    }

    public static synchronized ImplementationCheckerObjectType getRules(String rulesFile) {
        ImplementationCheckerObjectType rules;
        block15: {
            if (!rulesFile.contains("/") && !rulesFile.contains(".")) {
                rulesFile = "implementationcheckers/" + rulesFile + ".xml";
            }
            rules = null;
            try {
                if (!preLoadedValidatorsSingleton.containsKey(rulesFile)) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ImplementationCheckerObjectType.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    try {
                        rules = (ImplementationCheckerObjectType)jaxbUnmarshaller.unmarshal(ImplementationCheckerLoader.getFileFromResources(rulesFile));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    for (RulesType ro : rules.getRules()) {
                        for (RuleType ruleType : ro.getRule()) {
                        }
                    }
                    if (rules.getInclude() != null) {
                        for (IncludeType inc : rules.getInclude()) {
                            JAXBContext jaxbContextInc = JAXBContext.newInstance((Class[])new Class[]{ImplementationCheckerObjectType.class});
                            Unmarshaller jaxbUnmarshallerInc = jaxbContextInc.createUnmarshaller();
                            ImplementationCheckerObjectType rulesIncluded = (ImplementationCheckerObjectType)jaxbUnmarshallerInc.unmarshal(ImplementationCheckerLoader.getFileFromResources("implementationcheckers/" + inc.getPolicyChecker()));
                            for (RulesType ro : rulesIncluded.getRules()) {
                                boolean excludedRules = false;
                                HashSet<String> excluded = new HashSet<String>();
                                for (String id : inc.getExcluderules()) {
                                    if (id.equals(ro.getId())) {
                                        excludedRules = true;
                                    }
                                    excluded.add(id);
                                }
                                if (excludedRules) continue;
                                ro.setIncluded(true);
                                rules.getRules().add(ro);
                                for (int i = 0; i < ro.getRule().size(); ++i) {
                                    if (!excluded.contains(ro.getRule().get(i).getId())) continue;
                                    ro.getRule().remove(i--);
                                }
                                for (RuleType ruleType : ro.getRule()) {
                                }
                            }
                        }
                    }
                    preLoadedValidatorsSingleton.put(rulesFile, rules);
                    break block15;
                }
                rules = preLoadedValidatorsSingleton.get(rulesFile);
            }
            catch (JAXBException ex) {
                return null;
            }
        }
        return rules;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static InputStream getFileFromResources(String spathStr) {
        String pathStr = spathStr.replace("./", "");
        InputStream fis = null;
        File file = new File("src/main/resources/" + pathStr);
        try {
            if (file.exists()) {
                return new FileInputStream("src/main/resources/" + pathStr);
            }
            Class<ImplementationCheckerLoader> cls = ImplementationCheckerLoader.class;
            ClassLoader cLoader = cls.getClassLoader();
            fis = cLoader.getResourceAsStream(pathStr);
            fis = null;
            if (fis != null) return fis;
            CodeSource src = ImplementationCheckerLoader.class.getProtectionDomain().getCodeSource();
            if (src == null) return fis;
            try {
                ZipEntry zipFile;
                String name;
                URL jar = src.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                do {
                    if ((zipFile = zip.getNextEntry()) == null) return fis;
                } while (!(name = zipFile.getName()).contains(pathStr));
                try {
                    return zip;
                }
                catch (Exception ex) {
                    throw new Exception("");
                }
            }
            catch (Exception exception) {}
            return fis;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return fis;
    }

    public static List<String> getPathsList() {
        if (isoPaths == null) {
            ArrayList<String> list = new ArrayList<String>();
            String path = "implementationcheckers";
            try {
                String resource;
                Class<ImplementationCheckerLoader> cls = ImplementationCheckerLoader.class;
                ClassLoader cLoader = cls.getClassLoader();
                InputStream in = cLoader.getResourceAsStream(path);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((resource = br.readLine()) != null) {
                    if (!resource.endsWith(".xml")) continue;
                    list.add(path + "/" + resource);
                }
            }
            catch (Exception e) {
                list = new ArrayList();
            }
            if (list.isEmpty()) {
                try {
                    CodeSource src = ImplementationCheckerLoader.class.getProtectionDomain().getCodeSource();
                    if (src != null) {
                        ZipEntry zipFile;
                        URL jar = src.getLocation();
                        ZipInputStream zip = new ZipInputStream(jar.openStream());
                        while ((zipFile = zip.getNextEntry()) != null) {
                            String name = zipFile.getName();
                            if (!name.endsWith(".xml") || !name.startsWith("implementationcheckers")) continue;
                            list.add(name);
                        }
                    }
                }
                catch (Exception ex) {
                    list = new ArrayList();
                }
            }
            isoPaths = list;
        }
        return isoPaths;
    }

    public static List<String> getNamesList() {
        if (isoNames == null) {
            ArrayList<String> list = new ArrayList<String>();
            String path = "implementationcheckers";
            try {
                String resource;
                Class<ImplementationCheckerLoader> cls = ImplementationCheckerLoader.class;
                ClassLoader cLoader = cls.getClassLoader();
                InputStream in = cLoader.getResourceAsStream(path);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((resource = br.readLine()) != null) {
                    if (!resource.endsWith(".xml")) continue;
                    list.add(resource.replace(".xml", ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isoNames = list;
        }
        return isoNames;
    }

    public static String getFileName(String path) {
        if (path.contains("/") && path.contains(".")) {
            return path.substring(path.indexOf("/") + 1, path.indexOf("."));
        }
        return path;
    }

    public static String getIsoName(String path) {
        ImplementationCheckerObjectType icRules = ImplementationCheckerLoader.getRules(path);
        if (icRules != null) {
            return icRules.getTitle();
        }
        return ImplementationCheckerLoader.getFileName(path);
    }

    public static boolean isValid(String path) {
        ImplementationCheckerObjectType icRules = ImplementationCheckerLoader.getRules(path);
        return icRules != null;
    }
}

