/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker;

import com.easyinnova.implementation_checker.rules.RuleResult;
import java.util.ArrayList;
import java.util.List;

public class ValidationResult {
    private List<RuleResult> result = new ArrayList<RuleResult>();

    public void add(RuleResult ruleResult) {
        this.result.add(ruleResult);
    }

    public List<RuleResult> getResult() {
        return this.result;
    }

    public List<RuleResult> getPassed() {
        ArrayList<RuleResult> passed = new ArrayList<RuleResult>();
        for (RuleResult res : this.result) {
            if (!res.ok()) continue;
            passed.add(res);
        }
        return passed;
    }

    public List<RuleResult> getErrors() {
        ArrayList<RuleResult> errors = new ArrayList<RuleResult>();
        for (RuleResult res : this.result) {
            if (res.ok() || res.getWarning() || res.getInfo()) continue;
            errors.add(res);
        }
        return errors;
    }

    public List<RuleResult> getWarnings(boolean infos) {
        ArrayList<RuleResult> errors = new ArrayList<RuleResult>();
        for (RuleResult res : this.result) {
            if (res.ok()) continue;
            if (res.getWarning()) {
                errors.add(res);
                continue;
            }
            if (!infos || !res.getInfo()) continue;
            errors.add(res);
        }
        return errors;
    }

    public List<RuleResult> getInfos() {
        ArrayList<RuleResult> errors = new ArrayList<RuleResult>();
        for (RuleResult res : this.result) {
            if (res.ok() || !res.getInfo()) continue;
            errors.add(res);
        }
        return errors;
    }
}

