/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker.model;

import com.easyinnova.implementation_checker.model.TiffHeader;
import com.easyinnova.implementation_checker.model.TiffIfds;
import com.easyinnova.implementation_checker.model.TiffNode;
import com.easyinnova.implementation_checker.model.TiffNodeInterface;
import com.easyinnova.implementation_checker.model.TiffSingleNode;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TiffValidationObject
extends TiffNode
implements TiffNodeInterface {
    TiffHeader header;
    TiffIfds lifds;
    long size;
    String byteOrder;
    int numberImages;
    String iccProfileClass = "";
    HashMap<String, List<TiffNode>> hashObjects = null;

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    @XmlAttribute
    public void setIccProfileClass(String iccProfileClass) {
        this.iccProfileClass = iccProfileClass;
    }

    public String getIccProfileClass() {
        return this.iccProfileClass;
    }

    @XmlAttribute
    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    @XmlAttribute
    public void setNumberImages(int numberImages) {
        this.numberImages = numberImages;
    }

    public int getNumberImages() {
        return this.numberImages;
    }

    public void setHeader(TiffHeader header) {
        this.header = header;
    }

    public TiffHeader getHeader() {
        return this.header;
    }

    public void setIfds(TiffIfds ifds) {
        this.lifds = ifds;
    }

    public TiffIfds getIfds() {
        return this.lifds;
    }

    @Override
    public List<TiffNode> getChildren(boolean subchilds) {
        ArrayList<TiffNode> childs = new ArrayList<TiffNode>();
        childs.add(this.header);
        if (subchilds) {
            childs.addAll(this.header.getChildren(subchilds));
        }
        childs.add(this.lifds);
        if (subchilds) {
            childs.addAll(this.lifds.getChildren(subchilds));
        }
        childs.add(new TiffSingleNode("size", this.size + ""));
        childs.add(new TiffSingleNode("byteOrder", this.byteOrder));
        childs.add(new TiffSingleNode("numberImages", this.numberImages + ""));
        childs.add(new TiffSingleNode("iccProfileClass", this.iccProfileClass + ""));
        return childs;
    }

    public List<TiffNode> getObjectsFromContext(String context, boolean subchilds) {
        String key = context;
        key = subchilds ? key + "1" : key + "0";
        if (this.hashObjects != null && this.hashObjects.containsKey(key)) {
            return this.hashObjects.get(key);
        }
        ArrayList<TiffNode> objects = new ArrayList<TiffNode>();
        objects.add(this);
        objects.addAll(this.getChildren(subchilds));
        ArrayList<TiffNode> objectsFromContext = new ArrayList<TiffNode>();
        for (TiffNode node : objects) {
            if (node == null || !node.contextMatch(context)) continue;
            objectsFromContext.add(node);
        }
        if (this.hashObjects == null) {
            this.hashObjects = new HashMap();
        }
        this.hashObjects.put(key, objectsFromContext);
        return objectsFromContext;
    }

    @Override
    public String getContext() {
        return "tiffValidationObject";
    }

    public void writeXml(String filename) {
        try {
            File file = new File(filename);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TiffValidationObject.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)this, file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public String getXml() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TiffValidationObject.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal((Object)this, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return "";
        }
    }
}

