/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterMap;
import org.verapdf.gf.model.impl.arlington.GFACryptFilterPublicKeyMap;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.AEncryptionPublicKey;

public class GFAEncryptionPublicKey
extends GFAObject
implements AEncryptionPublicKey {
    public GFAEncryptionPublicKey(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionPublicKey");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
            case "Recipients": {
                return this.getRecipients();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.baselayer.Object> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getCF1_5() {
        COSObject object = this.getCFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getCFDictionary1_5(object.getDirectBase(), "CF");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getCFDictionary1_5(COSBase base, String keyName) {
        COSBase objectBase = COSDictionary.construct().getDirectBase();
        for (ASAtom key : base.getKeySet()) {
            COSObject obj = base.getKey(key);
            if (obj == null || obj.getDirectBase() == null) continue;
            objectBase = obj.getDirectBase();
            break;
        }
        if (objectBase.knownKey(ASAtom.getASAtom("Recipients")).booleanValue()) {
            return new GFACryptFilterPublicKeyMap(base, this.baseObject, keyName);
        }
        return new GFACryptFilterMap(base, this.baseObject, keyName);
    }

    private List<AArrayOfStringsByte> getRecipients() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getRecipients1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients1_3() {
        COSObject object = this.getRecipientsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSArray)object.getDirectBase(), this.baseObject, "Recipients"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CF"));
    }

    public COSObject getCFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CF"));
        return object;
    }

    @Override
    public String getCFType() {
        COSObject CF = this.getCFValue();
        return this.getObjectType(CF);
    }

    @Override
    public Boolean getCFHasTypeDictionary() {
        COSObject CF = this.getCFValue();
        return GFAEncryptionPublicKey.getHasTypeDictionary(CF);
    }

    @Override
    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EFF"));
    }

    public COSObject getEFFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EFF"));
        return object;
    }

    @Override
    public String getEFFType() {
        COSObject EFF = this.getEFFValue();
        return this.getObjectType(EFF);
    }

    @Override
    public Boolean getEFFHasTypeName() {
        COSObject EFF = this.getEFFValue();
        return GFAEncryptionPublicKey.getHasTypeName(EFF);
    }

    @Override
    public String getEFFNameValue() {
        COSObject EFF = this.getEFFValue();
        return GFAEncryptionPublicKey.getNameValue(EFF);
    }

    @Override
    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    @Override
    public String getEncryptMetadataType() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return this.getObjectType(EncryptMetadata);
    }

    @Override
    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return GFAEncryptionPublicKey.getHasTypeBoolean(EncryptMetadata);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAEncryptionPublicKey.getHasTypeName(Filter2);
    }

    @Override
    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAEncryptionPublicKey.getNameValue(Filter2);
    }

    @Override
    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom("KDFSalt"));
    }

    public COSObject getKDFSaltValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("KDFSalt"));
        return object;
    }

    @Override
    public Boolean getisKDFSaltIndirect() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return GFAEncryptionPublicKey.getisIndirect(KDFSalt);
    }

    @Override
    public String getKDFSaltType() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return this.getObjectType(KDFSalt);
    }

    @Override
    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject KDFSalt = this.getKDFSaltValue();
        return GFAEncryptionPublicKey.getHasTypeStringByte(KDFSalt);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return COSInteger.construct(40L);
            }
        }
        return null;
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        if (object == null || object.empty()) {
            object = this.getLengthDefaultValue();
        }
        return object;
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAEncryptionPublicKey.getHasTypeInteger(Length);
    }

    @Override
    public Long getLengthIntegerValue() {
        COSObject Length = this.getLengthValue();
        return GFAEncryptionPublicKey.getIntegerValue(Length);
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return COSInteger.construct(0L);
            }
        }
        return null;
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        if (object == null || object.empty()) {
            object = this.getPDefaultValue();
        }
        return object;
    }

    @Override
    public String getPType() {
        COSObject P = this.getPValue();
        return this.getObjectType(P);
    }

    @Override
    public Boolean getPHasTypeBitmask() {
        COSObject P = this.getPValue();
        return GFAEncryptionPublicKey.getHasTypeBitmask(P);
    }

    @Override
    public Long getPBitmaskValue() {
        COSObject P = this.getPValue();
        return GFAEncryptionPublicKey.getBitmaskValue(P);
    }

    @Override
    public Boolean getcontainsRecipients() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Recipients"));
    }

    public COSObject getRecipientsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Recipients"));
        return object;
    }

    @Override
    public String getRecipientsType() {
        COSObject Recipients = this.getRecipientsValue();
        return this.getObjectType(Recipients);
    }

    @Override
    public Boolean getRecipientsHasTypeArray() {
        COSObject Recipients = this.getRecipientsValue();
        return GFAEncryptionPublicKey.getHasTypeArray(Recipients);
    }

    @Override
    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StmF"));
    }

    public COSObject getStmFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStmFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StmF"));
        if (object == null || object.empty()) {
            object = this.getStmFDefaultValue();
        }
        return object;
    }

    @Override
    public String getStmFType() {
        COSObject StmF = this.getStmFValue();
        return this.getObjectType(StmF);
    }

    @Override
    public Boolean getStmFHasTypeName() {
        COSObject StmF = this.getStmFValue();
        return GFAEncryptionPublicKey.getHasTypeName(StmF);
    }

    @Override
    public String getStmFNameValue() {
        COSObject StmF = this.getStmFValue();
        return GFAEncryptionPublicKey.getNameValue(StmF);
    }

    @Override
    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("StrF"));
    }

    public COSObject getStrFDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("Identity");
            }
        }
        return null;
    }

    public COSObject getStrFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("StrF"));
        if (object == null || object.empty()) {
            object = this.getStrFDefaultValue();
        }
        return object;
    }

    @Override
    public String getStrFType() {
        COSObject StrF = this.getStrFValue();
        return this.getObjectType(StrF);
    }

    @Override
    public Boolean getStrFHasTypeName() {
        COSObject StrF = this.getStrFValue();
        return GFAEncryptionPublicKey.getHasTypeName(StrF);
    }

    @Override
    public String getStrFNameValue() {
        COSObject StrF = this.getStrFValue();
        return GFAEncryptionPublicKey.getNameValue(StrF);
    }

    @Override
    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SubFilter"));
    }

    public COSObject getSubFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SubFilter"));
        return object;
    }

    @Override
    public String getSubFilterType() {
        COSObject SubFilter = this.getSubFilterValue();
        return this.getObjectType(SubFilter);
    }

    @Override
    public Boolean getSubFilterHasTypeName() {
        COSObject SubFilter = this.getSubFilterValue();
        return GFAEncryptionPublicKey.getHasTypeName(SubFilter);
    }

    @Override
    public String getSubFilterNameValue() {
        COSObject SubFilter = this.getSubFilterValue();
        return GFAEncryptionPublicKey.getNameValue(SubFilter);
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public String getVType() {
        COSObject V = this.getVValue();
        return this.getObjectType(V);
    }

    @Override
    public Boolean getVHasTypeInteger() {
        COSObject V = this.getVValue();
        return GFAEncryptionPublicKey.getHasTypeInteger(V);
    }

    @Override
    public Long getVIntegerValue() {
        COSObject V = this.getVValue();
        return GFAEncryptionPublicKey.getIntegerValue(V);
    }

    @Override
    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }

    @Override
    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

