/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfNamesForPrintingOrder;
import org.verapdf.gf.model.impl.arlington.GFADictionaryOfFunctions;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASolidities;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfNamesForPrintingOrder;
import org.verapdf.model.alayer.ADeviceNMixingHints;
import org.verapdf.model.alayer.ADictionaryOfFunctions;
import org.verapdf.model.alayer.ASolidities;
import org.verapdf.model.baselayer.Object;

public class GFADeviceNMixingHints
extends GFAObject
implements ADeviceNMixingHints {
    public GFADeviceNMixingHints(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADeviceNMixingHints");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "DotGain": {
                return this.getDotGain();
            }
            case "PrintingOrder": {
                return this.getPrintingOrder();
            }
            case "Solidities": {
                return this.getSolidities();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ADictionaryOfFunctions> getDotGain() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDotGain1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ADictionaryOfFunctions> getDotGain1_6() {
        COSObject object = this.getDotGainValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADictionaryOfFunctions> list = new ArrayList<GFADictionaryOfFunctions>(1);
            list.add(new GFADictionaryOfFunctions((COSDictionary)object.getDirectBase(), this.baseObject, "DotGain"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamesForPrintingOrder> getPrintingOrder() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getPrintingOrder1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfNamesForPrintingOrder> getPrintingOrder1_6() {
        COSObject object = this.getPrintingOrderValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfNamesForPrintingOrder> list = new ArrayList<GFAArrayOfNamesForPrintingOrder>(1);
            list.add(new GFAArrayOfNamesForPrintingOrder((COSArray)object.getDirectBase(), this.baseObject, "PrintingOrder"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ASolidities> getSolidities() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSolidities1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<ASolidities> getSolidities1_6() {
        COSObject object = this.getSoliditiesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASolidities> list = new ArrayList<GFASolidities>(1);
            list.add(new GFASolidities((COSDictionary)object.getDirectBase(), this.baseObject, "Solidities"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsDotGain() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DotGain"));
    }

    public COSObject getDotGainValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DotGain"));
        return object;
    }

    @Override
    public Boolean getDotGainHasTypeDictionary() {
        COSObject object = this.getDotGainValue();
        return GFADeviceNMixingHints.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsPrintingOrder() {
        return this.baseObject.knownKey(ASAtom.getASAtom("PrintingOrder"));
    }

    public COSObject getPrintingOrderValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PrintingOrder"));
        return object;
    }

    @Override
    public Boolean getPrintingOrderHasTypeArray() {
        COSObject object = this.getPrintingOrderValue();
        return GFADeviceNMixingHints.getHasTypeArray(object);
    }

    @Override
    public Boolean getcontainsSolidities() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Solidities"));
    }

    public COSObject getSoliditiesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Solidities"));
        return object;
    }

    @Override
    public Boolean getSoliditiesHasTypeDictionary() {
        COSObject object = this.getSoliditiesValue();
        return GFADeviceNMixingHints.getHasTypeDictionary(object);
    }
}

