/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAMac;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AEmbeddedFileParameter;
import org.verapdf.model.alayer.AMac;
import org.verapdf.model.baselayer.Object;

public class GFAEmbeddedFileParameter
extends GFAObject
implements AEmbeddedFileParameter {
    public GFAEmbeddedFileParameter(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEmbeddedFileParameter");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Mac": {
                return this.getMac();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AMac> getMac() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getMac1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AMac> getMac1_3() {
        COSObject object = this.getMacValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAMac> list = new ArrayList<GFAMac>(1);
            list.add(new GFAMac((COSDictionary)object.getDirectBase(), this.baseObject, "Mac"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCheckSum() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CheckSum"));
    }

    public COSObject getCheckSumValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CheckSum"));
        return object;
    }

    @Override
    public Boolean getCheckSumHasTypeString() {
        COSObject object = this.getCheckSumValue();
        return GFAEmbeddedFileParameter.getHasTypeString(object);
    }

    @Override
    public Long getCheckSumStringSize() {
        COSObject object = this.getCheckSumValue();
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            return object.getString().length();
        }
        return null;
    }

    @Override
    public Boolean getcontainsCreationDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CreationDate"));
    }

    public COSObject getCreationDateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CreationDate"));
        return object;
    }

    @Override
    public Boolean getCreationDateHasTypeDate() {
        COSObject object = this.getCreationDateValue();
        return GFAEmbeddedFileParameter.getHasTypeDate(object);
    }

    @Override
    public Boolean getcontainsMac() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Mac"));
    }

    public COSObject getMacValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Mac"));
        return object;
    }

    @Override
    public Boolean getMacHasTypeDictionary() {
        COSObject object = this.getMacValue();
        return GFAEmbeddedFileParameter.getHasTypeDictionary(object);
    }

    @Override
    public Boolean getcontainsModDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom("ModDate"));
    }

    public COSObject getModDateValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("ModDate"));
        return object;
    }

    @Override
    public Boolean getModDateHasTypeDate() {
        COSObject object = this.getModDateValue();
        return GFAEmbeddedFileParameter.getHasTypeDate(object);
    }

    @Override
    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Size"));
        return object;
    }

    @Override
    public Boolean getSizeHasTypeInteger() {
        COSObject object = this.getSizeValue();
        return GFAEmbeddedFileParameter.getHasTypeInteger(object);
    }

    @Override
    public Long getSizeIntegerValue() {
        COSObject object = this.getSizeValue();
        return GFAEmbeddedFileParameter.getIntegerValue(object);
    }
}

