/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAActionECMAScript;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AActionECMAScript;
import org.verapdf.model.alayer.AAddActionCatalog;
import org.verapdf.model.baselayer.Object;

public class GFAAddActionCatalog
extends GFAObject
implements AAddActionCatalog {
    public GFAAddActionCatalog(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AAddActionCatalog");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "DC": {
                return this.getDC();
            }
            case "DP": {
                return this.getDP();
            }
            case "DS": {
                return this.getDS();
            }
            case "WP": {
                return this.getWP();
            }
            case "WS": {
                return this.getWS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AActionECMAScript> getDC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDC1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getDC1_4() {
        COSObject object = this.getDCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAActionECMAScript> list = new ArrayList<GFAActionECMAScript>(1);
            list.add(new GFAActionECMAScript((COSDictionary)object.getDirectBase(), this.baseObject, "DC"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getDP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDP1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getDP1_4() {
        COSObject object = this.getDPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAActionECMAScript> list = new ArrayList<GFAActionECMAScript>(1);
            list.add(new GFAActionECMAScript((COSDictionary)object.getDirectBase(), this.baseObject, "DP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getDS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDS1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getDS1_4() {
        COSObject object = this.getDSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAActionECMAScript> list = new ArrayList<GFAActionECMAScript>(1);
            list.add(new GFAActionECMAScript((COSDictionary)object.getDirectBase(), this.baseObject, "DS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getWP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWP1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getWP1_4() {
        COSObject object = this.getWPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAActionECMAScript> list = new ArrayList<GFAActionECMAScript>(1);
            list.add(new GFAActionECMAScript((COSDictionary)object.getDirectBase(), this.baseObject, "WP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getWS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWS1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AActionECMAScript> getWS1_4() {
        COSObject object = this.getWSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAActionECMAScript> list = new ArrayList<GFAActionECMAScript>(1);
            list.add(new GFAActionECMAScript((COSDictionary)object.getDirectBase(), this.baseObject, "WS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsDC() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DC"));
    }

    public COSObject getDCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DC"));
        return object;
    }

    @Override
    public Boolean getDCHasTypeDictionary() {
        COSObject DC = this.getDCValue();
        return GFAAddActionCatalog.getHasTypeDictionary(DC);
    }

    @Override
    public Boolean getcontainsDP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DP"));
    }

    public COSObject getDPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DP"));
        return object;
    }

    @Override
    public Boolean getDPHasTypeDictionary() {
        COSObject DP = this.getDPValue();
        return GFAAddActionCatalog.getHasTypeDictionary(DP);
    }

    @Override
    public Boolean getcontainsDS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DS"));
    }

    public COSObject getDSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DS"));
        return object;
    }

    @Override
    public Boolean getDSHasTypeDictionary() {
        COSObject DS = this.getDSValue();
        return GFAAddActionCatalog.getHasTypeDictionary(DS);
    }

    @Override
    public Boolean getcontainsWP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("WP"));
    }

    public COSObject getWPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("WP"));
        return object;
    }

    @Override
    public Boolean getWPHasTypeDictionary() {
        COSObject WP = this.getWPValue();
        return GFAAddActionCatalog.getHasTypeDictionary(WP);
    }

    @Override
    public Boolean getcontainsWS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("WS"));
    }

    public COSObject getWSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("WS"));
        return object;
    }

    @Override
    public Boolean getWSHasTypeDictionary() {
        COSObject WS = this.getWSValue();
        return GFAAddActionCatalog.getHasTypeDictionary(WS);
    }
}

