/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfOCG;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentGroup;
import org.verapdf.gf.model.impl.arlington.GFAVisibilityExpressionArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AOptContentMembership;
import org.verapdf.model.alayer.AVisibilityExpressionArray;
import org.verapdf.model.baselayer.Object;

public class GFAOptContentMembership
extends GFAObject
implements AOptContentMembership {
    public GFAOptContentMembership(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AOptContentMembership");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "OCGs": {
                return this.getOCGs();
            }
            case "VE": {
                return this.getVE();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getOCGs() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getOCGs1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getOCGs1_5() {
        COSObject object = this.getOCGsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfOCG> list = new ArrayList<GFAArrayOfOCG>(1);
            list.add(new GFAArrayOfOCG((COSArray)object.getDirectBase(), this.baseObject, "OCGs"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAOptContentGroup> list = new ArrayList<GFAOptContentGroup>(1);
            list.add(new GFAOptContentGroup((COSDictionary)object.getDirectBase(), this.baseObject, "OCGs"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AVisibilityExpressionArray> getVE() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getVE1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<AVisibilityExpressionArray> getVE1_6() {
        COSObject object = this.getVEValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAVisibilityExpressionArray> list = new ArrayList<GFAVisibilityExpressionArray>(1);
            list.add(new GFAVisibilityExpressionArray((COSArray)object.getDirectBase(), this.baseObject, "VE"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsOCGs() {
        return this.baseObject.knownKey(ASAtom.getASAtom("OCGs"));
    }

    public COSObject getOCGsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("OCGs"));
        return object;
    }

    @Override
    public Boolean getOCGsHasTypeArray() {
        COSObject OCGs = this.getOCGsValue();
        return GFAOptContentMembership.getHasTypeArray(OCGs);
    }

    @Override
    public Boolean getOCGsHasTypeDictionary() {
        COSObject OCGs = this.getOCGsValue();
        return GFAOptContentMembership.getHasTypeDictionary(OCGs);
    }

    @Override
    public Boolean getOCGsHasTypeNull() {
        COSObject OCGs = this.getOCGsValue();
        return GFAOptContentMembership.getHasTypeNull(OCGs);
    }

    @Override
    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom("P"));
    }

    public COSObject getPDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("AnyOn");
            }
        }
        return null;
    }

    public COSObject getPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("P"));
        if (object == null || object.empty()) {
            object = this.getPDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getPHasTypeName() {
        COSObject P = this.getPValue();
        return GFAOptContentMembership.getHasTypeName(P);
    }

    @Override
    public String getPNameValue() {
        COSObject P = this.getPValue();
        return GFAOptContentMembership.getNameValue(P);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAOptContentMembership.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAOptContentMembership.getNameValue(Type2);
    }

    @Override
    public Boolean getcontainsVE() {
        return this.baseObject.knownKey(ASAtom.getASAtom("VE"));
    }

    public COSObject getVEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("VE"));
        return object;
    }

    @Override
    public Boolean getVEHasTypeArray() {
        COSObject VE = this.getVEValue();
        return GFAOptContentMembership.getHasTypeArray(VE);
    }
}

