/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRequirementsHandlers;
import org.verapdf.gf.model.impl.arlington.GFADocTimeStamp;
import org.verapdf.gf.model.impl.arlington.GFAExtensions;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARequirementsHandler;
import org.verapdf.gf.model.impl.arlington.GFASignature;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExtensions;
import org.verapdf.model.alayer.ARequirementsDigSigValidation;

public class GFARequirementsDigSigValidation
extends GFAObject
implements ARequirementsDigSigValidation {
    public GFARequirementsDigSigValidation(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARequirementsDigSigValidation");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "DigSig": {
                return this.getDigSig();
            }
            case "RH": {
                return this.getRH();
            }
            case "V": {
                return this.getV();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.baselayer.Object> getDigSig() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getDigSig2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDigSig2_0() {
        COSObject object = this.getDigSigValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDigSigDictionary2_0(object.getDirectBase(), "DigSig");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDigSigDictionary2_0(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom("Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "DocTimeStamp": {
                return new GFADocTimeStamp(base, this.baseObject, keyName);
            }
            case "Sig": {
                return new GFASignature(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getRH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRH2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getRH2_0() {
        COSObject object = this.getRHValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRequirementsHandlers> list = new ArrayList<GFAArrayOfRequirementsHandlers>(1);
            list.add(new GFAArrayOfRequirementsHandlers((COSArray)object.getDirectBase(), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARequirementsHandler> list = new ArrayList<GFARequirementsHandler>(1);
            list.add(new GFARequirementsHandler((COSDictionary)object.getDirectBase(), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AExtensions> getV() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getV2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AExtensions> getV2_0() {
        COSObject object = this.getVValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAExtensions> list = new ArrayList<GFAExtensions>(1);
            list.add(new GFAExtensions((COSDictionary)object.getDirectBase(), this.baseObject, "V"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsDigSig() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DigSig"));
    }

    public COSObject getDigSigValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DigSig"));
        return object;
    }

    @Override
    public Boolean getDigSigHasTypeDictionary() {
        COSObject DigSig = this.getDigSigValue();
        return GFARequirementsDigSigValidation.getHasTypeDictionary(DigSig);
    }

    @Override
    public Boolean getcontainsPenalty() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Penalty"));
    }

    public COSObject getPenaltyDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return COSInteger.construct(100L);
            }
        }
        return null;
    }

    public COSObject getPenaltyValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Penalty"));
        if (object == null || object.empty()) {
            object = this.getPenaltyDefaultValue();
        }
        return object;
    }

    @Override
    public Boolean getPenaltyHasTypeInteger() {
        COSObject Penalty = this.getPenaltyValue();
        return GFARequirementsDigSigValidation.getHasTypeInteger(Penalty);
    }

    @Override
    public Long getPenaltyIntegerValue() {
        COSObject Penalty = this.getPenaltyValue();
        return GFARequirementsDigSigValidation.getIntegerValue(Penalty);
    }

    @Override
    public Boolean getcontainsRH() {
        return this.baseObject.knownKey(ASAtom.getASAtom("RH"));
    }

    public COSObject getRHValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("RH"));
        return object;
    }

    @Override
    public Boolean getRHHasTypeArray() {
        COSObject RH = this.getRHValue();
        return GFARequirementsDigSigValidation.getHasTypeArray(RH);
    }

    @Override
    public Boolean getRHHasTypeDictionary() {
        COSObject RH = this.getRHValue();
        return GFARequirementsDigSigValidation.getHasTypeDictionary(RH);
    }

    @Override
    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom("S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("S"));
        return object;
    }

    @Override
    public Boolean getSHasTypeName() {
        COSObject S = this.getSValue();
        return GFARequirementsDigSigValidation.getHasTypeName(S);
    }

    @Override
    public String getSNameValue() {
        COSObject S = this.getSValue();
        return GFARequirementsDigSigValidation.getNameValue(S);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFARequirementsDigSigValidation.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFARequirementsDigSigValidation.getNameValue(Type2);
    }

    @Override
    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom("V"));
    }

    public COSObject getVValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("V"));
        return object;
    }

    @Override
    public Boolean getVHasTypeDictionary() {
        COSObject V = this.getVValue();
        return GFARequirementsDigSigValidation.getHasTypeDictionary(V);
    }

    @Override
    public Boolean getVHasTypeName() {
        COSObject V = this.getVValue();
        return GFARequirementsDigSigValidation.getHasTypeName(V);
    }
}

