/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosActualText;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDStructTreeNode;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFHelper;

public class GFPDStructElem
extends GFPDStructTreeNode
implements org.verapdf.model.pdlayer.PDStructElem {
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";
    public static final String ACTUAL_TEXT = "actualText";
    private final String standardType;

    protected GFPDStructElem(PDStructElem structElemDictionary, String standardType, String type) {
        super(structElemDictionary, type);
        ASAtom subtype = this.simplePDObject.getNameKey(ASAtom.S);
        if (subtype != null) {
            this.id = (super.getID() != null ? super.getID() : "0 0 obj") + " " + ((COSName)COSName.fromValue(subtype)).getUnicodeValue();
        }
        this.standardType = standardType;
        if (StaticContainers.getFlavour() == PDFAFlavour.PDFUA_2) {
            this.fillStructElemRefs();
        }
    }

    public GFPDStructElem(PDStructElem structElemDictionary) {
        this(structElemDictionary, null, STRUCTURE_ELEMENT_TYPE);
    }

    @Override
    public String getType() {
        ASAtom type = ((PDStructElem)this.simplePDObject).getType();
        return type == null ? null : type.getValue();
    }

    @Override
    public String getparentStandardType() {
        PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent();
        if (parent != null) {
            String parentStandardType;
            StructureType parentStandardStructureType = GFSEFactory.getStructureElementStandardStructureType(parent);
            String string = parentStandardType = parentStandardStructureType != null ? parentStandardStructureType.getType().getValue() : null;
            while ("NonStruct".equals(parentStandardType) || "Div".equals(parentStandardType)) {
                if ((parent = parent.getParent()) == null) {
                    return null;
                }
                parentStandardStructureType = GFSEFactory.getStructureElementStandardStructureType(parent);
                parentStandardType = parentStandardStructureType != null ? parentStandardStructureType.getType().getValue() : null;
            }
            if (GFSEFactory.isMathStandardType(parentStandardStructureType)) {
                return "MathML";
            }
            return parentStandardType;
        }
        return null;
    }

    @Override
    public String getvalueS() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        return type != null ? type.getString() : null;
    }

    @Override
    public String getstandardType() {
        return this.standardType;
    }

    public String getStandardTypeNamespaceURL() {
        StructureType standardStructureType = GFSEFactory.getStructureElementStandardStructureType((PDStructElem)this.simplePDObject);
        return standardStructureType != null ? standardStructureType.getNameSpaceURI() : null;
    }

    @Override
    public Boolean getisRemappedStandardType() {
        if (this.hasStandardType()) {
            StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
            if (type == null) {
                return false;
            }
            return !type.getType().getValue().equals(this.standardType);
        }
        return false;
    }

    private boolean hasStandardType() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        if (type == null) {
            return false;
        }
        PDFAFlavour flavour = StaticContainers.getFlavour();
        if (flavour != null) {
            if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
                return TaggedPDFHelper.getPdf14StandardRoleTypes().contains(type.getType().getValue());
            }
            if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_4) {
                return TaggedPDFHelper.isStandardType(type);
            }
            if (flavour.getPart() == PDFAFlavour.Specification.WCAG_2_1) {
                return TaggedPDFHelper.isWCAGStandardType(type) && !"Title".equals(type.getType().getValue());
            }
        }
        return TaggedPDFHelper.getPdf17StandardRoleTypes().contains(type.getType().getValue());
    }

    @Override
    public String getAlt() {
        return ((PDStructElem)this.simplePDObject).getAlternateDescription();
    }

    @Override
    public String getActualText() {
        return ((PDStructElem)this.simplePDObject).getActualText().getString();
    }

    @Override
    public String getE() {
        return ((PDStructElem)this.simplePDObject).getExpandedAbbreviation();
    }

    @Override
    public Boolean getcircularMappingExist() {
        StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
        return type != null ? StaticResources.getRoleMapHelper().circularMappingExist(type.getType()) : null;
    }

    @Override
    public String getroleMapToSameNamespaceTag() {
        return ((PDStructElem)this.simplePDObject).getRoleMapToSameNamespaceTag() + ":" + this.getstandardType();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
            case "actualText": {
                return this.getactualText();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public String getparentLang() {
        COSString baseLang = null;
        HashSet<COSKey> keys = new HashSet<COSKey>();
        COSKey key = this.simplePDObject.getObject().getObjectKey();
        if (key != null) {
            keys.add(key);
        }
        for (PDStructElem parent = ((PDStructElem)this.simplePDObject).getParent(); baseLang == null && parent != null; parent = parent.getParent()) {
            key = parent.getObject().getObjectKey();
            if (keys.contains(key)) {
                throw new LoopedException("Struct tree loop found");
            }
            if (key != null) {
                keys.add(key);
            }
            baseLang = parent.getLang();
        }
        if (baseLang != null) {
            return baseLang.getString();
        }
        return null;
    }

    private List<CosActualText> getactualText() {
        COSObject actualText = ((PDStructElem)this.simplePDObject).getActualText();
        if (actualText != null && COSObjType.COS_STRING == actualText.getType()) {
            ArrayList<CosActualText> list = new ArrayList<CosActualText>(1);
            list.add(new GFCosActualText((COSString)actualText.getDirectBase()));
            return list;
        }
        return Collections.emptyList();
    }

    private void fillStructElemRefs() {
        COSKey key = this.simpleCOSObject.getKey();
        if (key == null) {
            return;
        }
        COSObject ref = ((PDStructElem)this.simplePDObject).getRef();
        if (ref.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)ref.getDirectBase()) {
                if (elem.getKey() == null) continue;
                StaticContainers.getStructElementsRefs().computeIfAbsent(elem.getKey(), k -> new HashSet()).add(key);
            }
        }
    }
}

