/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.GFPDStructElem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDStructTreeNode;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.TaggedPDFHelper;

public abstract class GFPDStructTreeNode
extends GFPDObject
implements PDStructTreeNode {
    public static final String CHILDREN = "K";
    private List<GFPDStructElem> children;

    protected GFPDStructTreeNode(org.verapdf.pd.structure.PDStructTreeNode structTreeNodeDictionary, String type) {
        super(structTreeNodeDictionary, type);
    }

    @Override
    public String getkidsStandardTypes() {
        if (StaticContainers.getFlavour() != null && StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.WCAG_2_1) {
            return this.getChildrenStandardTypes().stream().filter(type -> type != null && !"Artifact".equals(type)).collect(Collectors.joining("&"));
        }
        return this.getChildrenStandardTypes().stream().filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    @Override
    public Boolean gethasContentItems() {
        COSObject children = this.simplePDObject.getKey(ASAtom.K);
        if (children == null) {
            return false;
        }
        if (TaggedPDFHelper.isContentItem(children)) {
            return true;
        }
        if (children.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)children.getDirectBase()) {
                if (!TaggedPDFHelper.isContentItem(elem)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<String> getChildrenStandardTypes() {
        return GFPDStructTreeNode.getChildrenStandardTypes(this);
    }

    private static List<String> getChildrenStandardTypes(GFPDStructTreeNode element) {
        ArrayList<String> res = new ArrayList<String>();
        for (GFPDStructElem child : element.getChildren()) {
            String elementStandardType = child.getstandardType();
            if ("NonStruct".equals(elementStandardType) || "Div".equals(elementStandardType)) {
                res.addAll(GFPDStructTreeNode.getChildrenStandardTypes(child));
                continue;
            }
            res.add(elementStandardType);
        }
        return Collections.unmodifiableList(res);
    }

    public List<GFPDStructElem> getChildren() {
        if (this.children == null) {
            List<PDStructElem> elements = ((org.verapdf.pd.structure.PDStructTreeNode)this.simplePDObject).getStructChildren();
            if (!elements.isEmpty()) {
                ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
                for (PDStructElem element : elements) {
                    res.add(GFSEFactory.createTypedStructElem(element));
                }
                this.children = Collections.unmodifiableList(res);
            } else {
                this.children = Collections.emptyList();
            }
        }
        return this.children;
    }
}

