/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModelHelper {
    private static final Map<String, String> mapOfSuperNames = new HashMap<String, String>();
    private static final Map<String, List<String>> mapOfProperties = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> mapOfLinks = new HashMap<String, List<String>>();
    private static List<String> properties;
    private static List<String> links;

    private ModelHelper() {
    }

    public static List<String> getListOfSuperNames(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = mapOfSuperNames.get(objectName);
        while (currentObject != null) {
            res.add(currentObject);
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static Set<String> getTypes() {
        return mapOfSuperNames.keySet();
    }

    public static List<String> getListOfProperties(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String prop : mapOfProperties.get(currentObject)) {
                res.add(prop);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static List<String> getListOfLinks(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String link : mapOfLinks.get(currentObject)) {
                res.add(link);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    private static void fillMapOfSuperNamesObject() {
        mapOfSuperNames.put("Object", null);
    }

    private static void fillMapOfPropertiesObject() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Object", properties);
    }

    private static void fillMapOfLinksObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("Object", links);
    }

    private static void fillMapOfSuperNamesExternal() {
        mapOfSuperNames.put("External", "Object");
    }

    private static void fillMapOfPropertiesExternal() {
        properties = new ArrayList<String>();
        mapOfProperties.put("External", properties);
    }

    private static void fillMapOfLinksExternal() {
        links = new ArrayList<String>();
        mapOfLinks.put("External", links);
    }

    private static void fillMapOfSuperNamesICCProfile() {
        mapOfSuperNames.put("ICCProfile", "External");
    }

    private static void fillMapOfPropertiesICCProfile() {
        properties = new ArrayList<String>();
        properties.add("N");
        properties.add("deviceClass");
        properties.add("colorSpace");
        properties.add("version");
        properties.add("isValid");
        mapOfProperties.put("ICCProfile", properties);
    }

    private static void fillMapOfLinksICCProfile() {
        links = new ArrayList<String>();
        mapOfLinks.put("ICCProfile", links);
    }

    private static void fillMapOfSuperNamesICCInputProfile() {
        mapOfSuperNames.put("ICCInputProfile", "ICCProfile");
    }

    private static void fillMapOfPropertiesICCInputProfile() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ICCInputProfile", properties);
    }

    private static void fillMapOfLinksICCInputProfile() {
        links = new ArrayList<String>();
        mapOfLinks.put("ICCInputProfile", links);
    }

    private static void fillMapOfSuperNamesICCOutputProfile() {
        mapOfSuperNames.put("ICCOutputProfile", "ICCProfile");
    }

    private static void fillMapOfPropertiesICCOutputProfile() {
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("ICCOutputProfile", properties);
    }

    private static void fillMapOfLinksICCOutputProfile() {
        links = new ArrayList<String>();
        mapOfLinks.put("ICCOutputProfile", links);
    }

    private static void fillMapOfSuperNamesFontProgram() {
        mapOfSuperNames.put("FontProgram", "External");
    }

    private static void fillMapOfPropertiesFontProgram() {
        properties = new ArrayList<String>();
        mapOfProperties.put("FontProgram", properties);
    }

    private static void fillMapOfLinksFontProgram() {
        links = new ArrayList<String>();
        mapOfLinks.put("FontProgram", links);
    }

    private static void fillMapOfSuperNamesTrueTypeFontProgram() {
        mapOfSuperNames.put("TrueTypeFontProgram", "FontProgram");
    }

    private static void fillMapOfPropertiesTrueTypeFontProgram() {
        properties = new ArrayList<String>();
        properties.add("isSymbolic");
        properties.add("nrCmaps");
        properties.add("cmap30Present");
        properties.add("cmap31Present");
        properties.add("cmap10Present");
        mapOfProperties.put("TrueTypeFontProgram", properties);
    }

    private static void fillMapOfLinksTrueTypeFontProgram() {
        links = new ArrayList<String>();
        mapOfLinks.put("TrueTypeFontProgram", links);
    }

    private static void fillMapOfSuperNamesCMapFile() {
        mapOfSuperNames.put("CMapFile", "External");
    }

    private static void fillMapOfPropertiesCMapFile() {
        properties = new ArrayList<String>();
        properties.add("WMode");
        properties.add("dictWMode");
        properties.add("maximalCID");
        mapOfProperties.put("CMapFile", properties);
    }

    private static void fillMapOfLinksCMapFile() {
        links = new ArrayList<String>();
        mapOfLinks.put("CMapFile", links);
    }

    private static void fillMapOfSuperNamesJPEG2000() {
        mapOfSuperNames.put("JPEG2000", "External");
    }

    private static void fillMapOfPropertiesJPEG2000() {
        properties = new ArrayList<String>();
        properties.add("nrColorChannels");
        properties.add("nrColorSpaceSpecs");
        properties.add("nrColorSpacesWithApproxField");
        properties.add("colrMethod");
        properties.add("colrEnumCS");
        properties.add("bitDepth");
        properties.add("bpccBoxPresent");
        properties.add("hasColorSpace");
        mapOfProperties.put("JPEG2000", properties);
    }

    private static void fillMapOfLinksJPEG2000() {
        links = new ArrayList<String>();
        mapOfLinks.put("JPEG2000", links);
    }

    private static void fillMapOfSuperNamesEmbeddedFile() {
        mapOfSuperNames.put("EmbeddedFile", "External");
    }

    private static void fillMapOfPropertiesEmbeddedFile() {
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("isValidPDFA12");
        properties.add("isValidPDFA124");
        mapOfProperties.put("EmbeddedFile", properties);
    }

    private static void fillMapOfLinksEmbeddedFile() {
        links = new ArrayList<String>();
        mapOfLinks.put("EmbeddedFile", links);
    }

    private static void fillMapOfSuperNamesPKCSDataObject() {
        mapOfSuperNames.put("PKCSDataObject", "External");
    }

    private static void fillMapOfPropertiesPKCSDataObject() {
        properties = new ArrayList<String>();
        properties.add("SignerInfoCount");
        properties.add("signingCertificatePresent");
        mapOfProperties.put("PKCSDataObject", properties);
    }

    private static void fillMapOfLinksPKCSDataObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("PKCSDataObject", links);
    }

    private static void fillMapOfSuperNamesAObject() {
        mapOfSuperNames.put("AObject", "Object");
    }

    private static void fillMapOfPropertiesAObject() {
        properties = new ArrayList<String>();
        properties.add("size");
        properties.add("keyName");
        properties.add("keysString");
        properties.add("numberOfPages");
        properties.add("fileSize");
        properties.add("objectType");
        properties.add("isPDFTagged");
        properties.add("notStandard14Font");
        properties.add("isEncryptedWrapper");
        mapOfProperties.put("AObject", properties);
    }

    private static void fillMapOfLinksAObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("AObject", links);
    }

    private static void fillMapOfSuperNamesA3DActivation() {
        mapOfSuperNames.put("A3DActivation", "AObject");
    }

    private static void fillMapOfPropertiesA3DActivation() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeName");
        properties.add("ANameValue");
        properties.add("containsAIS");
        properties.add("AISHasTypeName");
        properties.add("AISNameValue");
        properties.add("containsD");
        properties.add("DHasTypeName");
        properties.add("DNameValue");
        properties.add("containsDIS");
        properties.add("DISHasTypeName");
        properties.add("DISNameValue");
        properties.add("containsNP");
        properties.add("NPHasTypeBoolean");
        properties.add("containsStyle");
        properties.add("StyleHasTypeName");
        properties.add("StyleNameValue");
        properties.add("containsTB");
        properties.add("TBHasTypeBoolean");
        properties.add("containsTransparent");
        properties.add("TransparentHasTypeBoolean");
        properties.add("containsWindow");
        properties.add("WindowHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DActivation", properties);
    }

    private static void fillMapOfLinksA3DActivation() {
        links = new ArrayList<String>();
        links.add("Window");
        mapOfLinks.put("A3DActivation", links);
    }

    private static void fillMapOfSuperNamesA3DAnimationStyle() {
        mapOfSuperNames.put("A3DAnimationStyle", "AObject");
    }

    private static void fillMapOfPropertiesA3DAnimationStyle() {
        properties = new ArrayList<String>();
        properties.add("containsPC");
        properties.add("PCHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTM");
        properties.add("TMHasTypeNumber");
        properties.add("TMNumberValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("A3DAnimationStyle", properties);
    }

    private static void fillMapOfLinksA3DAnimationStyle() {
        links = new ArrayList<String>();
        mapOfLinks.put("A3DAnimationStyle", links);
    }

    private static void fillMapOfSuperNamesA3DBackground() {
        mapOfSuperNames.put("A3DBackground", "AObject");
    }

    private static void fillMapOfPropertiesA3DBackground() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCS");
        properties.add("CSHasTypeName");
        properties.add("CSNameValue");
        properties.add("containsEA");
        properties.add("EAHasTypeBoolean");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("A3DBackground", properties);
    }

    private static void fillMapOfLinksA3DBackground() {
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("A3DBackground", links);
    }

    private static void fillMapOfSuperNamesA3DCrossSection() {
        mapOfSuperNames.put("A3DCrossSection", "AObject");
    }

    private static void fillMapOfPropertiesA3DCrossSection() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIV");
        properties.add("IVHasTypeBoolean");
        properties.add("IVBooleanValue");
        properties.add("containsO");
        properties.add("OHasTypeArray");
        properties.add("containsPC");
        properties.add("PCHasTypeArray");
        properties.add("containsPO");
        properties.add("POHasTypeNumber");
        properties.add("PONumberValue");
        properties.add("containsPV");
        properties.add("PVHasTypeBoolean");
        properties.add("containsSC");
        properties.add("SCHasTypeBoolean");
        properties.add("containsST");
        properties.add("STHasTypeBoolean");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("A3DCrossSection", properties);
    }

    private static void fillMapOfLinksA3DCrossSection() {
        links = new ArrayList<String>();
        links.add("C");
        links.add("IC");
        links.add("O");
        links.add("PC");
        mapOfLinks.put("A3DCrossSection", links);
    }

    private static void fillMapOfSuperNamesA3DLightingScheme() {
        mapOfSuperNames.put("A3DLightingScheme", "AObject");
    }

    private static void fillMapOfPropertiesA3DLightingScheme() {
        properties = new ArrayList<String>();
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("A3DLightingScheme", properties);
    }

    private static void fillMapOfLinksA3DLightingScheme() {
        links = new ArrayList<String>();
        mapOfLinks.put("A3DLightingScheme", links);
    }

    private static void fillMapOfSuperNamesA3DMeasure3DC() {
        mapOfSuperNames.put("A3DMeasure3DC", "AObject");
    }

    private static void fillMapOfPropertiesA3DMeasure3DC() {
        properties = new ArrayList<String>();
        properties.add("containsA1");
        properties.add("A1HasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsN1");
        properties.add("N1HasTypeStringText");
        properties.add("containsS");
        properties.add("isSIndirect");
        properties.add("SHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTB");
        properties.add("TBHasTypeArray");
        properties.add("containsTP");
        properties.add("TPHasTypeArray");
        properties.add("containsTRL");
        properties.add("TRLHasTypeStringText");
        properties.add("containsTS");
        properties.add("TSHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUT");
        properties.add("UTHasTypeStringText");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DMeasure3DC", properties);
    }

    private static void fillMapOfLinksA3DMeasure3DC() {
        links = new ArrayList<String>();
        links.add("A1");
        links.add("C");
        links.add("S");
        links.add("TB");
        links.add("TP");
        mapOfLinks.put("A3DMeasure3DC", links);
    }

    private static void fillMapOfSuperNamesA3DMeasureAD3() {
        mapOfSuperNames.put("A3DMeasureAD3", "AObject");
    }

    private static void fillMapOfPropertiesA3DMeasureAD3() {
        properties = new ArrayList<String>();
        properties.add("containsA1");
        properties.add("A1HasTypeArray");
        properties.add("containsA2");
        properties.add("A2HasTypeArray");
        properties.add("containsAP");
        properties.add("APHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsD1");
        properties.add("D1HasTypeArray");
        properties.add("containsD2");
        properties.add("D2HasTypeArray");
        properties.add("containsDR");
        properties.add("DRHasTypeBoolean");
        properties.add("containsN1");
        properties.add("N1HasTypeStringText");
        properties.add("containsN2");
        properties.add("N2HasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsS");
        properties.add("isSIndirect");
        properties.add("SHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTP");
        properties.add("TPHasTypeArray");
        properties.add("containsTRL");
        properties.add("TRLHasTypeStringText");
        properties.add("containsTS");
        properties.add("TSHasTypeNumber");
        properties.add("containsTX");
        properties.add("TXHasTypeArray");
        properties.add("containsTY");
        properties.add("TYHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUT");
        properties.add("UTHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DMeasureAD3", properties);
    }

    private static void fillMapOfLinksA3DMeasureAD3() {
        links = new ArrayList<String>();
        links.add("A1");
        links.add("A2");
        links.add("AP");
        links.add("C");
        links.add("D1");
        links.add("D2");
        links.add("S");
        links.add("TP");
        links.add("TX");
        links.add("TY");
        mapOfLinks.put("A3DMeasureAD3", links);
    }

    private static void fillMapOfSuperNamesA3DMeasureLD3() {
        mapOfSuperNames.put("A3DMeasureLD3", "AObject");
    }

    private static void fillMapOfPropertiesA3DMeasureLD3() {
        properties = new ArrayList<String>();
        properties.add("containsA1");
        properties.add("A1HasTypeArray");
        properties.add("containsA2");
        properties.add("A2HasTypeArray");
        properties.add("containsAP");
        properties.add("APHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsN1");
        properties.add("N1HasTypeStringText");
        properties.add("containsN2");
        properties.add("N2HasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsS");
        properties.add("isSIndirect");
        properties.add("SHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTP");
        properties.add("TPHasTypeArray");
        properties.add("containsTRL");
        properties.add("TRLHasTypeStringText");
        properties.add("containsTS");
        properties.add("TSHasTypeNumber");
        properties.add("containsTY");
        properties.add("TYHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU");
        properties.add("UHasTypeStringText");
        properties.add("containsUT");
        properties.add("UTHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DMeasureLD3", properties);
    }

    private static void fillMapOfLinksA3DMeasureLD3() {
        links = new ArrayList<String>();
        links.add("A1");
        links.add("A2");
        links.add("AP");
        links.add("C");
        links.add("S");
        links.add("TP");
        links.add("TY");
        mapOfLinks.put("A3DMeasureLD3", links);
    }

    private static void fillMapOfSuperNamesA3DMeasurePD3() {
        mapOfSuperNames.put("A3DMeasurePD3", "AObject");
    }

    private static void fillMapOfPropertiesA3DMeasurePD3() {
        properties = new ArrayList<String>();
        properties.add("containsA1");
        properties.add("A1HasTypeArray");
        properties.add("containsA2");
        properties.add("A2HasTypeArray");
        properties.add("containsAP");
        properties.add("APHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsD1");
        properties.add("D1HasTypeArray");
        properties.add("containsN1");
        properties.add("N1HasTypeStringText");
        properties.add("containsN2");
        properties.add("N2HasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsS");
        properties.add("isSIndirect");
        properties.add("SHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTP");
        properties.add("TPHasTypeArray");
        properties.add("containsTRL");
        properties.add("TRLHasTypeStringText");
        properties.add("containsTS");
        properties.add("TSHasTypeNumber");
        properties.add("containsTY");
        properties.add("TYHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU");
        properties.add("UHasTypeStringText");
        properties.add("containsUT");
        properties.add("UTHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DMeasurePD3", properties);
    }

    private static void fillMapOfLinksA3DMeasurePD3() {
        links = new ArrayList<String>();
        links.add("A1");
        links.add("A2");
        links.add("AP");
        links.add("C");
        links.add("D1");
        links.add("S");
        links.add("TP");
        links.add("TY");
        mapOfLinks.put("A3DMeasurePD3", links);
    }

    private static void fillMapOfSuperNamesA3DMeasureRD3() {
        mapOfSuperNames.put("A3DMeasureRD3", "AObject");
    }

    private static void fillMapOfPropertiesA3DMeasureRD3() {
        properties = new ArrayList<String>();
        properties.add("containsA1");
        properties.add("A1HasTypeArray");
        properties.add("containsA2");
        properties.add("A2HasTypeArray");
        properties.add("containsA3");
        properties.add("A3HasTypeArray");
        properties.add("containsA4");
        properties.add("A4HasTypeArray");
        properties.add("containsAP");
        properties.add("APHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsEL");
        properties.add("ELHasTypeNumber");
        properties.add("containsN2");
        properties.add("N2HasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsR");
        properties.add("RHasTypeBoolean");
        properties.add("containsS");
        properties.add("isSIndirect");
        properties.add("SHasTypeDictionary");
        properties.add("containsSC");
        properties.add("SCHasTypeBoolean");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTP");
        properties.add("TPHasTypeArray");
        properties.add("containsTRL");
        properties.add("TRLHasTypeStringText");
        properties.add("containsTS");
        properties.add("TSHasTypeNumber");
        properties.add("containsTX");
        properties.add("TXHasTypeArray");
        properties.add("containsTY");
        properties.add("TYHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU");
        properties.add("UHasTypeStringText");
        properties.add("containsUT");
        properties.add("UTHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DMeasureRD3", properties);
    }

    private static void fillMapOfLinksA3DMeasureRD3() {
        links = new ArrayList<String>();
        links.add("A1");
        links.add("A2");
        links.add("A3");
        links.add("A4");
        links.add("AP");
        links.add("C");
        links.add("S");
        links.add("TP");
        links.add("TX");
        links.add("TY");
        mapOfLinks.put("A3DMeasureRD3", links);
    }

    private static void fillMapOfSuperNamesA3DNode() {
        mapOfSuperNames.put("A3DNode", "AObject");
    }

    private static void fillMapOfPropertiesA3DNode() {
        properties = new ArrayList<String>();
        properties.add("containsData");
        properties.add("isDataIndirect");
        properties.add("DataHasTypeStream");
        properties.add("DataHasTypeStringText");
        properties.add("containsInstance");
        properties.add("InstanceHasTypeDictionary");
        properties.add("containsM");
        properties.add("MHasTypeArray");
        properties.add("containsN");
        properties.add("NHasTypeString");
        properties.add("containsO");
        properties.add("OHasTypeNumber");
        properties.add("ONumberValue");
        properties.add("containsRM");
        properties.add("RMHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeBoolean");
        mapOfProperties.put("A3DNode", properties);
    }

    private static void fillMapOfLinksA3DNode() {
        links = new ArrayList<String>();
        links.add("Data");
        links.add("Instance");
        links.add("M");
        links.add("RM");
        mapOfLinks.put("A3DNode", links);
    }

    private static void fillMapOfSuperNamesA3DReference() {
        mapOfSuperNames.put("A3DReference", "AObject");
    }

    private static void fillMapOfPropertiesA3DReference() {
        properties = new ArrayList<String>();
        properties.add("contains3DD");
        properties.add("isentry3DDIndirect");
        properties.add("entry3DDHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("A3DReference", properties);
    }

    private static void fillMapOfLinksA3DReference() {
        links = new ArrayList<String>();
        links.add("entry3DD");
        mapOfLinks.put("A3DReference", links);
    }

    private static void fillMapOfSuperNamesA3DRenderMode() {
        mapOfSuperNames.put("A3DRenderMode", "AObject");
    }

    private static void fillMapOfPropertiesA3DRenderMode() {
        properties = new ArrayList<String>();
        properties.add("containsAC");
        properties.add("ACHasTypeArray");
        properties.add("containsCV");
        properties.add("CVHasTypeNumber");
        properties.add("containsFC");
        properties.add("FCHasTypeArray");
        properties.add("FCHasTypeName");
        properties.add("FCNameValue");
        properties.add("containsO");
        properties.add("OHasTypeNumber");
        properties.add("ONumberValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("A3DRenderMode", properties);
    }

    private static void fillMapOfLinksA3DRenderMode() {
        links = new ArrayList<String>();
        links.add("AC");
        links.add("FC");
        mapOfLinks.put("A3DRenderMode", links);
    }

    private static void fillMapOfSuperNamesA3DStream() {
        mapOfSuperNames.put("A3DStream", "AObject");
    }

    private static void fillMapOfPropertiesA3DStream() {
        properties = new ArrayList<String>();
        properties.add("containsAN");
        properties.add("ANHasTypeDictionary");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDV");
        properties.add("DVHasTypeDictionary");
        properties.add("DVHasTypeInteger");
        properties.add("DVHasTypeName");
        properties.add("DVHasTypeString");
        properties.add("DVIntegerValue");
        properties.add("DVNameValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsOnInstantiate");
        properties.add("isOnInstantiateIndirect");
        properties.add("OnInstantiateHasTypeStream");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeNameTree");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVA");
        properties.add("VAHasTypeArray");
        properties.add("VAArraySize");
        mapOfProperties.put("A3DStream", properties);
    }

    private static void fillMapOfLinksA3DStream() {
        links = new ArrayList<String>();
        links.add("AN");
        links.add("ColorSpace");
        links.add("DV");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("OnInstantiate");
        links.add("Resources");
        links.add("VA");
        mapOfLinks.put("A3DStream", links);
    }

    private static void fillMapOfSuperNamesA3DStreamNameTreeResources() {
        mapOfSuperNames.put("A3DStreamNameTreeResources", "AObject");
    }

    private static void fillMapOfPropertiesA3DStreamNameTreeResources() {
        properties = new ArrayList<String>();
        mapOfProperties.put("A3DStreamNameTreeResources", properties);
    }

    private static void fillMapOfLinksA3DStreamNameTreeResources() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("A3DStreamNameTreeResources", links);
    }

    private static void fillMapOfSuperNamesA3DStreamNameTreeResourcesEntry() {
        mapOfSuperNames.put("A3DStreamNameTreeResourcesEntry", "AObject");
    }

    private static void fillMapOfPropertiesA3DStreamNameTreeResourcesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("A3DStreamNameTreeResourcesEntry", properties);
    }

    private static void fillMapOfLinksA3DStreamNameTreeResourcesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("A3DStreamNameTreeResourcesEntry", links);
    }

    private static void fillMapOfSuperNamesA3DUnits() {
        mapOfSuperNames.put("A3DUnits", "AObject");
    }

    private static void fillMapOfPropertiesA3DUnits() {
        properties = new ArrayList<String>();
        properties.add("containsDSm");
        properties.add("DSmHasTypeNumber");
        properties.add("containsDSn");
        properties.add("DSnHasTypeNumber");
        properties.add("containsDU");
        properties.add("DUHasTypeStringText");
        properties.add("containsTSm");
        properties.add("TSmHasTypeNumber");
        properties.add("containsTSn");
        properties.add("TSnHasTypeNumber");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsUSm");
        properties.add("USmHasTypeNumber");
        properties.add("containsUSn");
        properties.add("USnHasTypeNumber");
        properties.add("containsUU");
        properties.add("UUHasTypeStringText");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DUnits", properties);
    }

    private static void fillMapOfLinksA3DUnits() {
        links = new ArrayList<String>();
        mapOfLinks.put("A3DUnits", links);
    }

    private static void fillMapOfSuperNamesA3DView() {
        mapOfSuperNames.put("A3DView", "AObject");
    }

    private static void fillMapOfPropertiesA3DView() {
        properties = new ArrayList<String>();
        properties.add("containsBG");
        properties.add("BGHasTypeDictionary");
        properties.add("containsC2W");
        properties.add("C2WHasTypeArray");
        properties.add("containsCO");
        properties.add("COHasTypeNumber");
        properties.add("containsIN");
        properties.add("INHasTypeStringText");
        properties.add("containsLS");
        properties.add("LSHasTypeDictionary");
        properties.add("containsMA");
        properties.add("MAHasTypeArray");
        properties.add("containsMS");
        properties.add("MSHasTypeName");
        properties.add("MSNameValue");
        properties.add("containsNA");
        properties.add("NAHasTypeArray");
        properties.add("containsNR");
        properties.add("NRHasTypeBoolean");
        properties.add("containsO");
        properties.add("isOIndirect");
        properties.add("OHasTypeStream");
        properties.add("containsP");
        properties.add("PHasTypeDictionary");
        properties.add("containsRM");
        properties.add("RMHasTypeDictionary");
        properties.add("containsSA");
        properties.add("SAHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU3DPath");
        properties.add("U3DPathHasTypeArray");
        properties.add("U3DPathHasTypeStringText");
        properties.add("containsXN");
        properties.add("XNHasTypeStringText");
        mapOfProperties.put("A3DView", properties);
    }

    private static void fillMapOfLinksA3DView() {
        links = new ArrayList<String>();
        links.add("BG");
        links.add("C2W");
        links.add("LS");
        links.add("MA");
        links.add("NA");
        links.add("O");
        links.add("P");
        links.add("RM");
        links.add("SA");
        links.add("U3DPath");
        mapOfLinks.put("A3DView", links);
    }

    private static void fillMapOfSuperNamesA3DViewAddEntries() {
        mapOfSuperNames.put("A3DViewAddEntries", "AObject");
    }

    private static void fillMapOfPropertiesA3DViewAddEntries() {
        properties = new ArrayList<String>();
        properties.add("containsBG");
        properties.add("BGHasTypeDictionary");
        properties.add("containsC2W");
        properties.add("C2WHasTypeArray");
        properties.add("containsCO");
        properties.add("COHasTypeNumber");
        properties.add("containsIN");
        properties.add("INHasTypeString");
        properties.add("containsLS");
        properties.add("LSHasTypeDictionary");
        properties.add("containsMA");
        properties.add("MAHasTypeArray");
        properties.add("containsMS");
        properties.add("MSHasTypeName");
        properties.add("MSNameValue");
        properties.add("containsNA");
        properties.add("NAHasTypeArray");
        properties.add("containsNR");
        properties.add("NRHasTypeBoolean");
        properties.add("containsO");
        properties.add("isOIndirect");
        properties.add("OHasTypeStream");
        properties.add("containsP");
        properties.add("PHasTypeDictionary");
        properties.add("containsParams");
        properties.add("ParamsHasTypeArray");
        properties.add("containsRM");
        properties.add("RMHasTypeDictionary");
        properties.add("containsSA");
        properties.add("SAHasTypeArray");
        properties.add("containsSnapshot");
        properties.add("isSnapshotIndirect");
        properties.add("SnapshotHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU3DPath");
        properties.add("U3DPathHasTypeArray");
        properties.add("U3DPathHasTypeString");
        properties.add("containsXN");
        properties.add("XNHasTypeString");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("A3DViewAddEntries", properties);
    }

    private static void fillMapOfLinksA3DViewAddEntries() {
        links = new ArrayList<String>();
        links.add("BG");
        links.add("C2W");
        links.add("LS");
        links.add("MA");
        links.add("NA");
        links.add("O");
        links.add("P");
        links.add("Params");
        links.add("RM");
        links.add("SA");
        links.add("Snapshot");
        links.add("U3DPath");
        mapOfLinks.put("A3DViewAddEntries", links);
    }

    private static void fillMapOfSuperNamesAAAPL_ST() {
        mapOfSuperNames.put("AAAPL_ST", "AObject");
    }

    private static void fillMapOfPropertiesAAAPL_ST() {
        properties = new ArrayList<String>();
        properties.add("containsColor");
        properties.add("ColorHasTypeArray");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsOffset");
        properties.add("OffsetHasTypeArray");
        properties.add("containsRadius");
        properties.add("RadiusHasTypeNumber");
        properties.add("RadiusNumberValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionAAPL");
        mapOfProperties.put("AAAPL_ST", properties);
    }

    private static void fillMapOfLinksAAAPL_ST() {
        links = new ArrayList<String>();
        links.add("Color");
        links.add("ColorSpace");
        links.add("Offset");
        mapOfLinks.put("AAAPL_ST", links);
    }

    private static void fillMapOfSuperNamesAActionECMAScript() {
        mapOfSuperNames.put("AActionECMAScript", "AObject");
    }

    private static void fillMapOfPropertiesAActionECMAScript() {
        properties = new ArrayList<String>();
        properties.add("containsJS");
        properties.add("isJSIndirect");
        properties.add("JSHasTypeStream");
        properties.add("JSHasTypeStringText");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionECMAScript", properties);
    }

    private static void fillMapOfLinksAActionECMAScript() {
        links = new ArrayList<String>();
        links.add("JS");
        links.add("Next");
        mapOfLinks.put("AActionECMAScript", links);
    }

    private static void fillMapOfSuperNamesAActionGoTo() {
        mapOfSuperNames.put("AActionGoTo", "AObject");
    }

    private static void fillMapOfPropertiesAActionGoTo() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("DHasTypeName");
        properties.add("DHasTypeStringByte");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSD");
        properties.add("SDHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionGoTo", properties);
    }

    private static void fillMapOfLinksAActionGoTo() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("Next");
        links.add("SD");
        mapOfLinks.put("AActionGoTo", links);
    }

    private static void fillMapOfSuperNamesAActionGoTo3DView() {
        mapOfSuperNames.put("AActionGoTo3DView", "AObject");
    }

    private static void fillMapOfPropertiesAActionGoTo3DView() {
        properties = new ArrayList<String>();
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsTA");
        properties.add("TAHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeInteger");
        properties.add("VHasTypeName");
        properties.add("VHasTypeStringText");
        mapOfProperties.put("AActionGoTo3DView", properties);
    }

    private static void fillMapOfLinksAActionGoTo3DView() {
        links = new ArrayList<String>();
        links.add("Next");
        links.add("TA");
        links.add("V");
        mapOfLinks.put("AActionGoTo3DView", links);
    }

    private static void fillMapOfSuperNamesAActionGoToDp() {
        mapOfSuperNames.put("AActionGoToDp", "AObject");
    }

    private static void fillMapOfPropertiesAActionGoToDp() {
        properties = new ArrayList<String>();
        properties.add("containsDp");
        properties.add("isDpIndirect");
        properties.add("DpHasTypeDictionary");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionGoToDp", properties);
    }

    private static void fillMapOfLinksAActionGoToDp() {
        links = new ArrayList<String>();
        links.add("Dp");
        links.add("Next");
        mapOfLinks.put("AActionGoToDp", links);
    }

    private static void fillMapOfSuperNamesAActionGoToE() {
        mapOfSuperNames.put("AActionGoToE", "AObject");
    }

    private static void fillMapOfPropertiesAActionGoToE() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("DHasTypeName");
        properties.add("DHasTypeStringByte");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsNewWindow");
        properties.add("NewWindowHasTypeBoolean");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsT");
        properties.add("THasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionGoToE", properties);
    }

    private static void fillMapOfLinksAActionGoToE() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("F");
        links.add("Next");
        links.add("T");
        mapOfLinks.put("AActionGoToE", links);
    }

    private static void fillMapOfSuperNamesAActionGoToR() {
        mapOfSuperNames.put("AActionGoToR", "AObject");
    }

    private static void fillMapOfPropertiesAActionGoToR() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("DHasTypeName");
        properties.add("DHasTypeStringByte");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsNewWindow");
        properties.add("NewWindowHasTypeBoolean");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSD");
        properties.add("SDHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionGoToR", properties);
    }

    private static void fillMapOfLinksAActionGoToR() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("F");
        links.add("Next");
        links.add("SD");
        mapOfLinks.put("AActionGoToR", links);
    }

    private static void fillMapOfSuperNamesAActionHide() {
        mapOfSuperNames.put("AActionHide", "AObject");
    }

    private static void fillMapOfPropertiesAActionHide() {
        properties = new ArrayList<String>();
        properties.add("containsH");
        properties.add("HHasTypeBoolean");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsT");
        properties.add("isTIndirect");
        properties.add("THasTypeArray");
        properties.add("THasTypeDictionary");
        properties.add("THasTypeStringText");
        properties.add("TIsFieldName");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionHide", properties);
    }

    private static void fillMapOfLinksAActionHide() {
        links = new ArrayList<String>();
        links.add("Next");
        links.add("T");
        mapOfLinks.put("AActionHide", links);
    }

    private static void fillMapOfSuperNamesAActionImportData() {
        mapOfSuperNames.put("AActionImportData", "AObject");
    }

    private static void fillMapOfPropertiesAActionImportData() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionImportData", properties);
    }

    private static void fillMapOfLinksAActionImportData() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("Next");
        mapOfLinks.put("AActionImportData", links);
    }

    private static void fillMapOfSuperNamesAActionLaunch() {
        mapOfSuperNames.put("AActionLaunch", "AObject");
    }

    private static void fillMapOfPropertiesAActionLaunch() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsMac");
        properties.add("MacHasTypeNull");
        properties.add("containsNewWindow");
        properties.add("NewWindowHasTypeBoolean");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUnix");
        properties.add("UnixHasTypeNull");
        properties.add("containsWin");
        properties.add("WinHasTypeDictionary");
        mapOfProperties.put("AActionLaunch", properties);
    }

    private static void fillMapOfLinksAActionLaunch() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("Next");
        links.add("Win");
        mapOfLinks.put("AActionLaunch", links);
    }

    private static void fillMapOfSuperNamesAActionMovie() {
        mapOfSuperNames.put("AActionMovie", "AObject");
    }

    private static void fillMapOfPropertiesAActionMovie() {
        properties = new ArrayList<String>();
        properties.add("containsAnnotation");
        properties.add("AnnotationHasTypeDictionary");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsOperation");
        properties.add("OperationHasTypeName");
        properties.add("OperationNameValue");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionMovie", properties);
    }

    private static void fillMapOfLinksAActionMovie() {
        links = new ArrayList<String>();
        links.add("Annotation");
        links.add("Next");
        mapOfLinks.put("AActionMovie", links);
    }

    private static void fillMapOfSuperNamesAActionNOP() {
        mapOfSuperNames.put("AActionNOP", "AObject");
    }

    private static void fillMapOfPropertiesAActionNOP() {
        properties = new ArrayList<String>();
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionNOP", properties);
    }

    private static void fillMapOfLinksAActionNOP() {
        links = new ArrayList<String>();
        mapOfLinks.put("AActionNOP", links);
    }

    private static void fillMapOfSuperNamesAActionNamed() {
        mapOfSuperNames.put("AActionNamed", "AObject");
    }

    private static void fillMapOfPropertiesAActionNamed() {
        properties = new ArrayList<String>();
        properties.add("containsN");
        properties.add("NHasTypeName");
        properties.add("NNameValue");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionNamed", properties);
    }

    private static void fillMapOfLinksAActionNamed() {
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("AActionNamed", links);
    }

    private static void fillMapOfSuperNamesAActionRendition() {
        mapOfSuperNames.put("AActionRendition", "AObject");
    }

    private static void fillMapOfPropertiesAActionRendition() {
        properties = new ArrayList<String>();
        properties.add("containsAN");
        properties.add("isANIndirect");
        properties.add("ANHasTypeDictionary");
        properties.add("containsJS");
        properties.add("isJSIndirect");
        properties.add("JSHasTypeStream");
        properties.add("JSHasTypeStringText");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsOP");
        properties.add("OPHasTypeInteger");
        properties.add("OPIntegerValue");
        properties.add("containsR");
        properties.add("RHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionRendition", properties);
    }

    private static void fillMapOfLinksAActionRendition() {
        links = new ArrayList<String>();
        links.add("AN");
        links.add("JS");
        links.add("Next");
        links.add("R");
        mapOfLinks.put("AActionRendition", links);
    }

    private static void fillMapOfSuperNamesAActionResetForm() {
        mapOfSuperNames.put("AActionResetForm", "AObject");
    }

    private static void fillMapOfPropertiesAActionResetForm() {
        properties = new ArrayList<String>();
        properties.add("containsFields");
        properties.add("FieldsHasTypeArray");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionResetForm", properties);
    }

    private static void fillMapOfLinksAActionResetForm() {
        links = new ArrayList<String>();
        links.add("Fields");
        links.add("Next");
        mapOfLinks.put("AActionResetForm", links);
    }

    private static void fillMapOfSuperNamesAActionRichMediaExecute() {
        mapOfSuperNames.put("AActionRichMediaExecute", "AObject");
    }

    private static void fillMapOfPropertiesAActionRichMediaExecute() {
        properties = new ArrayList<String>();
        properties.add("containsCMD");
        properties.add("CMDHasTypeDictionary");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsTA");
        properties.add("isTAIndirect");
        properties.add("TAHasTypeDictionary");
        properties.add("containsTI");
        properties.add("isTIIndirect");
        properties.add("TIHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AActionRichMediaExecute", properties);
    }

    private static void fillMapOfLinksAActionRichMediaExecute() {
        links = new ArrayList<String>();
        links.add("CMD");
        links.add("Next");
        links.add("TA");
        links.add("TI");
        mapOfLinks.put("AActionRichMediaExecute", links);
    }

    private static void fillMapOfSuperNamesAActionSetOCGState() {
        mapOfSuperNames.put("AActionSetOCGState", "AObject");
    }

    private static void fillMapOfPropertiesAActionSetOCGState() {
        properties = new ArrayList<String>();
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsPreserveRB");
        properties.add("PreserveRBHasTypeBoolean");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsState");
        properties.add("StateHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionSetOCGState", properties);
    }

    private static void fillMapOfLinksAActionSetOCGState() {
        links = new ArrayList<String>();
        links.add("Next");
        links.add("State");
        mapOfLinks.put("AActionSetOCGState", links);
    }

    private static void fillMapOfSuperNamesAActionSetState() {
        mapOfSuperNames.put("AActionSetState", "AObject");
    }

    private static void fillMapOfPropertiesAActionSetState() {
        properties = new ArrayList<String>();
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsT");
        properties.add("isTIndirect");
        properties.add("THasTypeArray");
        properties.add("THasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionSetState", properties);
    }

    private static void fillMapOfLinksAActionSetState() {
        links = new ArrayList<String>();
        links.add("T");
        mapOfLinks.put("AActionSetState", links);
    }

    private static void fillMapOfSuperNamesAActionSound() {
        mapOfSuperNames.put("AActionSound", "AObject");
    }

    private static void fillMapOfPropertiesAActionSound() {
        properties = new ArrayList<String>();
        properties.add("containsMix");
        properties.add("MixHasTypeBoolean");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsRepeat");
        properties.add("RepeatHasTypeBoolean");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSound");
        properties.add("isSoundIndirect");
        properties.add("SoundHasTypeStream");
        properties.add("containsSynchronous");
        properties.add("SynchronousHasTypeBoolean");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVolume");
        properties.add("VolumeHasTypeNumber");
        properties.add("VolumeNumberValue");
        mapOfProperties.put("AActionSound", properties);
    }

    private static void fillMapOfLinksAActionSound() {
        links = new ArrayList<String>();
        links.add("Next");
        links.add("Sound");
        mapOfLinks.put("AActionSound", links);
    }

    private static void fillMapOfSuperNamesAActionSubmitForm() {
        mapOfSuperNames.put("AActionSubmitForm", "AObject");
    }

    private static void fillMapOfPropertiesAActionSubmitForm() {
        properties = new ArrayList<String>();
        properties.add("containsCharSet");
        properties.add("CharSetHasTypeString");
        properties.add("CharSetStringValue");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFields");
        properties.add("FieldsHasTypeArray");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        mapOfProperties.put("AActionSubmitForm", properties);
    }

    private static void fillMapOfLinksAActionSubmitForm() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("Fields");
        mapOfLinks.put("AActionSubmitForm", links);
    }

    private static void fillMapOfSuperNamesAActionThread() {
        mapOfSuperNames.put("AActionThread", "AObject");
    }

    private static void fillMapOfPropertiesAActionThread() {
        properties = new ArrayList<String>();
        properties.add("containsB");
        properties.add("isBIndirect");
        properties.add("BHasTypeDictionary");
        properties.add("BHasTypeInteger");
        properties.add("BIntegerValue");
        properties.add("containsD");
        properties.add("isDIndirect");
        properties.add("DHasTypeDictionary");
        properties.add("DHasTypeInteger");
        properties.add("DHasTypeStringText");
        properties.add("DIntegerValue");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("trailerCatalogThreadsArraySize");
        properties.add("trailerCatalogThreadsHasTypeArray");
        mapOfProperties.put("AActionThread", properties);
    }

    private static void fillMapOfLinksAActionThread() {
        links = new ArrayList<String>();
        links.add("B");
        links.add("D");
        links.add("F");
        links.add("Next");
        mapOfLinks.put("AActionThread", links);
    }

    private static void fillMapOfSuperNamesAActionTransition() {
        mapOfSuperNames.put("AActionTransition", "AObject");
    }

    private static void fillMapOfPropertiesAActionTransition() {
        properties = new ArrayList<String>();
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsTrans");
        properties.add("TransHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AActionTransition", properties);
    }

    private static void fillMapOfLinksAActionTransition() {
        links = new ArrayList<String>();
        links.add("Next");
        links.add("Trans");
        mapOfLinks.put("AActionTransition", links);
    }

    private static void fillMapOfSuperNamesAActionURI() {
        mapOfSuperNames.put("AActionURI", "AObject");
    }

    private static void fillMapOfPropertiesAActionURI() {
        properties = new ArrayList<String>();
        properties.add("containsIsMap");
        properties.add("IsMapHasTypeBoolean");
        properties.add("containsNext");
        properties.add("NextHasTypeArray");
        properties.add("NextHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsURI");
        properties.add("URIHasTypeStringAscii");
        mapOfProperties.put("AActionURI", properties);
    }

    private static void fillMapOfLinksAActionURI() {
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("AActionURI", links);
    }

    private static void fillMapOfSuperNamesAAddActionCatalog() {
        mapOfSuperNames.put("AAddActionCatalog", "AObject");
    }

    private static void fillMapOfPropertiesAAddActionCatalog() {
        properties = new ArrayList<String>();
        properties.add("containsDC");
        properties.add("DCHasTypeDictionary");
        properties.add("containsDP");
        properties.add("DPHasTypeDictionary");
        properties.add("containsDS");
        properties.add("DSHasTypeDictionary");
        properties.add("containsWP");
        properties.add("WPHasTypeDictionary");
        properties.add("containsWS");
        properties.add("WSHasTypeDictionary");
        mapOfProperties.put("AAddActionCatalog", properties);
    }

    private static void fillMapOfLinksAAddActionCatalog() {
        links = new ArrayList<String>();
        links.add("DC");
        links.add("DP");
        links.add("DS");
        links.add("WP");
        links.add("WS");
        mapOfLinks.put("AAddActionCatalog", links);
    }

    private static void fillMapOfSuperNamesAAddActionFormField() {
        mapOfSuperNames.put("AAddActionFormField", "AObject");
    }

    private static void fillMapOfPropertiesAAddActionFormField() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("containsK");
        properties.add("KHasTypeDictionary");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        mapOfProperties.put("AAddActionFormField", properties);
    }

    private static void fillMapOfLinksAAddActionFormField() {
        links = new ArrayList<String>();
        links.add("C");
        links.add("F");
        links.add("K");
        links.add("V");
        mapOfLinks.put("AAddActionFormField", links);
    }

    private static void fillMapOfSuperNamesAAddActionPageObject() {
        mapOfSuperNames.put("AAddActionPageObject", "AObject");
    }

    private static void fillMapOfPropertiesAAddActionPageObject() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeDictionary");
        properties.add("containsO");
        properties.add("OHasTypeDictionary");
        mapOfProperties.put("AAddActionPageObject", properties);
    }

    private static void fillMapOfLinksAAddActionPageObject() {
        links = new ArrayList<String>();
        links.add("C");
        links.add("O");
        mapOfLinks.put("AAddActionPageObject", links);
    }

    private static void fillMapOfSuperNamesAAddActionScreenAnnotation() {
        mapOfSuperNames.put("AAddActionScreenAnnotation", "AObject");
    }

    private static void fillMapOfPropertiesAAddActionScreenAnnotation() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsE");
        properties.add("EHasTypeDictionary");
        properties.add("containsPC");
        properties.add("PCHasTypeDictionary");
        properties.add("containsPI");
        properties.add("PIHasTypeDictionary");
        properties.add("containsPO");
        properties.add("POHasTypeDictionary");
        properties.add("containsPV");
        properties.add("PVHasTypeDictionary");
        properties.add("containsU");
        properties.add("UHasTypeDictionary");
        properties.add("containsX");
        properties.add("XHasTypeDictionary");
        mapOfProperties.put("AAddActionScreenAnnotation", properties);
    }

    private static void fillMapOfLinksAAddActionScreenAnnotation() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("E");
        links.add("PC");
        links.add("PI");
        links.add("PO");
        links.add("PV");
        links.add("U");
        links.add("X");
        mapOfLinks.put("AAddActionScreenAnnotation", links);
    }

    private static void fillMapOfSuperNamesAAddActionWidgetAnnotation() {
        mapOfSuperNames.put("AAddActionWidgetAnnotation", "AObject");
    }

    private static void fillMapOfPropertiesAAddActionWidgetAnnotation() {
        properties = new ArrayList<String>();
        properties.add("containsBl");
        properties.add("BlHasTypeDictionary");
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsE");
        properties.add("EHasTypeDictionary");
        properties.add("containsFo");
        properties.add("FoHasTypeDictionary");
        properties.add("containsPC");
        properties.add("PCHasTypeDictionary");
        properties.add("containsPI");
        properties.add("PIHasTypeDictionary");
        properties.add("containsPO");
        properties.add("POHasTypeDictionary");
        properties.add("containsPV");
        properties.add("PVHasTypeDictionary");
        properties.add("containsU");
        properties.add("UHasTypeDictionary");
        properties.add("containsX");
        properties.add("XHasTypeDictionary");
        mapOfProperties.put("AAddActionWidgetAnnotation", properties);
    }

    private static void fillMapOfLinksAAddActionWidgetAnnotation() {
        links = new ArrayList<String>();
        links.add("Bl");
        links.add("D");
        links.add("E");
        links.add("Fo");
        links.add("PC");
        links.add("PI");
        links.add("PO");
        links.add("PV");
        links.add("U");
        links.add("X");
        mapOfLinks.put("AAddActionWidgetAnnotation", links);
    }

    private static void fillMapOfSuperNamesAAlternateImage() {
        mapOfSuperNames.put("AAlternateImage", "AObject");
    }

    private static void fillMapOfPropertiesAAlternateImage() {
        properties = new ArrayList<String>();
        properties.add("containsDefaultForPrinting");
        properties.add("DefaultForPrintingHasTypeBoolean");
        properties.add("containsImage");
        properties.add("isImageIndirect");
        properties.add("ImageHasTypeStream");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        mapOfProperties.put("AAlternateImage", properties);
    }

    private static void fillMapOfLinksAAlternateImage() {
        links = new ArrayList<String>();
        links.add("Image");
        links.add("OC");
        mapOfLinks.put("AAlternateImage", links);
    }

    private static void fillMapOfSuperNamesAAnnot3D() {
        mapOfSuperNames.put("AAnnot3D", "AObject");
    }

    private static void fillMapOfPropertiesAAnnot3D() {
        properties = new ArrayList<String>();
        properties.add("contains3DA");
        properties.add("entry3DAHasTypeDictionary");
        properties.add("contains3DB");
        properties.add("entry3DBHasTypeRectangle");
        properties.add("contains3DD");
        properties.add("isentry3DDIndirect");
        properties.add("entry3DDHasTypeDictionary");
        properties.add("entry3DDHasTypeStream");
        properties.add("contains3DI");
        properties.add("entry3DIHasTypeBoolean");
        properties.add("contains3DU");
        properties.add("entry3DUHasTypeDictionary");
        properties.add("contains3DV");
        properties.add("entry3DVHasTypeDictionary");
        properties.add("entry3DVHasTypeInteger");
        properties.add("entry3DVHasTypeName");
        properties.add("entry3DVHasTypeString");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsGEO");
        properties.add("GEOHasTypeDictionary");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnot3D", properties);
    }

    private static void fillMapOfLinksAAnnot3D() {
        links = new ArrayList<String>();
        links.add("entry3DA");
        links.add("entry3DD");
        links.add("entry3DU");
        links.add("entry3DV");
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("GEO");
        links.add("OC");
        links.add("P");
        mapOfLinks.put("AAnnot3D", links);
    }

    private static void fillMapOfSuperNamesAAnnotCaret() {
        mapOfSuperNames.put("AAnnotCaret", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotCaret() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRD");
        properties.add("RDHasTypeRectangle");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsSy");
        properties.add("SyHasTypeName");
        properties.add("SyNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("RD2NumberValue");
        properties.add("RD3NumberValue");
        properties.add("RD0NumberValue");
        properties.add("RD1NumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotCaret", properties);
    }

    private static void fillMapOfLinksAAnnotCaret() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotCaret", links);
    }

    private static void fillMapOfSuperNamesAAnnotCircle() {
        mapOfSuperNames.put("AAnnotCircle", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotCircle() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRD");
        properties.add("RDHasTypeRectangle");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("RD2NumberValue");
        properties.add("RD3NumberValue");
        properties.add("RD0NumberValue");
        properties.add("RD1NumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotCircle", properties);
    }

    private static void fillMapOfLinksAAnnotCircle() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BE");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IC");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotCircle", links);
    }

    private static void fillMapOfSuperNamesAAnnotFileAttachment() {
        mapOfSuperNames.put("AAnnotFileAttachment", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotFileAttachment() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsFS");
        properties.add("FSHasTypeDictionary");
        properties.add("FSHasTypeString");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("NameNameValue");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotFileAttachment", properties);
    }

    private static void fillMapOfLinksAAnnotFileAttachment() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("FS");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotFileAttachment", links);
    }

    private static void fillMapOfSuperNamesAAnnotFreeText() {
        mapOfSuperNames.put("AAnnotFreeText", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotFreeText() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsCL");
        properties.add("CLHasTypeArray");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("ITNameValue");
        properties.add("containsLE");
        properties.add("LEHasTypeName");
        properties.add("LENameValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRD");
        properties.add("RDHasTypeRectangle");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("RD2NumberValue");
        properties.add("RD3NumberValue");
        properties.add("RD0NumberValue");
        properties.add("RD1NumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotFreeText", properties);
    }

    private static void fillMapOfLinksAAnnotFreeText() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BE");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("CL");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotFreeText", links);
    }

    private static void fillMapOfSuperNamesAAnnotHighlight() {
        mapOfSuperNames.put("AAnnotHighlight", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotHighlight() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsQuadPoints");
        properties.add("QuadPointsHasTypeArray");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotHighlight", properties);
    }

    private static void fillMapOfLinksAAnnotHighlight() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("QuadPoints");
        links.add("RC");
        mapOfLinks.put("AAnnotHighlight", links);
    }

    private static void fillMapOfSuperNamesAAnnotInk() {
        mapOfSuperNames.put("AAnnotInk", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotInk() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsInkList");
        properties.add("InkListHasTypeArray");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPath");
        properties.add("PathHasTypeArray");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotInk", properties);
    }

    private static void fillMapOfLinksAAnnotInk() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("InkList");
        links.add("OC");
        links.add("P");
        links.add("Path");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotInk", links);
    }

    private static void fillMapOfSuperNamesAAnnotLine() {
        mapOfSuperNames.put("AAnnotLine", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotLine() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsCO");
        properties.add("COHasTypeArray");
        properties.add("containsCP");
        properties.add("CPHasTypeName");
        properties.add("CPNameValue");
        properties.add("containsCap");
        properties.add("CapHasTypeBoolean");
        properties.add("CapBooleanValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("ITNameValue");
        properties.add("containsL");
        properties.add("LHasTypeArray");
        properties.add("containsLE");
        properties.add("LEHasTypeArray");
        properties.add("containsLL");
        properties.add("LLHasTypeNumber");
        properties.add("containsLLE");
        properties.add("LLEHasTypeNumber");
        properties.add("LLENumberValue");
        properties.add("containsLLO");
        properties.add("LLOHasTypeNumber");
        properties.add("LLONumberValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotLine", properties);
    }

    private static void fillMapOfLinksAAnnotLine() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("CO");
        links.add("ExData");
        links.add("IC");
        links.add("IRT");
        links.add("L");
        links.add("LE");
        links.add("Measure");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotLine", links);
    }

    private static void fillMapOfSuperNamesAAnnotLink() {
        mapOfSuperNames.put("AAnnotLink", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotLink() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeDictionary");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsDest");
        properties.add("DestHasTypeArray");
        properties.add("DestHasTypeName");
        properties.add("DestHasTypeStringByte");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsH");
        properties.add("HHasTypeName");
        properties.add("HNameValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPA");
        properties.add("PAHasTypeDictionary");
        properties.add("containsPath");
        properties.add("PathHasTypeArray");
        properties.add("containsQuadPoints");
        properties.add("QuadPointsHasTypeArray");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionISO_TS_24654");
        mapOfProperties.put("AAnnotLink", properties);
    }

    private static void fillMapOfLinksAAnnotLink() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("AF");
        links.add("AP");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("Dest");
        links.add("OC");
        links.add("P");
        links.add("PA");
        links.add("Path");
        links.add("QuadPoints");
        mapOfLinks.put("AAnnotLink", links);
    }

    private static void fillMapOfSuperNamesAAnnotMovie() {
        mapOfSuperNames.put("AAnnotMovie", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotMovie() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeBoolean");
        properties.add("AHasTypeDictionary");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMovie");
        properties.add("MovieHasTypeDictionary");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeString");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        mapOfProperties.put("AAnnotMovie", properties);
    }

    private static void fillMapOfLinksAAnnotMovie() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("Movie");
        links.add("OC");
        links.add("P");
        mapOfLinks.put("AAnnotMovie", links);
    }

    private static void fillMapOfSuperNamesAAnnotPolyLine() {
        mapOfSuperNames.put("AAnnotPolyLine", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotPolyLine() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("ITNameValue");
        properties.add("containsLE");
        properties.add("LEHasTypeArray");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPath");
        properties.add("PathHasTypeArray");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVertices");
        properties.add("VerticesHasTypeArray");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotPolyLine", properties);
    }

    private static void fillMapOfLinksAAnnotPolyLine() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BE");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IC");
        links.add("IRT");
        links.add("LE");
        links.add("Measure");
        links.add("OC");
        links.add("P");
        links.add("Path");
        links.add("Popup");
        links.add("RC");
        links.add("Vertices");
        mapOfLinks.put("AAnnotPolyLine", links);
    }

    private static void fillMapOfSuperNamesAAnnotPolygon() {
        mapOfSuperNames.put("AAnnotPolygon", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotPolygon() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("ITNameValue");
        properties.add("containsLE");
        properties.add("LEHasTypeArray");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPath");
        properties.add("PathHasTypeArray");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVertices");
        properties.add("VerticesHasTypeArray");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotPolygon", properties);
    }

    private static void fillMapOfLinksAAnnotPolygon() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BE");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IC");
        links.add("IRT");
        links.add("LE");
        links.add("Measure");
        links.add("OC");
        links.add("P");
        links.add("Path");
        links.add("Popup");
        links.add("RC");
        links.add("Vertices");
        mapOfLinks.put("AAnnotPolygon", links);
    }

    private static void fillMapOfSuperNamesAAnnotPopup() {
        mapOfSuperNames.put("AAnnotPopup", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotPopup() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOpen");
        properties.add("OpenHasTypeBoolean");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        mapOfProperties.put("AAnnotPopup", properties);
    }

    private static void fillMapOfLinksAAnnotPopup() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("OC");
        links.add("P");
        links.add("Parent");
        mapOfLinks.put("AAnnotPopup", links);
    }

    private static void fillMapOfSuperNamesAAnnotPrinterMark() {
        mapOfSuperNames.put("AAnnotPrinterMark", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotPrinterMark() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMN");
        properties.add("MNHasTypeName");
        properties.add("MNNameValue");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        mapOfProperties.put("AAnnotPrinterMark", properties);
    }

    private static void fillMapOfLinksAAnnotPrinterMark() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("OC");
        links.add("P");
        mapOfLinks.put("AAnnotPrinterMark", links);
    }

    private static void fillMapOfSuperNamesAAnnotProjection() {
        mapOfSuperNames.put("AAnnotProjection", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotProjection() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotProjection", properties);
    }

    private static void fillMapOfLinksAAnnotProjection() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotProjection", links);
    }

    private static void fillMapOfSuperNamesAAnnotRedact() {
        mapOfSuperNames.put("AAnnotRedact", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotRedact() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOverlayText");
        properties.add("OverlayTextHasTypeStringText");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsQuadPoints");
        properties.add("QuadPointsHasTypeArray");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRO");
        properties.add("isROIndirect");
        properties.add("ROHasTypeStream");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsRepeat");
        properties.add("RepeatHasTypeBoolean");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotRedact", properties);
    }

    private static void fillMapOfLinksAAnnotRedact() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IC");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("QuadPoints");
        links.add("RC");
        links.add("RO");
        mapOfLinks.put("AAnnotRedact", links);
    }

    private static void fillMapOfSuperNamesAAnnotRichMedia() {
        mapOfSuperNames.put("AAnnotRichMedia", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotRichMedia() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsRichMediaContent");
        properties.add("RichMediaContentHasTypeDictionary");
        properties.add("containsRichMediaSettings");
        properties.add("RichMediaSettingsHasTypeDictionary");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotRichMedia", properties);
    }

    private static void fillMapOfLinksAAnnotRichMedia() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("OC");
        links.add("P");
        links.add("RichMediaContent");
        links.add("RichMediaSettings");
        mapOfLinks.put("AAnnotRichMedia", links);
    }

    private static void fillMapOfSuperNamesAAnnotScreen() {
        mapOfSuperNames.put("AAnnotScreen", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotScreen() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeDictionary");
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMK");
        properties.add("MKHasTypeDictionary");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        mapOfProperties.put("AAnnotScreen", properties);
    }

    private static void fillMapOfLinksAAnnotScreen() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("AA");
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("MK");
        links.add("OC");
        links.add("P");
        mapOfLinks.put("AAnnotScreen", links);
    }

    private static void fillMapOfSuperNamesAAnnotSound() {
        mapOfSuperNames.put("AAnnotSound", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotSound() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsSound");
        properties.add("isSoundIndirect");
        properties.add("SoundHasTypeStream");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotSound", properties);
    }

    private static void fillMapOfLinksAAnnotSound() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        links.add("Sound");
        mapOfLinks.put("AAnnotSound", links);
    }

    private static void fillMapOfSuperNamesAAnnotSquare() {
        mapOfSuperNames.put("AAnnotSquare", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotSquare() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIC");
        properties.add("ICHasTypeArray");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRD");
        properties.add("RDHasTypeRectangle");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("RD2NumberValue");
        properties.add("RD3NumberValue");
        properties.add("RD0NumberValue");
        properties.add("RD1NumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotSquare", properties);
    }

    private static void fillMapOfLinksAAnnotSquare() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("BE");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IC");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotSquare", links);
    }

    private static void fillMapOfSuperNamesAAnnotSquiggly() {
        mapOfSuperNames.put("AAnnotSquiggly", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotSquiggly() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsQuadPoints");
        properties.add("QuadPointsHasTypeArray");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotSquiggly", properties);
    }

    private static void fillMapOfLinksAAnnotSquiggly() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("QuadPoints");
        links.add("RC");
        mapOfLinks.put("AAnnotSquiggly", links);
    }

    private static void fillMapOfSuperNamesAAnnotStamp() {
        mapOfSuperNames.put("AAnnotStamp", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotStamp() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("ITNameValue");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("NameNameValue");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotStamp", properties);
    }

    private static void fillMapOfLinksAAnnotStamp() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotStamp", links);
    }

    private static void fillMapOfSuperNamesAAnnotStrikeOut() {
        mapOfSuperNames.put("AAnnotStrikeOut", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotStrikeOut() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsQuadPoints");
        properties.add("QuadPointsHasTypeArray");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotStrikeOut", properties);
    }

    private static void fillMapOfLinksAAnnotStrikeOut() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("QuadPoints");
        links.add("RC");
        mapOfLinks.put("AAnnotStrikeOut", links);
    }

    private static void fillMapOfSuperNamesAAnnotText() {
        mapOfSuperNames.put("AAnnotText", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotText() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("NameNameValue");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOpen");
        properties.add("OpenHasTypeBoolean");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsState");
        properties.add("StateHasTypeStringText");
        properties.add("StateStringTextValue");
        properties.add("containsStateModel");
        properties.add("StateModelHasTypeStringText");
        properties.add("StateModelStringTextValue");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotText", properties);
    }

    private static void fillMapOfLinksAAnnotText() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("RC");
        mapOfLinks.put("AAnnotText", links);
    }

    private static void fillMapOfSuperNamesAAnnotTrapNetwork() {
        mapOfSuperNames.put("AAnnotTrapNetwork", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotTrapNetwork() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsAnnotStates");
        properties.add("AnnotStatesHasTypeArray");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeString");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsFontFauxing");
        properties.add("FontFauxingHasTypeArray");
        properties.add("containsLang");
        properties.add("LangHasTypeString");
        properties.add("containsLastModified");
        properties.add("LastModifiedHasTypeDate");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeString");
        properties.add("containsNM");
        properties.add("NMHasTypeString");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVersion");
        properties.add("VersionHasTypeArray");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        mapOfProperties.put("AAnnotTrapNetwork", properties);
    }

    private static void fillMapOfLinksAAnnotTrapNetwork() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("AnnotStates");
        links.add("Border");
        links.add("C");
        links.add("FontFauxing");
        links.add("OC");
        links.add("P");
        links.add("Version");
        mapOfLinks.put("AAnnotTrapNetwork", links);
    }

    private static void fillMapOfSuperNamesAAnnotUnderline() {
        mapOfSuperNames.put("AAnnotUnderline", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotUnderline() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsExData");
        properties.add("ExDataHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsIRT");
        properties.add("IRTHasTypeDictionary");
        properties.add("containsIT");
        properties.add("ITHasTypeName");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPopup");
        properties.add("isPopupIndirect");
        properties.add("PopupHasTypeDictionary");
        properties.add("containsQuadPoints");
        properties.add("QuadPointsHasTypeArray");
        properties.add("containsRC");
        properties.add("isRCIndirect");
        properties.add("RCHasTypeStream");
        properties.add("RCHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeName");
        properties.add("RTNameValue");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubj");
        properties.add("SubjHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotUnderline", properties);
    }

    private static void fillMapOfLinksAAnnotUnderline() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("ExData");
        links.add("IRT");
        links.add("OC");
        links.add("P");
        links.add("Popup");
        links.add("QuadPoints");
        links.add("RC");
        mapOfLinks.put("AAnnotUnderline", links);
    }

    private static void fillMapOfSuperNamesAAnnotWatermark() {
        mapOfSuperNames.put("AAnnotWatermark", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotWatermark() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsFixedPrint");
        properties.add("FixedPrintHasTypeDictionary");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        mapOfProperties.put("AAnnotWatermark", properties);
    }

    private static void fillMapOfLinksAAnnotWatermark() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("AP");
        links.add("Border");
        links.add("C");
        links.add("FixedPrint");
        links.add("OC");
        links.add("P");
        mapOfLinks.put("AAnnotWatermark", links);
    }

    private static void fillMapOfSuperNamesAAnnotWidget() {
        mapOfSuperNames.put("AAnnotWidget", "AObject");
    }

    private static void fillMapOfPropertiesAAnnotWidget() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeDictionary");
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAP");
        properties.add("APHasTypeDictionary");
        properties.add("containsAS");
        properties.add("ASHasTypeName");
        properties.add("containsBM");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsBS");
        properties.add("BSHasTypeDictionary");
        properties.add("containsBorder");
        properties.add("BorderHasTypeArray");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("containsH");
        properties.add("HHasTypeName");
        properties.add("HNameValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("MHasTypeStringText");
        properties.add("containsMK");
        properties.add("MKHasTypeDictionary");
        properties.add("containsNM");
        properties.add("NMHasTypeStringText");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPMD");
        properties.add("PMDHasTypeDictionary");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsRect");
        properties.add("RectHasTypeRectangle");
        properties.add("RectRectHeight");
        properties.add("RectRectWidth");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("APNHasTypeDictionary");
        properties.add("APRHasTypeDictionary");
        properties.add("APDHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AAnnotWidget", properties);
    }

    private static void fillMapOfLinksAAnnotWidget() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("AA");
        links.add("AF");
        links.add("AP");
        links.add("BS");
        links.add("Border");
        links.add("C");
        links.add("Kids");
        links.add("MK");
        links.add("OC");
        links.add("P");
        links.add("PMD");
        links.add("Parent");
        mapOfLinks.put("AAnnotWidget", links);
    }

    private static void fillMapOfSuperNamesAAppearance() {
        mapOfSuperNames.put("AAppearance", "AObject");
    }

    private static void fillMapOfPropertiesAAppearance() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("isDIndirect");
        properties.add("DHasTypeDictionary");
        properties.add("DHasTypeStream");
        properties.add("containsN");
        properties.add("isNIndirect");
        properties.add("NHasTypeDictionary");
        properties.add("NHasTypeStream");
        properties.add("containsR");
        properties.add("isRIndirect");
        properties.add("RHasTypeDictionary");
        properties.add("RHasTypeStream");
        mapOfProperties.put("AAppearance", properties);
    }

    private static void fillMapOfLinksAAppearance() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("N");
        links.add("R");
        mapOfLinks.put("AAppearance", links);
    }

    private static void fillMapOfSuperNamesAAppearanceCharacteristics() {
        mapOfSuperNames.put("AAppearanceCharacteristics", "AObject");
    }

    private static void fillMapOfPropertiesAAppearanceCharacteristics() {
        properties = new ArrayList<String>();
        properties.add("containsAC");
        properties.add("ACHasTypeStringText");
        properties.add("containsBC");
        properties.add("BCHasTypeArray");
        properties.add("containsBG");
        properties.add("BGHasTypeArray");
        properties.add("containsCA");
        properties.add("CAHasTypeStringText");
        properties.add("containsI");
        properties.add("isIIndirect");
        properties.add("IHasTypeStream");
        properties.add("containsIF");
        properties.add("IFHasTypeDictionary");
        properties.add("containsIX");
        properties.add("isIXIndirect");
        properties.add("IXHasTypeStream");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("containsRC");
        properties.add("RCHasTypeStringText");
        properties.add("containsRI");
        properties.add("isRIIndirect");
        properties.add("RIHasTypeStream");
        properties.add("containsTP");
        properties.add("TPHasTypeInteger");
        properties.add("TPIntegerValue");
        mapOfProperties.put("AAppearanceCharacteristics", properties);
    }

    private static void fillMapOfLinksAAppearanceCharacteristics() {
        links = new ArrayList<String>();
        links.add("BC");
        links.add("BG");
        links.add("I");
        links.add("IF");
        links.add("IX");
        links.add("RI");
        mapOfLinks.put("AAppearanceCharacteristics", links);
    }

    private static void fillMapOfSuperNamesAAppearancePrinterMark() {
        mapOfSuperNames.put("AAppearancePrinterMark", "AObject");
    }

    private static void fillMapOfPropertiesAAppearancePrinterMark() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("isDIndirect");
        properties.add("DHasTypeDictionary");
        properties.add("DHasTypeStream");
        properties.add("containsN");
        properties.add("isNIndirect");
        properties.add("NHasTypeDictionary");
        properties.add("NHasTypeStream");
        properties.add("containsR");
        properties.add("isRIndirect");
        properties.add("RHasTypeDictionary");
        properties.add("RHasTypeStream");
        mapOfProperties.put("AAppearancePrinterMark", properties);
    }

    private static void fillMapOfLinksAAppearancePrinterMark() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("N");
        links.add("R");
        mapOfLinks.put("AAppearancePrinterMark", links);
    }

    private static void fillMapOfSuperNamesAAppearancePrinterMarkSubDict() {
        mapOfSuperNames.put("AAppearancePrinterMarkSubDict", "AObject");
    }

    private static void fillMapOfPropertiesAAppearancePrinterMarkSubDict() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AAppearancePrinterMarkSubDict", properties);
    }

    private static void fillMapOfLinksAAppearancePrinterMarkSubDict() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AAppearancePrinterMarkSubDict", links);
    }

    private static void fillMapOfSuperNamesAAppearancePrinterMarkSubDictEntry() {
        mapOfSuperNames.put("AAppearancePrinterMarkSubDictEntry", "AObject");
    }

    private static void fillMapOfPropertiesAAppearancePrinterMarkSubDictEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("AAppearancePrinterMarkSubDictEntry", properties);
    }

    private static void fillMapOfLinksAAppearancePrinterMarkSubDictEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AAppearancePrinterMarkSubDictEntry", links);
    }

    private static void fillMapOfSuperNamesAAppearanceSubDict() {
        mapOfSuperNames.put("AAppearanceSubDict", "AObject");
    }

    private static void fillMapOfPropertiesAAppearanceSubDict() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AAppearanceSubDict", properties);
    }

    private static void fillMapOfLinksAAppearanceSubDict() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AAppearanceSubDict", links);
    }

    private static void fillMapOfSuperNamesAAppearanceSubDictEntry() {
        mapOfSuperNames.put("AAppearanceSubDictEntry", "AObject");
    }

    private static void fillMapOfPropertiesAAppearanceSubDictEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("AAppearanceSubDictEntry", properties);
    }

    private static void fillMapOfLinksAAppearanceSubDictEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AAppearanceSubDictEntry", links);
    }

    private static void fillMapOfSuperNamesAAppearanceTrapNet() {
        mapOfSuperNames.put("AAppearanceTrapNet", "AObject");
    }

    private static void fillMapOfPropertiesAAppearanceTrapNet() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("isDIndirect");
        properties.add("DHasTypeDictionary");
        properties.add("DHasTypeStream");
        properties.add("containsN");
        properties.add("isNIndirect");
        properties.add("NHasTypeDictionary");
        properties.add("NHasTypeStream");
        properties.add("containsR");
        properties.add("isRIndirect");
        properties.add("RHasTypeDictionary");
        properties.add("RHasTypeStream");
        mapOfProperties.put("AAppearanceTrapNet", properties);
    }

    private static void fillMapOfLinksAAppearanceTrapNet() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("N");
        links.add("R");
        mapOfLinks.put("AAppearanceTrapNet", links);
    }

    private static void fillMapOfSuperNamesAAppearanceTrapNetSubDict() {
        mapOfSuperNames.put("AAppearanceTrapNetSubDict", "AObject");
    }

    private static void fillMapOfPropertiesAAppearanceTrapNetSubDict() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AAppearanceTrapNetSubDict", properties);
    }

    private static void fillMapOfLinksAAppearanceTrapNetSubDict() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AAppearanceTrapNetSubDict", links);
    }

    private static void fillMapOfSuperNamesAAppearanceTrapNetSubDictEntry() {
        mapOfSuperNames.put("AAppearanceTrapNetSubDictEntry", "AObject");
    }

    private static void fillMapOfPropertiesAAppearanceTrapNetSubDictEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("AAppearanceTrapNetSubDictEntry", properties);
    }

    private static void fillMapOfLinksAAppearanceTrapNetSubDictEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AAppearanceTrapNetSubDictEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DCrossSection() {
        mapOfSuperNames.put("AArrayOf3DCrossSection", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DCrossSection() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOf3DCrossSection", properties);
    }

    private static void fillMapOfLinksAArrayOf3DCrossSection() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOf3DCrossSection", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DCrossSectionEntry() {
        mapOfSuperNames.put("AArrayOf3DCrossSectionEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DCrossSectionEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOf3DCrossSectionEntry", properties);
    }

    private static void fillMapOfLinksAArrayOf3DCrossSectionEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOf3DCrossSectionEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DMeasure() {
        mapOfSuperNames.put("AArrayOf3DMeasure", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DMeasure() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOf3DMeasure", properties);
    }

    private static void fillMapOfLinksAArrayOf3DMeasure() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOf3DMeasure", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DMeasureEntry() {
        mapOfSuperNames.put("AArrayOf3DMeasureEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DMeasureEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOf3DMeasureEntry", properties);
    }

    private static void fillMapOfLinksAArrayOf3DMeasureEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOf3DMeasureEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DNode() {
        mapOfSuperNames.put("AArrayOf3DNode", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DNode() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOf3DNode", properties);
    }

    private static void fillMapOfLinksAArrayOf3DNode() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOf3DNode", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DNodeEntry() {
        mapOfSuperNames.put("AArrayOf3DNodeEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DNodeEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOf3DNodeEntry", properties);
    }

    private static void fillMapOfLinksAArrayOf3DNodeEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOf3DNodeEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DTransMatrix() {
        mapOfSuperNames.put("AArrayOf3DTransMatrix", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DTransMatrix() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry10HasTypeNumber");
        properties.add("entry11HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        properties.add("entry6HasTypeNumber");
        properties.add("entry7HasTypeNumber");
        properties.add("entry8HasTypeNumber");
        properties.add("entry9HasTypeNumber");
        mapOfProperties.put("AArrayOf3DTransMatrix", properties);
    }

    private static void fillMapOfLinksAArrayOf3DTransMatrix() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf3DTransMatrix", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DView() {
        mapOfSuperNames.put("AArrayOf3DView", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DView() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOf3DView", properties);
    }

    private static void fillMapOfLinksAArrayOf3DView() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOf3DView", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DViewAddEntries() {
        mapOfSuperNames.put("AArrayOf3DViewAddEntries", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DViewAddEntries() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOf3DViewAddEntries", properties);
    }

    private static void fillMapOfLinksAArrayOf3DViewAddEntries() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOf3DViewAddEntries", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DViewAddEntriesEntry() {
        mapOfSuperNames.put("AArrayOf3DViewAddEntriesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DViewAddEntriesEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOf3DViewAddEntriesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOf3DViewAddEntriesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOf3DViewAddEntriesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3DViewEntry() {
        mapOfSuperNames.put("AArrayOf3DViewEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3DViewEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOf3DViewEntry", properties);
    }

    private static void fillMapOfLinksAArrayOf3DViewEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOf3DViewEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf3PDUNames() {
        mapOfSuperNames.put("AArrayOf3PDUNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf3PDUNames() {
        properties = new ArrayList<String>();
        properties.add("contains0");
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("contains1");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("contains2");
        properties.add("entry2HasTypeName");
        properties.add("entry2NameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOf3PDUNames", properties);
    }

    private static void fillMapOfLinksAArrayOf3PDUNames() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf3PDUNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOf4Functions() {
        mapOfSuperNames.put("AArrayOf4Functions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf4Functions() {
        properties = new ArrayList<String>();
        properties.add("isentry0Indirect");
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeStream");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeDictionary");
        properties.add("entry1HasTypeStream");
        properties.add("isentry2Indirect");
        properties.add("entry2HasTypeDictionary");
        properties.add("entry2HasTypeStream");
        properties.add("isentry3Indirect");
        properties.add("entry3HasTypeDictionary");
        properties.add("entry3HasTypeStream");
        mapOfProperties.put("AArrayOf4Functions", properties);
    }

    private static void fillMapOfLinksAArrayOf4Functions() {
        links = new ArrayList<String>();
        links.add("entry0");
        links.add("entry1");
        links.add("entry2");
        links.add("entry3");
        mapOfLinks.put("AArrayOf4Functions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfActionHideAnnots() {
        mapOfSuperNames.put("AArrayOfActionHideAnnots", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfActionHideAnnots() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfActionHideAnnots", properties);
    }

    private static void fillMapOfLinksAArrayOfActionHideAnnots() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfActionHideAnnots", links);
    }

    private static void fillMapOfSuperNamesAArrayOfActionHideAnnotsEntry() {
        mapOfSuperNames.put("AArrayOfActionHideAnnotsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfActionHideAnnotsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStringText");
        properties.add("IsFieldName");
        mapOfProperties.put("AArrayOfActionHideAnnotsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfActionHideAnnotsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfActionHideAnnotsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfActions() {
        mapOfSuperNames.put("AArrayOfActions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfActions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfActions", properties);
    }

    private static void fillMapOfLinksAArrayOfActions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfActions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfActionsEntry() {
        mapOfSuperNames.put("AArrayOfActionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfActionsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfActionsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfActionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfActionsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAnnotStates() {
        mapOfSuperNames.put("AArrayOfAnnotStates", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAnnotStates() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfAnnotStates", properties);
    }

    private static void fillMapOfLinksAArrayOfAnnotStates() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfAnnotStates", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAnnotStatesEntry() {
        mapOfSuperNames.put("AArrayOfAnnotStatesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAnnotStatesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("HasTypeNull");
        mapOfProperties.put("AArrayOfAnnotStatesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfAnnotStatesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfAnnotStatesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAnnots() {
        mapOfSuperNames.put("AArrayOfAnnots", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAnnots() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfAnnots", properties);
    }

    private static void fillMapOfLinksAArrayOfAnnots() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfAnnots", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAnnotsEntry() {
        mapOfSuperNames.put("AArrayOfAnnotsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAnnotsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfAnnotsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfAnnotsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfAnnotsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysInkList() {
        mapOfSuperNames.put("AArrayOfArraysInkList", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysInkList() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfArraysInkList", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysInkList() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfArraysInkList", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysInkListEntry() {
        mapOfSuperNames.put("AArrayOfArraysInkListEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysInkListEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        mapOfProperties.put("AArrayOfArraysInkListEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysInkListEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfArraysInkListEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysPaths() {
        mapOfSuperNames.put("AArrayOfArraysPaths", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysPaths() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeArray");
        properties.add("entry0ArraySize");
        mapOfProperties.put("AArrayOfArraysPaths", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysPaths() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("entry0");
        mapOfLinks.put("AArrayOfArraysPaths", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysPathsEntry() {
        mapOfSuperNames.put("AArrayOfArraysPathsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysPathsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("ArraySize");
        mapOfProperties.put("AArrayOfArraysPathsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysPathsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfArraysPathsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysRBGroups() {
        mapOfSuperNames.put("AArrayOfArraysRBGroups", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysRBGroups() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfArraysRBGroups", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysRBGroups() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfArraysRBGroups", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysRBGroupsEntry() {
        mapOfSuperNames.put("AArrayOfArraysRBGroupsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysRBGroupsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("ArraySize");
        mapOfProperties.put("AArrayOfArraysRBGroupsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysRBGroupsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfArraysRBGroupsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysURLStrings() {
        mapOfSuperNames.put("AArrayOfArraysURLStrings", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysURLStrings() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfArraysURLStrings", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysURLStrings() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfArraysURLStrings", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysURLStringsEntry() {
        mapOfSuperNames.put("AArrayOfArraysURLStringsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysURLStringsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        mapOfProperties.put("AArrayOfArraysURLStringsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysURLStringsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfArraysURLStringsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysXPTSValues() {
        mapOfSuperNames.put("AArrayOfArraysXPTSValues", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysXPTSValues() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfArraysXPTSValues", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysXPTSValues() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfArraysXPTSValues", links);
    }

    private static void fillMapOfSuperNamesAArrayOfArraysXPTSValuesEntry() {
        mapOfSuperNames.put("AArrayOfArraysXPTSValuesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfArraysXPTSValuesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("ArraySize");
        properties.add("parentNamesArraySize");
        properties.add("parentNamesHasTypeArray");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfArraysXPTSValuesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfArraysXPTSValuesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfArraysXPTSValuesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAttributeObjects() {
        mapOfSuperNames.put("AArrayOfAttributeObjects", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAttributeObjects() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfAttributeObjects", properties);
    }

    private static void fillMapOfLinksAArrayOfAttributeObjects() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfAttributeObjects", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAttributeObjectsEntry() {
        mapOfSuperNames.put("AArrayOfAttributeObjectsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAttributeObjectsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfAttributeObjectsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfAttributeObjectsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfAttributeObjectsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAttributeRevisions() {
        mapOfSuperNames.put("AArrayOfAttributeRevisions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAttributeRevisions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfAttributeRevisions", properties);
    }

    private static void fillMapOfLinksAArrayOfAttributeRevisions() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfAttributeRevisions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfAttributeRevisionsSubArray() {
        mapOfSuperNames.put("AArrayOfAttributeRevisionsSubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfAttributeRevisionsSubArray() {
        properties = new ArrayList<String>();
        properties.add("isentry0Indirect");
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeStream");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        mapOfProperties.put("AArrayOfAttributeRevisionsSubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfAttributeRevisionsSubArray() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("AArrayOfAttributeRevisionsSubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfBeads() {
        mapOfSuperNames.put("AArrayOfBeads", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfBeads() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfBeads", properties);
    }

    private static void fillMapOfLinksAArrayOfBeads() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfBeads", links);
    }

    private static void fillMapOfSuperNamesAArrayOfBeadsEntry() {
        mapOfSuperNames.put("AArrayOfBeadsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfBeadsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfBeadsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfBeadsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfBeadsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfBlendModes() {
        mapOfSuperNames.put("AArrayOfBlendModes", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfBlendModes() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfBlendModes", properties);
    }

    private static void fillMapOfLinksAArrayOfBlendModes() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfBlendModes", links);
    }

    private static void fillMapOfSuperNamesAArrayOfBlendModesEntry() {
        mapOfSuperNames.put("AArrayOfBlendModesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfBlendModesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfBlendModesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfBlendModesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfBlendModesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfBooleansGeneral() {
        mapOfSuperNames.put("AArrayOfBooleansGeneral", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfBooleansGeneral() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfBooleansGeneral", properties);
    }

    private static void fillMapOfLinksAArrayOfBooleansGeneral() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfBooleansGeneral", links);
    }

    private static void fillMapOfSuperNamesAArrayOfBooleansGeneralEntry() {
        mapOfSuperNames.put("AArrayOfBooleansGeneralEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfBooleansGeneralEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeBoolean");
        mapOfProperties.put("AArrayOfBooleansGeneralEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfBooleansGeneralEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfBooleansGeneralEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfCIDGlyphMetricsW() {
        mapOfSuperNames.put("AArrayOfCIDGlyphMetricsW", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfCIDGlyphMetricsW() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfCIDGlyphMetricsW", properties);
    }

    private static void fillMapOfLinksAArrayOfCIDGlyphMetricsW() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfCIDGlyphMetricsW", links);
    }

    private static void fillMapOfSuperNamesAArrayOfCIDGlyphMetricsW2() {
        mapOfSuperNames.put("AArrayOfCIDGlyphMetricsW2", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfCIDGlyphMetricsW2() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfCIDGlyphMetricsW2", properties);
    }

    private static void fillMapOfLinksAArrayOfCIDGlyphMetricsW2() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfCIDGlyphMetricsW2", links);
    }

    private static void fillMapOfSuperNamesAArrayOfCIDGlyphMetricsW2Entry() {
        mapOfSuperNames.put("AArrayOfCIDGlyphMetricsW2Entry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfCIDGlyphMetricsW2Entry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeInteger");
        properties.add("HasTypeNumber");
        properties.add("ArraySize");
        mapOfProperties.put("AArrayOfCIDGlyphMetricsW2Entry", properties);
    }

    private static void fillMapOfLinksAArrayOfCIDGlyphMetricsW2Entry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfCIDGlyphMetricsW2Entry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfCIDGlyphMetricsWEntry() {
        mapOfSuperNames.put("AArrayOfCIDGlyphMetricsWEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfCIDGlyphMetricsWEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeInteger");
        properties.add("HasTypeNumber");
        mapOfProperties.put("AArrayOfCIDGlyphMetricsWEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfCIDGlyphMetricsWEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfCIDGlyphMetricsWEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfClassNamesRevisions() {
        mapOfSuperNames.put("AArrayOfClassNamesRevisions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfClassNamesRevisions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfClassNamesRevisions", properties);
    }

    private static void fillMapOfLinksAArrayOfClassNamesRevisions() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfClassNamesRevisions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfClassNamesRevisionsSubArray() {
        mapOfSuperNames.put("AArrayOfClassNamesRevisionsSubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfClassNamesRevisionsSubArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        mapOfProperties.put("AArrayOfClassNamesRevisionsSubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfClassNamesRevisionsSubArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfClassNamesRevisionsSubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfCompressionFilterNames() {
        mapOfSuperNames.put("AArrayOfCompressionFilterNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfCompressionFilterNames() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfCompressionFilterNames", properties);
    }

    private static void fillMapOfLinksAArrayOfCompressionFilterNames() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfCompressionFilterNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOfCompressionFilterNamesEntry() {
        mapOfSuperNames.put("AArrayOfCompressionFilterNamesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfCompressionFilterNamesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfCompressionFilterNamesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfCompressionFilterNamesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfCompressionFilterNamesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDPartArrays() {
        mapOfSuperNames.put("AArrayOfDPartArrays", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDPartArrays() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDPartArrays", properties);
    }

    private static void fillMapOfLinksAArrayOfDPartArrays() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDPartArrays", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDPartArraysEntry() {
        mapOfSuperNames.put("AArrayOfDPartArraysEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDPartArraysEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("AArrayOfDPartArraysEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDPartArraysEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfDPartArraysEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDParts() {
        mapOfSuperNames.put("AArrayOfDParts", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDParts() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDParts", properties);
    }

    private static void fillMapOfLinksAArrayOfDParts() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDParts", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDPartsEntry() {
        mapOfSuperNames.put("AArrayOfDPartsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDPartsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("AArrayOfDPartsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDPartsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfDPartsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDashPatterns() {
        mapOfSuperNames.put("AArrayOfDashPatterns", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDashPatterns() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDashPatterns", properties);
    }

    private static void fillMapOfLinksAArrayOfDashPatterns() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDashPatterns", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDashPatternsEntry() {
        mapOfSuperNames.put("AArrayOfDashPatternsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDashPatternsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeNumber");
        mapOfProperties.put("AArrayOfDashPatternsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDashPatternsEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfDashPatternsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDecodeParams() {
        mapOfSuperNames.put("AArrayOfDecodeParams", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDecodeParams() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDecodeParams", properties);
    }

    private static void fillMapOfLinksAArrayOfDecodeParams() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDecodeParams", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDecodeParamsEntry() {
        mapOfSuperNames.put("AArrayOfDecodeParamsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDecodeParamsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("HasTypeNull");
        mapOfProperties.put("AArrayOfDecodeParamsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDecodeParamsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfDecodeParamsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDescendantFonts() {
        mapOfSuperNames.put("AArrayOfDescendantFonts", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDescendantFonts() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        mapOfProperties.put("AArrayOfDescendantFonts", properties);
    }

    private static void fillMapOfLinksAArrayOfDescendantFonts() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("AArrayOfDescendantFonts", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDevExtensions() {
        mapOfSuperNames.put("AArrayOfDevExtensions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDevExtensions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDevExtensions", properties);
    }

    private static void fillMapOfLinksAArrayOfDevExtensions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDevExtensions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDevExtensionsEntry() {
        mapOfSuperNames.put("AArrayOfDevExtensionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDevExtensionsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfDevExtensionsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDevExtensionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfDevExtensionsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDifferences() {
        mapOfSuperNames.put("AArrayOfDifferences", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDifferences() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDifferences", properties);
    }

    private static void fillMapOfLinksAArrayOfDifferences() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDifferences", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDifferencesEntry() {
        mapOfSuperNames.put("AArrayOfDifferencesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDifferencesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeInteger");
        properties.add("HasTypeName");
        mapOfProperties.put("AArrayOfDifferencesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDifferencesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfDifferencesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDigestMethod() {
        mapOfSuperNames.put("AArrayOfDigestMethod", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDigestMethod() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfDigestMethod", properties);
    }

    private static void fillMapOfLinksAArrayOfDigestMethod() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfDigestMethod", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDigestMethodEntry() {
        mapOfSuperNames.put("AArrayOfDigestMethodEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDigestMethodEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfDigestMethodEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfDigestMethodEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfDigestMethodEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfDuration() {
        mapOfSuperNames.put("AArrayOfDuration", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfDuration() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeInteger");
        properties.add("entry0HasTypeStringByte");
        properties.add("entry0IntegerValue");
        properties.add("entry0StringSize");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        mapOfProperties.put("AArrayOfDuration", properties);
    }

    private static void fillMapOfLinksAArrayOfDuration() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfDuration", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFieldChoiceOpt() {
        mapOfSuperNames.put("AArrayOfFieldChoiceOpt", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFieldChoiceOpt() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFieldChoiceOpt", properties);
    }

    private static void fillMapOfLinksAArrayOfFieldChoiceOpt() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFieldChoiceOpt", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFieldChoiceOptEntry() {
        mapOfSuperNames.put("AArrayOfFieldChoiceOptEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFieldChoiceOptEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeStringText");
        mapOfProperties.put("AArrayOfFieldChoiceOptEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFieldChoiceOptEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfFieldChoiceOptEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFieldID() {
        mapOfSuperNames.put("AArrayOfFieldID", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFieldID() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFieldID", properties);
    }

    private static void fillMapOfLinksAArrayOfFieldID() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFieldID", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFieldIDEntry() {
        mapOfSuperNames.put("AArrayOfFieldIDEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFieldIDEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStringText");
        mapOfProperties.put("AArrayOfFieldIDEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFieldIDEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfFieldIDEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFields() {
        mapOfSuperNames.put("AArrayOfFields", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFields() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFields", properties);
    }

    private static void fillMapOfLinksAArrayOfFields() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFields", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFieldsEntry() {
        mapOfSuperNames.put("AArrayOfFieldsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFieldsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfFieldsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFieldsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfFieldsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFileSpecifications() {
        mapOfSuperNames.put("AArrayOfFileSpecifications", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFileSpecifications() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFileSpecifications", properties);
    }

    private static void fillMapOfLinksAArrayOfFileSpecifications() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFileSpecifications", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFileSpecificationsEntry() {
        mapOfSuperNames.put("AArrayOfFileSpecificationsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFileSpecificationsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfFileSpecificationsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFileSpecificationsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfFileSpecificationsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFilterNames() {
        mapOfSuperNames.put("AArrayOfFilterNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFilterNames() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFilterNames", properties);
    }

    private static void fillMapOfLinksAArrayOfFilterNames() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFilterNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFilterNamesEntry() {
        mapOfSuperNames.put("AArrayOfFilterNamesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFilterNamesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfFilterNamesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFilterNamesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfFilterNamesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFontAndSize() {
        mapOfSuperNames.put("AArrayOfFontAndSize", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFontAndSize() {
        properties = new ArrayList<String>();
        properties.add("isentry0Indirect");
        properties.add("entry0HasTypeDictionary");
        properties.add("entry1HasTypeNumber");
        mapOfProperties.put("AArrayOfFontAndSize", properties);
    }

    private static void fillMapOfLinksAArrayOfFontAndSize() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("AArrayOfFontAndSize", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFonts() {
        mapOfSuperNames.put("AArrayOfFonts", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFonts() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFonts", properties);
    }

    private static void fillMapOfLinksAArrayOfFonts() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFonts", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFontsEntry() {
        mapOfSuperNames.put("AArrayOfFontsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFontsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfFontsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFontsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfFontsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFunctions() {
        mapOfSuperNames.put("AArrayOfFunctions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFunctions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfFunctions", properties);
    }

    private static void fillMapOfLinksAArrayOfFunctions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfFunctions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfFunctionsEntry() {
        mapOfSuperNames.put("AArrayOfFunctionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfFunctionsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("AArrayOfFunctionsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfFunctionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfFunctionsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfGSPDashPatterns() {
        mapOfSuperNames.put("AArrayOfGSPDashPatterns", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfGSPDashPatterns() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeArray");
        properties.add("entry1HasTypeNumber");
        mapOfProperties.put("AArrayOfGSPDashPatterns", properties);
    }

    private static void fillMapOfLinksAArrayOfGSPDashPatterns() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("AArrayOfGSPDashPatterns", links);
    }

    private static void fillMapOfSuperNamesAArrayOfImageAlternates() {
        mapOfSuperNames.put("AArrayOfImageAlternates", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfImageAlternates() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfImageAlternates", properties);
    }

    private static void fillMapOfLinksAArrayOfImageAlternates() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfImageAlternates", links);
    }

    private static void fillMapOfSuperNamesAArrayOfImageAlternatesEntry() {
        mapOfSuperNames.put("AArrayOfImageAlternatesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfImageAlternatesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfImageAlternatesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfImageAlternatesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfImageAlternatesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfIndirectFileSpecifications() {
        mapOfSuperNames.put("AArrayOfIndirectFileSpecifications", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfIndirectFileSpecifications() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfIndirectFileSpecifications", properties);
    }

    private static void fillMapOfLinksAArrayOfIndirectFileSpecifications() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfIndirectFileSpecifications", links);
    }

    private static void fillMapOfSuperNamesAArrayOfIndirectFileSpecificationsEntry() {
        mapOfSuperNames.put("AArrayOfIndirectFileSpecificationsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfIndirectFileSpecificationsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("EntryIsIndexInNameTreeparentRichMediaContentAssets");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfIndirectFileSpecificationsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfIndirectFileSpecificationsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfIndirectFileSpecificationsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfIntegersGeneral() {
        mapOfSuperNames.put("AArrayOfIntegersGeneral", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfIntegersGeneral() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfIntegersGeneral", properties);
    }

    private static void fillMapOfLinksAArrayOfIntegersGeneral() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfIntegersGeneral", links);
    }

    private static void fillMapOfSuperNamesAArrayOfIntegersGeneralEntry() {
        mapOfSuperNames.put("AArrayOfIntegersGeneralEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfIntegersGeneralEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeInteger");
        mapOfProperties.put("AArrayOfIntegersGeneralEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfIntegersGeneralEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfIntegersGeneralEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfIntegersGreaterThanZero() {
        mapOfSuperNames.put("AArrayOfIntegersGreaterThanZero", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfIntegersGreaterThanZero() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfIntegersGreaterThanZero", properties);
    }

    private static void fillMapOfLinksAArrayOfIntegersGreaterThanZero() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfIntegersGreaterThanZero", links);
    }

    private static void fillMapOfSuperNamesAArrayOfIntegersGreaterThanZeroEntry() {
        mapOfSuperNames.put("AArrayOfIntegersGreaterThanZeroEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfIntegersGreaterThanZeroEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeInteger");
        properties.add("IntegerValue");
        mapOfProperties.put("AArrayOfIntegersGreaterThanZeroEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfIntegersGreaterThanZeroEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfIntegersGreaterThanZeroEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfMediaPlayerInfo() {
        mapOfSuperNames.put("AArrayOfMediaPlayerInfo", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfMediaPlayerInfo() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfMediaPlayerInfo", properties);
    }

    private static void fillMapOfLinksAArrayOfMediaPlayerInfo() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfMediaPlayerInfo", links);
    }

    private static void fillMapOfSuperNamesAArrayOfMediaPlayerInfoEntry() {
        mapOfSuperNames.put("AArrayOfMediaPlayerInfoEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfMediaPlayerInfoEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfMediaPlayerInfoEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfMediaPlayerInfoEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfMediaPlayerInfoEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesForEnforce() {
        mapOfSuperNames.put("AArrayOfNamesForEnforce", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesForEnforce() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNamesForEnforce", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesForEnforce() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNamesForEnforce", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesForEnforceEntry() {
        mapOfSuperNames.put("AArrayOfNamesForEnforceEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesForEnforceEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        properties.add("parentPrintScalingNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfNamesForEnforceEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesForEnforceEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNamesForEnforceEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesForPrintingOrder() {
        mapOfSuperNames.put("AArrayOfNamesForPrintingOrder", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesForPrintingOrder() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNamesForPrintingOrder", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesForPrintingOrder() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNamesForPrintingOrder", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesForPrintingOrderEntry() {
        mapOfSuperNames.put("AArrayOfNamesForPrintingOrderEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesForPrintingOrderEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        mapOfProperties.put("AArrayOfNamesForPrintingOrderEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesForPrintingOrderEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNamesForPrintingOrderEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesForProcSet() {
        mapOfSuperNames.put("AArrayOfNamesForProcSet", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesForProcSet() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNamesForProcSet", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesForProcSet() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNamesForProcSet", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesForProcSetEntry() {
        mapOfSuperNames.put("AArrayOfNamesForProcSetEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesForProcSetEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfNamesForProcSetEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesForProcSetEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNamesForProcSetEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesGeneral() {
        mapOfSuperNames.put("AArrayOfNamesGeneral", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesGeneral() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNamesGeneral", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesGeneral() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNamesGeneral", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesGeneralEntry() {
        mapOfSuperNames.put("AArrayOfNamesGeneralEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesGeneralEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        mapOfProperties.put("AArrayOfNamesGeneralEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesGeneralEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNamesGeneralEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesInPtData() {
        mapOfSuperNames.put("AArrayOfNamesInPtData", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesInPtData() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNamesInPtData", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesInPtData() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNamesInPtData", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamesInPtDataEntry() {
        mapOfSuperNames.put("AArrayOfNamesInPtDataEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamesInPtDataEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfNamesInPtDataEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNamesInPtDataEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNamesInPtDataEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamespace() {
        mapOfSuperNames.put("AArrayOfNamespace", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamespace() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNamespace", properties);
    }

    private static void fillMapOfLinksAArrayOfNamespace() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNamespace", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNamespaceEntry() {
        mapOfSuperNames.put("AArrayOfNamespaceEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNamespaceEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfNamespaceEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNamespaceEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfNamespaceEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNavigatorLayoutNames() {
        mapOfSuperNames.put("AArrayOfNavigatorLayoutNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNavigatorLayoutNames() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNavigatorLayoutNames", properties);
    }

    private static void fillMapOfLinksAArrayOfNavigatorLayoutNames() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNavigatorLayoutNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNavigatorLayoutNamesEntry() {
        mapOfSuperNames.put("AArrayOfNavigatorLayoutNamesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNavigatorLayoutNamesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfNavigatorLayoutNamesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNavigatorLayoutNamesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNavigatorLayoutNamesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNonNegativeIntegersGeneral() {
        mapOfSuperNames.put("AArrayOfNonNegativeIntegersGeneral", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNonNegativeIntegersGeneral() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNonNegativeIntegersGeneral", properties);
    }

    private static void fillMapOfLinksAArrayOfNonNegativeIntegersGeneral() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNonNegativeIntegersGeneral", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNonNegativeIntegersGeneralEntry() {
        mapOfSuperNames.put("AArrayOfNonNegativeIntegersGeneralEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNonNegativeIntegersGeneralEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeInteger");
        properties.add("IntegerValue");
        mapOfProperties.put("AArrayOfNonNegativeIntegersGeneralEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNonNegativeIntegersGeneralEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNonNegativeIntegersGeneralEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNumberFormats() {
        mapOfSuperNames.put("AArrayOfNumberFormats", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNumberFormats() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNumberFormats", properties);
    }

    private static void fillMapOfLinksAArrayOfNumberFormats() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNumberFormats", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNumberFormatsEntry() {
        mapOfSuperNames.put("AArrayOfNumberFormatsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNumberFormatsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfNumberFormatsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNumberFormatsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfNumberFormatsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNumbersGeneral() {
        mapOfSuperNames.put("AArrayOfNumbersGeneral", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNumbersGeneral() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfNumbersGeneral", properties);
    }

    private static void fillMapOfLinksAArrayOfNumbersGeneral() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfNumbersGeneral", links);
    }

    private static void fillMapOfSuperNamesAArrayOfNumbersGeneralEntry() {
        mapOfSuperNames.put("AArrayOfNumbersGeneralEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfNumbersGeneralEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeNumber");
        mapOfProperties.put("AArrayOfNumbersGeneralEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfNumbersGeneralEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfNumbersGeneralEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCConfig() {
        mapOfSuperNames.put("AArrayOfOCConfig", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCConfig() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOCConfig", properties);
    }

    private static void fillMapOfLinksAArrayOfOCConfig() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOCConfig", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCConfigEntry() {
        mapOfSuperNames.put("AArrayOfOCConfigEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCConfigEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfOCConfigEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOCConfigEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOCConfigEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCG() {
        mapOfSuperNames.put("AArrayOfOCG", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCG() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOCG", properties);
    }

    private static void fillMapOfLinksAArrayOfOCG() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOCG", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCGEntry() {
        mapOfSuperNames.put("AArrayOfOCGEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCGEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("HasTypeNull");
        mapOfProperties.put("AArrayOfOCGEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOCGEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOCGEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCGState() {
        mapOfSuperNames.put("AArrayOfOCGState", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCGState() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOCGState", properties);
    }

    private static void fillMapOfLinksAArrayOfOCGState() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOCGState", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCGStateEntry() {
        mapOfSuperNames.put("AArrayOfOCGStateEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCGStateEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfOCGStateEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOCGStateEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOCGStateEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCGindirect() {
        mapOfSuperNames.put("AArrayOfOCGindirect", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCGindirect() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOCGindirect", properties);
    }

    private static void fillMapOfLinksAArrayOfOCGindirect() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOCGindirect", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCGindirectEntry() {
        mapOfSuperNames.put("AArrayOfOCGindirectEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCGindirectEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeNull");
        mapOfProperties.put("AArrayOfOCGindirectEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOCGindirectEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOCGindirectEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCUsage() {
        mapOfSuperNames.put("AArrayOfOCUsage", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCUsage() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOCUsage", properties);
    }

    private static void fillMapOfLinksAArrayOfOCUsage() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOCUsage", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOCUsageEntry() {
        mapOfSuperNames.put("AArrayOfOCUsageEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOCUsageEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfOCUsageEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOCUsageEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOCUsageEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOPI13Color() {
        mapOfSuperNames.put("AArrayOfOPI13Color", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOPI13Color() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        properties.add("entry3HasTypeNumber");
        properties.add("entry3NumberValue");
        properties.add("entry4HasTypeStringByte");
        mapOfProperties.put("AArrayOfOPI13Color", properties);
    }

    private static void fillMapOfLinksAArrayOfOPI13Color() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfOPI13Color", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOPI2Inks() {
        mapOfSuperNames.put("AArrayOfOPI2Inks", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOPI2Inks() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        mapOfProperties.put("AArrayOfOPI2Inks", properties);
    }

    private static void fillMapOfLinksAArrayOfOPI2Inks() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfOPI2Inks", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOPI2InksSubArray() {
        mapOfSuperNames.put("AArrayOfOPI2InksSubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOPI2InksSubArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeString");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        mapOfProperties.put("AArrayOfOPI2InksSubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfOPI2InksSubArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfOPI2InksSubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfObjectStreams() {
        mapOfSuperNames.put("AArrayOfObjectStreams", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfObjectStreams() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfObjectStreams", properties);
    }

    private static void fillMapOfLinksAArrayOfObjectStreams() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfObjectStreams", links);
    }

    private static void fillMapOfSuperNamesAArrayOfObjectStreamsEntry() {
        mapOfSuperNames.put("AArrayOfObjectStreamsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfObjectStreamsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStream");
        mapOfProperties.put("AArrayOfObjectStreamsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfObjectStreamsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfObjectStreamsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOptContentGroups() {
        mapOfSuperNames.put("AArrayOfOptContentGroups", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOptContentGroups() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOptContentGroups", properties);
    }

    private static void fillMapOfLinksAArrayOfOptContentGroups() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOptContentGroups", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOptContentGroupsEntry() {
        mapOfSuperNames.put("AArrayOfOptContentGroupsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOptContentGroupsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfOptContentGroupsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOptContentGroupsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOptContentGroupsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOptContentOrderElements() {
        mapOfSuperNames.put("AArrayOfOptContentOrderElements", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOptContentOrderElements() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOptContentOrderElements", properties);
    }

    private static void fillMapOfLinksAArrayOfOptContentOrderElements() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOptContentOrderElements", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOptContentOrderElementsEntry() {
        mapOfSuperNames.put("AArrayOfOptContentOrderElementsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOptContentOrderElementsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfOptContentOrderElementsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOptContentOrderElementsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOptContentOrderElementsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOptContentOrders() {
        mapOfSuperNames.put("AArrayOfOptContentOrders", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOptContentOrders() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeStringText");
        mapOfProperties.put("AArrayOfOptContentOrders", properties);
    }

    private static void fillMapOfLinksAArrayOfOptContentOrders() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("entry0");
        mapOfLinks.put("AArrayOfOptContentOrders", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOptContentOrdersEntry() {
        mapOfSuperNames.put("AArrayOfOptContentOrdersEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOptContentOrdersEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfOptContentOrdersEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOptContentOrdersEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOptContentOrdersEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOutputIntents() {
        mapOfSuperNames.put("AArrayOfOutputIntents", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOutputIntents() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfOutputIntents", properties);
    }

    private static void fillMapOfLinksAArrayOfOutputIntents() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfOutputIntents", links);
    }

    private static void fillMapOfSuperNamesAArrayOfOutputIntentsEntry() {
        mapOfSuperNames.put("AArrayOfOutputIntentsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfOutputIntentsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfOutputIntentsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfOutputIntentsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfOutputIntentsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfPageTreeNodeKids() {
        mapOfSuperNames.put("AArrayOfPageTreeNodeKids", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfPageTreeNodeKids() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfPageTreeNodeKids", properties);
    }

    private static void fillMapOfLinksAArrayOfPageTreeNodeKids() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfPageTreeNodeKids", links);
    }

    private static void fillMapOfSuperNamesAArrayOfPageTreeNodeKidsEntry() {
        mapOfSuperNames.put("AArrayOfPageTreeNodeKidsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfPageTreeNodeKidsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfPageTreeNodeKidsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfPageTreeNodeKidsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfPageTreeNodeKidsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfPages() {
        mapOfSuperNames.put("AArrayOfPages", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfPages() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfPages", properties);
    }

    private static void fillMapOfLinksAArrayOfPages() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfPages", links);
    }

    private static void fillMapOfSuperNamesAArrayOfPagesEntry() {
        mapOfSuperNames.put("AArrayOfPagesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfPagesEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("containsAnySeparationInfo");
        mapOfProperties.put("AArrayOfPagesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfPagesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfPagesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfPaths() {
        mapOfSuperNames.put("AArrayOfPaths", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfPaths() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        mapOfProperties.put("AArrayOfPaths", properties);
    }

    private static void fillMapOfLinksAArrayOfPaths() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfPaths", links);
    }

    private static void fillMapOfSuperNamesAArrayOfQuadPoints() {
        mapOfSuperNames.put("AArrayOfQuadPoints", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfQuadPoints() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfQuadPoints", properties);
    }

    private static void fillMapOfLinksAArrayOfQuadPoints() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfQuadPoints", links);
    }

    private static void fillMapOfSuperNamesAArrayOfQuadPointsSubArray() {
        mapOfSuperNames.put("AArrayOfQuadPointsSubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfQuadPointsSubArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        properties.add("entry6HasTypeNumber");
        properties.add("entry7HasTypeNumber");
        mapOfProperties.put("AArrayOfQuadPointsSubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfQuadPointsSubArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfQuadPointsSubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRenditions() {
        mapOfSuperNames.put("AArrayOfRenditions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRenditions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfRenditions", properties);
    }

    private static void fillMapOfLinksAArrayOfRenditions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfRenditions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRenditionsEntry() {
        mapOfSuperNames.put("AArrayOfRenditionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRenditionsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfRenditionsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfRenditionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfRenditionsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRequirements() {
        mapOfSuperNames.put("AArrayOfRequirements", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRequirements() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfRequirements", properties);
    }

    private static void fillMapOfLinksAArrayOfRequirements() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfRequirements", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRequirementsEntry() {
        mapOfSuperNames.put("AArrayOfRequirementsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRequirementsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionISO_TS_24064");
        mapOfProperties.put("AArrayOfRequirementsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfRequirementsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfRequirementsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRequirementsHandlers() {
        mapOfSuperNames.put("AArrayOfRequirementsHandlers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRequirementsHandlers() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfRequirementsHandlers", properties);
    }

    private static void fillMapOfLinksAArrayOfRequirementsHandlers() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfRequirementsHandlers", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRequirementsHandlersEntry() {
        mapOfSuperNames.put("AArrayOfRequirementsHandlersEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRequirementsHandlersEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfRequirementsHandlersEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfRequirementsHandlersEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfRequirementsHandlersEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRichMediaConfiguration() {
        mapOfSuperNames.put("AArrayOfRichMediaConfiguration", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRichMediaConfiguration() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfRichMediaConfiguration", properties);
    }

    private static void fillMapOfLinksAArrayOfRichMediaConfiguration() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfRichMediaConfiguration", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRichMediaConfigurationEntry() {
        mapOfSuperNames.put("AArrayOfRichMediaConfigurationEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRichMediaConfigurationEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfRichMediaConfigurationEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfRichMediaConfigurationEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfRichMediaConfigurationEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRichMediaCuePoints() {
        mapOfSuperNames.put("AArrayOfRichMediaCuePoints", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRichMediaCuePoints() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfRichMediaCuePoints", properties);
    }

    private static void fillMapOfLinksAArrayOfRichMediaCuePoints() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfRichMediaCuePoints", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRichMediaCuePointsEntry() {
        mapOfSuperNames.put("AArrayOfRichMediaCuePointsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRichMediaCuePointsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfRichMediaCuePointsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfRichMediaCuePointsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfRichMediaCuePointsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRichMediaInstances() {
        mapOfSuperNames.put("AArrayOfRichMediaInstances", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRichMediaInstances() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfRichMediaInstances", properties);
    }

    private static void fillMapOfLinksAArrayOfRichMediaInstances() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfRichMediaInstances", links);
    }

    private static void fillMapOfSuperNamesAArrayOfRichMediaInstancesEntry() {
        mapOfSuperNames.put("AArrayOfRichMediaInstancesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfRichMediaInstancesEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfRichMediaInstancesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfRichMediaInstancesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfRichMediaInstancesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSignatureReferences() {
        mapOfSuperNames.put("AArrayOfSignatureReferences", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSignatureReferences() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfSignatureReferences", properties);
    }

    private static void fillMapOfLinksAArrayOfSignatureReferences() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfSignatureReferences", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSignatureReferencesEntry() {
        mapOfSuperNames.put("AArrayOfSignatureReferencesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSignatureReferencesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfSignatureReferencesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfSignatureReferencesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfSignatureReferencesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSignatureSubFilterNames() {
        mapOfSuperNames.put("AArrayOfSignatureSubFilterNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSignatureSubFilterNames() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfSignatureSubFilterNames", properties);
    }

    private static void fillMapOfLinksAArrayOfSignatureSubFilterNames() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfSignatureSubFilterNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSignatureSubFilterNamesEntry() {
        mapOfSuperNames.put("AArrayOfSignatureSubFilterNamesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSignatureSubFilterNamesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AArrayOfSignatureSubFilterNamesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfSignatureSubFilterNamesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfSignatureSubFilterNamesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSoftwareIdentifiers() {
        mapOfSuperNames.put("AArrayOfSoftwareIdentifiers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSoftwareIdentifiers() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfSoftwareIdentifiers", properties);
    }

    private static void fillMapOfLinksAArrayOfSoftwareIdentifiers() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfSoftwareIdentifiers", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSoftwareIdentifiersEntry() {
        mapOfSuperNames.put("AArrayOfSoftwareIdentifiersEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSoftwareIdentifiersEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfSoftwareIdentifiersEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfSoftwareIdentifiersEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfSoftwareIdentifiersEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSoftwareVersions() {
        mapOfSuperNames.put("AArrayOfSoftwareVersions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSoftwareVersions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfSoftwareVersions", properties);
    }

    private static void fillMapOfLinksAArrayOfSoftwareVersions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfSoftwareVersions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSoftwareVersionsEntry() {
        mapOfSuperNames.put("AArrayOfSoftwareVersionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSoftwareVersionsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeInteger");
        properties.add("IntegerValue");
        mapOfProperties.put("AArrayOfSoftwareVersionsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfSoftwareVersionsEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfSoftwareVersionsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSourceInformation() {
        mapOfSuperNames.put("AArrayOfSourceInformation", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSourceInformation() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfSourceInformation", properties);
    }

    private static void fillMapOfLinksAArrayOfSourceInformation() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfSourceInformation", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSourceInformationEntry() {
        mapOfSuperNames.put("AArrayOfSourceInformationEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSourceInformationEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfSourceInformationEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfSourceInformationEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfSourceInformationEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStreamsGeneral() {
        mapOfSuperNames.put("AArrayOfStreamsGeneral", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStreamsGeneral() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfStreamsGeneral", properties);
    }

    private static void fillMapOfLinksAArrayOfStreamsGeneral() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfStreamsGeneral", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStreamsGeneralEntry() {
        mapOfSuperNames.put("AArrayOfStreamsGeneralEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStreamsGeneralEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("AArrayOfStreamsGeneralEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfStreamsGeneralEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfStreamsGeneralEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStringsASCII() {
        mapOfSuperNames.put("AArrayOfStringsASCII", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStringsASCII() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfStringsASCII", properties);
    }

    private static void fillMapOfLinksAArrayOfStringsASCII() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfStringsASCII", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStringsASCIIEntry() {
        mapOfSuperNames.put("AArrayOfStringsASCIIEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStringsASCIIEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStringAscii");
        mapOfProperties.put("AArrayOfStringsASCIIEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfStringsASCIIEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfStringsASCIIEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStringsByte() {
        mapOfSuperNames.put("AArrayOfStringsByte", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStringsByte() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfStringsByte", properties);
    }

    private static void fillMapOfLinksAArrayOfStringsByte() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfStringsByte", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStringsByteEntry() {
        mapOfSuperNames.put("AArrayOfStringsByteEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStringsByteEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStringByte");
        mapOfProperties.put("AArrayOfStringsByteEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfStringsByteEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfStringsByteEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStringsText() {
        mapOfSuperNames.put("AArrayOfStringsText", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStringsText() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfStringsText", properties);
    }

    private static void fillMapOfLinksAArrayOfStringsText() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfStringsText", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStringsTextEntry() {
        mapOfSuperNames.put("AArrayOfStringsTextEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStringsTextEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStringText");
        mapOfProperties.put("AArrayOfStringsTextEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfStringsTextEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfStringsTextEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStructElem() {
        mapOfSuperNames.put("AArrayOfStructElem", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStructElem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfStructElem", properties);
    }

    private static void fillMapOfLinksAArrayOfStructElem() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfStructElem", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStructElemEntry() {
        mapOfSuperNames.put("AArrayOfStructElemEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStructElemEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfStructElemEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfStructElemEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfStructElemEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStructElemKids() {
        mapOfSuperNames.put("AArrayOfStructElemKids", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStructElemKids() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfStructElemKids", properties);
    }

    private static void fillMapOfLinksAArrayOfStructElemKids() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfStructElemKids", links);
    }

    private static void fillMapOfSuperNamesAArrayOfStructElemKidsEntry() {
        mapOfSuperNames.put("AArrayOfStructElemKidsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfStructElemKidsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("HasTypeInteger");
        mapOfProperties.put("AArrayOfStructElemKidsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfStructElemKidsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfStructElemKidsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSubjectDN() {
        mapOfSuperNames.put("AArrayOfSubjectDN", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSubjectDN() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfSubjectDN", properties);
    }

    private static void fillMapOfLinksAArrayOfSubjectDN() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfSubjectDN", links);
    }

    private static void fillMapOfSuperNamesAArrayOfSubjectDNEntry() {
        mapOfSuperNames.put("AArrayOfSubjectDNEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfSubjectDNEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfSubjectDNEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfSubjectDNEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfSubjectDNEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfTags() {
        mapOfSuperNames.put("AArrayOfTags", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfTags() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfTags", properties);
    }

    private static void fillMapOfLinksAArrayOfTags() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfTags", links);
    }

    private static void fillMapOfSuperNamesAArrayOfTagsSubArray() {
        mapOfSuperNames.put("AArrayOfTagsSubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfTagsSubArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeInteger");
        properties.add("entry1HasTypeStringAscii");
        mapOfProperties.put("AArrayOfTagsSubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfTagsSubArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfTagsSubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfThreads() {
        mapOfSuperNames.put("AArrayOfThreads", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfThreads() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfThreads", properties);
    }

    private static void fillMapOfLinksAArrayOfThreads() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfThreads", links);
    }

    private static void fillMapOfSuperNamesAArrayOfThreadsEntry() {
        mapOfSuperNames.put("AArrayOfThreadsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfThreadsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfThreadsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfThreadsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfThreadsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfTrapNetVersionObjects() {
        mapOfSuperNames.put("AArrayOfTrapNetVersionObjects", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfTrapNetVersionObjects() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfTrapNetVersionObjects", properties);
    }

    private static void fillMapOfLinksAArrayOfTrapNetVersionObjects() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfTrapNetVersionObjects", links);
    }

    private static void fillMapOfSuperNamesAArrayOfTrapNetVersionObjectsEntry() {
        mapOfSuperNames.put("AArrayOfTrapNetVersionObjectsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfTrapNetVersionObjectsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("AArrayOfTrapNetVersionObjectsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfTrapNetVersionObjectsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfTrapNetVersionObjectsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfTrapRegions() {
        mapOfSuperNames.put("AArrayOfTrapRegions", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfTrapRegions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfTrapRegions", properties);
    }

    private static void fillMapOfLinksAArrayOfTrapRegions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfTrapRegions", links);
    }

    private static void fillMapOfSuperNamesAArrayOfTrapRegionsEntry() {
        mapOfSuperNames.put("AArrayOfTrapRegionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfTrapRegionsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfTrapRegionsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfTrapRegionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfTrapRegionsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfURLStrings() {
        mapOfSuperNames.put("AArrayOfURLStrings", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfURLStrings() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfURLStrings", properties);
    }

    private static void fillMapOfLinksAArrayOfURLStrings() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfURLStrings", links);
    }

    private static void fillMapOfSuperNamesAArrayOfURLStringsEntry() {
        mapOfSuperNames.put("AArrayOfURLStringsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfURLStringsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStringText");
        mapOfProperties.put("AArrayOfURLStringsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfURLStringsEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfURLStringsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfURLs() {
        mapOfSuperNames.put("AArrayOfURLs", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfURLs() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfURLs", properties);
    }

    private static void fillMapOfLinksAArrayOfURLs() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfURLs", links);
    }

    private static void fillMapOfSuperNamesAArrayOfURLsEntry() {
        mapOfSuperNames.put("AArrayOfURLsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfURLsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("AArrayOfURLsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfURLsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfURLsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfUserProperty() {
        mapOfSuperNames.put("AArrayOfUserProperty", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfUserProperty() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfUserProperty", properties);
    }

    private static void fillMapOfLinksAArrayOfUserProperty() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfUserProperty", links);
    }

    private static void fillMapOfSuperNamesAArrayOfUserPropertyEntry() {
        mapOfSuperNames.put("AArrayOfUserPropertyEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfUserPropertyEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfUserPropertyEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfUserPropertyEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfUserPropertyEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfViewParams() {
        mapOfSuperNames.put("AArrayOfViewParams", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfViewParams() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfViewParams", properties);
    }

    private static void fillMapOfLinksAArrayOfViewParams() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfViewParams", links);
    }

    private static void fillMapOfSuperNamesAArrayOfViewParamsEntry() {
        mapOfSuperNames.put("AArrayOfViewParamsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfViewParamsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfViewParamsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfViewParamsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfViewParamsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfViewports() {
        mapOfSuperNames.put("AArrayOfViewports", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfViewports() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfViewports", properties);
    }

    private static void fillMapOfLinksAArrayOfViewports() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfViewports", links);
    }

    private static void fillMapOfSuperNamesAArrayOfViewportsEntry() {
        mapOfSuperNames.put("AArrayOfViewportsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfViewportsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfViewportsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfViewportsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfViewportsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfWebCaptureCommands() {
        mapOfSuperNames.put("AArrayOfWebCaptureCommands", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfWebCaptureCommands() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfWebCaptureCommands", properties);
    }

    private static void fillMapOfLinksAArrayOfWebCaptureCommands() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfWebCaptureCommands", links);
    }

    private static void fillMapOfSuperNamesAArrayOfWebCaptureCommandsEntry() {
        mapOfSuperNames.put("AArrayOfWebCaptureCommandsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfWebCaptureCommandsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfWebCaptureCommandsEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfWebCaptureCommandsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfWebCaptureCommandsEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfWebCaptureImages() {
        mapOfSuperNames.put("AArrayOfWebCaptureImages", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfWebCaptureImages() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfWebCaptureImages", properties);
    }

    private static void fillMapOfLinksAArrayOfWebCaptureImages() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfWebCaptureImages", links);
    }

    private static void fillMapOfSuperNamesAArrayOfWebCaptureImagesEntry() {
        mapOfSuperNames.put("AArrayOfWebCaptureImagesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfWebCaptureImagesEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("AArrayOfWebCaptureImagesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfWebCaptureImagesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfWebCaptureImagesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfWebCapturePages() {
        mapOfSuperNames.put("AArrayOfWebCapturePages", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfWebCapturePages() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfWebCapturePages", properties);
    }

    private static void fillMapOfLinksAArrayOfWebCapturePages() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfWebCapturePages", links);
    }

    private static void fillMapOfSuperNamesAArrayOfWebCapturePagesEntry() {
        mapOfSuperNames.put("AArrayOfWebCapturePagesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfWebCapturePagesEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AArrayOfWebCapturePagesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfWebCapturePagesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOfWebCapturePagesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXFA() {
        mapOfSuperNames.put("AArrayOfXFA", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXFA() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfXFA", properties);
    }

    private static void fillMapOfLinksAArrayOfXFA() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfXFA", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXFASubArray() {
        mapOfSuperNames.put("AArrayOfXFASubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXFASubArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeStringText");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeStream");
        mapOfProperties.put("AArrayOfXFASubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfXFASubArray() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("AArrayOfXFASubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXPTSValues() {
        mapOfSuperNames.put("AArrayOfXPTSValues", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXPTSValues() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfXPTSValues", properties);
    }

    private static void fillMapOfLinksAArrayOfXPTSValues() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOfXPTSValues", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXPTSValuesEntry() {
        mapOfSuperNames.put("AArrayOfXPTSValuesEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXPTSValuesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOfXPTSValuesEntry", properties);
    }

    private static void fillMapOfLinksAArrayOfXPTSValuesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfXPTSValuesEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXRefIndexIntegers() {
        mapOfSuperNames.put("AArrayOfXRefIndexIntegers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXRefIndexIntegers() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOfXRefIndexIntegers", properties);
    }

    private static void fillMapOfLinksAArrayOfXRefIndexIntegers() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("AArrayOfXRefIndexIntegers", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXRefIndexIntegersSubArray() {
        mapOfSuperNames.put("AArrayOfXRefIndexIntegersSubArray", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXRefIndexIntegersSubArray() {
        properties = new ArrayList<String>();
        properties.add("isentry0Indirect");
        properties.add("entry0HasTypeInteger");
        properties.add("entry0IntegerValue");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        mapOfProperties.put("AArrayOfXRefIndexIntegersSubArray", properties);
    }

    private static void fillMapOfLinksAArrayOfXRefIndexIntegersSubArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfXRefIndexIntegersSubArray", links);
    }

    private static void fillMapOfSuperNamesAArrayOfXRefWIntegers() {
        mapOfSuperNames.put("AArrayOfXRefWIntegers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOfXRefWIntegers() {
        properties = new ArrayList<String>();
        properties.add("isentry0Indirect");
        properties.add("entry0HasTypeInteger");
        properties.add("entry0IntegerValue");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        properties.add("isentry2Indirect");
        properties.add("entry2HasTypeInteger");
        properties.add("entry2IntegerValue");
        mapOfProperties.put("AArrayOfXRefWIntegers", properties);
    }

    private static void fillMapOfLinksAArrayOfXRefWIntegers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOfXRefWIntegers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2Booleans() {
        mapOfSuperNames.put("AArrayOf_2Booleans", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2Booleans() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeBoolean");
        properties.add("entry1HasTypeBoolean");
        mapOfProperties.put("AArrayOf_2Booleans", properties);
    }

    private static void fillMapOfLinksAArrayOf_2Booleans() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2Booleans", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2DashNumbers() {
        mapOfSuperNames.put("AArrayOf_2DashNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2DashNumbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        mapOfProperties.put("AArrayOf_2DashNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_2DashNumbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2DashNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2Integers() {
        mapOfSuperNames.put("AArrayOf_2Integers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2Integers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeInteger");
        properties.add("entry0IntegerValue");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        mapOfProperties.put("AArrayOf_2Integers", properties);
    }

    private static void fillMapOfLinksAArrayOf_2Integers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2Integers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2LineEndingsNames() {
        mapOfSuperNames.put("AArrayOf_2LineEndingsNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2LineEndingsNames() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        mapOfProperties.put("AArrayOf_2LineEndingsNames", properties);
    }

    private static void fillMapOfLinksAArrayOf_2LineEndingsNames() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2LineEndingsNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2Numbers() {
        mapOfSuperNames.put("AArrayOf_2Numbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2Numbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        mapOfProperties.put("AArrayOf_2Numbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_2Numbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2Numbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2StringsByte() {
        mapOfSuperNames.put("AArrayOf_2StringsByte", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2StringsByte() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeStringByte");
        properties.add("entry1HasTypeStringByte");
        mapOfProperties.put("AArrayOf_2StringsByte", properties);
    }

    private static void fillMapOfLinksAArrayOf_2StringsByte() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2StringsByte", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_2StringsText() {
        mapOfSuperNames.put("AArrayOf_2StringsText", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_2StringsText() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeStringText");
        properties.add("entry1HasTypeStringText");
        mapOfProperties.put("AArrayOf_2StringsText", properties);
    }

    private static void fillMapOfLinksAArrayOf_2StringsText() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_2StringsText", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_3CenterOfRotationNumbers() {
        mapOfSuperNames.put("AArrayOf_3CenterOfRotationNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_3CenterOfRotationNumbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        mapOfProperties.put("AArrayOf_3CenterOfRotationNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_3CenterOfRotationNumbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_3CenterOfRotationNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_3Integers() {
        mapOfSuperNames.put("AArrayOf_3Integers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_3Integers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeInteger");
        properties.add("entry0IntegerValue");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        properties.add("entry2HasTypeInteger");
        properties.add("entry2IntegerValue");
        mapOfProperties.put("AArrayOf_3Integers", properties);
    }

    private static void fillMapOfLinksAArrayOf_3Integers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_3Integers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_3Numbers() {
        mapOfSuperNames.put("AArrayOf_3Numbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_3Numbers() {
        properties = new ArrayList<String>();
        properties.add("contains0");
        properties.add("entry0HasTypeNumber");
        properties.add("contains1");
        properties.add("entry1HasTypeNumber");
        properties.add("contains2");
        properties.add("entry2HasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AArrayOf_3Numbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_3Numbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_3Numbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_3OrientationNumbers() {
        mapOfSuperNames.put("AArrayOf_3OrientationNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_3OrientationNumbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNull");
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNull");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        mapOfProperties.put("AArrayOf_3OrientationNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_3OrientationNumbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_3OrientationNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_3RGBNumbers() {
        mapOfSuperNames.put("AArrayOf_3RGBNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_3RGBNumbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        mapOfProperties.put("AArrayOf_3RGBNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_3RGBNumbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_3RGBNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_3or4CalloutLineNumbers() {
        mapOfSuperNames.put("AArrayOf_3or4CalloutLineNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_3or4CalloutLineNumbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        mapOfProperties.put("AArrayOf_3or4CalloutLineNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_3or4CalloutLineNumbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_3or4CalloutLineNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4AnnotBorderCharacteristics() {
        mapOfSuperNames.put("AArrayOf_4AnnotBorderCharacteristics", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4AnnotBorderCharacteristics() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        properties.add("entry3HasTypeArray");
        mapOfProperties.put("AArrayOf_4AnnotBorderCharacteristics", properties);
    }

    private static void fillMapOfLinksAArrayOf_4AnnotBorderCharacteristics() {
        links = new ArrayList<String>();
        links.add("entry3");
        mapOfLinks.put("AArrayOf_4AnnotBorderCharacteristics", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4BorderColorArrays() {
        mapOfSuperNames.put("AArrayOf_4BorderColorArrays", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4BorderColorArrays() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeArray");
        properties.add("entry0HasTypeNull");
        properties.add("entry1HasTypeArray");
        properties.add("entry1HasTypeNull");
        properties.add("entry2HasTypeArray");
        properties.add("entry2HasTypeNull");
        properties.add("entry3HasTypeArray");
        properties.add("entry3HasTypeNull");
        mapOfProperties.put("AArrayOf_4BorderColorArrays", properties);
    }

    private static void fillMapOfLinksAArrayOf_4BorderColorArrays() {
        links = new ArrayList<String>();
        links.add("entry0");
        links.add("entry1");
        links.add("entry2");
        links.add("entry3");
        mapOfLinks.put("AArrayOf_4BorderColorArrays", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4BorderStyleNames() {
        mapOfSuperNames.put("AArrayOf_4BorderStyleNames", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4BorderStyleNames() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0HasTypeNull");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeName");
        properties.add("entry1HasTypeNull");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeName");
        properties.add("entry2HasTypeNull");
        properties.add("entry2NameValue");
        properties.add("entry3HasTypeName");
        properties.add("entry3HasTypeNull");
        properties.add("entry3NameValue");
        mapOfProperties.put("AArrayOf_4BorderStyleNames", properties);
    }

    private static void fillMapOfLinksAArrayOf_4BorderStyleNames() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_4BorderStyleNames", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4BorderThicknessNumbers() {
        mapOfSuperNames.put("AArrayOf_4BorderThicknessNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4BorderThicknessNumbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNull");
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNull");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        properties.add("entry3HasTypeNull");
        properties.add("entry3HasTypeNumber");
        properties.add("entry3NumberValue");
        mapOfProperties.put("AArrayOf_4BorderThicknessNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_4BorderThicknessNumbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_4BorderThicknessNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4ColourSpaceEntries() {
        mapOfSuperNames.put("AArrayOf_4ColourSpaceEntries", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4ColourSpaceEntries() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        properties.add("entry3HasTypeNumber");
        properties.add("entry3NumberValue");
        mapOfProperties.put("AArrayOf_4ColourSpaceEntries", properties);
    }

    private static void fillMapOfLinksAArrayOf_4ColourSpaceEntries() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_4ColourSpaceEntries", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4Integers() {
        mapOfSuperNames.put("AArrayOf_4Integers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4Integers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeInteger");
        properties.add("entry0IntegerValue");
        properties.add("entry1HasTypeInteger");
        properties.add("entry1IntegerValue");
        properties.add("entry2HasTypeInteger");
        properties.add("entry2IntegerValue");
        properties.add("entry3HasTypeInteger");
        properties.add("entry3IntegerValue");
        mapOfProperties.put("AArrayOf_4Integers", properties);
    }

    private static void fillMapOfLinksAArrayOf_4Integers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_4Integers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4Numbers() {
        mapOfSuperNames.put("AArrayOf_4Numbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4Numbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        mapOfProperties.put("AArrayOf_4Numbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_4Numbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_4Numbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_4NumbersColorAnnotation() {
        mapOfSuperNames.put("AArrayOf_4NumbersColorAnnotation", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_4NumbersColorAnnotation() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("contains2");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        properties.add("entry3HasTypeNumber");
        properties.add("entry3NumberValue");
        mapOfProperties.put("AArrayOf_4NumbersColorAnnotation", properties);
    }

    private static void fillMapOfLinksAArrayOf_4NumbersColorAnnotation() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_4NumbersColorAnnotation", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_6Numbers() {
        mapOfSuperNames.put("AArrayOf_6Numbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_6Numbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        mapOfProperties.put("AArrayOf_6Numbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_6Numbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_6Numbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_8Numbers() {
        mapOfSuperNames.put("AArrayOf_8Numbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_8Numbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        properties.add("entry6HasTypeNumber");
        properties.add("entry7HasTypeNumber");
        mapOfProperties.put("AArrayOf_8Numbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_8Numbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_8Numbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_9Numbers() {
        mapOfSuperNames.put("AArrayOf_9Numbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_9Numbers() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry1HasTypeNumber");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNumber");
        properties.add("entry6HasTypeNumber");
        properties.add("entry7HasTypeNumber");
        properties.add("entry8HasTypeNumber");
        mapOfProperties.put("AArrayOf_9Numbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_9Numbers() {
        links = new ArrayList<String>();
        mapOfLinks.put("AArrayOf_9Numbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_ArrayOfNumbers() {
        mapOfSuperNames.put("AArrayOf_ArrayOfNumbers", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_ArrayOfNumbers() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AArrayOf_ArrayOfNumbers", properties);
    }

    private static void fillMapOfLinksAArrayOf_ArrayOfNumbers() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AArrayOf_ArrayOfNumbers", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_ArrayOfNumbersEntry() {
        mapOfSuperNames.put("AArrayOf_ArrayOfNumbersEntry", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_ArrayOfNumbersEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        mapOfProperties.put("AArrayOf_ArrayOfNumbersEntry", properties);
    }

    private static void fillMapOfLinksAArrayOf_ArrayOfNumbersEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AArrayOf_ArrayOfNumbersEntry", links);
    }

    private static void fillMapOfSuperNamesAArrayOf_RoleMapNS() {
        mapOfSuperNames.put("AArrayOf_RoleMapNS", "AObject");
    }

    private static void fillMapOfPropertiesAArrayOf_RoleMapNS() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeDictionary");
        mapOfProperties.put("AArrayOf_RoleMapNS", properties);
    }

    private static void fillMapOfLinksAArrayOf_RoleMapNS() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("AArrayOf_RoleMapNS", links);
    }

    private static void fillMapOfSuperNamesAAuthCode() {
        mapOfSuperNames.put("AAuthCode", "AObject");
    }

    private static void fillMapOfPropertiesAAuthCode() {
        properties = new ArrayList<String>();
        properties.add("containsByteRange");
        properties.add("isByteRangeIndirect");
        properties.add("ByteRangeHasTypeArray");
        properties.add("containsMAC");
        properties.add("isMACIndirect");
        properties.add("MACHasTypeStringByte");
        properties.add("containsMACLocation");
        properties.add("isMACLocationIndirect");
        properties.add("MACLocationHasTypeName");
        properties.add("MACLocationNameValue");
        properties.add("containsSigObjRef");
        properties.add("isSigObjRefIndirect");
        properties.add("SigObjRefHasTypeDictionary");
        properties.add("ByteRange1IntegerValue");
        properties.add("ByteRange2IntegerValue");
        properties.add("ByteRange0IntegerValue");
        properties.add("ByteRange3IntegerValue");
        properties.add("ByteRange1HasTypeInteger");
        properties.add("ByteRange2HasTypeInteger");
        properties.add("ByteRange0HasTypeInteger");
        properties.add("ByteRange3HasTypeInteger");
        properties.add("hasExtensionISO_TS_32004");
        mapOfProperties.put("AAuthCode", properties);
    }

    private static void fillMapOfLinksAAuthCode() {
        links = new ArrayList<String>();
        links.add("ByteRange");
        links.add("SigObjRef");
        mapOfLinks.put("AAuthCode", links);
    }

    private static void fillMapOfSuperNamesABead() {
        mapOfSuperNames.put("ABead", "AObject");
    }

    private static void fillMapOfPropertiesABead() {
        properties = new ArrayList<String>();
        properties.add("containsN");
        properties.add("isNIndirect");
        properties.add("NHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsR");
        properties.add("RHasTypeRectangle");
        properties.add("containsT");
        properties.add("isTIndirect");
        properties.add("THasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("isVIndirect");
        properties.add("VHasTypeDictionary");
        mapOfProperties.put("ABead", properties);
    }

    private static void fillMapOfLinksABead() {
        links = new ArrayList<String>();
        links.add("N");
        links.add("P");
        links.add("T");
        links.add("V");
        mapOfLinks.put("ABead", links);
    }

    private static void fillMapOfSuperNamesABeadFirst() {
        mapOfSuperNames.put("ABeadFirst", "AObject");
    }

    private static void fillMapOfPropertiesABeadFirst() {
        properties = new ArrayList<String>();
        properties.add("containsN");
        properties.add("isNIndirect");
        properties.add("NHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsR");
        properties.add("RHasTypeRectangle");
        properties.add("containsT");
        properties.add("isTIndirect");
        properties.add("THasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("isVIndirect");
        properties.add("VHasTypeDictionary");
        mapOfProperties.put("ABeadFirst", properties);
    }

    private static void fillMapOfLinksABeadFirst() {
        links = new ArrayList<String>();
        links.add("N");
        links.add("P");
        links.add("T");
        links.add("V");
        mapOfLinks.put("ABeadFirst", links);
    }

    private static void fillMapOfSuperNamesABlackpointArray() {
        mapOfSuperNames.put("ABlackpointArray", "AObject");
    }

    private static void fillMapOfPropertiesABlackpointArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        mapOfProperties.put("ABlackpointArray", properties);
    }

    private static void fillMapOfLinksABlackpointArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("ABlackpointArray", links);
    }

    private static void fillMapOfSuperNamesABorderEffect() {
        mapOfSuperNames.put("ABorderEffect", "AObject");
    }

    private static void fillMapOfPropertiesABorderEffect() {
        properties = new ArrayList<String>();
        properties.add("containsI");
        properties.add("IHasTypeNumber");
        properties.add("INumberValue");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        mapOfProperties.put("ABorderEffect", properties);
    }

    private static void fillMapOfLinksABorderEffect() {
        links = new ArrayList<String>();
        mapOfLinks.put("ABorderEffect", links);
    }

    private static void fillMapOfSuperNamesABorderStyle() {
        mapOfSuperNames.put("ABorderStyle", "AObject");
    }

    private static void fillMapOfPropertiesABorderStyle() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsW");
        properties.add("WHasTypeNumber");
        properties.add("WNumberValue");
        mapOfProperties.put("ABorderStyle", properties);
    }

    private static void fillMapOfLinksABorderStyle() {
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("ABorderStyle", links);
    }

    private static void fillMapOfSuperNamesABoxColorInfo() {
        mapOfSuperNames.put("ABoxColorInfo", "AObject");
    }

    private static void fillMapOfPropertiesABoxColorInfo() {
        properties = new ArrayList<String>();
        properties.add("containsArtBox");
        properties.add("ArtBoxHasTypeDictionary");
        properties.add("containsBleedBox");
        properties.add("BleedBoxHasTypeDictionary");
        properties.add("containsCropBox");
        properties.add("CropBoxHasTypeDictionary");
        properties.add("containsTrimBox");
        properties.add("TrimBoxHasTypeDictionary");
        mapOfProperties.put("ABoxColorInfo", properties);
    }

    private static void fillMapOfLinksABoxColorInfo() {
        links = new ArrayList<String>();
        links.add("ArtBox");
        links.add("BleedBox");
        links.add("CropBox");
        links.add("TrimBox");
        mapOfLinks.put("ABoxColorInfo", links);
    }

    private static void fillMapOfSuperNamesABoxStyle() {
        mapOfSuperNames.put("ABoxStyle", "AObject");
    }

    private static void fillMapOfPropertiesABoxStyle() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsW");
        properties.add("WHasTypeNumber");
        mapOfProperties.put("ABoxStyle", properties);
    }

    private static void fillMapOfLinksABoxStyle() {
        links = new ArrayList<String>();
        links.add("C");
        links.add("D");
        mapOfLinks.put("ABoxStyle", links);
    }

    private static void fillMapOfSuperNamesACIDFontDescriptorMetrics() {
        mapOfSuperNames.put("ACIDFontDescriptorMetrics", "AObject");
    }

    private static void fillMapOfPropertiesACIDFontDescriptorMetrics() {
        properties = new ArrayList<String>();
        properties.add("containsAscent");
        properties.add("AscentHasTypeNumber");
        properties.add("containsAvgWidth");
        properties.add("AvgWidthHasTypeNumber");
        properties.add("containsCapHeight");
        properties.add("CapHeightHasTypeNumber");
        properties.add("containsCharSet");
        properties.add("CharSetHasTypeString");
        properties.add("containsDescent");
        properties.add("DescentHasTypeNumber");
        properties.add("DescentNumberValue");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontName");
        properties.add("FontNameHasTypeName");
        properties.add("containsItalicAngle");
        properties.add("ItalicAngleHasTypeNumber");
        properties.add("containsLeading");
        properties.add("LeadingHasTypeNumber");
        properties.add("containsMaxWidth");
        properties.add("MaxWidthHasTypeNumber");
        properties.add("containsMissingWidth");
        properties.add("MissingWidthHasTypeNumber");
        properties.add("containsStemH");
        properties.add("StemHHasTypeNumber");
        properties.add("containsStemV");
        properties.add("StemVHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXHeight");
        properties.add("XHeightHasTypeNumber");
        mapOfProperties.put("ACIDFontDescriptorMetrics", properties);
    }

    private static void fillMapOfLinksACIDFontDescriptorMetrics() {
        links = new ArrayList<String>();
        mapOfLinks.put("ACIDFontDescriptorMetrics", links);
    }

    private static void fillMapOfSuperNamesACIDSystemInfo() {
        mapOfSuperNames.put("ACIDSystemInfo", "AObject");
    }

    private static void fillMapOfPropertiesACIDSystemInfo() {
        properties = new ArrayList<String>();
        properties.add("containsOrdering");
        properties.add("OrderingHasTypeStringAscii");
        properties.add("containsRegistry");
        properties.add("RegistryHasTypeStringAscii");
        properties.add("containsSupplement");
        properties.add("SupplementHasTypeInteger");
        mapOfProperties.put("ACIDSystemInfo", properties);
    }

    private static void fillMapOfLinksACIDSystemInfo() {
        links = new ArrayList<String>();
        mapOfLinks.put("ACIDSystemInfo", links);
    }

    private static void fillMapOfSuperNamesACMapStream() {
        mapOfSuperNames.put("ACMapStream", "AObject");
    }

    private static void fillMapOfPropertiesACMapStream() {
        properties = new ArrayList<String>();
        properties.add("containsCIDSystemInfo");
        properties.add("CIDSystemInfoHasTypeDictionary");
        properties.add("containsCMapName");
        properties.add("CMapNameHasTypeName");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUseCMap");
        properties.add("isUseCMapIndirect");
        properties.add("UseCMapHasTypeName");
        properties.add("UseCMapHasTypeStream");
        properties.add("UseCMapNameValue");
        properties.add("containsWMode");
        properties.add("WModeHasTypeInteger");
        properties.add("WModeIntegerValue");
        mapOfProperties.put("ACMapStream", properties);
    }

    private static void fillMapOfLinksACMapStream() {
        links = new ArrayList<String>();
        links.add("CIDSystemInfo");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("UseCMap");
        mapOfLinks.put("ACMapStream", links);
    }

    private static void fillMapOfSuperNamesACalGrayColorSpace() {
        mapOfSuperNames.put("ACalGrayColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesACalGrayColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeDictionary");
        mapOfProperties.put("ACalGrayColorSpace", properties);
    }

    private static void fillMapOfLinksACalGrayColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("ACalGrayColorSpace", links);
    }

    private static void fillMapOfSuperNamesACalGrayDict() {
        mapOfSuperNames.put("ACalGrayDict", "AObject");
    }

    private static void fillMapOfPropertiesACalGrayDict() {
        properties = new ArrayList<String>();
        properties.add("containsBlackPoint");
        properties.add("BlackPointHasTypeArray");
        properties.add("containsGamma");
        properties.add("GammaHasTypeNumber");
        properties.add("GammaNumberValue");
        properties.add("containsWhitePoint");
        properties.add("WhitePointHasTypeArray");
        mapOfProperties.put("ACalGrayDict", properties);
    }

    private static void fillMapOfLinksACalGrayDict() {
        links = new ArrayList<String>();
        links.add("BlackPoint");
        links.add("WhitePoint");
        mapOfLinks.put("ACalGrayDict", links);
    }

    private static void fillMapOfSuperNamesACalRGBColorSpace() {
        mapOfSuperNames.put("ACalRGBColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesACalRGBColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeDictionary");
        mapOfProperties.put("ACalRGBColorSpace", properties);
    }

    private static void fillMapOfLinksACalRGBColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("ACalRGBColorSpace", links);
    }

    private static void fillMapOfSuperNamesACalRGBDict() {
        mapOfSuperNames.put("ACalRGBDict", "AObject");
    }

    private static void fillMapOfPropertiesACalRGBDict() {
        properties = new ArrayList<String>();
        properties.add("containsBlackPoint");
        properties.add("BlackPointHasTypeArray");
        properties.add("containsGamma");
        properties.add("GammaHasTypeArray");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeArray");
        properties.add("containsWhitePoint");
        properties.add("WhitePointHasTypeArray");
        mapOfProperties.put("ACalRGBDict", properties);
    }

    private static void fillMapOfLinksACalRGBDict() {
        links = new ArrayList<String>();
        links.add("BlackPoint");
        links.add("Gamma");
        links.add("Matrix");
        links.add("WhitePoint");
        mapOfLinks.put("ACalRGBDict", links);
    }

    private static void fillMapOfSuperNamesACatalog() {
        mapOfSuperNames.put("ACatalog", "AObject");
    }

    private static void fillMapOfPropertiesACatalog() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFArraySize");
        properties.add("containsAcroForm");
        properties.add("AcroFormHasTypeDictionary");
        properties.add("containsCollection");
        properties.add("CollectionHasTypeDictionary");
        properties.add("containsDPartRoot");
        properties.add("DPartRootHasTypeDictionary");
        properties.add("containsDSS");
        properties.add("DSSHasTypeDictionary");
        properties.add("containsDests");
        properties.add("isDestsIndirect");
        properties.add("DestsHasTypeDictionary");
        properties.add("containsExtensions");
        properties.add("isExtensionsIndirect");
        properties.add("ExtensionsHasTypeDictionary");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsLegal");
        properties.add("LegalHasTypeDictionary");
        properties.add("containsMarkInfo");
        properties.add("MarkInfoHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsNames");
        properties.add("NamesHasTypeDictionary");
        properties.add("containsNeedsRendering");
        properties.add("NeedsRenderingHasTypeBoolean");
        properties.add("containsOCProperties");
        properties.add("OCPropertiesHasTypeDictionary");
        properties.add("containsOpenAction");
        properties.add("OpenActionHasTypeArray");
        properties.add("OpenActionHasTypeDictionary");
        properties.add("containsOutlines");
        properties.add("isOutlinesIndirect");
        properties.add("OutlinesHasTypeDictionary");
        properties.add("containsOutputIntents");
        properties.add("OutputIntentsHasTypeArray");
        properties.add("containsPageLabels");
        properties.add("PageLabelsHasTypeNumberTree");
        properties.add("containsPageLayout");
        properties.add("PageLayoutHasTypeName");
        properties.add("PageLayoutNameValue");
        properties.add("containsPageMode");
        properties.add("PageModeHasTypeName");
        properties.add("PageModeNameValue");
        properties.add("containsPages");
        properties.add("isPagesIndirect");
        properties.add("PagesHasTypeDictionary");
        properties.add("containsPerms");
        properties.add("PermsHasTypeDictionary");
        properties.add("containsPieceInfo");
        properties.add("PieceInfoHasTypeDictionary");
        properties.add("containsRequirements");
        properties.add("RequirementsHasTypeArray");
        properties.add("containsSpiderInfo");
        properties.add("SpiderInfoHasTypeDictionary");
        properties.add("containsStructTreeRoot");
        properties.add("isStructTreeRootIndirect");
        properties.add("StructTreeRootHasTypeDictionary");
        properties.add("containsThreads");
        properties.add("isThreadsIndirect");
        properties.add("ThreadsHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsURI");
        properties.add("URIHasTypeDictionary");
        properties.add("containsVersion");
        properties.add("VersionHasTypeName");
        properties.add("VersionNameValue");
        properties.add("containsViewerPreferences");
        properties.add("ViewerPreferencesHasTypeDictionary");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("ACatalog", properties);
    }

    private static void fillMapOfLinksACatalog() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("AF");
        links.add("AcroForm");
        links.add("Collection");
        links.add("DPartRoot");
        links.add("DSS");
        links.add("Dests");
        links.add("Extensions");
        links.add("Legal");
        links.add("MarkInfo");
        links.add("Metadata");
        links.add("Names");
        links.add("OCProperties");
        links.add("OpenAction");
        links.add("Outlines");
        links.add("OutputIntents");
        links.add("PageLabels");
        links.add("Pages");
        links.add("Perms");
        links.add("PieceInfo");
        links.add("Requirements");
        links.add("SpiderInfo");
        links.add("StructTreeRoot");
        links.add("Threads");
        links.add("URI");
        links.add("ViewerPreferences");
        mapOfLinks.put("ACatalog", links);
    }

    private static void fillMapOfSuperNamesACatalogNumberTreePageLabels() {
        mapOfSuperNames.put("ACatalogNumberTreePageLabels", "AObject");
    }

    private static void fillMapOfPropertiesACatalogNumberTreePageLabels() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ACatalogNumberTreePageLabels", properties);
    }

    private static void fillMapOfLinksACatalogNumberTreePageLabels() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ACatalogNumberTreePageLabels", links);
    }

    private static void fillMapOfSuperNamesACatalogNumberTreePageLabelsEntry() {
        mapOfSuperNames.put("ACatalogNumberTreePageLabelsEntry", "AObject");
    }

    private static void fillMapOfPropertiesACatalogNumberTreePageLabelsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ACatalogNumberTreePageLabelsEntry", properties);
    }

    private static void fillMapOfLinksACatalogNumberTreePageLabelsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACatalogNumberTreePageLabelsEntry", links);
    }

    private static void fillMapOfSuperNamesACertSeedValue() {
        mapOfSuperNames.put("ACertSeedValue", "AObject");
    }

    private static void fillMapOfPropertiesACertSeedValue() {
        properties = new ArrayList<String>();
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsIssuer");
        properties.add("IssuerHasTypeArray");
        properties.add("containsKeyUsage");
        properties.add("KeyUsageHasTypeArray");
        properties.add("containsOID");
        properties.add("OIDHasTypeArray");
        properties.add("containsSignaturePolicyCommitmentType");
        properties.add("SignaturePolicyCommitmentTypeHasTypeArray");
        properties.add("containsSignaturePolicyHashAlgorithm");
        properties.add("SignaturePolicyHashAlgorithmHasTypeName");
        properties.add("SignaturePolicyHashAlgorithmNameValue");
        properties.add("containsSignaturePolicyHashValue");
        properties.add("SignaturePolicyHashValueHasTypeString");
        properties.add("containsSignaturePolicyOID");
        properties.add("SignaturePolicyOIDHasTypeStringAscii");
        properties.add("containsSubject");
        properties.add("SubjectHasTypeArray");
        properties.add("containsSubjectDN");
        properties.add("SubjectDNHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsURL");
        properties.add("URLHasTypeStringAscii");
        properties.add("containsURLType");
        properties.add("URLTypeHasTypeName");
        properties.add("URLTypeNameValue");
        mapOfProperties.put("ACertSeedValue", properties);
    }

    private static void fillMapOfLinksACertSeedValue() {
        links = new ArrayList<String>();
        links.add("Issuer");
        links.add("KeyUsage");
        links.add("OID");
        links.add("SignaturePolicyCommitmentType");
        links.add("Subject");
        links.add("SubjectDN");
        mapOfLinks.put("ACertSeedValue", links);
    }

    private static void fillMapOfSuperNamesACharProcMap() {
        mapOfSuperNames.put("ACharProcMap", "AObject");
    }

    private static void fillMapOfPropertiesACharProcMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ACharProcMap", properties);
    }

    private static void fillMapOfLinksACharProcMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ACharProcMap", links);
    }

    private static void fillMapOfSuperNamesACharProcMapEntry() {
        mapOfSuperNames.put("ACharProcMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesACharProcMapEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("ACharProcMapEntry", properties);
    }

    private static void fillMapOfLinksACharProcMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACharProcMapEntry", links);
    }

    private static void fillMapOfSuperNamesAClassMap() {
        mapOfSuperNames.put("AClassMap", "AObject");
    }

    private static void fillMapOfPropertiesAClassMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AClassMap", properties);
    }

    private static void fillMapOfLinksAClassMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AClassMap", links);
    }

    private static void fillMapOfSuperNamesAClassMapEntry() {
        mapOfSuperNames.put("AClassMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAClassMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AClassMapEntry", properties);
    }

    private static void fillMapOfLinksAClassMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AClassMapEntry", links);
    }

    private static void fillMapOfSuperNamesACollection() {
        mapOfSuperNames.put("ACollection", "AObject");
    }

    private static void fillMapOfPropertiesACollection() {
        properties = new ArrayList<String>();
        properties.add("containsColors");
        properties.add("ColorsHasTypeDictionary");
        properties.add("containsD");
        properties.add("DHasTypeStringByte");
        properties.add("containsFolders");
        properties.add("isFoldersIndirect");
        properties.add("FoldersHasTypeDictionary");
        properties.add("containsNavigator");
        properties.add("isNavigatorIndirect");
        properties.add("NavigatorHasTypeDictionary");
        properties.add("containsResources");
        properties.add("isResourcesIndirect");
        properties.add("ResourcesHasTypeNameTree");
        properties.add("containsSchema");
        properties.add("SchemaHasTypeDictionary");
        properties.add("containsSort");
        properties.add("SortHasTypeDictionary");
        properties.add("containsSplit");
        properties.add("SplitHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsView");
        properties.add("ViewHasTypeName");
        properties.add("ViewNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ACollection", properties);
    }

    private static void fillMapOfLinksACollection() {
        links = new ArrayList<String>();
        links.add("Colors");
        links.add("Folders");
        links.add("Navigator");
        links.add("Resources");
        links.add("Schema");
        links.add("Sort");
        links.add("Split");
        mapOfLinks.put("ACollection", links);
    }

    private static void fillMapOfSuperNamesACollectionColors() {
        mapOfSuperNames.put("ACollectionColors", "AObject");
    }

    private static void fillMapOfPropertiesACollectionColors() {
        properties = new ArrayList<String>();
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsCardBackground");
        properties.add("CardBackgroundHasTypeArray");
        properties.add("containsCardBorder");
        properties.add("CardBorderHasTypeArray");
        properties.add("containsPrimaryText");
        properties.add("PrimaryTextHasTypeArray");
        properties.add("containsSecondaryText");
        properties.add("SecondaryTextHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ACollectionColors", properties);
    }

    private static void fillMapOfLinksACollectionColors() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("CardBackground");
        links.add("CardBorder");
        links.add("PrimaryText");
        links.add("SecondaryText");
        mapOfLinks.put("ACollectionColors", links);
    }

    private static void fillMapOfSuperNamesACollectionField() {
        mapOfSuperNames.put("ACollectionField", "AObject");
    }

    private static void fillMapOfPropertiesACollectionField() {
        properties = new ArrayList<String>();
        properties.add("containsE");
        properties.add("EHasTypeBoolean");
        properties.add("containsN");
        properties.add("NHasTypeStringText");
        properties.add("containsO");
        properties.add("OHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeBoolean");
        mapOfProperties.put("ACollectionField", properties);
    }

    private static void fillMapOfLinksACollectionField() {
        links = new ArrayList<String>();
        mapOfLinks.put("ACollectionField", links);
    }

    private static void fillMapOfSuperNamesACollectionFolder() {
        mapOfSuperNames.put("ACollectionFolder", "AObject");
    }

    private static void fillMapOfPropertiesACollectionFolder() {
        properties = new ArrayList<String>();
        properties.add("containsCI");
        properties.add("CIHasTypeDictionary");
        properties.add("containsChild");
        properties.add("isChildIndirect");
        properties.add("ChildHasTypeDictionary");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsDesc");
        properties.add("DescHasTypeStringText");
        properties.add("containsFree");
        properties.add("FreeHasTypeArray");
        properties.add("containsID");
        properties.add("entryIDHasTypeInteger");
        properties.add("containsModDate");
        properties.add("ModDateHasTypeDate");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsNext");
        properties.add("isNextIndirect");
        properties.add("NextHasTypeDictionary");
        properties.add("containsParent");
        properties.add("isParentIndirect");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsThumb");
        properties.add("isThumbIndirect");
        properties.add("ThumbHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ACollectionFolder", properties);
    }

    private static void fillMapOfLinksACollectionFolder() {
        links = new ArrayList<String>();
        links.add("CI");
        links.add("Child");
        links.add("Free");
        links.add("Next");
        links.add("Parent");
        links.add("Thumb");
        mapOfLinks.put("ACollectionFolder", links);
    }

    private static void fillMapOfSuperNamesACollectionItem() {
        mapOfSuperNames.put("ACollectionItem", "AObject");
    }

    private static void fillMapOfPropertiesACollectionItem() {
        properties = new ArrayList<String>();
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ACollectionItem", properties);
    }

    private static void fillMapOfLinksACollectionItem() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ACollectionItem", links);
    }

    private static void fillMapOfSuperNamesACollectionItemEntry() {
        mapOfSuperNames.put("ACollectionItemEntry", "AObject");
    }

    private static void fillMapOfPropertiesACollectionItemEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDate");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeNumber");
        properties.add("HasTypeStringText");
        mapOfProperties.put("ACollectionItemEntry", properties);
    }

    private static void fillMapOfLinksACollectionItemEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACollectionItemEntry", links);
    }

    private static void fillMapOfSuperNamesACollectionNameTreeResources() {
        mapOfSuperNames.put("ACollectionNameTreeResources", "AObject");
    }

    private static void fillMapOfPropertiesACollectionNameTreeResources() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ACollectionNameTreeResources", properties);
    }

    private static void fillMapOfLinksACollectionNameTreeResources() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ACollectionNameTreeResources", links);
    }

    private static void fillMapOfSuperNamesACollectionNameTreeResourcesEntry() {
        mapOfSuperNames.put("ACollectionNameTreeResourcesEntry", "AObject");
    }

    private static void fillMapOfPropertiesACollectionNameTreeResourcesEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("ACollectionNameTreeResourcesEntry", properties);
    }

    private static void fillMapOfLinksACollectionNameTreeResourcesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACollectionNameTreeResourcesEntry", links);
    }

    private static void fillMapOfSuperNamesACollectionSchema() {
        mapOfSuperNames.put("ACollectionSchema", "AObject");
    }

    private static void fillMapOfPropertiesACollectionSchema() {
        properties = new ArrayList<String>();
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ACollectionSchema", properties);
    }

    private static void fillMapOfLinksACollectionSchema() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ACollectionSchema", links);
    }

    private static void fillMapOfSuperNamesACollectionSchemaEntry() {
        mapOfSuperNames.put("ACollectionSchemaEntry", "AObject");
    }

    private static void fillMapOfPropertiesACollectionSchemaEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ACollectionSchemaEntry", properties);
    }

    private static void fillMapOfLinksACollectionSchemaEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACollectionSchemaEntry", links);
    }

    private static void fillMapOfSuperNamesACollectionSort() {
        mapOfSuperNames.put("ACollectionSort", "AObject");
    }

    private static void fillMapOfPropertiesACollectionSort() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeArray");
        properties.add("AHasTypeBoolean");
        properties.add("containsS");
        properties.add("SHasTypeArray");
        properties.add("SHasTypeName");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ACollectionSort", properties);
    }

    private static void fillMapOfLinksACollectionSort() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("S");
        mapOfLinks.put("ACollectionSort", links);
    }

    private static void fillMapOfSuperNamesACollectionSplit() {
        mapOfSuperNames.put("ACollectionSplit", "AObject");
    }

    private static void fillMapOfPropertiesACollectionSplit() {
        properties = new ArrayList<String>();
        properties.add("containsDirection");
        properties.add("DirectionHasTypeName");
        properties.add("DirectionNameValue");
        properties.add("containsPosition");
        properties.add("PositionHasTypeNumber");
        properties.add("PositionNumberValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ACollectionSplit", properties);
    }

    private static void fillMapOfLinksACollectionSplit() {
        links = new ArrayList<String>();
        mapOfLinks.put("ACollectionSplit", links);
    }

    private static void fillMapOfSuperNamesACollectionSubitem() {
        mapOfSuperNames.put("ACollectionSubitem", "AObject");
    }

    private static void fillMapOfPropertiesACollectionSubitem() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeDate");
        properties.add("DHasTypeNumber");
        properties.add("DHasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ACollectionSubitem", properties);
    }

    private static void fillMapOfLinksACollectionSubitem() {
        links = new ArrayList<String>();
        mapOfLinks.put("ACollectionSubitem", links);
    }

    private static void fillMapOfSuperNamesAColorSpaceMap() {
        mapOfSuperNames.put("AColorSpaceMap", "AObject");
    }

    private static void fillMapOfPropertiesAColorSpaceMap() {
        properties = new ArrayList<String>();
        properties.add("containsDefaultCMYK");
        properties.add("DefaultCMYKHasTypeArray");
        properties.add("containsDefaultGray");
        properties.add("DefaultGrayHasTypeArray");
        properties.add("containsDefaultRGB");
        properties.add("DefaultRGBHasTypeArray");
        mapOfProperties.put("AColorSpaceMap", properties);
    }

    private static void fillMapOfLinksAColorSpaceMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("DefaultCMYK");
        links.add("DefaultGray");
        links.add("DefaultRGB");
        mapOfLinks.put("AColorSpaceMap", links);
    }

    private static void fillMapOfSuperNamesAColorSpaceMapEntry() {
        mapOfSuperNames.put("AColorSpaceMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAColorSpaceMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AColorSpaceMapEntry", properties);
    }

    private static void fillMapOfLinksAColorSpaceMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AColorSpaceMapEntry", links);
    }

    private static void fillMapOfSuperNamesAColorantsDict() {
        mapOfSuperNames.put("AColorantsDict", "AObject");
    }

    private static void fillMapOfPropertiesAColorantsDict() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AColorantsDict", properties);
    }

    private static void fillMapOfLinksAColorantsDict() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AColorantsDict", links);
    }

    private static void fillMapOfSuperNamesAColorantsDictEntry() {
        mapOfSuperNames.put("AColorantsDictEntry", "AObject");
    }

    private static void fillMapOfPropertiesAColorantsDictEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        mapOfProperties.put("AColorantsDictEntry", properties);
    }

    private static void fillMapOfLinksAColorantsDictEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AColorantsDictEntry", links);
    }

    private static void fillMapOfSuperNamesACryptFilter() {
        mapOfSuperNames.put("ACryptFilter", "AObject");
    }

    private static void fillMapOfPropertiesACryptFilter() {
        properties = new ArrayList<String>();
        properties.add("containsAuthEvent");
        properties.add("AuthEventHasTypeName");
        properties.add("AuthEventNameValue");
        properties.add("containsCFM");
        properties.add("CFMHasTypeName");
        properties.add("CFMNameValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("LengthIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ACryptFilter", properties);
    }

    private static void fillMapOfLinksACryptFilter() {
        links = new ArrayList<String>();
        mapOfLinks.put("ACryptFilter", links);
    }

    private static void fillMapOfSuperNamesACryptFilterMap() {
        mapOfSuperNames.put("ACryptFilterMap", "AObject");
    }

    private static void fillMapOfPropertiesACryptFilterMap() {
        properties = new ArrayList<String>();
        properties.add("containsIdentity");
        properties.add("IdentityHasTypeDictionary");
        properties.add("containsStdCF");
        properties.add("StdCFHasTypeDictionary");
        properties.add("StdCFAuthEventNameValue");
        mapOfProperties.put("ACryptFilterMap", properties);
    }

    private static void fillMapOfLinksACryptFilterMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("Identity");
        links.add("StdCF");
        mapOfLinks.put("ACryptFilterMap", links);
    }

    private static void fillMapOfSuperNamesACryptFilterMapEntry() {
        mapOfSuperNames.put("ACryptFilterMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesACryptFilterMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ACryptFilterMapEntry", properties);
    }

    private static void fillMapOfLinksACryptFilterMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACryptFilterMapEntry", links);
    }

    private static void fillMapOfSuperNamesACryptFilterPublicKey() {
        mapOfSuperNames.put("ACryptFilterPublicKey", "AObject");
    }

    private static void fillMapOfPropertiesACryptFilterPublicKey() {
        properties = new ArrayList<String>();
        properties.add("containsAuthEvent");
        properties.add("AuthEventHasTypeName");
        properties.add("AuthEventNameValue");
        properties.add("containsCFM");
        properties.add("CFMHasTypeName");
        properties.add("CFMNameValue");
        properties.add("containsEncryptMetadata");
        properties.add("EncryptMetadataHasTypeBoolean");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("LengthIntegerValue");
        properties.add("containsRecipients");
        properties.add("RecipientsHasTypeArray");
        properties.add("RecipientsHasTypeStringByte");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ACryptFilterPublicKey", properties);
    }

    private static void fillMapOfLinksACryptFilterPublicKey() {
        links = new ArrayList<String>();
        links.add("Recipients");
        mapOfLinks.put("ACryptFilterPublicKey", links);
    }

    private static void fillMapOfSuperNamesACryptFilterPublicKeyMap() {
        mapOfSuperNames.put("ACryptFilterPublicKeyMap", "AObject");
    }

    private static void fillMapOfPropertiesACryptFilterPublicKeyMap() {
        properties = new ArrayList<String>();
        properties.add("containsDefEmbeddedFile");
        properties.add("DefEmbeddedFileHasTypeDictionary");
        properties.add("containsDefaultCryptFilter");
        properties.add("DefaultCryptFilterHasTypeDictionary");
        mapOfProperties.put("ACryptFilterPublicKeyMap", properties);
    }

    private static void fillMapOfLinksACryptFilterPublicKeyMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("DefEmbeddedFile");
        links.add("DefaultCryptFilter");
        mapOfLinks.put("ACryptFilterPublicKeyMap", links);
    }

    private static void fillMapOfSuperNamesACryptFilterPublicKeyMapEntry() {
        mapOfSuperNames.put("ACryptFilterPublicKeyMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesACryptFilterPublicKeyMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ACryptFilterPublicKeyMapEntry", properties);
    }

    private static void fillMapOfLinksACryptFilterPublicKeyMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ACryptFilterPublicKeyMapEntry", links);
    }

    private static void fillMapOfSuperNamesADPM() {
        mapOfSuperNames.put("ADPM", "AObject");
    }

    private static void fillMapOfPropertiesADPM() {
        properties = new ArrayList<String>();
        properties.add("containsGTS_Managed");
        properties.add("GTS_ManagedHasTypeDictionary");
        properties.add("containsGTS_Suspect");
        properties.add("GTS_SuspectHasTypeDictionary");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("ADPM", properties);
    }

    private static void fillMapOfLinksADPM() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("GTS_Managed");
        links.add("GTS_Suspect");
        mapOfLinks.put("ADPM", links);
    }

    private static void fillMapOfSuperNamesADPMEntry() {
        mapOfSuperNames.put("ADPMEntry", "AObject");
    }

    private static void fillMapOfPropertiesADPMEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeBoolean");
        properties.add("HasTypeDate");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeInteger");
        properties.add("HasTypeName");
        properties.add("HasTypeNumber");
        properties.add("HasTypeStringText");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("ADPMEntry", properties);
    }

    private static void fillMapOfLinksADPMEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ADPMEntry", links);
    }

    private static void fillMapOfSuperNamesADPart() {
        mapOfSuperNames.put("ADPart", "AObject");
    }

    private static void fillMapOfPropertiesADPart() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("containsDPM");
        properties.add("DPMHasTypeDictionary");
        properties.add("containsDParts");
        properties.add("DPartsHasTypeArray");
        properties.add("DPartsArraySize");
        properties.add("containsEnd");
        properties.add("isEndIndirect");
        properties.add("EndHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsParent");
        properties.add("isParentIndirect");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsStart");
        properties.add("isStartIndirect");
        properties.add("StartHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("ADPart", properties);
    }

    private static void fillMapOfLinksADPart() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("DPM");
        links.add("DParts");
        links.add("End");
        links.add("Metadata");
        links.add("Parent");
        links.add("Start");
        mapOfLinks.put("ADPart", links);
    }

    private static void fillMapOfSuperNamesADPartRoot() {
        mapOfSuperNames.put("ADPartRoot", "AObject");
    }

    private static void fillMapOfPropertiesADPartRoot() {
        properties = new ArrayList<String>();
        properties.add("containsDPartRootNode");
        properties.add("isDPartRootNodeIndirect");
        properties.add("DPartRootNodeHasTypeDictionary");
        properties.add("containsNodeNameList");
        properties.add("NodeNameListHasTypeArray");
        properties.add("containsRecordLevel");
        properties.add("RecordLevelHasTypeInteger");
        properties.add("RecordLevelIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("ADPartRoot", properties);
    }

    private static void fillMapOfLinksADPartRoot() {
        links = new ArrayList<String>();
        links.add("DPartRootNode");
        links.add("NodeNameList");
        mapOfLinks.put("ADPartRoot", links);
    }

    private static void fillMapOfSuperNamesADSS() {
        mapOfSuperNames.put("ADSS", "AObject");
    }

    private static void fillMapOfPropertiesADSS() {
        properties = new ArrayList<String>();
        properties.add("containsCRLs");
        properties.add("CRLsHasTypeArray");
        properties.add("containsCerts");
        properties.add("CertsHasTypeArray");
        properties.add("containsOCSPs");
        properties.add("OCSPsHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVRI");
        properties.add("VRIHasTypeDictionary");
        mapOfProperties.put("ADSS", properties);
    }

    private static void fillMapOfLinksADSS() {
        links = new ArrayList<String>();
        links.add("CRLs");
        links.add("Certs");
        links.add("OCSPs");
        links.add("VRI");
        mapOfLinks.put("ADSS", links);
    }

    private static void fillMapOfSuperNamesAData() {
        mapOfSuperNames.put("AData", "AObject");
    }

    private static void fillMapOfPropertiesAData() {
        properties = new ArrayList<String>();
        properties.add("containsLastModified");
        properties.add("LastModifiedHasTypeDate");
        properties.add("containsPrivate");
        properties.add("isPrivateIndirect");
        properties.add("PrivateHasTypeArray");
        properties.add("PrivateHasTypeBoolean");
        properties.add("PrivateHasTypeDictionary");
        properties.add("PrivateHasTypeInteger");
        properties.add("PrivateHasTypeName");
        properties.add("PrivateHasTypeNumber");
        properties.add("PrivateHasTypeStream");
        properties.add("PrivateHasTypeString");
        mapOfProperties.put("AData", properties);
    }

    private static void fillMapOfLinksAData() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("Private");
        mapOfLinks.put("AData", links);
    }

    private static void fillMapOfSuperNamesADataEntry() {
        mapOfSuperNames.put("ADataEntry", "AObject");
    }

    private static void fillMapOfPropertiesADataEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeArray");
        properties.add("HasTypeBoolean");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeInteger");
        properties.add("HasTypeName");
        properties.add("HasTypeNumber");
        properties.add("HasTypeStream");
        properties.add("HasTypeString");
        mapOfProperties.put("ADataEntry", properties);
    }

    private static void fillMapOfLinksADataEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ADataEntry", links);
    }

    private static void fillMapOfSuperNamesADest0Array() {
        mapOfSuperNames.put("ADest0Array", "AObject");
    }

    private static void fillMapOfPropertiesADest0Array() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        mapOfProperties.put("ADest0Array", properties);
    }

    private static void fillMapOfLinksADest0Array() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADest0Array", links);
    }

    private static void fillMapOfSuperNamesADest0StructArray() {
        mapOfSuperNames.put("ADest0StructArray", "AObject");
    }

    private static void fillMapOfPropertiesADest0StructArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeName");
        properties.add("entry0HasTypeStringByte");
        properties.add("entry0NameValue");
        properties.add("entry0EntryIsIndexInNameTreetrailerCatalogNamesDests");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("keysStringtrailerCatalogDests");
        mapOfProperties.put("ADest0StructArray", properties);
    }

    private static void fillMapOfLinksADest0StructArray() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADest0StructArray", links);
    }

    private static void fillMapOfSuperNamesADest1Array() {
        mapOfSuperNames.put("ADest1Array", "AObject");
    }

    private static void fillMapOfPropertiesADest1Array() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        mapOfProperties.put("ADest1Array", properties);
    }

    private static void fillMapOfLinksADest1Array() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADest1Array", links);
    }

    private static void fillMapOfSuperNamesADest1StructArray() {
        mapOfSuperNames.put("ADest1StructArray", "AObject");
    }

    private static void fillMapOfPropertiesADest1StructArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeName");
        properties.add("entry0HasTypeStringByte");
        properties.add("entry0NameValue");
        properties.add("entry0EntryIsIndexInNameTreetrailerCatalogNamesDests");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        properties.add("keysStringtrailerCatalogDests");
        mapOfProperties.put("ADest1StructArray", properties);
    }

    private static void fillMapOfLinksADest1StructArray() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADest1StructArray", links);
    }

    private static void fillMapOfSuperNamesADest4Array() {
        mapOfSuperNames.put("ADest4Array", "AObject");
    }

    private static void fillMapOfPropertiesADest4Array() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNull");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNull");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNull");
        properties.add("entry5HasTypeNumber");
        mapOfProperties.put("ADest4Array", properties);
    }

    private static void fillMapOfLinksADest4Array() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADest4Array", links);
    }

    private static void fillMapOfSuperNamesADest4StructArray() {
        mapOfSuperNames.put("ADest4StructArray", "AObject");
    }

    private static void fillMapOfPropertiesADest4StructArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeName");
        properties.add("entry0HasTypeStringByte");
        properties.add("entry0NameValue");
        properties.add("entry0EntryIsIndexInNameTreetrailerCatalogNamesDests");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNull");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNull");
        properties.add("entry4HasTypeNumber");
        properties.add("entry5HasTypeNull");
        properties.add("entry5HasTypeNumber");
        properties.add("keysStringtrailerCatalogDests");
        mapOfProperties.put("ADest4StructArray", properties);
    }

    private static void fillMapOfLinksADest4StructArray() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADest4StructArray", links);
    }

    private static void fillMapOfSuperNamesADestDict() {
        mapOfSuperNames.put("ADestDict", "AObject");
    }

    private static void fillMapOfPropertiesADestDict() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("containsSD");
        properties.add("SDHasTypeArray");
        mapOfProperties.put("ADestDict", properties);
    }

    private static void fillMapOfLinksADestDict() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("SD");
        mapOfLinks.put("ADestDict", links);
    }

    private static void fillMapOfSuperNamesADestOutputProfileRef() {
        mapOfSuperNames.put("ADestOutputProfileRef", "AObject");
    }

    private static void fillMapOfPropertiesADestOutputProfileRef() {
        properties = new ArrayList<String>();
        properties.add("containsCheckSum");
        properties.add("CheckSumHasTypeString");
        properties.add("containsColorantTable");
        properties.add("ColorantTableHasTypeArray");
        properties.add("containsICCVersion");
        properties.add("ICCVersionHasTypeString");
        properties.add("containsProfileCS");
        properties.add("ProfileCSHasTypeString");
        properties.add("containsProfileName");
        properties.add("ProfileNameHasTypeStringText");
        properties.add("containsURLs");
        properties.add("URLsHasTypeArray");
        properties.add("URLsArraySize");
        mapOfProperties.put("ADestOutputProfileRef", properties);
    }

    private static void fillMapOfLinksADestOutputProfileRef() {
        links = new ArrayList<String>();
        links.add("ColorantTable");
        links.add("URLs");
        mapOfLinks.put("ADestOutputProfileRef", links);
    }

    private static void fillMapOfSuperNamesADestXYZArray() {
        mapOfSuperNames.put("ADestXYZArray", "AObject");
    }

    private static void fillMapOfPropertiesADestXYZArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNull");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNull");
        properties.add("entry4HasTypeNumber");
        mapOfProperties.put("ADestXYZArray", properties);
    }

    private static void fillMapOfLinksADestXYZArray() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADestXYZArray", links);
    }

    private static void fillMapOfSuperNamesADestXYZStructArray() {
        mapOfSuperNames.put("ADestXYZStructArray", "AObject");
    }

    private static void fillMapOfPropertiesADestXYZStructArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeDictionary");
        properties.add("entry0HasTypeName");
        properties.add("entry0HasTypeStringByte");
        properties.add("entry0NameValue");
        properties.add("entry0EntryIsIndexInNameTreetrailerCatalogNamesDests");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeNull");
        properties.add("entry2HasTypeNumber");
        properties.add("entry3HasTypeNull");
        properties.add("entry3HasTypeNumber");
        properties.add("entry4HasTypeNull");
        properties.add("entry4HasTypeNumber");
        properties.add("keysStringtrailerCatalogDests");
        mapOfProperties.put("ADestXYZStructArray", properties);
    }

    private static void fillMapOfLinksADestXYZStructArray() {
        links = new ArrayList<String>();
        links.add("entry0");
        mapOfLinks.put("ADestXYZStructArray", links);
    }

    private static void fillMapOfSuperNamesADestsMap() {
        mapOfSuperNames.put("ADestsMap", "AObject");
    }

    private static void fillMapOfPropertiesADestsMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ADestsMap", properties);
    }

    private static void fillMapOfLinksADestsMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ADestsMap", links);
    }

    private static void fillMapOfSuperNamesADestsMapEntry() {
        mapOfSuperNames.put("ADestsMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesADestsMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ADestsMapEntry", properties);
    }

    private static void fillMapOfLinksADestsMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ADestsMapEntry", links);
    }

    private static void fillMapOfSuperNamesADevExtensions() {
        mapOfSuperNames.put("ADevExtensions", "AObject");
    }

    private static void fillMapOfPropertiesADevExtensions() {
        properties = new ArrayList<String>();
        properties.add("containsBaseVersion");
        properties.add("isBaseVersionIndirect");
        properties.add("BaseVersionHasTypeName");
        properties.add("BaseVersionNameValue");
        properties.add("containsExtensionLevel");
        properties.add("isExtensionLevelIndirect");
        properties.add("ExtensionLevelHasTypeInteger");
        properties.add("containsExtensionRevision");
        properties.add("isExtensionRevisionIndirect");
        properties.add("ExtensionRevisionHasTypeStringText");
        properties.add("containsType");
        properties.add("isTypeIndirect");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsURL");
        properties.add("isURLIndirect");
        properties.add("URLHasTypeString");
        mapOfProperties.put("ADevExtensions", properties);
    }

    private static void fillMapOfLinksADevExtensions() {
        links = new ArrayList<String>();
        mapOfLinks.put("ADevExtensions", links);
    }

    private static void fillMapOfSuperNamesADeviceNColorSpace() {
        mapOfSuperNames.put("ADeviceNColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesADeviceNColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeArray");
        properties.add("entry2HasTypeArray");
        properties.add("entry2HasTypeName");
        properties.add("entry2NameValue");
        properties.add("isentry3Indirect");
        properties.add("entry3HasTypeDictionary");
        properties.add("entry3HasTypeStream");
        properties.add("entry4HasTypeDictionary");
        mapOfProperties.put("ADeviceNColorSpace", properties);
    }

    private static void fillMapOfLinksADeviceNColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        links.add("entry2");
        links.add("entry3");
        links.add("entry4");
        mapOfLinks.put("ADeviceNColorSpace", links);
    }

    private static void fillMapOfSuperNamesADeviceNDict() {
        mapOfSuperNames.put("ADeviceNDict", "AObject");
    }

    private static void fillMapOfPropertiesADeviceNDict() {
        properties = new ArrayList<String>();
        properties.add("containsColorants");
        properties.add("ColorantsHasTypeDictionary");
        properties.add("containsMixingHints");
        properties.add("MixingHintsHasTypeDictionary");
        properties.add("containsProcess");
        properties.add("ProcessHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("parent1EntriesString");
        mapOfProperties.put("ADeviceNDict", properties);
    }

    private static void fillMapOfLinksADeviceNDict() {
        links = new ArrayList<String>();
        links.add("Colorants");
        links.add("MixingHints");
        links.add("Process");
        mapOfLinks.put("ADeviceNDict", links);
    }

    private static void fillMapOfSuperNamesADeviceNMixingHints() {
        mapOfSuperNames.put("ADeviceNMixingHints", "AObject");
    }

    private static void fillMapOfPropertiesADeviceNMixingHints() {
        properties = new ArrayList<String>();
        properties.add("containsDotGain");
        properties.add("DotGainHasTypeDictionary");
        properties.add("containsPrintingOrder");
        properties.add("PrintingOrderHasTypeArray");
        properties.add("containsSolidities");
        properties.add("SoliditiesHasTypeDictionary");
        mapOfProperties.put("ADeviceNMixingHints", properties);
    }

    private static void fillMapOfLinksADeviceNMixingHints() {
        links = new ArrayList<String>();
        links.add("DotGain");
        links.add("PrintingOrder");
        links.add("Solidities");
        mapOfLinks.put("ADeviceNMixingHints", links);
    }

    private static void fillMapOfSuperNamesADeviceNProcess() {
        mapOfSuperNames.put("ADeviceNProcess", "AObject");
    }

    private static void fillMapOfPropertiesADeviceNProcess() {
        properties = new ArrayList<String>();
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsComponents");
        properties.add("ComponentsHasTypeArray");
        mapOfProperties.put("ADeviceNProcess", properties);
    }

    private static void fillMapOfLinksADeviceNProcess() {
        links = new ArrayList<String>();
        links.add("ColorSpace");
        links.add("Components");
        mapOfLinks.put("ADeviceNProcess", links);
    }

    private static void fillMapOfSuperNamesADictionaryOfFunctions() {
        mapOfSuperNames.put("ADictionaryOfFunctions", "AObject");
    }

    private static void fillMapOfPropertiesADictionaryOfFunctions() {
        properties = new ArrayList<String>();
        properties.add("containsDefault");
        properties.add("isDefaultIndirect");
        properties.add("DefaultHasTypeDictionary");
        properties.add("DefaultHasTypeStream");
        mapOfProperties.put("ADictionaryOfFunctions", properties);
    }

    private static void fillMapOfLinksADictionaryOfFunctions() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("Default");
        mapOfLinks.put("ADictionaryOfFunctions", links);
    }

    private static void fillMapOfSuperNamesADictionaryOfFunctionsEntry() {
        mapOfSuperNames.put("ADictionaryOfFunctionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesADictionaryOfFunctionsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("ADictionaryOfFunctionsEntry", properties);
    }

    private static void fillMapOfLinksADictionaryOfFunctionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ADictionaryOfFunctionsEntry", links);
    }

    private static void fillMapOfSuperNamesADocInfo() {
        mapOfSuperNames.put("ADocInfo", "AObject");
    }

    private static void fillMapOfPropertiesADocInfo() {
        properties = new ArrayList<String>();
        properties.add("containsAuthor");
        properties.add("AuthorHasTypeStringText");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsCreator");
        properties.add("CreatorHasTypeStringText");
        properties.add("containsKeywords");
        properties.add("KeywordsHasTypeStringText");
        properties.add("containsModDate");
        properties.add("ModDateHasTypeDate");
        properties.add("containsProducer");
        properties.add("ProducerHasTypeStringText");
        properties.add("containsSubject");
        properties.add("SubjectHasTypeStringText");
        properties.add("containsTitle");
        properties.add("TitleHasTypeStringText");
        properties.add("containsTrapped");
        properties.add("TrappedHasTypeName");
        properties.add("TrappedNameValue");
        mapOfProperties.put("ADocInfo", properties);
    }

    private static void fillMapOfLinksADocInfo() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ADocInfo", links);
    }

    private static void fillMapOfSuperNamesADocInfoEntry() {
        mapOfSuperNames.put("ADocInfoEntry", "AObject");
    }

    private static void fillMapOfPropertiesADocInfoEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStringText");
        mapOfProperties.put("ADocInfoEntry", properties);
    }

    private static void fillMapOfLinksADocInfoEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("ADocInfoEntry", links);
    }

    private static void fillMapOfSuperNamesADocMDPTransformParameters() {
        mapOfSuperNames.put("ADocMDPTransformParameters", "AObject");
    }

    private static void fillMapOfPropertiesADocMDPTransformParameters() {
        properties = new ArrayList<String>();
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeName");
        properties.add("VNameValue");
        mapOfProperties.put("ADocMDPTransformParameters", properties);
    }

    private static void fillMapOfLinksADocMDPTransformParameters() {
        links = new ArrayList<String>();
        mapOfLinks.put("ADocMDPTransformParameters", links);
    }

    private static void fillMapOfSuperNamesADocTimeStamp() {
        mapOfSuperNames.put("ADocTimeStamp", "AObject");
    }

    private static void fillMapOfPropertiesADocTimeStamp() {
        properties = new ArrayList<String>();
        properties.add("containsADBE_Build");
        properties.add("ADBE_BuildHasTypeString");
        properties.add("containsByteRange");
        properties.add("ByteRangeHasTypeArray");
        properties.add("containsCert");
        properties.add("CertHasTypeArray");
        properties.add("CertHasTypeStringByte");
        properties.add("containsChanges");
        properties.add("ChangesHasTypeArray");
        properties.add("containsContactInfo");
        properties.add("ContactInfoHasTypeString");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringByte");
        properties.add("containsFilter");
        properties.add("FilterHasTypeName");
        properties.add("containsLocation");
        properties.add("LocationHasTypeString");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("containsName");
        properties.add("NameHasTypeString");
        properties.add("containsProp_AuthTime");
        properties.add("Prop_AuthTimeHasTypeInteger");
        properties.add("containsProp_AuthType");
        properties.add("Prop_AuthTypeHasTypeName");
        properties.add("containsProp_Build");
        properties.add("Prop_BuildHasTypeDictionary");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("containsReason");
        properties.add("ReasonHasTypeString");
        properties.add("containsReference");
        properties.add("ReferenceHasTypeArray");
        properties.add("containsSubFilter");
        properties.add("SubFilterHasTypeName");
        properties.add("SubFilterNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        mapOfProperties.put("ADocTimeStamp", properties);
    }

    private static void fillMapOfLinksADocTimeStamp() {
        links = new ArrayList<String>();
        links.add("ByteRange");
        links.add("Cert");
        links.add("Changes");
        links.add("Prop_Build");
        links.add("Reference");
        mapOfLinks.put("ADocTimeStamp", links);
    }

    private static void fillMapOfSuperNamesAEmbeddedFileParameter() {
        mapOfSuperNames.put("AEmbeddedFileParameter", "AObject");
    }

    private static void fillMapOfPropertiesAEmbeddedFileParameter() {
        properties = new ArrayList<String>();
        properties.add("containsCheckSum");
        properties.add("CheckSumHasTypeString");
        properties.add("CheckSumStringSize");
        properties.add("containsCreationDate");
        properties.add("CreationDateHasTypeDate");
        properties.add("containsMac");
        properties.add("MacHasTypeDictionary");
        properties.add("containsModDate");
        properties.add("ModDateHasTypeDate");
        properties.add("containsSize");
        properties.add("SizeHasTypeInteger");
        properties.add("SizeIntegerValue");
        mapOfProperties.put("AEmbeddedFileParameter", properties);
    }

    private static void fillMapOfLinksAEmbeddedFileParameter() {
        links = new ArrayList<String>();
        links.add("Mac");
        mapOfLinks.put("AEmbeddedFileParameter", links);
    }

    private static void fillMapOfSuperNamesAEmbeddedFileStream() {
        mapOfSuperNames.put("AEmbeddedFileStream", "AObject");
    }

    private static void fillMapOfPropertiesAEmbeddedFileStream() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsParams");
        properties.add("ParamsHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AEmbeddedFileStream", properties);
    }

    private static void fillMapOfLinksAEmbeddedFileStream() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Params");
        mapOfLinks.put("AEmbeddedFileStream", links);
    }

    private static void fillMapOfSuperNamesAEncoding() {
        mapOfSuperNames.put("AEncoding", "AObject");
    }

    private static void fillMapOfPropertiesAEncoding() {
        properties = new ArrayList<String>();
        properties.add("containsBaseEncoding");
        properties.add("BaseEncodingHasTypeName");
        properties.add("BaseEncodingNameValue");
        properties.add("containsDifferences");
        properties.add("DifferencesHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AEncoding", properties);
    }

    private static void fillMapOfLinksAEncoding() {
        links = new ArrayList<String>();
        links.add("Differences");
        mapOfLinks.put("AEncoding", links);
    }

    private static void fillMapOfSuperNamesAEncryptedPayload() {
        mapOfSuperNames.put("AEncryptedPayload", "AObject");
    }

    private static void fillMapOfPropertiesAEncryptedPayload() {
        properties = new ArrayList<String>();
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVersion");
        properties.add("VersionHasTypeName");
        mapOfProperties.put("AEncryptedPayload", properties);
    }

    private static void fillMapOfLinksAEncryptedPayload() {
        links = new ArrayList<String>();
        mapOfLinks.put("AEncryptedPayload", links);
    }

    private static void fillMapOfSuperNamesAEncryptionPublicKey() {
        mapOfSuperNames.put("AEncryptionPublicKey", "AObject");
    }

    private static void fillMapOfPropertiesAEncryptionPublicKey() {
        properties = new ArrayList<String>();
        properties.add("containsCF");
        properties.add("CFHasTypeDictionary");
        properties.add("containsEFF");
        properties.add("EFFHasTypeName");
        properties.add("EFFNameValue");
        properties.add("containsEncryptMetadata");
        properties.add("EncryptMetadataHasTypeBoolean");
        properties.add("containsFilter");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("containsKDFSalt");
        properties.add("isKDFSaltIndirect");
        properties.add("KDFSaltHasTypeStringByte");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("LengthIntegerValue");
        properties.add("containsP");
        properties.add("PHasTypeBitmask");
        properties.add("PBitmaskValue");
        properties.add("containsRecipients");
        properties.add("RecipientsHasTypeArray");
        properties.add("containsStmF");
        properties.add("StmFHasTypeName");
        properties.add("StmFNameValue");
        properties.add("containsStrF");
        properties.add("StrFHasTypeName");
        properties.add("StrFNameValue");
        properties.add("containsSubFilter");
        properties.add("SubFilterHasTypeName");
        properties.add("SubFilterNameValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        properties.add("VIntegerValue");
        properties.add("hasExtensionADBE_Extn3");
        properties.add("hasExtensionISO_TS_32004");
        mapOfProperties.put("AEncryptionPublicKey", properties);
    }

    private static void fillMapOfLinksAEncryptionPublicKey() {
        links = new ArrayList<String>();
        links.add("CF");
        links.add("Recipients");
        mapOfLinks.put("AEncryptionPublicKey", links);
    }

    private static void fillMapOfSuperNamesAEncryptionStandard() {
        mapOfSuperNames.put("AEncryptionStandard", "AObject");
    }

    private static void fillMapOfPropertiesAEncryptionStandard() {
        properties = new ArrayList<String>();
        properties.add("containsCF");
        properties.add("CFHasTypeDictionary");
        properties.add("containsEFF");
        properties.add("EFFHasTypeName");
        properties.add("containsEncryptMetadata");
        properties.add("EncryptMetadataHasTypeBoolean");
        properties.add("containsFilter");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("containsKDFSalt");
        properties.add("isKDFSaltIndirect");
        properties.add("KDFSaltHasTypeStringByte");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("LengthIntegerValue");
        properties.add("containsO");
        properties.add("OHasTypeStringByte");
        properties.add("OStringSize");
        properties.add("containsOE");
        properties.add("OEHasTypeStringByte");
        properties.add("OEStringSize");
        properties.add("containsP");
        properties.add("PHasTypeBitmask");
        properties.add("PBitmaskValue");
        properties.add("containsPerms");
        properties.add("PermsHasTypeStringByte");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("RIntegerValue");
        properties.add("containsStmF");
        properties.add("StmFHasTypeName");
        properties.add("containsStrF");
        properties.add("StrFHasTypeName");
        properties.add("containsSubFilter");
        properties.add("SubFilterHasTypeName");
        properties.add("containsU");
        properties.add("UHasTypeStringByte");
        properties.add("UStringSize");
        properties.add("containsUE");
        properties.add("UEHasTypeStringByte");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        properties.add("VIntegerValue");
        properties.add("hasExtensionADBE_Extn3");
        properties.add("hasExtensionISO_TS_32004");
        mapOfProperties.put("AEncryptionStandard", properties);
    }

    private static void fillMapOfLinksAEncryptionStandard() {
        links = new ArrayList<String>();
        links.add("CF");
        mapOfLinks.put("AEncryptionStandard", links);
    }

    private static void fillMapOfSuperNamesAExData3DMarkup() {
        mapOfSuperNames.put("AExData3DMarkup", "AObject");
    }

    private static void fillMapOfPropertiesAExData3DMarkup() {
        properties = new ArrayList<String>();
        properties.add("contains3DA");
        properties.add("entry3DAHasTypeDictionary");
        properties.add("entry3DAHasTypeStringText");
        properties.add("contains3DV");
        properties.add("entry3DVHasTypeDictionary");
        properties.add("containsMD5");
        properties.add("MD5HasTypeStringByte");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AExData3DMarkup", properties);
    }

    private static void fillMapOfLinksAExData3DMarkup() {
        links = new ArrayList<String>();
        links.add("entry3DA");
        links.add("entry3DV");
        mapOfLinks.put("AExData3DMarkup", links);
    }

    private static void fillMapOfSuperNamesAExDataMarkupGeo() {
        mapOfSuperNames.put("AExDataMarkupGeo", "AObject");
    }

    private static void fillMapOfPropertiesAExDataMarkupGeo() {
        properties = new ArrayList<String>();
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AExDataMarkupGeo", properties);
    }

    private static void fillMapOfLinksAExDataMarkupGeo() {
        links = new ArrayList<String>();
        mapOfLinks.put("AExDataMarkupGeo", links);
    }

    private static void fillMapOfSuperNamesAExDataProjection() {
        mapOfSuperNames.put("AExDataProjection", "AObject");
    }

    private static void fillMapOfPropertiesAExDataProjection() {
        properties = new ArrayList<String>();
        properties.add("containsM3DREF");
        properties.add("isM3DREFIndirect");
        properties.add("M3DREFHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AExDataProjection", properties);
    }

    private static void fillMapOfLinksAExDataProjection() {
        links = new ArrayList<String>();
        links.add("M3DREF");
        mapOfLinks.put("AExDataProjection", links);
    }

    private static void fillMapOfSuperNamesAExtensions() {
        mapOfSuperNames.put("AExtensions", "AObject");
    }

    private static void fillMapOfPropertiesAExtensions() {
        properties = new ArrayList<String>();
        properties.add("containsType");
        properties.add("isTypeIndirect");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AExtensions", properties);
    }

    private static void fillMapOfLinksAExtensions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AExtensions", links);
    }

    private static void fillMapOfSuperNamesAExtensionsEntry() {
        mapOfSuperNames.put("AExtensionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesAExtensionsEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AExtensionsEntry", properties);
    }

    private static void fillMapOfLinksAExtensionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AExtensionsEntry", links);
    }

    private static void fillMapOfSuperNamesAFDDict() {
        mapOfSuperNames.put("AFDDict", "AObject");
    }

    private static void fillMapOfPropertiesAFDDict() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AFDDict", properties);
    }

    private static void fillMapOfLinksAFDDict() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AFDDict", links);
    }

    private static void fillMapOfSuperNamesAFDDictEntry() {
        mapOfSuperNames.put("AFDDictEntry", "AObject");
    }

    private static void fillMapOfPropertiesAFDDictEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AFDDictEntry", properties);
    }

    private static void fillMapOfLinksAFDDictEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AFDDictEntry", links);
    }

    private static void fillMapOfSuperNamesAField() {
        mapOfSuperNames.put("AField", "AObject");
    }

    private static void fillMapOfPropertiesAField() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        mapOfProperties.put("AField", properties);
    }

    private static void fillMapOfLinksAField() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Kids");
        links.add("Parent");
        mapOfLinks.put("AField", links);
    }

    private static void fillMapOfSuperNamesAFieldBtnCheckbox() {
        mapOfSuperNames.put("AFieldBtnCheckbox", "AObject");
    }

    private static void fillMapOfPropertiesAFieldBtnCheckbox() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsDV");
        properties.add("DVHasTypeName");
        properties.add("containsFT");
        properties.add("FTHasTypeName");
        properties.add("FTNameValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsOpt");
        properties.add("OptHasTypeArray");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRV");
        properties.add("isRVIndirect");
        properties.add("RVHasTypeStream");
        properties.add("RVHasTypeStringText");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeName");
        mapOfProperties.put("AFieldBtnCheckbox", properties);
    }

    private static void fillMapOfLinksAFieldBtnCheckbox() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Kids");
        links.add("Opt");
        links.add("Parent");
        links.add("RV");
        mapOfLinks.put("AFieldBtnCheckbox", links);
    }

    private static void fillMapOfSuperNamesAFieldBtnPush() {
        mapOfSuperNames.put("AFieldBtnPush", "AObject");
    }

    private static void fillMapOfPropertiesAFieldBtnPush() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsDV");
        properties.add("DVHasTypeName");
        properties.add("containsFT");
        properties.add("FTHasTypeName");
        properties.add("FTNameValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRV");
        properties.add("isRVIndirect");
        properties.add("RVHasTypeStream");
        properties.add("RVHasTypeStringText");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeName");
        mapOfProperties.put("AFieldBtnPush", properties);
    }

    private static void fillMapOfLinksAFieldBtnPush() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Kids");
        links.add("Parent");
        links.add("RV");
        mapOfLinks.put("AFieldBtnPush", links);
    }

    private static void fillMapOfSuperNamesAFieldBtnRadio() {
        mapOfSuperNames.put("AFieldBtnRadio", "AObject");
    }

    private static void fillMapOfPropertiesAFieldBtnRadio() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsDV");
        properties.add("DVHasTypeName");
        properties.add("containsFT");
        properties.add("FTHasTypeName");
        properties.add("FTNameValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsOpt");
        properties.add("OptHasTypeArray");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRV");
        properties.add("isRVIndirect");
        properties.add("RVHasTypeStream");
        properties.add("RVHasTypeStringText");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeName");
        mapOfProperties.put("AFieldBtnRadio", properties);
    }

    private static void fillMapOfLinksAFieldBtnRadio() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Kids");
        links.add("Opt");
        links.add("Parent");
        links.add("RV");
        mapOfLinks.put("AFieldBtnRadio", links);
    }

    private static void fillMapOfSuperNamesAFieldChoice() {
        mapOfSuperNames.put("AFieldChoice", "AObject");
    }

    private static void fillMapOfPropertiesAFieldChoice() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsDV");
        properties.add("DVHasTypeArray");
        properties.add("DVHasTypeStringText");
        properties.add("containsFT");
        properties.add("FTHasTypeName");
        properties.add("FTNameValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsI");
        properties.add("IHasTypeArray");
        properties.add("isIArraySortAscending1");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsOpt");
        properties.add("OptHasTypeArray");
        properties.add("OptArraySize");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRV");
        properties.add("isRVIndirect");
        properties.add("RVHasTypeStream");
        properties.add("RVHasTypeStringText");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTI");
        properties.add("TIHasTypeInteger");
        properties.add("TIIntegerValue");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeArray");
        properties.add("VHasTypeStringText");
        mapOfProperties.put("AFieldChoice", properties);
    }

    private static void fillMapOfLinksAFieldChoice() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("DV");
        links.add("I");
        links.add("Kids");
        links.add("Opt");
        links.add("Parent");
        links.add("RV");
        links.add("V");
        mapOfLinks.put("AFieldChoice", links);
    }

    private static void fillMapOfSuperNamesAFieldMDPTransformParameters() {
        mapOfSuperNames.put("AFieldMDPTransformParameters", "AObject");
    }

    private static void fillMapOfPropertiesAFieldMDPTransformParameters() {
        properties = new ArrayList<String>();
        properties.add("containsAction");
        properties.add("ActionHasTypeName");
        properties.add("ActionNameValue");
        properties.add("containsFields");
        properties.add("FieldsHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeName");
        properties.add("VNameValue");
        mapOfProperties.put("AFieldMDPTransformParameters", properties);
    }

    private static void fillMapOfLinksAFieldMDPTransformParameters() {
        links = new ArrayList<String>();
        links.add("Fields");
        mapOfLinks.put("AFieldMDPTransformParameters", links);
    }

    private static void fillMapOfSuperNamesAFieldSig() {
        mapOfSuperNames.put("AFieldSig", "AObject");
    }

    private static void fillMapOfPropertiesAFieldSig() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsDV");
        properties.add("DVHasTypeDictionary");
        properties.add("containsFT");
        properties.add("FTHasTypeName");
        properties.add("FTNameValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsLock");
        properties.add("isLockIndirect");
        properties.add("LockHasTypeDictionary");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRV");
        properties.add("isRVIndirect");
        properties.add("RVHasTypeStream");
        properties.add("RVHasTypeStringText");
        properties.add("containsSV");
        properties.add("isSVIndirect");
        properties.add("SVHasTypeDictionary");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        mapOfProperties.put("AFieldSig", properties);
    }

    private static void fillMapOfLinksAFieldSig() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("DV");
        links.add("Kids");
        links.add("Lock");
        links.add("Parent");
        links.add("RV");
        links.add("SV");
        links.add("V");
        mapOfLinks.put("AFieldSig", links);
    }

    private static void fillMapOfSuperNamesAFieldTx() {
        mapOfSuperNames.put("AFieldTx", "AObject");
    }

    private static void fillMapOfPropertiesAFieldTx() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDS");
        properties.add("DSHasTypeStringText");
        properties.add("containsDV");
        properties.add("isDVIndirect");
        properties.add("DVHasTypeStream");
        properties.add("DVHasTypeStringText");
        properties.add("containsFT");
        properties.add("FTHasTypeName");
        properties.add("FTNameValue");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsMaxLen");
        properties.add("MaxLenHasTypeInteger");
        properties.add("MaxLenIntegerValue");
        properties.add("containsParent");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsRV");
        properties.add("isRVIndirect");
        properties.add("RVHasTypeStream");
        properties.add("RVHasTypeStringText");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTM");
        properties.add("TMHasTypeStringText");
        properties.add("containsTU");
        properties.add("TUHasTypeStringText");
        properties.add("containsV");
        properties.add("isVIndirect");
        properties.add("VHasTypeStream");
        properties.add("VHasTypeStringText");
        mapOfProperties.put("AFieldTx", properties);
    }

    private static void fillMapOfLinksAFieldTx() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("DV");
        links.add("Kids");
        links.add("Parent");
        links.add("RV");
        links.add("V");
        mapOfLinks.put("AFieldTx", links);
    }

    private static void fillMapOfSuperNamesAFileSpecEF() {
        mapOfSuperNames.put("AFileSpecEF", "AObject");
    }

    private static void fillMapOfPropertiesAFileSpecEF() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("isFIndirect");
        properties.add("FHasTypeStream");
        properties.add("containsUF");
        properties.add("isUFIndirect");
        properties.add("UFHasTypeStream");
        mapOfProperties.put("AFileSpecEF", properties);
    }

    private static void fillMapOfLinksAFileSpecEF() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("UF");
        mapOfLinks.put("AFileSpecEF", links);
    }

    private static void fillMapOfSuperNamesAFileSpecRF() {
        mapOfSuperNames.put("AFileSpecRF", "AObject");
    }

    private static void fillMapOfPropertiesAFileSpecRF() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("isFIndirect");
        properties.add("FHasTypeArray");
        properties.add("FArraySize");
        properties.add("containsUF");
        properties.add("isUFIndirect");
        properties.add("UFHasTypeArray");
        properties.add("UFArraySize");
        mapOfProperties.put("AFileSpecRF", properties);
    }

    private static void fillMapOfLinksAFileSpecRF() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("UF");
        mapOfLinks.put("AFileSpecRF", links);
    }

    private static void fillMapOfSuperNamesAFileSpecification() {
        mapOfSuperNames.put("AFileSpecification", "AObject");
    }

    private static void fillMapOfPropertiesAFileSpecification() {
        properties = new ArrayList<String>();
        properties.add("containsAFRelationship");
        properties.add("AFRelationshipHasTypeName");
        properties.add("AFRelationshipNameValue");
        properties.add("containsCI");
        properties.add("CIHasTypeDictionary");
        properties.add("containsDOS");
        properties.add("DOSHasTypeStringByte");
        properties.add("containsDesc");
        properties.add("DescHasTypeString");
        properties.add("containsEF");
        properties.add("EFHasTypeDictionary");
        properties.add("containsEP");
        properties.add("EPHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeString");
        properties.add("containsFS");
        properties.add("FSHasTypeName");
        properties.add("FSNameValue");
        properties.add("containsID");
        properties.add("entryIDHasTypeArray");
        properties.add("containsMac");
        properties.add("MacHasTypeStringByte");
        properties.add("containsRF");
        properties.add("RFHasTypeDictionary");
        properties.add("containsThumb");
        properties.add("isThumbIndirect");
        properties.add("ThumbHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUF");
        properties.add("UFHasTypeStringText");
        properties.add("containsUnix");
        properties.add("UnixHasTypeStringByte");
        properties.add("containsV");
        properties.add("VHasTypeBoolean");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AFileSpecification", properties);
    }

    private static void fillMapOfLinksAFileSpecification() {
        links = new ArrayList<String>();
        links.add("CI");
        links.add("EF");
        links.add("EP");
        links.add("entryID");
        links.add("RF");
        links.add("Thumb");
        mapOfLinks.put("AFileSpecification", links);
    }

    private static void fillMapOfSuperNamesAFileTrailer() {
        mapOfSuperNames.put("AFileTrailer", "AObject");
    }

    private static void fillMapOfPropertiesAFileTrailer() {
        properties = new ArrayList<String>();
        properties.add("containsAuthCode");
        properties.add("isAuthCodeIndirect");
        properties.add("AuthCodeHasTypeDictionary");
        properties.add("containsEncrypt");
        properties.add("EncryptHasTypeDictionary");
        properties.add("containsID");
        properties.add("isentryIDIndirect");
        properties.add("entryIDHasTypeArray");
        properties.add("containsInfo");
        properties.add("isInfoIndirect");
        properties.add("InfoHasTypeDictionary");
        properties.add("containsPrev");
        properties.add("isPrevIndirect");
        properties.add("PrevHasTypeInteger");
        properties.add("PrevIntegerValue");
        properties.add("containsRoot");
        properties.add("isRootIndirect");
        properties.add("RootHasTypeDictionary");
        properties.add("containsSize");
        properties.add("isSizeIndirect");
        properties.add("SizeHasTypeInteger");
        properties.add("SizeIntegerValue");
        properties.add("containsXRefStm");
        properties.add("XRefStmHasTypeInteger");
        properties.add("XRefStmIntegerValue");
        properties.add("containsXRefStream");
        properties.add("XRefStreamHasTypeStream");
        properties.add("EncryptVIntegerValue");
        properties.add("EncryptVHasTypeInteger");
        properties.add("containstrailerInfoModDate");
        properties.add("containstrailerCatalogPieceInfo");
        properties.add("hasExtensionISO_TS_32004");
        mapOfProperties.put("AFileTrailer", properties);
    }

    private static void fillMapOfLinksAFileTrailer() {
        links = new ArrayList<String>();
        links.add("AuthCode");
        links.add("Encrypt");
        links.add("entryID");
        links.add("Info");
        links.add("LinearizationParameterDict");
        links.add("ObjectStreams");
        links.add("Root");
        links.add("XRefStream");
        mapOfLinks.put("AFileTrailer", links);
    }

    private static void fillMapOfSuperNamesAFilterCCITTFaxDecode() {
        mapOfSuperNames.put("AFilterCCITTFaxDecode", "AObject");
    }

    private static void fillMapOfPropertiesAFilterCCITTFaxDecode() {
        properties = new ArrayList<String>();
        properties.add("containsBlackIs1");
        properties.add("BlackIs1HasTypeBoolean");
        properties.add("containsBlackls1");
        properties.add("Blackls1HasTypeBoolean");
        properties.add("containsColumns");
        properties.add("ColumnsHasTypeInteger");
        properties.add("ColumnsIntegerValue");
        properties.add("containsDamagedRowsBeforeError");
        properties.add("DamagedRowsBeforeErrorHasTypeInteger");
        properties.add("DamagedRowsBeforeErrorIntegerValue");
        properties.add("containsEncodedByteAlign");
        properties.add("EncodedByteAlignHasTypeBoolean");
        properties.add("containsEndOfBlock");
        properties.add("EndOfBlockHasTypeBoolean");
        properties.add("containsEndOfLine");
        properties.add("EndOfLineHasTypeBoolean");
        properties.add("EndOfLineBooleanValue");
        properties.add("containsK");
        properties.add("KHasTypeInteger");
        properties.add("KIntegerValue");
        properties.add("containsRows");
        properties.add("RowsHasTypeInteger");
        properties.add("RowsIntegerValue");
        properties.add("hasExtensionMalforms");
        mapOfProperties.put("AFilterCCITTFaxDecode", properties);
    }

    private static void fillMapOfLinksAFilterCCITTFaxDecode() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFilterCCITTFaxDecode", links);
    }

    private static void fillMapOfSuperNamesAFilterCrypt() {
        mapOfSuperNames.put("AFilterCrypt", "AObject");
    }

    private static void fillMapOfPropertiesAFilterCrypt() {
        properties = new ArrayList<String>();
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("NameNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("keysStringtrailerEncryptCF");
        mapOfProperties.put("AFilterCrypt", properties);
    }

    private static void fillMapOfLinksAFilterCrypt() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFilterCrypt", links);
    }

    private static void fillMapOfSuperNamesAFilterDCTDecode() {
        mapOfSuperNames.put("AFilterDCTDecode", "AObject");
    }

    private static void fillMapOfPropertiesAFilterDCTDecode() {
        properties = new ArrayList<String>();
        properties.add("containsColorTransform");
        properties.add("ColorTransformHasTypeInteger");
        properties.add("ColorTransformIntegerValue");
        mapOfProperties.put("AFilterDCTDecode", properties);
    }

    private static void fillMapOfLinksAFilterDCTDecode() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFilterDCTDecode", links);
    }

    private static void fillMapOfSuperNamesAFilterFlateDecode() {
        mapOfSuperNames.put("AFilterFlateDecode", "AObject");
    }

    private static void fillMapOfPropertiesAFilterFlateDecode() {
        properties = new ArrayList<String>();
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsColors");
        properties.add("ColorsHasTypeInteger");
        properties.add("ColorsIntegerValue");
        properties.add("containsColumns");
        properties.add("ColumnsHasTypeInteger");
        properties.add("containsPredictor");
        properties.add("PredictorHasTypeInteger");
        properties.add("PredictorIntegerValue");
        mapOfProperties.put("AFilterFlateDecode", properties);
    }

    private static void fillMapOfLinksAFilterFlateDecode() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFilterFlateDecode", links);
    }

    private static void fillMapOfSuperNamesAFilterJBIG2Decode() {
        mapOfSuperNames.put("AFilterJBIG2Decode", "AObject");
    }

    private static void fillMapOfPropertiesAFilterJBIG2Decode() {
        properties = new ArrayList<String>();
        properties.add("containsJBIG2Globals");
        properties.add("isJBIG2GlobalsIndirect");
        properties.add("JBIG2GlobalsHasTypeStream");
        mapOfProperties.put("AFilterJBIG2Decode", properties);
    }

    private static void fillMapOfLinksAFilterJBIG2Decode() {
        links = new ArrayList<String>();
        links.add("JBIG2Globals");
        mapOfLinks.put("AFilterJBIG2Decode", links);
    }

    private static void fillMapOfSuperNamesAFilterLZWDecode() {
        mapOfSuperNames.put("AFilterLZWDecode", "AObject");
    }

    private static void fillMapOfPropertiesAFilterLZWDecode() {
        properties = new ArrayList<String>();
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsColors");
        properties.add("ColorsHasTypeInteger");
        properties.add("ColorsIntegerValue");
        properties.add("containsColumns");
        properties.add("ColumnsHasTypeInteger");
        properties.add("containsEarlyChange");
        properties.add("EarlyChangeHasTypeInteger");
        properties.add("EarlyChangeIntegerValue");
        properties.add("containsPredictor");
        properties.add("PredictorHasTypeInteger");
        properties.add("PredictorIntegerValue");
        mapOfProperties.put("AFilterLZWDecode", properties);
    }

    private static void fillMapOfLinksAFilterLZWDecode() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFilterLZWDecode", links);
    }

    private static void fillMapOfSuperNamesAFixedPrint() {
        mapOfSuperNames.put("AFixedPrint", "AObject");
    }

    private static void fillMapOfPropertiesAFixedPrint() {
        properties = new ArrayList<String>();
        properties.add("containsH");
        properties.add("HHasTypeNumber");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        mapOfProperties.put("AFixedPrint", properties);
    }

    private static void fillMapOfLinksAFixedPrint() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFixedPrint", links);
    }

    private static void fillMapOfSuperNamesAFloatingWindowParameters() {
        mapOfSuperNames.put("AFloatingWindowParameters", "AObject");
    }

    private static void fillMapOfPropertiesAFloatingWindowParameters() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("containsO");
        properties.add("OHasTypeInteger");
        properties.add("OIntegerValue");
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("RIntegerValue");
        properties.add("containsRT");
        properties.add("RTHasTypeInteger");
        properties.add("RTIntegerValue");
        properties.add("containsT");
        properties.add("THasTypeBoolean");
        properties.add("TBooleanValue");
        properties.add("containsTT");
        properties.add("TTHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUC");
        properties.add("UCHasTypeBoolean");
        properties.add("D1IntegerValue");
        properties.add("D0IntegerValue");
        properties.add("D1HasTypeInteger");
        properties.add("D0HasTypeInteger");
        mapOfProperties.put("AFloatingWindowParameters", properties);
    }

    private static void fillMapOfLinksAFloatingWindowParameters() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("TT");
        mapOfLinks.put("AFloatingWindowParameters", links);
    }

    private static void fillMapOfSuperNamesAFontCIDType0() {
        mapOfSuperNames.put("AFontCIDType0", "AObject");
    }

    private static void fillMapOfPropertiesAFontCIDType0() {
        properties = new ArrayList<String>();
        properties.add("containsBaseFont");
        properties.add("BaseFontHasTypeName");
        properties.add("BaseFontNameValue");
        properties.add("containsCIDSystemInfo");
        properties.add("CIDSystemInfoHasTypeDictionary");
        properties.add("containsCIDToGIDMap");
        properties.add("isCIDToGIDMapIndirect");
        properties.add("CIDToGIDMapHasTypeName");
        properties.add("CIDToGIDMapHasTypeStream");
        properties.add("CIDToGIDMapNameValue");
        properties.add("containsDW");
        properties.add("DWHasTypeNumber");
        properties.add("containsDW2");
        properties.add("DW2HasTypeArray");
        properties.add("containsFontDescriptor");
        properties.add("isFontDescriptorIndirect");
        properties.add("FontDescriptorHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsW");
        properties.add("WHasTypeArray");
        properties.add("containsW2");
        properties.add("W2HasTypeArray");
        mapOfProperties.put("AFontCIDType0", properties);
    }

    private static void fillMapOfLinksAFontCIDType0() {
        links = new ArrayList<String>();
        links.add("CIDSystemInfo");
        links.add("CIDToGIDMap");
        links.add("DW2");
        links.add("FontDescriptor");
        links.add("ToUnicode");
        links.add("W");
        links.add("W2");
        mapOfLinks.put("AFontCIDType0", links);
    }

    private static void fillMapOfSuperNamesAFontCIDType2() {
        mapOfSuperNames.put("AFontCIDType2", "AObject");
    }

    private static void fillMapOfPropertiesAFontCIDType2() {
        properties = new ArrayList<String>();
        properties.add("containsBaseFont");
        properties.add("BaseFontHasTypeName");
        properties.add("BaseFontNameValue");
        properties.add("containsCIDSystemInfo");
        properties.add("CIDSystemInfoHasTypeDictionary");
        properties.add("containsCIDToGIDMap");
        properties.add("isCIDToGIDMapIndirect");
        properties.add("CIDToGIDMapHasTypeName");
        properties.add("CIDToGIDMapHasTypeStream");
        properties.add("CIDToGIDMapNameValue");
        properties.add("containsDW");
        properties.add("DWHasTypeNumber");
        properties.add("containsDW2");
        properties.add("DW2HasTypeArray");
        properties.add("containsFontDescriptor");
        properties.add("isFontDescriptorIndirect");
        properties.add("FontDescriptorHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsW");
        properties.add("WHasTypeArray");
        properties.add("containsW2");
        properties.add("W2HasTypeArray");
        properties.add("containsFontDescriptorFontFile2");
        mapOfProperties.put("AFontCIDType2", properties);
    }

    private static void fillMapOfLinksAFontCIDType2() {
        links = new ArrayList<String>();
        links.add("CIDSystemInfo");
        links.add("CIDToGIDMap");
        links.add("DW2");
        links.add("FontDescriptor");
        links.add("ToUnicode");
        links.add("W");
        links.add("W2");
        mapOfLinks.put("AFontCIDType2", links);
    }

    private static void fillMapOfSuperNamesAFontDescriptorCIDType0() {
        mapOfSuperNames.put("AFontDescriptorCIDType0", "AObject");
    }

    private static void fillMapOfPropertiesAFontDescriptorCIDType0() {
        properties = new ArrayList<String>();
        properties.add("containsAscent");
        properties.add("AscentHasTypeNumber");
        properties.add("containsAvgWidth");
        properties.add("AvgWidthHasTypeNumber");
        properties.add("containsCIDSet");
        properties.add("isCIDSetIndirect");
        properties.add("CIDSetHasTypeStream");
        properties.add("containsCapHeight");
        properties.add("CapHeightHasTypeNumber");
        properties.add("containsDescent");
        properties.add("DescentHasTypeNumber");
        properties.add("DescentNumberValue");
        properties.add("containsFD");
        properties.add("FDHasTypeDictionary");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontFamily");
        properties.add("FontFamilyHasTypeString");
        properties.add("containsFontFile");
        properties.add("isFontFileIndirect");
        properties.add("FontFileHasTypeStream");
        properties.add("containsFontFile3");
        properties.add("isFontFile3Indirect");
        properties.add("FontFile3HasTypeStream");
        properties.add("containsFontName");
        properties.add("FontNameHasTypeName");
        properties.add("FontNameNameValue");
        properties.add("containsFontStretch");
        properties.add("FontStretchHasTypeName");
        properties.add("FontStretchNameValue");
        properties.add("containsFontWeight");
        properties.add("FontWeightHasTypeInteger");
        properties.add("FontWeightIntegerValue");
        properties.add("containsItalicAngle");
        properties.add("ItalicAngleHasTypeNumber");
        properties.add("containsLang");
        properties.add("LangHasTypeName");
        properties.add("containsLeading");
        properties.add("LeadingHasTypeNumber");
        properties.add("containsMaxWidth");
        properties.add("MaxWidthHasTypeNumber");
        properties.add("containsMissingWidth");
        properties.add("MissingWidthHasTypeNumber");
        properties.add("containsStemH");
        properties.add("StemHHasTypeNumber");
        properties.add("containsStemV");
        properties.add("StemVHasTypeNumber");
        properties.add("containsStyle");
        properties.add("StyleHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXHeight");
        properties.add("XHeightHasTypeNumber");
        properties.add("parentBaseFontNameValue");
        mapOfProperties.put("AFontDescriptorCIDType0", properties);
    }

    private static void fillMapOfLinksAFontDescriptorCIDType0() {
        links = new ArrayList<String>();
        links.add("CIDSet");
        links.add("FD");
        links.add("FontFile");
        links.add("FontFile3");
        links.add("Style");
        mapOfLinks.put("AFontDescriptorCIDType0", links);
    }

    private static void fillMapOfSuperNamesAFontDescriptorCIDType2() {
        mapOfSuperNames.put("AFontDescriptorCIDType2", "AObject");
    }

    private static void fillMapOfPropertiesAFontDescriptorCIDType2() {
        properties = new ArrayList<String>();
        properties.add("containsAscent");
        properties.add("AscentHasTypeNumber");
        properties.add("containsAvgWidth");
        properties.add("AvgWidthHasTypeNumber");
        properties.add("containsCIDSet");
        properties.add("isCIDSetIndirect");
        properties.add("CIDSetHasTypeStream");
        properties.add("containsCapHeight");
        properties.add("CapHeightHasTypeNumber");
        properties.add("containsDescent");
        properties.add("DescentHasTypeNumber");
        properties.add("DescentNumberValue");
        properties.add("containsFD");
        properties.add("FDHasTypeDictionary");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontFamily");
        properties.add("FontFamilyHasTypeString");
        properties.add("containsFontFile");
        properties.add("isFontFileIndirect");
        properties.add("FontFileHasTypeStream");
        properties.add("containsFontFile2");
        properties.add("isFontFile2Indirect");
        properties.add("FontFile2HasTypeStream");
        properties.add("containsFontName");
        properties.add("FontNameHasTypeName");
        properties.add("FontNameNameValue");
        properties.add("containsFontStretch");
        properties.add("FontStretchHasTypeName");
        properties.add("FontStretchNameValue");
        properties.add("containsFontWeight");
        properties.add("FontWeightHasTypeInteger");
        properties.add("FontWeightIntegerValue");
        properties.add("containsItalicAngle");
        properties.add("ItalicAngleHasTypeNumber");
        properties.add("containsLang");
        properties.add("LangHasTypeName");
        properties.add("containsLeading");
        properties.add("LeadingHasTypeNumber");
        properties.add("containsMaxWidth");
        properties.add("MaxWidthHasTypeNumber");
        properties.add("containsMissingWidth");
        properties.add("MissingWidthHasTypeNumber");
        properties.add("containsStemH");
        properties.add("StemHHasTypeNumber");
        properties.add("containsStemV");
        properties.add("StemVHasTypeNumber");
        properties.add("containsStyle");
        properties.add("StyleHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXHeight");
        properties.add("XHeightHasTypeNumber");
        properties.add("parentBaseFontNameValue");
        mapOfProperties.put("AFontDescriptorCIDType2", properties);
    }

    private static void fillMapOfLinksAFontDescriptorCIDType2() {
        links = new ArrayList<String>();
        links.add("CIDSet");
        links.add("FD");
        links.add("FontFile");
        links.add("FontFile2");
        links.add("Style");
        mapOfLinks.put("AFontDescriptorCIDType2", links);
    }

    private static void fillMapOfSuperNamesAFontDescriptorTrueType() {
        mapOfSuperNames.put("AFontDescriptorTrueType", "AObject");
    }

    private static void fillMapOfPropertiesAFontDescriptorTrueType() {
        properties = new ArrayList<String>();
        properties.add("containsAscent");
        properties.add("AscentHasTypeNumber");
        properties.add("containsAvgWidth");
        properties.add("AvgWidthHasTypeNumber");
        properties.add("containsCapHeight");
        properties.add("CapHeightHasTypeNumber");
        properties.add("containsDescent");
        properties.add("DescentHasTypeNumber");
        properties.add("DescentNumberValue");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontFamily");
        properties.add("FontFamilyHasTypeStringByte");
        properties.add("containsFontFile");
        properties.add("isFontFileIndirect");
        properties.add("FontFileHasTypeStream");
        properties.add("containsFontFile2");
        properties.add("isFontFile2Indirect");
        properties.add("FontFile2HasTypeStream");
        properties.add("containsFontName");
        properties.add("FontNameHasTypeName");
        properties.add("FontNameNameValue");
        properties.add("containsFontStretch");
        properties.add("FontStretchHasTypeName");
        properties.add("FontStretchNameValue");
        properties.add("containsFontWeight");
        properties.add("FontWeightHasTypeInteger");
        properties.add("FontWeightIntegerValue");
        properties.add("containsItalicAngle");
        properties.add("ItalicAngleHasTypeNumber");
        properties.add("containsLeading");
        properties.add("LeadingHasTypeNumber");
        properties.add("containsMaxWidth");
        properties.add("MaxWidthHasTypeNumber");
        properties.add("containsMissingWidth");
        properties.add("MissingWidthHasTypeNumber");
        properties.add("containsStemH");
        properties.add("StemHHasTypeNumber");
        properties.add("containsStemV");
        properties.add("StemVHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXHeight");
        properties.add("XHeightHasTypeNumber");
        properties.add("parentBaseFontNameValue");
        mapOfProperties.put("AFontDescriptorTrueType", properties);
    }

    private static void fillMapOfLinksAFontDescriptorTrueType() {
        links = new ArrayList<String>();
        links.add("FontFile");
        links.add("FontFile2");
        mapOfLinks.put("AFontDescriptorTrueType", links);
    }

    private static void fillMapOfSuperNamesAFontDescriptorType1() {
        mapOfSuperNames.put("AFontDescriptorType1", "AObject");
    }

    private static void fillMapOfPropertiesAFontDescriptorType1() {
        properties = new ArrayList<String>();
        properties.add("containsAscent");
        properties.add("AscentHasTypeNumber");
        properties.add("containsAvgWidth");
        properties.add("AvgWidthHasTypeNumber");
        properties.add("containsCapHeight");
        properties.add("CapHeightHasTypeNumber");
        properties.add("containsCharSet");
        properties.add("CharSetHasTypeStringAscii");
        properties.add("CharSetHasTypeStringByte");
        properties.add("containsDescent");
        properties.add("DescentHasTypeNumber");
        properties.add("DescentNumberValue");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontFamily");
        properties.add("FontFamilyHasTypeStringByte");
        properties.add("containsFontFile");
        properties.add("isFontFileIndirect");
        properties.add("FontFileHasTypeStream");
        properties.add("containsFontFile3");
        properties.add("isFontFile3Indirect");
        properties.add("FontFile3HasTypeStream");
        properties.add("containsFontName");
        properties.add("FontNameHasTypeName");
        properties.add("FontNameNameValue");
        properties.add("containsFontStretch");
        properties.add("FontStretchHasTypeName");
        properties.add("FontStretchNameValue");
        properties.add("containsFontWeight");
        properties.add("FontWeightHasTypeInteger");
        properties.add("FontWeightIntegerValue");
        properties.add("containsItalicAngle");
        properties.add("ItalicAngleHasTypeNumber");
        properties.add("containsLeading");
        properties.add("LeadingHasTypeNumber");
        properties.add("containsMaxWidth");
        properties.add("MaxWidthHasTypeNumber");
        properties.add("containsMissingWidth");
        properties.add("MissingWidthHasTypeNumber");
        properties.add("containsStemH");
        properties.add("StemHHasTypeNumber");
        properties.add("containsStemV");
        properties.add("StemVHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXHeight");
        properties.add("XHeightHasTypeNumber");
        properties.add("parentBaseFontNameValue");
        mapOfProperties.put("AFontDescriptorType1", properties);
    }

    private static void fillMapOfLinksAFontDescriptorType1() {
        links = new ArrayList<String>();
        links.add("FontFile");
        links.add("FontFile3");
        mapOfLinks.put("AFontDescriptorType1", links);
    }

    private static void fillMapOfSuperNamesAFontDescriptorType3() {
        mapOfSuperNames.put("AFontDescriptorType3", "AObject");
    }

    private static void fillMapOfPropertiesAFontDescriptorType3() {
        properties = new ArrayList<String>();
        properties.add("containsAscent");
        properties.add("AscentHasTypeNumber");
        properties.add("containsAvgWidth");
        properties.add("AvgWidthHasTypeNumber");
        properties.add("containsCapHeight");
        properties.add("CapHeightHasTypeNumber");
        properties.add("containsDescent");
        properties.add("DescentHasTypeNumber");
        properties.add("DescentNumberValue");
        properties.add("containsFlags");
        properties.add("FlagsHasTypeBitmask");
        properties.add("FlagsBitmaskValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontFamily");
        properties.add("FontFamilyHasTypeStringByte");
        properties.add("containsFontName");
        properties.add("FontNameHasTypeName");
        properties.add("FontNameNameValue");
        properties.add("containsFontStretch");
        properties.add("FontStretchHasTypeName");
        properties.add("FontStretchNameValue");
        properties.add("containsFontWeight");
        properties.add("FontWeightHasTypeInteger");
        properties.add("FontWeightIntegerValue");
        properties.add("containsItalicAngle");
        properties.add("ItalicAngleHasTypeNumber");
        properties.add("containsLeading");
        properties.add("LeadingHasTypeNumber");
        properties.add("containsMaxWidth");
        properties.add("MaxWidthHasTypeNumber");
        properties.add("containsMissingWidth");
        properties.add("MissingWidthHasTypeNumber");
        properties.add("containsStemH");
        properties.add("StemHHasTypeNumber");
        properties.add("containsStemV");
        properties.add("StemVHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXHeight");
        properties.add("XHeightHasTypeNumber");
        properties.add("parentNameNameValue");
        mapOfProperties.put("AFontDescriptorType3", properties);
    }

    private static void fillMapOfLinksAFontDescriptorType3() {
        links = new ArrayList<String>();
        mapOfLinks.put("AFontDescriptorType3", links);
    }

    private static void fillMapOfSuperNamesAFontFile() {
        mapOfSuperNames.put("AFontFile", "AObject");
    }

    private static void fillMapOfPropertiesAFontFile() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLength1");
        properties.add("Length1HasTypeInteger");
        properties.add("Length1IntegerValue");
        properties.add("containsLength2");
        properties.add("Length2HasTypeInteger");
        properties.add("Length2IntegerValue");
        properties.add("containsLength3");
        properties.add("Length3HasTypeInteger");
        properties.add("Length3IntegerValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        mapOfProperties.put("AFontFile", properties);
    }

    private static void fillMapOfLinksAFontFile() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AFontFile", links);
    }

    private static void fillMapOfSuperNamesAFontFile2() {
        mapOfSuperNames.put("AFontFile2", "AObject");
    }

    private static void fillMapOfPropertiesAFontFile2() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLength1");
        properties.add("Length1HasTypeInteger");
        properties.add("Length1IntegerValue");
        properties.add("containsLength2");
        properties.add("Length2HasTypeInteger");
        properties.add("Length2IntegerValue");
        properties.add("containsLength3");
        properties.add("Length3HasTypeInteger");
        properties.add("Length3IntegerValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("parentparentSubtypeNameValue");
        mapOfProperties.put("AFontFile2", properties);
    }

    private static void fillMapOfLinksAFontFile2() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AFontFile2", links);
    }

    private static void fillMapOfSuperNamesAFontFile3CIDType0() {
        mapOfSuperNames.put("AFontFile3CIDType0", "AObject");
    }

    private static void fillMapOfPropertiesAFontFile3CIDType0() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLength1");
        properties.add("Length1HasTypeInteger");
        properties.add("Length1IntegerValue");
        properties.add("containsLength2");
        properties.add("Length2HasTypeInteger");
        properties.add("Length2IntegerValue");
        properties.add("containsLength3");
        properties.add("Length3HasTypeInteger");
        properties.add("Length3IntegerValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        mapOfProperties.put("AFontFile3CIDType0", properties);
    }

    private static void fillMapOfLinksAFontFile3CIDType0() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AFontFile3CIDType0", links);
    }

    private static void fillMapOfSuperNamesAFontFile3Type1() {
        mapOfSuperNames.put("AFontFile3Type1", "AObject");
    }

    private static void fillMapOfPropertiesAFontFile3Type1() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLength1");
        properties.add("Length1HasTypeInteger");
        properties.add("Length1IntegerValue");
        properties.add("containsLength2");
        properties.add("Length2HasTypeInteger");
        properties.add("Length2IntegerValue");
        properties.add("containsLength3");
        properties.add("Length3HasTypeInteger");
        properties.add("Length3IntegerValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        mapOfProperties.put("AFontFile3Type1", properties);
    }

    private static void fillMapOfLinksAFontFile3Type1() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AFontFile3Type1", links);
    }

    private static void fillMapOfSuperNamesAFontFileType1() {
        mapOfSuperNames.put("AFontFileType1", "AObject");
    }

    private static void fillMapOfPropertiesAFontFileType1() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLength1");
        properties.add("Length1HasTypeInteger");
        properties.add("Length1IntegerValue");
        properties.add("containsLength2");
        properties.add("Length2HasTypeInteger");
        properties.add("Length2IntegerValue");
        properties.add("containsLength3");
        properties.add("Length3HasTypeInteger");
        properties.add("Length3IntegerValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        mapOfProperties.put("AFontFileType1", properties);
    }

    private static void fillMapOfLinksAFontFileType1() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AFontFileType1", links);
    }

    private static void fillMapOfSuperNamesAFontMap() {
        mapOfSuperNames.put("AFontMap", "AObject");
    }

    private static void fillMapOfPropertiesAFontMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AFontMap", properties);
    }

    private static void fillMapOfLinksAFontMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AFontMap", links);
    }

    private static void fillMapOfSuperNamesAFontMapEntry() {
        mapOfSuperNames.put("AFontMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAFontMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AFontMapEntry", properties);
    }

    private static void fillMapOfLinksAFontMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AFontMapEntry", links);
    }

    private static void fillMapOfSuperNamesAFontMultipleMaster() {
        mapOfSuperNames.put("AFontMultipleMaster", "AObject");
    }

    private static void fillMapOfPropertiesAFontMultipleMaster() {
        properties = new ArrayList<String>();
        properties.add("containsBaseFont");
        properties.add("BaseFontHasTypeName");
        properties.add("containsEncoding");
        properties.add("EncodingHasTypeDictionary");
        properties.add("EncodingHasTypeName");
        properties.add("EncodingNameValue");
        properties.add("containsFirstChar");
        properties.add("FirstCharHasTypeInteger");
        properties.add("containsFontDescriptor");
        properties.add("isFontDescriptorIndirect");
        properties.add("FontDescriptorHasTypeDictionary");
        properties.add("containsLastChar");
        properties.add("LastCharHasTypeInteger");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidths");
        properties.add("WidthsHasTypeArray");
        mapOfProperties.put("AFontMultipleMaster", properties);
    }

    private static void fillMapOfLinksAFontMultipleMaster() {
        links = new ArrayList<String>();
        links.add("Encoding");
        links.add("FontDescriptor");
        links.add("ToUnicode");
        links.add("Widths");
        mapOfLinks.put("AFontMultipleMaster", links);
    }

    private static void fillMapOfSuperNamesAFontTrueType() {
        mapOfSuperNames.put("AFontTrueType", "AObject");
    }

    private static void fillMapOfPropertiesAFontTrueType() {
        properties = new ArrayList<String>();
        properties.add("containsBaseFont");
        properties.add("BaseFontHasTypeName");
        properties.add("BaseFontNameValue");
        properties.add("containsEncoding");
        properties.add("EncodingHasTypeDictionary");
        properties.add("EncodingHasTypeName");
        properties.add("EncodingNameValue");
        properties.add("containsFirstChar");
        properties.add("FirstCharHasTypeInteger");
        properties.add("containsFontDescriptor");
        properties.add("isFontDescriptorIndirect");
        properties.add("FontDescriptorHasTypeDictionary");
        properties.add("containsLastChar");
        properties.add("LastCharHasTypeInteger");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidths");
        properties.add("WidthsHasTypeArray");
        mapOfProperties.put("AFontTrueType", properties);
    }

    private static void fillMapOfLinksAFontTrueType() {
        links = new ArrayList<String>();
        links.add("Encoding");
        links.add("FontDescriptor");
        links.add("ToUnicode");
        links.add("Widths");
        mapOfLinks.put("AFontTrueType", links);
    }

    private static void fillMapOfSuperNamesAFontType0() {
        mapOfSuperNames.put("AFontType0", "AObject");
    }

    private static void fillMapOfPropertiesAFontType0() {
        properties = new ArrayList<String>();
        properties.add("containsBaseFont");
        properties.add("BaseFontHasTypeName");
        properties.add("containsDescendantFonts");
        properties.add("DescendantFontsHasTypeArray");
        properties.add("containsEncoding");
        properties.add("isEncodingIndirect");
        properties.add("EncodingHasTypeName");
        properties.add("EncodingHasTypeStream");
        properties.add("EncodingNameValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AFontType0", properties);
    }

    private static void fillMapOfLinksAFontType0() {
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        links.add("ToUnicode");
        mapOfLinks.put("AFontType0", links);
    }

    private static void fillMapOfSuperNamesAFontType1() {
        mapOfSuperNames.put("AFontType1", "AObject");
    }

    private static void fillMapOfPropertiesAFontType1() {
        properties = new ArrayList<String>();
        properties.add("containsBaseFont");
        properties.add("BaseFontHasTypeName");
        properties.add("containsEncoding");
        properties.add("EncodingHasTypeDictionary");
        properties.add("EncodingHasTypeName");
        properties.add("EncodingNameValue");
        properties.add("containsFirstChar");
        properties.add("FirstCharHasTypeInteger");
        properties.add("FirstCharIntegerValue");
        properties.add("containsFontDescriptor");
        properties.add("isFontDescriptorIndirect");
        properties.add("FontDescriptorHasTypeDictionary");
        properties.add("containsLastChar");
        properties.add("LastCharHasTypeInteger");
        properties.add("LastCharIntegerValue");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidths");
        properties.add("WidthsHasTypeArray");
        properties.add("WidthsArraySize");
        mapOfProperties.put("AFontType1", properties);
    }

    private static void fillMapOfLinksAFontType1() {
        links = new ArrayList<String>();
        links.add("Encoding");
        links.add("FontDescriptor");
        links.add("ToUnicode");
        links.add("Widths");
        mapOfLinks.put("AFontType1", links);
    }

    private static void fillMapOfSuperNamesAFontType3() {
        mapOfSuperNames.put("AFontType3", "AObject");
    }

    private static void fillMapOfPropertiesAFontType3() {
        properties = new ArrayList<String>();
        properties.add("containsCharProcs");
        properties.add("CharProcsHasTypeDictionary");
        properties.add("containsEncoding");
        properties.add("EncodingHasTypeDictionary");
        properties.add("containsFirstChar");
        properties.add("FirstCharHasTypeInteger");
        properties.add("FirstCharIntegerValue");
        properties.add("containsFontBBox");
        properties.add("FontBBoxHasTypeRectangle");
        properties.add("containsFontDescriptor");
        properties.add("isFontDescriptorIndirect");
        properties.add("FontDescriptorHasTypeDictionary");
        properties.add("containsFontMatrix");
        properties.add("FontMatrixHasTypeMatrix");
        properties.add("containsLastChar");
        properties.add("LastCharHasTypeInteger");
        properties.add("LastCharIntegerValue");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("NameNameValue");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsToUnicode");
        properties.add("isToUnicodeIndirect");
        properties.add("ToUnicodeHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidths");
        properties.add("WidthsHasTypeArray");
        properties.add("WidthsArraySize");
        mapOfProperties.put("AFontType3", properties);
    }

    private static void fillMapOfLinksAFontType3() {
        links = new ArrayList<String>();
        links.add("CharProcs");
        links.add("Encoding");
        links.add("FontDescriptor");
        links.add("Resources");
        links.add("ToUnicode");
        links.add("Widths");
        mapOfLinks.put("AFontType3", links);
    }

    private static void fillMapOfSuperNamesAFunctionType0() {
        mapOfSuperNames.put("AFunctionType0", "AObject");
    }

    private static void fillMapOfPropertiesAFunctionType0() {
        properties = new ArrayList<String>();
        properties.add("containsBitsPerSample");
        properties.add("BitsPerSampleHasTypeInteger");
        properties.add("BitsPerSampleIntegerValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("DecodeArraySize");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("DomainArraySize");
        properties.add("containsEncode");
        properties.add("EncodeHasTypeArray");
        properties.add("EncodeArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFunctionType");
        properties.add("FunctionTypeHasTypeInteger");
        properties.add("FunctionTypeIntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsOrder");
        properties.add("OrderHasTypeInteger");
        properties.add("OrderIntegerValue");
        properties.add("containsRange");
        properties.add("RangeHasTypeArray");
        properties.add("RangeArraySize");
        properties.add("containsSize");
        properties.add("SizeHasTypeArray");
        properties.add("SizeArraySize");
        mapOfProperties.put("AFunctionType0", properties);
    }

    private static void fillMapOfLinksAFunctionType0() {
        links = new ArrayList<String>();
        links.add("Decode");
        links.add("DecodeParms");
        links.add("Domain");
        links.add("Encode");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Range");
        links.add("Size");
        mapOfLinks.put("AFunctionType0", links);
    }

    private static void fillMapOfSuperNamesAFunctionType2() {
        mapOfSuperNames.put("AFunctionType2", "AObject");
    }

    private static void fillMapOfPropertiesAFunctionType2() {
        properties = new ArrayList<String>();
        properties.add("containsC0");
        properties.add("C0HasTypeArray");
        properties.add("C0ArraySize");
        properties.add("containsC1");
        properties.add("C1HasTypeArray");
        properties.add("C1ArraySize");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("DomainArraySize");
        properties.add("containsFunctionType");
        properties.add("FunctionTypeHasTypeInteger");
        properties.add("FunctionTypeIntegerValue");
        properties.add("containsN");
        properties.add("NHasTypeNumber");
        properties.add("containsRange");
        properties.add("RangeHasTypeArray");
        properties.add("RangeArraySize");
        mapOfProperties.put("AFunctionType2", properties);
    }

    private static void fillMapOfLinksAFunctionType2() {
        links = new ArrayList<String>();
        links.add("C0");
        links.add("C1");
        links.add("Domain");
        links.add("Range");
        mapOfLinks.put("AFunctionType2", links);
    }

    private static void fillMapOfSuperNamesAFunctionType3() {
        mapOfSuperNames.put("AFunctionType3", "AObject");
    }

    private static void fillMapOfPropertiesAFunctionType3() {
        properties = new ArrayList<String>();
        properties.add("containsBounds");
        properties.add("BoundsHasTypeArray");
        properties.add("BoundsArraySize");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("DomainArraySize");
        properties.add("containsEncode");
        properties.add("EncodeHasTypeArray");
        properties.add("EncodeArraySize");
        properties.add("containsFunctionType");
        properties.add("FunctionTypeHasTypeInteger");
        properties.add("FunctionTypeIntegerValue");
        properties.add("containsFunctions");
        properties.add("FunctionsHasTypeArray");
        properties.add("FunctionsArraySize");
        properties.add("containsRange");
        properties.add("RangeHasTypeArray");
        properties.add("RangeArraySize");
        mapOfProperties.put("AFunctionType3", properties);
    }

    private static void fillMapOfLinksAFunctionType3() {
        links = new ArrayList<String>();
        links.add("Bounds");
        links.add("Domain");
        links.add("Encode");
        links.add("Functions");
        links.add("Range");
        mapOfLinks.put("AFunctionType3", links);
    }

    private static void fillMapOfSuperNamesAFunctionType4() {
        mapOfSuperNames.put("AFunctionType4", "AObject");
    }

    private static void fillMapOfPropertiesAFunctionType4() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("DomainArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFunctionType");
        properties.add("FunctionTypeHasTypeInteger");
        properties.add("FunctionTypeIntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsRange");
        properties.add("RangeHasTypeArray");
        properties.add("RangeArraySize");
        mapOfProperties.put("AFunctionType4", properties);
    }

    private static void fillMapOfLinksAFunctionType4() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("Domain");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Range");
        mapOfLinks.put("AFunctionType4", links);
    }

    private static void fillMapOfSuperNamesAGammaArray() {
        mapOfSuperNames.put("AGammaArray", "AObject");
    }

    private static void fillMapOfPropertiesAGammaArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        mapOfProperties.put("AGammaArray", properties);
    }

    private static void fillMapOfLinksAGammaArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AGammaArray", links);
    }

    private static void fillMapOfSuperNamesAGeographicCoordinateSystem() {
        mapOfSuperNames.put("AGeographicCoordinateSystem", "AObject");
    }

    private static void fillMapOfPropertiesAGeographicCoordinateSystem() {
        properties = new ArrayList<String>();
        properties.add("containsEPSG");
        properties.add("EPSGHasTypeInteger");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWKT");
        properties.add("WKTHasTypeStringAscii");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AGeographicCoordinateSystem", properties);
    }

    private static void fillMapOfLinksAGeographicCoordinateSystem() {
        links = new ArrayList<String>();
        mapOfLinks.put("AGeographicCoordinateSystem", links);
    }

    private static void fillMapOfSuperNamesAGraphicsStateParameter() {
        mapOfSuperNames.put("AGraphicsStateParameter", "AObject");
    }

    private static void fillMapOfPropertiesAGraphicsStateParameter() {
        properties = new ArrayList<String>();
        properties.add("containsAAPLAA");
        properties.add("AAPLAAHasTypeBoolean");
        properties.add("containsAAPLST");
        properties.add("AAPLSTHasTypeDictionary");
        properties.add("AAPLSTHasTypeName");
        properties.add("containsAIS");
        properties.add("AISHasTypeBoolean");
        properties.add("containsBG");
        properties.add("isBGIndirect");
        properties.add("BGHasTypeDictionary");
        properties.add("BGHasTypeStream");
        properties.add("containsBG2");
        properties.add("isBG2Indirect");
        properties.add("BG2HasTypeDictionary");
        properties.add("BG2HasTypeName");
        properties.add("BG2HasTypeStream");
        properties.add("containsBM");
        properties.add("BMHasTypeArray");
        properties.add("BMHasTypeName");
        properties.add("BMNameValue");
        properties.add("containsCA");
        properties.add("CAHasTypeNumber");
        properties.add("CANumberValue");
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("containsFL");
        properties.add("FLHasTypeNumber");
        properties.add("FLNumberValue");
        properties.add("containsFont");
        properties.add("FontHasTypeArray");
        properties.add("containsHT");
        properties.add("isHTIndirect");
        properties.add("HTHasTypeDictionary");
        properties.add("HTHasTypeName");
        properties.add("HTHasTypeStream");
        properties.add("containsHTO");
        properties.add("HTOHasTypeArray");
        properties.add("containsHTP");
        properties.add("HTPHasTypeArray");
        properties.add("containsLC");
        properties.add("LCHasTypeInteger");
        properties.add("LCIntegerValue");
        properties.add("containsLJ");
        properties.add("LJHasTypeInteger");
        properties.add("LJIntegerValue");
        properties.add("containsLW");
        properties.add("LWHasTypeNumber");
        properties.add("LWNumberValue");
        properties.add("containsML");
        properties.add("MLHasTypeNumber");
        properties.add("MLNumberValue");
        properties.add("containsOP");
        properties.add("OPHasTypeBoolean");
        properties.add("containsOPM");
        properties.add("OPMHasTypeInteger");
        properties.add("OPMIntegerValue");
        properties.add("containsRI");
        properties.add("RIHasTypeName");
        properties.add("RINameValue");
        properties.add("containsSA");
        properties.add("SAHasTypeBoolean");
        properties.add("containsSM");
        properties.add("SMHasTypeNumber");
        properties.add("SMNumberValue");
        properties.add("containsSMask");
        properties.add("SMaskHasTypeDictionary");
        properties.add("SMaskHasTypeName");
        properties.add("SMaskNameValue");
        properties.add("containsTK");
        properties.add("TKHasTypeBoolean");
        properties.add("containsTR");
        properties.add("isTRIndirect");
        properties.add("TRHasTypeArray");
        properties.add("TRHasTypeDictionary");
        properties.add("TRHasTypeName");
        properties.add("TRHasTypeStream");
        properties.add("containsTR2");
        properties.add("isTR2Indirect");
        properties.add("TR2HasTypeArray");
        properties.add("TR2HasTypeDictionary");
        properties.add("TR2HasTypeName");
        properties.add("TR2HasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUCR");
        properties.add("isUCRIndirect");
        properties.add("UCRHasTypeDictionary");
        properties.add("UCRHasTypeStream");
        properties.add("containsUCR2");
        properties.add("isUCR2Indirect");
        properties.add("UCR2HasTypeDictionary");
        properties.add("UCR2HasTypeName");
        properties.add("UCR2HasTypeStream");
        properties.add("containsUseBlackPtComp");
        properties.add("UseBlackPtCompHasTypeName");
        properties.add("UseBlackPtCompNameValue");
        properties.add("containsca");
        properties.add("caHasTypeNumber");
        properties.add("caNumberValue");
        properties.add("containsop");
        properties.add("opHasTypeBoolean");
        properties.add("hasExtensionAAPL");
        mapOfProperties.put("AGraphicsStateParameter", properties);
    }

    private static void fillMapOfLinksAGraphicsStateParameter() {
        links = new ArrayList<String>();
        links.add("AAPLST");
        links.add("BG");
        links.add("BG2");
        links.add("BM");
        links.add("D");
        links.add("Font");
        links.add("HT");
        links.add("HTO");
        links.add("HTP");
        links.add("SMask");
        links.add("TR");
        links.add("TR2");
        links.add("UCR");
        links.add("UCR2");
        mapOfLinks.put("AGraphicsStateParameter", links);
    }

    private static void fillMapOfSuperNamesAGraphicsStateParameterMap() {
        mapOfSuperNames.put("AGraphicsStateParameterMap", "AObject");
    }

    private static void fillMapOfPropertiesAGraphicsStateParameterMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AGraphicsStateParameterMap", properties);
    }

    private static void fillMapOfLinksAGraphicsStateParameterMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AGraphicsStateParameterMap", links);
    }

    private static void fillMapOfSuperNamesAGraphicsStateParameterMapEntry() {
        mapOfSuperNames.put("AGraphicsStateParameterMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAGraphicsStateParameterMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AGraphicsStateParameterMapEntry", properties);
    }

    private static void fillMapOfLinksAGraphicsStateParameterMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AGraphicsStateParameterMapEntry", links);
    }

    private static void fillMapOfSuperNamesAGroupAttributes() {
        mapOfSuperNames.put("AGroupAttributes", "AObject");
    }

    private static void fillMapOfPropertiesAGroupAttributes() {
        properties = new ArrayList<String>();
        properties.add("containsCS");
        properties.add("CSHasTypeArray");
        properties.add("CSHasTypeName");
        properties.add("CSNameValue");
        properties.add("containsI");
        properties.add("IHasTypeBoolean");
        properties.add("containsK");
        properties.add("KHasTypeBoolean");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AGroupAttributes", properties);
    }

    private static void fillMapOfLinksAGroupAttributes() {
        links = new ArrayList<String>();
        links.add("CS");
        mapOfLinks.put("AGroupAttributes", links);
    }

    private static void fillMapOfSuperNamesAHalftoneType1() {
        mapOfSuperNames.put("AHalftoneType1", "AObject");
    }

    private static void fillMapOfPropertiesAHalftoneType1() {
        properties = new ArrayList<String>();
        properties.add("containsAccurateScreens");
        properties.add("AccurateScreensHasTypeBoolean");
        properties.add("containsAngle");
        properties.add("AngleHasTypeNumber");
        properties.add("containsFrequency");
        properties.add("FrequencyHasTypeNumber");
        properties.add("FrequencyNumberValue");
        properties.add("containsHalftoneName");
        properties.add("HalftoneNameHasTypeStringByte");
        properties.add("containsHalftoneType");
        properties.add("HalftoneTypeHasTypeInteger");
        properties.add("HalftoneTypeIntegerValue");
        properties.add("containsSpotFunction");
        properties.add("isSpotFunctionIndirect");
        properties.add("SpotFunctionHasTypeArray");
        properties.add("SpotFunctionHasTypeDictionary");
        properties.add("SpotFunctionHasTypeName");
        properties.add("SpotFunctionHasTypeStream");
        properties.add("SpotFunctionNameValue");
        properties.add("containsTransferFunction");
        properties.add("isTransferFunctionIndirect");
        properties.add("TransferFunctionHasTypeDictionary");
        properties.add("TransferFunctionHasTypeName");
        properties.add("TransferFunctionHasTypeStream");
        properties.add("TransferFunctionNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("parentHalftoneTypeIntegerValue");
        properties.add("parentHalftoneTypeHasTypeInteger");
        mapOfProperties.put("AHalftoneType1", properties);
    }

    private static void fillMapOfLinksAHalftoneType1() {
        links = new ArrayList<String>();
        links.add("SpotFunction");
        links.add("TransferFunction");
        mapOfLinks.put("AHalftoneType1", links);
    }

    private static void fillMapOfSuperNamesAHalftoneType10() {
        mapOfSuperNames.put("AHalftoneType10", "AObject");
    }

    private static void fillMapOfPropertiesAHalftoneType10() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsHalftoneName");
        properties.add("HalftoneNameHasTypeStringByte");
        properties.add("containsHalftoneType");
        properties.add("HalftoneTypeHasTypeInteger");
        properties.add("HalftoneTypeIntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsTransferFunction");
        properties.add("isTransferFunctionIndirect");
        properties.add("TransferFunctionHasTypeDictionary");
        properties.add("TransferFunctionHasTypeName");
        properties.add("TransferFunctionHasTypeStream");
        properties.add("TransferFunctionNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXsquare");
        properties.add("XsquareHasTypeInteger");
        properties.add("XsquareIntegerValue");
        properties.add("containsYsquare");
        properties.add("YsquareHasTypeInteger");
        properties.add("YsquareIntegerValue");
        properties.add("parentHalftoneTypeIntegerValue");
        properties.add("parentHalftoneTypeHasTypeInteger");
        mapOfProperties.put("AHalftoneType10", properties);
    }

    private static void fillMapOfLinksAHalftoneType10() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("TransferFunction");
        mapOfLinks.put("AHalftoneType10", links);
    }

    private static void fillMapOfSuperNamesAHalftoneType16() {
        mapOfSuperNames.put("AHalftoneType16", "AObject");
    }

    private static void fillMapOfPropertiesAHalftoneType16() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsHalftoneName");
        properties.add("HalftoneNameHasTypeStringByte");
        properties.add("containsHalftoneType");
        properties.add("HalftoneTypeHasTypeInteger");
        properties.add("HalftoneTypeIntegerValue");
        properties.add("containsHeight");
        properties.add("HeightHasTypeInteger");
        properties.add("HeightIntegerValue");
        properties.add("containsHeight2");
        properties.add("Height2HasTypeInteger");
        properties.add("Height2IntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsTransferFunction");
        properties.add("isTransferFunctionIndirect");
        properties.add("TransferFunctionHasTypeDictionary");
        properties.add("TransferFunctionHasTypeName");
        properties.add("TransferFunctionHasTypeStream");
        properties.add("TransferFunctionNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeInteger");
        properties.add("WidthIntegerValue");
        properties.add("containsWidth2");
        properties.add("Width2HasTypeInteger");
        properties.add("Width2IntegerValue");
        properties.add("parentHalftoneTypeIntegerValue");
        properties.add("parentHalftoneTypeHasTypeInteger");
        mapOfProperties.put("AHalftoneType16", properties);
    }

    private static void fillMapOfLinksAHalftoneType16() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("TransferFunction");
        mapOfLinks.put("AHalftoneType16", links);
    }

    private static void fillMapOfSuperNamesAHalftoneType5() {
        mapOfSuperNames.put("AHalftoneType5", "AObject");
    }

    private static void fillMapOfPropertiesAHalftoneType5() {
        properties = new ArrayList<String>();
        properties.add("containsDefault");
        properties.add("isDefaultIndirect");
        properties.add("DefaultHasTypeDictionary");
        properties.add("DefaultHasTypeStream");
        properties.add("containsHalftoneName");
        properties.add("HalftoneNameHasTypeStringByte");
        properties.add("containsHalftoneType");
        properties.add("HalftoneTypeHasTypeInteger");
        properties.add("HalftoneTypeIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AHalftoneType5", properties);
    }

    private static void fillMapOfLinksAHalftoneType5() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("Default");
        mapOfLinks.put("AHalftoneType5", links);
    }

    private static void fillMapOfSuperNamesAHalftoneType5Entry() {
        mapOfSuperNames.put("AHalftoneType5Entry", "AObject");
    }

    private static void fillMapOfPropertiesAHalftoneType5Entry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("AHalftoneType5Entry", properties);
    }

    private static void fillMapOfLinksAHalftoneType5Entry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AHalftoneType5Entry", links);
    }

    private static void fillMapOfSuperNamesAHalftoneType6() {
        mapOfSuperNames.put("AHalftoneType6", "AObject");
    }

    private static void fillMapOfPropertiesAHalftoneType6() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsHalftoneName");
        properties.add("HalftoneNameHasTypeStringByte");
        properties.add("containsHalftoneType");
        properties.add("HalftoneTypeHasTypeInteger");
        properties.add("HalftoneTypeIntegerValue");
        properties.add("containsHeight");
        properties.add("HeightHasTypeInteger");
        properties.add("HeightIntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsTransferFunction");
        properties.add("isTransferFunctionIndirect");
        properties.add("TransferFunctionHasTypeDictionary");
        properties.add("TransferFunctionHasTypeName");
        properties.add("TransferFunctionHasTypeStream");
        properties.add("TransferFunctionNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeInteger");
        properties.add("WidthIntegerValue");
        mapOfProperties.put("AHalftoneType6", properties);
    }

    private static void fillMapOfLinksAHalftoneType6() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("TransferFunction");
        mapOfLinks.put("AHalftoneType6", links);
    }

    private static void fillMapOfSuperNamesAICCBasedColorSpace() {
        mapOfSuperNames.put("AICCBasedColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesAICCBasedColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeStream");
        mapOfProperties.put("AICCBasedColorSpace", properties);
    }

    private static void fillMapOfLinksAICCBasedColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("AICCBasedColorSpace", links);
    }

    private static void fillMapOfSuperNamesAICCProfileStream() {
        mapOfSuperNames.put("AICCProfileStream", "AObject");
    }

    private static void fillMapOfPropertiesAICCProfileStream() {
        properties = new ArrayList<String>();
        properties.add("containsAlternate");
        properties.add("AlternateHasTypeArray");
        properties.add("AlternateHasTypeName");
        properties.add("AlternateNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsN");
        properties.add("NHasTypeInteger");
        properties.add("NIntegerValue");
        properties.add("containsRange");
        properties.add("RangeHasTypeArray");
        properties.add("RangeArraySize");
        mapOfProperties.put("AICCProfileStream", properties);
    }

    private static void fillMapOfLinksAICCProfileStream() {
        links = new ArrayList<String>();
        links.add("Alternate");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Metadata");
        links.add("Range");
        mapOfLinks.put("AICCProfileStream", links);
    }

    private static void fillMapOfSuperNamesAIconFit() {
        mapOfSuperNames.put("AIconFit", "AObject");
    }

    private static void fillMapOfPropertiesAIconFit() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeArray");
        properties.add("containsFB");
        properties.add("FBHasTypeBoolean");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSW");
        properties.add("SWHasTypeName");
        properties.add("SWNameValue");
        properties.add("A1NumberValue");
        properties.add("A0NumberValue");
        properties.add("A1HasTypeNumber");
        properties.add("A0HasTypeNumber");
        mapOfProperties.put("AIconFit", properties);
    }

    private static void fillMapOfLinksAIconFit() {
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("AIconFit", links);
    }

    private static void fillMapOfSuperNamesAIndexedColorSpace() {
        mapOfSuperNames.put("AIndexedColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesAIndexedColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeArray");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        properties.add("entry2HasTypeInteger");
        properties.add("entry2IntegerValue");
        properties.add("isentry3Indirect");
        properties.add("entry3HasTypeStream");
        properties.add("entry3HasTypeString");
        mapOfProperties.put("AIndexedColorSpace", properties);
    }

    private static void fillMapOfLinksAIndexedColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        links.add("entry3");
        mapOfLinks.put("AIndexedColorSpace", links);
    }

    private static void fillMapOfSuperNamesAInteractiveForm() {
        mapOfSuperNames.put("AInteractiveForm", "AObject");
    }

    private static void fillMapOfPropertiesAInteractiveForm() {
        properties = new ArrayList<String>();
        properties.add("containsCO");
        properties.add("COHasTypeArray");
        properties.add("containsDA");
        properties.add("DAHasTypeStringByte");
        properties.add("containsDR");
        properties.add("DRHasTypeDictionary");
        properties.add("containsFields");
        properties.add("FieldsHasTypeArray");
        properties.add("containsNeedAppearances");
        properties.add("NeedAppearancesHasTypeBoolean");
        properties.add("containsQ");
        properties.add("QHasTypeInteger");
        properties.add("QIntegerValue");
        properties.add("containsSigFlags");
        properties.add("SigFlagsHasTypeBitmask");
        properties.add("SigFlagsBitmaskValue");
        properties.add("containsXFA");
        properties.add("isXFAIndirect");
        properties.add("XFAHasTypeArray");
        properties.add("XFAHasTypeStream");
        properties.add("containsDRFontAny");
        mapOfProperties.put("AInteractiveForm", properties);
    }

    private static void fillMapOfLinksAInteractiveForm() {
        links = new ArrayList<String>();
        links.add("CO");
        links.add("DR");
        links.add("Fields");
        links.add("XFA");
        mapOfLinks.put("AInteractiveForm", links);
    }

    private static void fillMapOfSuperNamesALabColorSpace() {
        mapOfSuperNames.put("ALabColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesALabColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeDictionary");
        mapOfProperties.put("ALabColorSpace", properties);
    }

    private static void fillMapOfLinksALabColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("ALabColorSpace", links);
    }

    private static void fillMapOfSuperNamesALabDict() {
        mapOfSuperNames.put("ALabDict", "AObject");
    }

    private static void fillMapOfPropertiesALabDict() {
        properties = new ArrayList<String>();
        properties.add("containsBlackPoint");
        properties.add("BlackPointHasTypeArray");
        properties.add("containsRange");
        properties.add("RangeHasTypeArray");
        properties.add("containsWhitePoint");
        properties.add("WhitePointHasTypeArray");
        mapOfProperties.put("ALabDict", properties);
    }

    private static void fillMapOfLinksALabDict() {
        links = new ArrayList<String>();
        links.add("BlackPoint");
        links.add("Range");
        links.add("WhitePoint");
        mapOfLinks.put("ALabDict", links);
    }

    private static void fillMapOfSuperNamesALabRangeArray() {
        mapOfSuperNames.put("ALabRangeArray", "AObject");
    }

    private static void fillMapOfPropertiesALabRangeArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        properties.add("entry3HasTypeNumber");
        properties.add("entry3NumberValue");
        mapOfProperties.put("ALabRangeArray", properties);
    }

    private static void fillMapOfLinksALabRangeArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("ALabRangeArray", links);
    }

    private static void fillMapOfSuperNamesALegalAttestation() {
        mapOfSuperNames.put("ALegalAttestation", "AObject");
    }

    private static void fillMapOfPropertiesALegalAttestation() {
        properties = new ArrayList<String>();
        properties.add("containsAlternateImages");
        properties.add("AlternateImagesHasTypeInteger");
        properties.add("AlternateImagesIntegerValue");
        properties.add("containsAnnotations");
        properties.add("AnnotationsHasTypeInteger");
        properties.add("AnnotationsIntegerValue");
        properties.add("containsAttestation");
        properties.add("AttestationHasTypeStringText");
        properties.add("containsDevDepGS_BG");
        properties.add("DevDepGS_BGHasTypeInteger");
        properties.add("DevDepGS_BGIntegerValue");
        properties.add("containsDevDepGS_FL");
        properties.add("DevDepGS_FLHasTypeInteger");
        properties.add("DevDepGS_FLIntegerValue");
        properties.add("containsDevDepGS_HT");
        properties.add("DevDepGS_HTHasTypeInteger");
        properties.add("DevDepGS_HTIntegerValue");
        properties.add("containsDevDepGS_OP");
        properties.add("DevDepGS_OPHasTypeInteger");
        properties.add("DevDepGS_OPIntegerValue");
        properties.add("containsDevDepGS_TR");
        properties.add("DevDepGS_TRHasTypeInteger");
        properties.add("DevDepGS_TRIntegerValue");
        properties.add("containsDevDepGS_UCR");
        properties.add("DevDepGS_UCRHasTypeInteger");
        properties.add("DevDepGS_UCRIntegerValue");
        properties.add("containsExternalOPIdicts");
        properties.add("ExternalOPIdictsHasTypeInteger");
        properties.add("ExternalOPIdictsIntegerValue");
        properties.add("containsExternalRefXobjects");
        properties.add("ExternalRefXobjectsHasTypeInteger");
        properties.add("ExternalRefXobjectsIntegerValue");
        properties.add("containsExternalStreams");
        properties.add("ExternalStreamsHasTypeInteger");
        properties.add("ExternalStreamsIntegerValue");
        properties.add("containsGoToRemoteActions");
        properties.add("GoToRemoteActionsHasTypeInteger");
        properties.add("GoToRemoteActionsIntegerValue");
        properties.add("containsHideAnnotationActions");
        properties.add("HideAnnotationActionsHasTypeInteger");
        properties.add("HideAnnotationActionsIntegerValue");
        properties.add("containsJavaScriptActions");
        properties.add("JavaScriptActionsHasTypeInteger");
        properties.add("JavaScriptActionsIntegerValue");
        properties.add("containsLaunchActions");
        properties.add("LaunchActionsHasTypeInteger");
        properties.add("LaunchActionsIntegerValue");
        properties.add("containsMovieActions");
        properties.add("MovieActionsHasTypeInteger");
        properties.add("MovieActionsIntegerValue");
        properties.add("containsNonEmbeddedFonts");
        properties.add("NonEmbeddedFontsHasTypeInteger");
        properties.add("NonEmbeddedFontsIntegerValue");
        properties.add("containsOptionalContent");
        properties.add("OptionalContentHasTypeBoolean");
        properties.add("containsSoundActions");
        properties.add("SoundActionsHasTypeInteger");
        properties.add("SoundActionsIntegerValue");
        properties.add("containsTrueTypeFonts");
        properties.add("TrueTypeFontsHasTypeInteger");
        properties.add("TrueTypeFontsIntegerValue");
        properties.add("containsURIActions");
        properties.add("URIActionsHasTypeInteger");
        properties.add("URIActionsIntegerValue");
        mapOfProperties.put("ALegalAttestation", properties);
    }

    private static void fillMapOfLinksALegalAttestation() {
        links = new ArrayList<String>();
        mapOfLinks.put("ALegalAttestation", links);
    }

    private static void fillMapOfSuperNamesALinearizationParameterDict() {
        mapOfSuperNames.put("ALinearizationParameterDict", "AObject");
    }

    private static void fillMapOfPropertiesALinearizationParameterDict() {
        properties = new ArrayList<String>();
        properties.add("containsE");
        properties.add("isEIndirect");
        properties.add("EHasTypeInteger");
        properties.add("EIntegerValue");
        properties.add("containsH");
        properties.add("isHIndirect");
        properties.add("HHasTypeArray");
        properties.add("containsL");
        properties.add("isLIndirect");
        properties.add("LHasTypeInteger");
        properties.add("LIntegerValue");
        properties.add("containsLinearized");
        properties.add("isLinearizedIndirect");
        properties.add("LinearizedHasTypeNumber");
        properties.add("LinearizedNumberValue");
        properties.add("containsN");
        properties.add("isNIndirect");
        properties.add("NHasTypeInteger");
        properties.add("NIntegerValue");
        properties.add("containsO");
        properties.add("isOIndirect");
        properties.add("OHasTypeInteger");
        properties.add("OIntegerValue");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        properties.add("containsT");
        properties.add("isTIndirect");
        properties.add("THasTypeInteger");
        properties.add("TIntegerValue");
        mapOfProperties.put("ALinearizationParameterDict", properties);
    }

    private static void fillMapOfLinksALinearizationParameterDict() {
        links = new ArrayList<String>();
        links.add("H");
        mapOfLinks.put("ALinearizationParameterDict", links);
    }

    private static void fillMapOfSuperNamesAMDPDict() {
        mapOfSuperNames.put("AMDPDict", "AObject");
    }

    private static void fillMapOfPropertiesAMDPDict() {
        properties = new ArrayList<String>();
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PIntegerValue");
        mapOfProperties.put("AMDPDict", properties);
    }

    private static void fillMapOfLinksAMDPDict() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMDPDict", links);
    }

    private static void fillMapOfSuperNamesAMac() {
        mapOfSuperNames.put("AMac", "AObject");
    }

    private static void fillMapOfPropertiesAMac() {
        properties = new ArrayList<String>();
        properties.add("containsCreator");
        properties.add("CreatorHasTypeInteger");
        properties.add("containsResFork");
        properties.add("isResForkIndirect");
        properties.add("ResForkHasTypeStream");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeInteger");
        mapOfProperties.put("AMac", properties);
    }

    private static void fillMapOfLinksAMac() {
        links = new ArrayList<String>();
        links.add("ResFork");
        mapOfLinks.put("AMac", links);
    }

    private static void fillMapOfSuperNamesAMarkInfo() {
        mapOfSuperNames.put("AMarkInfo", "AObject");
    }

    private static void fillMapOfPropertiesAMarkInfo() {
        properties = new ArrayList<String>();
        properties.add("containsMarked");
        properties.add("MarkedHasTypeBoolean");
        properties.add("containsSuspects");
        properties.add("SuspectsHasTypeBoolean");
        properties.add("containsUserProperties");
        properties.add("UserPropertiesHasTypeBoolean");
        properties.add("UserPropertiesBooleanValue");
        mapOfProperties.put("AMarkInfo", properties);
    }

    private static void fillMapOfLinksAMarkInfo() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMarkInfo", links);
    }

    private static void fillMapOfSuperNamesAMarkedContentReference() {
        mapOfSuperNames.put("AMarkedContentReference", "AObject");
    }

    private static void fillMapOfPropertiesAMarkedContentReference() {
        properties = new ArrayList<String>();
        properties.add("containsMCID");
        properties.add("MCIDHasTypeInteger");
        properties.add("containsPg");
        properties.add("isPgIndirect");
        properties.add("PgHasTypeDictionary");
        properties.add("containsStm");
        properties.add("isStmIndirect");
        properties.add("StmHasTypeStream");
        properties.add("containsStmOwn");
        properties.add("isStmOwnIndirect");
        properties.add("StmOwnHasTypeArray");
        properties.add("StmOwnHasTypeDictionary");
        properties.add("StmOwnHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMarkedContentReference", properties);
    }

    private static void fillMapOfLinksAMarkedContentReference() {
        links = new ArrayList<String>();
        links.add("Pg");
        links.add("Stm");
        links.add("StmOwn");
        mapOfLinks.put("AMarkedContentReference", links);
    }

    private static void fillMapOfSuperNamesAMeasureGEO() {
        mapOfSuperNames.put("AMeasureGEO", "AObject");
    }

    private static void fillMapOfPropertiesAMeasureGEO() {
        properties = new ArrayList<String>();
        properties.add("containsBounds");
        properties.add("BoundsHasTypeArray");
        properties.add("containsDCS");
        properties.add("DCSHasTypeDictionary");
        properties.add("containsGCS");
        properties.add("GCSHasTypeDictionary");
        properties.add("containsGPTS");
        properties.add("GPTSHasTypeArray");
        properties.add("containsLPTS");
        properties.add("LPTSHasTypeArray");
        properties.add("containsPCSM");
        properties.add("PCSMHasTypeArray");
        properties.add("containsPDU");
        properties.add("PDUHasTypeArray");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AMeasureGEO", properties);
    }

    private static void fillMapOfLinksAMeasureGEO() {
        links = new ArrayList<String>();
        links.add("Bounds");
        links.add("DCS");
        links.add("GCS");
        links.add("GPTS");
        links.add("LPTS");
        links.add("PCSM");
        links.add("PDU");
        mapOfLinks.put("AMeasureGEO", links);
    }

    private static void fillMapOfSuperNamesAMeasureRL() {
        mapOfSuperNames.put("AMeasureRL", "AObject");
    }

    private static void fillMapOfPropertiesAMeasureRL() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeArray");
        properties.add("containsCYX");
        properties.add("CYXHasTypeNumber");
        properties.add("containsD");
        properties.add("DHasTypeArray");
        properties.add("containsO");
        properties.add("OHasTypeArray");
        properties.add("containsR");
        properties.add("RHasTypeStringText");
        properties.add("containsS");
        properties.add("SHasTypeArray");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsT");
        properties.add("THasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsX");
        properties.add("XHasTypeArray");
        properties.add("containsY");
        properties.add("YHasTypeArray");
        mapOfProperties.put("AMeasureRL", properties);
    }

    private static void fillMapOfLinksAMeasureRL() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("D");
        links.add("O");
        links.add("S");
        links.add("T");
        links.add("X");
        links.add("Y");
        mapOfLinks.put("AMeasureRL", links);
    }

    private static void fillMapOfSuperNamesAMediaClipData() {
        mapOfSuperNames.put("AMediaClipData", "AObject");
    }

    private static void fillMapOfPropertiesAMediaClipData() {
        properties = new ArrayList<String>();
        properties.add("containsAlt");
        properties.add("AltHasTypeArray");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsCT");
        properties.add("CTHasTypeStringAscii");
        properties.add("containsD");
        properties.add("isDIndirect");
        properties.add("DHasTypeDictionary");
        properties.add("DHasTypeStream");
        properties.add("DHasTypeString");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsN");
        properties.add("NHasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeDictionary");
        properties.add("containsPL");
        properties.add("PLHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaClipData", properties);
    }

    private static void fillMapOfLinksAMediaClipData() {
        links = new ArrayList<String>();
        links.add("Alt");
        links.add("BE");
        links.add("D");
        links.add("MH");
        links.add("P");
        links.add("PL");
        mapOfLinks.put("AMediaClipData", links);
    }

    private static void fillMapOfSuperNamesAMediaClipDataMHBE() {
        mapOfSuperNames.put("AMediaClipDataMHBE", "AObject");
    }

    private static void fillMapOfPropertiesAMediaClipDataMHBE() {
        properties = new ArrayList<String>();
        properties.add("containsBU");
        properties.add("BUHasTypeStringAscii");
        mapOfProperties.put("AMediaClipDataMHBE", properties);
    }

    private static void fillMapOfLinksAMediaClipDataMHBE() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMediaClipDataMHBE", links);
    }

    private static void fillMapOfSuperNamesAMediaClipSection() {
        mapOfSuperNames.put("AMediaClipSection", "AObject");
    }

    private static void fillMapOfPropertiesAMediaClipSection() {
        properties = new ArrayList<String>();
        properties.add("containsAlt");
        properties.add("AltHasTypeArray");
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsN");
        properties.add("NHasTypeStringText");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaClipSection", properties);
    }

    private static void fillMapOfLinksAMediaClipSection() {
        links = new ArrayList<String>();
        links.add("Alt");
        links.add("BE");
        links.add("D");
        links.add("MH");
        mapOfLinks.put("AMediaClipSection", links);
    }

    private static void fillMapOfSuperNamesAMediaClipSectionMHBE() {
        mapOfSuperNames.put("AMediaClipSectionMHBE", "AObject");
    }

    private static void fillMapOfPropertiesAMediaClipSectionMHBE() {
        properties = new ArrayList<String>();
        properties.add("containsB");
        properties.add("BHasTypeDictionary");
        properties.add("containsE");
        properties.add("EHasTypeDictionary");
        mapOfProperties.put("AMediaClipSectionMHBE", properties);
    }

    private static void fillMapOfLinksAMediaClipSectionMHBE() {
        links = new ArrayList<String>();
        links.add("B");
        links.add("E");
        mapOfLinks.put("AMediaClipSectionMHBE", links);
    }

    private static void fillMapOfSuperNamesAMediaCriteria() {
        mapOfSuperNames.put("AMediaCriteria", "AObject");
    }

    private static void fillMapOfPropertiesAMediaCriteria() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeBoolean");
        properties.add("containsC");
        properties.add("CHasTypeBoolean");
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsL");
        properties.add("LHasTypeArray");
        properties.add("containsO");
        properties.add("OHasTypeBoolean");
        properties.add("containsP");
        properties.add("PHasTypeArray");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("RIntegerValue");
        properties.add("containsS");
        properties.add("SHasTypeBoolean");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeArray");
        properties.add("containsZ");
        properties.add("ZHasTypeDictionary");
        mapOfProperties.put("AMediaCriteria", properties);
    }

    private static void fillMapOfLinksAMediaCriteria() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("L");
        links.add("P");
        links.add("V");
        links.add("Z");
        mapOfLinks.put("AMediaCriteria", links);
    }

    private static void fillMapOfSuperNamesAMediaDuration() {
        mapOfSuperNames.put("AMediaDuration", "AObject");
    }

    private static void fillMapOfPropertiesAMediaDuration() {
        properties = new ArrayList<String>();
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsT");
        properties.add("THasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaDuration", properties);
    }

    private static void fillMapOfLinksAMediaDuration() {
        links = new ArrayList<String>();
        links.add("T");
        mapOfLinks.put("AMediaDuration", links);
    }

    private static void fillMapOfSuperNamesAMediaOffsetFrame() {
        mapOfSuperNames.put("AMediaOffsetFrame", "AObject");
    }

    private static void fillMapOfPropertiesAMediaOffsetFrame() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("FHasTypeInteger");
        properties.add("FIntegerValue");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaOffsetFrame", properties);
    }

    private static void fillMapOfLinksAMediaOffsetFrame() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMediaOffsetFrame", links);
    }

    private static void fillMapOfSuperNamesAMediaOffsetMarker() {
        mapOfSuperNames.put("AMediaOffsetMarker", "AObject");
    }

    private static void fillMapOfPropertiesAMediaOffsetMarker() {
        properties = new ArrayList<String>();
        properties.add("containsM");
        properties.add("MHasTypeStringText");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaOffsetMarker", properties);
    }

    private static void fillMapOfLinksAMediaOffsetMarker() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMediaOffsetMarker", links);
    }

    private static void fillMapOfSuperNamesAMediaOffsetTime() {
        mapOfSuperNames.put("AMediaOffsetTime", "AObject");
    }

    private static void fillMapOfPropertiesAMediaOffsetTime() {
        properties = new ArrayList<String>();
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsT");
        properties.add("THasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaOffsetTime", properties);
    }

    private static void fillMapOfLinksAMediaOffsetTime() {
        links = new ArrayList<String>();
        links.add("T");
        mapOfLinks.put("AMediaOffsetTime", links);
    }

    private static void fillMapOfSuperNamesAMediaPermissions() {
        mapOfSuperNames.put("AMediaPermissions", "AObject");
    }

    private static void fillMapOfPropertiesAMediaPermissions() {
        properties = new ArrayList<String>();
        properties.add("containsTF");
        properties.add("TFHasTypeStringAscii");
        properties.add("TFStringAsciiValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaPermissions", properties);
    }

    private static void fillMapOfLinksAMediaPermissions() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMediaPermissions", links);
    }

    private static void fillMapOfSuperNamesAMediaPlayParameters() {
        mapOfSuperNames.put("AMediaPlayParameters", "AObject");
    }

    private static void fillMapOfPropertiesAMediaPlayParameters() {
        properties = new ArrayList<String>();
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsPL");
        properties.add("PLHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaPlayParameters", properties);
    }

    private static void fillMapOfLinksAMediaPlayParameters() {
        links = new ArrayList<String>();
        links.add("BE");
        links.add("MH");
        links.add("PL");
        mapOfLinks.put("AMediaPlayParameters", links);
    }

    private static void fillMapOfSuperNamesAMediaPlayParametersBE() {
        mapOfSuperNames.put("AMediaPlayParametersBE", "AObject");
    }

    private static void fillMapOfPropertiesAMediaPlayParametersBE() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeBoolean");
        properties.add("containsC");
        properties.add("CHasTypeBoolean");
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeInteger");
        properties.add("FIntegerValue");
        properties.add("containsRC");
        properties.add("RCHasTypeNumber");
        properties.add("RCNumberValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        properties.add("VIntegerValue");
        mapOfProperties.put("AMediaPlayParametersBE", properties);
    }

    private static void fillMapOfLinksAMediaPlayParametersBE() {
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("AMediaPlayParametersBE", links);
    }

    private static void fillMapOfSuperNamesAMediaPlayParametersMH() {
        mapOfSuperNames.put("AMediaPlayParametersMH", "AObject");
    }

    private static void fillMapOfPropertiesAMediaPlayParametersMH() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeBoolean");
        properties.add("containsC");
        properties.add("CHasTypeBoolean");
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeInteger");
        properties.add("FIntegerValue");
        properties.add("containsRC");
        properties.add("RCHasTypeNumber");
        properties.add("RCNumberValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        properties.add("VIntegerValue");
        mapOfProperties.put("AMediaPlayParametersMH", properties);
    }

    private static void fillMapOfLinksAMediaPlayParametersMH() {
        links = new ArrayList<String>();
        links.add("D");
        mapOfLinks.put("AMediaPlayParametersMH", links);
    }

    private static void fillMapOfSuperNamesAMediaPlayerInfo() {
        mapOfSuperNames.put("AMediaPlayerInfo", "AObject");
    }

    private static void fillMapOfPropertiesAMediaPlayerInfo() {
        properties = new ArrayList<String>();
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsPID");
        properties.add("PIDHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaPlayerInfo", properties);
    }

    private static void fillMapOfLinksAMediaPlayerInfo() {
        links = new ArrayList<String>();
        links.add("BE");
        links.add("MH");
        links.add("PID");
        mapOfLinks.put("AMediaPlayerInfo", links);
    }

    private static void fillMapOfSuperNamesAMediaPlayers() {
        mapOfSuperNames.put("AMediaPlayers", "AObject");
    }

    private static void fillMapOfPropertiesAMediaPlayers() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeArray");
        properties.add("containsMU");
        properties.add("MUHasTypeArray");
        properties.add("MUArraySize");
        properties.add("containsNU");
        properties.add("NUHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaPlayers", properties);
    }

    private static void fillMapOfLinksAMediaPlayers() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("MU");
        links.add("NU");
        mapOfLinks.put("AMediaPlayers", links);
    }

    private static void fillMapOfSuperNamesAMediaScreenParameters() {
        mapOfSuperNames.put("AMediaScreenParameters", "AObject");
    }

    private static void fillMapOfPropertiesAMediaScreenParameters() {
        properties = new ArrayList<String>();
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMediaScreenParameters", properties);
    }

    private static void fillMapOfLinksAMediaScreenParameters() {
        links = new ArrayList<String>();
        links.add("BE");
        links.add("MH");
        mapOfLinks.put("AMediaScreenParameters", links);
    }

    private static void fillMapOfSuperNamesAMediaScreenParametersMHBE() {
        mapOfSuperNames.put("AMediaScreenParametersMHBE", "AObject");
    }

    private static void fillMapOfPropertiesAMediaScreenParametersMHBE() {
        properties = new ArrayList<String>();
        properties.add("containsB");
        properties.add("BHasTypeArray");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("containsM");
        properties.add("MHasTypeInteger");
        properties.add("MIntegerValue");
        properties.add("containsO");
        properties.add("OHasTypeNumber");
        properties.add("ONumberValue");
        properties.add("containsW");
        properties.add("WHasTypeInteger");
        properties.add("WIntegerValue");
        mapOfProperties.put("AMediaScreenParametersMHBE", properties);
    }

    private static void fillMapOfLinksAMediaScreenParametersMHBE() {
        links = new ArrayList<String>();
        links.add("B");
        links.add("F");
        mapOfLinks.put("AMediaScreenParametersMHBE", links);
    }

    private static void fillMapOfSuperNamesAMetadata() {
        mapOfSuperNames.put("AMetadata", "AObject");
    }

    private static void fillMapOfPropertiesAMetadata() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AMetadata", properties);
    }

    private static void fillMapOfLinksAMetadata() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AMetadata", links);
    }

    private static void fillMapOfSuperNamesAMicrosoftWindowsLaunchParam() {
        mapOfSuperNames.put("AMicrosoftWindowsLaunchParam", "AObject");
    }

    private static void fillMapOfPropertiesAMicrosoftWindowsLaunchParam() {
        properties = new ArrayList<String>();
        properties.add("containsD");
        properties.add("DHasTypeStringByte");
        properties.add("containsF");
        properties.add("FHasTypeStringByte");
        properties.add("containsO");
        properties.add("OHasTypeStringAscii");
        properties.add("OStringAsciiValue");
        properties.add("containsP");
        properties.add("PHasTypeStringByte");
        mapOfProperties.put("AMicrosoftWindowsLaunchParam", properties);
    }

    private static void fillMapOfLinksAMicrosoftWindowsLaunchParam() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMicrosoftWindowsLaunchParam", links);
    }

    private static void fillMapOfSuperNamesAMinimumBitDepth() {
        mapOfSuperNames.put("AMinimumBitDepth", "AObject");
    }

    private static void fillMapOfPropertiesAMinimumBitDepth() {
        properties = new ArrayList<String>();
        properties.add("containsM");
        properties.add("MHasTypeInteger");
        properties.add("MIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        properties.add("VIntegerValue");
        mapOfProperties.put("AMinimumBitDepth", properties);
    }

    private static void fillMapOfLinksAMinimumBitDepth() {
        links = new ArrayList<String>();
        mapOfLinks.put("AMinimumBitDepth", links);
    }

    private static void fillMapOfSuperNamesAMinimumScreenSize() {
        mapOfSuperNames.put("AMinimumScreenSize", "AObject");
    }

    private static void fillMapOfPropertiesAMinimumScreenSize() {
        properties = new ArrayList<String>();
        properties.add("containsM");
        properties.add("MHasTypeInteger");
        properties.add("MIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeArray");
        mapOfProperties.put("AMinimumScreenSize", properties);
    }

    private static void fillMapOfLinksAMinimumScreenSize() {
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("AMinimumScreenSize", links);
    }

    private static void fillMapOfSuperNamesAMovie() {
        mapOfSuperNames.put("AMovie", "AObject");
    }

    private static void fillMapOfPropertiesAMovie() {
        properties = new ArrayList<String>();
        properties.add("containsAspect");
        properties.add("AspectHasTypeArray");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsPoster");
        properties.add("isPosterIndirect");
        properties.add("PosterHasTypeBoolean");
        properties.add("PosterHasTypeStream");
        properties.add("containsRotate");
        properties.add("RotateHasTypeInteger");
        properties.add("RotateIntegerValue");
        mapOfProperties.put("AMovie", properties);
    }

    private static void fillMapOfLinksAMovie() {
        links = new ArrayList<String>();
        links.add("Aspect");
        links.add("F");
        links.add("Poster");
        mapOfLinks.put("AMovie", links);
    }

    private static void fillMapOfSuperNamesAMovieActivation() {
        mapOfSuperNames.put("AMovieActivation", "AObject");
    }

    private static void fillMapOfPropertiesAMovieActivation() {
        properties = new ArrayList<String>();
        properties.add("containsDuration");
        properties.add("DurationHasTypeArray");
        properties.add("DurationHasTypeInteger");
        properties.add("DurationHasTypeStringByte");
        properties.add("DurationIntegerValue");
        properties.add("DurationStringSize");
        properties.add("containsFWPosition");
        properties.add("FWPositionHasTypeArray");
        properties.add("containsFWScale");
        properties.add("FWScaleHasTypeArray");
        properties.add("containsMode");
        properties.add("ModeHasTypeName");
        properties.add("ModeNameValue");
        properties.add("containsRate");
        properties.add("RateHasTypeNumber");
        properties.add("containsShowControls");
        properties.add("ShowControlsHasTypeBoolean");
        properties.add("containsStart");
        properties.add("StartHasTypeArray");
        properties.add("StartHasTypeInteger");
        properties.add("StartHasTypeStringByte");
        properties.add("StartIntegerValue");
        properties.add("StartStringSize");
        properties.add("containsSynchronous");
        properties.add("SynchronousHasTypeBoolean");
        properties.add("containsVolume");
        properties.add("VolumeHasTypeNumber");
        properties.add("VolumeNumberValue");
        properties.add("FWPosition0NumberValue");
        properties.add("FWPosition1NumberValue");
        properties.add("FWScale0IntegerValue");
        properties.add("FWScale1IntegerValue");
        properties.add("FWPosition0HasTypeNumber");
        properties.add("FWPosition1HasTypeNumber");
        properties.add("FWScale0HasTypeInteger");
        properties.add("FWScale1HasTypeInteger");
        mapOfProperties.put("AMovieActivation", properties);
    }

    private static void fillMapOfLinksAMovieActivation() {
        links = new ArrayList<String>();
        links.add("Duration");
        links.add("FWPosition");
        links.add("FWScale");
        links.add("Start");
        mapOfLinks.put("AMovieActivation", links);
    }

    private static void fillMapOfSuperNamesAName() {
        mapOfSuperNames.put("AName", "AObject");
    }

    private static void fillMapOfPropertiesAName() {
        properties = new ArrayList<String>();
        properties.add("containsAP");
        properties.add("APHasTypeNameTree");
        properties.add("containsAlternatePresentations");
        properties.add("AlternatePresentationsHasTypeNameTree");
        properties.add("containsDests");
        properties.add("DestsHasTypeNameTree");
        properties.add("containsEmbeddedFiles");
        properties.add("EmbeddedFilesHasTypeNameTree");
        properties.add("containsIDS");
        properties.add("IDSHasTypeNameTree");
        properties.add("containsJavaScript");
        properties.add("JavaScriptHasTypeNameTree");
        properties.add("containsPages");
        properties.add("PagesHasTypeNameTree");
        properties.add("containsRenditions");
        properties.add("RenditionsHasTypeNameTree");
        properties.add("containsTemplates");
        properties.add("TemplatesHasTypeNameTree");
        properties.add("containsURLS");
        properties.add("URLSHasTypeNameTree");
        properties.add("containsXFAResources");
        properties.add("XFAResourcesHasTypeNameTree");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AName", properties);
    }

    private static void fillMapOfLinksAName() {
        links = new ArrayList<String>();
        links.add("AP");
        links.add("AlternatePresentations");
        links.add("Dests");
        links.add("EmbeddedFiles");
        links.add("IDS");
        links.add("JavaScript");
        links.add("Pages");
        links.add("Renditions");
        links.add("Templates");
        links.add("URLS");
        links.add("XFAResources");
        mapOfLinks.put("AName", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeAP() {
        mapOfSuperNames.put("ANameNameTreeAP", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeAP() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeAP", properties);
    }

    private static void fillMapOfLinksANameNameTreeAP() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeAP", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeAPEntry() {
        mapOfSuperNames.put("ANameNameTreeAPEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeAPEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStream");
        mapOfProperties.put("ANameNameTreeAPEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeAPEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeAPEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeAlternatePresentations() {
        mapOfSuperNames.put("ANameNameTreeAlternatePresentations", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeAlternatePresentations() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeAlternatePresentations", properties);
    }

    private static void fillMapOfLinksANameNameTreeAlternatePresentations() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeAlternatePresentations", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeAlternatePresentationsEntry() {
        mapOfSuperNames.put("ANameNameTreeAlternatePresentationsEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeAlternatePresentationsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeAlternatePresentationsEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeAlternatePresentationsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeAlternatePresentationsEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeDests() {
        mapOfSuperNames.put("ANameNameTreeDests", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeDests() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeDests", properties);
    }

    private static void fillMapOfLinksANameNameTreeDests() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeDests", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeDestsEntry() {
        mapOfSuperNames.put("ANameNameTreeDestsEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeDestsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeDestsEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeDestsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeDestsEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeEmbeddedFiles() {
        mapOfSuperNames.put("ANameNameTreeEmbeddedFiles", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeEmbeddedFiles() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeEmbeddedFiles", properties);
    }

    private static void fillMapOfLinksANameNameTreeEmbeddedFiles() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeEmbeddedFiles", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeEmbeddedFilesEntry() {
        mapOfSuperNames.put("ANameNameTreeEmbeddedFilesEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeEmbeddedFilesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeEmbeddedFilesEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeEmbeddedFilesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeEmbeddedFilesEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeIDS() {
        mapOfSuperNames.put("ANameNameTreeIDS", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeIDS() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeIDS", properties);
    }

    private static void fillMapOfLinksANameNameTreeIDS() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeIDS", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeIDSEntry() {
        mapOfSuperNames.put("ANameNameTreeIDSEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeIDSEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeIDSEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeIDSEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeIDSEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeJavaScript() {
        mapOfSuperNames.put("ANameNameTreeJavaScript", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeJavaScript() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeJavaScript", properties);
    }

    private static void fillMapOfLinksANameNameTreeJavaScript() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeJavaScript", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeJavaScriptEntry() {
        mapOfSuperNames.put("ANameNameTreeJavaScriptEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeJavaScriptEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeJavaScriptEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeJavaScriptEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeJavaScriptEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreePages() {
        mapOfSuperNames.put("ANameNameTreePages", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreePages() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreePages", properties);
    }

    private static void fillMapOfLinksANameNameTreePages() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreePages", links);
    }

    private static void fillMapOfSuperNamesANameNameTreePagesEntry() {
        mapOfSuperNames.put("ANameNameTreePagesEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreePagesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreePagesEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreePagesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreePagesEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeRenditions() {
        mapOfSuperNames.put("ANameNameTreeRenditions", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeRenditions() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeRenditions", properties);
    }

    private static void fillMapOfLinksANameNameTreeRenditions() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeRenditions", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeRenditionsEntry() {
        mapOfSuperNames.put("ANameNameTreeRenditionsEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeRenditionsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeRenditionsEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeRenditionsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeRenditionsEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeTemplates() {
        mapOfSuperNames.put("ANameNameTreeTemplates", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeTemplates() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeTemplates", properties);
    }

    private static void fillMapOfLinksANameNameTreeTemplates() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeTemplates", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeTemplatesEntry() {
        mapOfSuperNames.put("ANameNameTreeTemplatesEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeTemplatesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeTemplatesEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeTemplatesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeTemplatesEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeURLS() {
        mapOfSuperNames.put("ANameNameTreeURLS", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeURLS() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeURLS", properties);
    }

    private static void fillMapOfLinksANameNameTreeURLS() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeURLS", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeURLSEntry() {
        mapOfSuperNames.put("ANameNameTreeURLSEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeURLSEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ANameNameTreeURLSEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeURLSEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeURLSEntry", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeXFAResources() {
        mapOfSuperNames.put("ANameNameTreeXFAResources", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeXFAResources() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANameNameTreeXFAResources", properties);
    }

    private static void fillMapOfLinksANameNameTreeXFAResources() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANameNameTreeXFAResources", links);
    }

    private static void fillMapOfSuperNamesANameNameTreeXFAResourcesEntry() {
        mapOfSuperNames.put("ANameNameTreeXFAResourcesEntry", "AObject");
    }

    private static void fillMapOfPropertiesANameNameTreeXFAResourcesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStream");
        mapOfProperties.put("ANameNameTreeXFAResourcesEntry", properties);
    }

    private static void fillMapOfLinksANameNameTreeXFAResourcesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANameNameTreeXFAResourcesEntry", links);
    }

    private static void fillMapOfSuperNamesANamespace() {
        mapOfSuperNames.put("ANamespace", "AObject");
    }

    private static void fillMapOfPropertiesANamespace() {
        properties = new ArrayList<String>();
        properties.add("containsNS");
        properties.add("NSHasTypeStringText");
        properties.add("containsRoleMapNS");
        properties.add("RoleMapNSHasTypeDictionary");
        properties.add("containsSchema");
        properties.add("SchemaHasTypeDictionary");
        properties.add("SchemaHasTypeString");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ANamespace", properties);
    }

    private static void fillMapOfLinksANamespace() {
        links = new ArrayList<String>();
        links.add("RoleMapNS");
        links.add("Schema");
        mapOfLinks.put("ANamespace", links);
    }

    private static void fillMapOfSuperNamesANavNode() {
        mapOfSuperNames.put("ANavNode", "AObject");
    }

    private static void fillMapOfPropertiesANavNode() {
        properties = new ArrayList<String>();
        properties.add("containsDur");
        properties.add("DurHasTypeNumber");
        properties.add("containsNA");
        properties.add("NAHasTypeDictionary");
        properties.add("containsNext");
        properties.add("NextHasTypeDictionary");
        properties.add("containsPA");
        properties.add("PAHasTypeDictionary");
        properties.add("containsPrev");
        properties.add("PrevHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ANavNode", properties);
    }

    private static void fillMapOfLinksANavNode() {
        links = new ArrayList<String>();
        links.add("NA");
        links.add("Next");
        links.add("PA");
        links.add("Prev");
        mapOfLinks.put("ANavNode", links);
    }

    private static void fillMapOfSuperNamesANavigator() {
        mapOfSuperNames.put("ANavigator", "AObject");
    }

    private static void fillMapOfPropertiesANavigator() {
        properties = new ArrayList<String>();
        properties.add("containsAPIVersion");
        properties.add("APIVersionHasTypeStringText");
        properties.add("containsCategory");
        properties.add("CategoryHasTypeStringText");
        properties.add("containsDesc");
        properties.add("DescHasTypeStringText");
        properties.add("containsID");
        properties.add("entryIDHasTypeStringText");
        properties.add("containsIcon");
        properties.add("IconHasTypeStringText");
        properties.add("containsInitialFields");
        properties.add("InitialFieldsHasTypeDictionary");
        properties.add("containsLayout");
        properties.add("LayoutHasTypeArray");
        properties.add("LayoutHasTypeName");
        properties.add("LayoutNameValue");
        properties.add("containsLoadType");
        properties.add("LoadTypeHasTypeName");
        properties.add("LoadTypeNameValue");
        properties.add("containsLocale");
        properties.add("LocaleHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeNameTree");
        properties.add("containsSWF");
        properties.add("SWFHasTypeStringText");
        properties.add("containsStrings");
        properties.add("StringsHasTypeNameTree");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVersion");
        properties.add("VersionHasTypeStringText");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ANavigator", properties);
    }

    private static void fillMapOfLinksANavigator() {
        links = new ArrayList<String>();
        links.add("InitialFields");
        links.add("Layout");
        links.add("Resources");
        links.add("Strings");
        mapOfLinks.put("ANavigator", links);
    }

    private static void fillMapOfSuperNamesANavigatorNameTreeResources() {
        mapOfSuperNames.put("ANavigatorNameTreeResources", "AObject");
    }

    private static void fillMapOfPropertiesANavigatorNameTreeResources() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANavigatorNameTreeResources", properties);
    }

    private static void fillMapOfLinksANavigatorNameTreeResources() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANavigatorNameTreeResources", links);
    }

    private static void fillMapOfSuperNamesANavigatorNameTreeResourcesEntry() {
        mapOfSuperNames.put("ANavigatorNameTreeResourcesEntry", "AObject");
    }

    private static void fillMapOfPropertiesANavigatorNameTreeResourcesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStream");
        mapOfProperties.put("ANavigatorNameTreeResourcesEntry", properties);
    }

    private static void fillMapOfLinksANavigatorNameTreeResourcesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ANavigatorNameTreeResourcesEntry", links);
    }

    private static void fillMapOfSuperNamesANavigatorNameTreeStrings() {
        mapOfSuperNames.put("ANavigatorNameTreeStrings", "AObject");
    }

    private static void fillMapOfPropertiesANavigatorNameTreeStrings() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANavigatorNameTreeStrings", properties);
    }

    private static void fillMapOfLinksANavigatorNameTreeStrings() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ANavigatorNameTreeStrings", links);
    }

    private static void fillMapOfSuperNamesANavigatorNameTreeStringsEntry() {
        mapOfSuperNames.put("ANavigatorNameTreeStringsEntry", "AObject");
    }

    private static void fillMapOfPropertiesANavigatorNameTreeStringsEntry() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ANavigatorNameTreeStringsEntry", properties);
    }

    private static void fillMapOfLinksANavigatorNameTreeStringsEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("ANavigatorNameTreeStringsEntry", links);
    }

    private static void fillMapOfSuperNamesANumberFormat() {
        mapOfSuperNames.put("ANumberFormat", "AObject");
    }

    private static void fillMapOfPropertiesANumberFormat() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeNumber");
        properties.add("containsD");
        properties.add("DHasTypeInteger");
        properties.add("DIntegerValue");
        properties.add("containsF");
        properties.add("FHasTypeName");
        properties.add("FNameValue");
        properties.add("containsFD");
        properties.add("FDHasTypeBoolean");
        properties.add("containsO");
        properties.add("OHasTypeName");
        properties.add("ONameValue");
        properties.add("containsPS");
        properties.add("PSHasTypeStringText");
        properties.add("containsRD");
        properties.add("RDHasTypeStringText");
        properties.add("containsRT");
        properties.add("RTHasTypeStringText");
        properties.add("containsSS");
        properties.add("SSHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU");
        properties.add("UHasTypeStringText");
        mapOfProperties.put("ANumberFormat", properties);
    }

    private static void fillMapOfLinksANumberFormat() {
        links = new ArrayList<String>();
        mapOfLinks.put("ANumberFormat", links);
    }

    private static void fillMapOfSuperNamesAOPIVersion13() {
        mapOfSuperNames.put("AOPIVersion13", "AObject");
    }

    private static void fillMapOfPropertiesAOPIVersion13() {
        properties = new ArrayList<String>();
        properties.add("contains13");
        properties.add("entry13HasTypeDictionary");
        mapOfProperties.put("AOPIVersion13", properties);
    }

    private static void fillMapOfLinksAOPIVersion13() {
        links = new ArrayList<String>();
        links.add("entry13");
        mapOfLinks.put("AOPIVersion13", links);
    }

    private static void fillMapOfSuperNamesAOPIVersion13Dict() {
        mapOfSuperNames.put("AOPIVersion13Dict", "AObject");
    }

    private static void fillMapOfPropertiesAOPIVersion13Dict() {
        properties = new ArrayList<String>();
        properties.add("containsColor");
        properties.add("ColorHasTypeArray");
        properties.add("containsColorType");
        properties.add("ColorTypeHasTypeName");
        properties.add("containsComments");
        properties.add("CommentsHasTypeStringText");
        properties.add("containsCropFixed");
        properties.add("CropFixedHasTypeArray");
        properties.add("containsCropRect");
        properties.add("CropRectHasTypeRectangle");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsGrayMap");
        properties.add("GrayMapHasTypeArray");
        properties.add("GrayMapArraySize");
        properties.add("containsID");
        properties.add("entryIDHasTypeStringByte");
        properties.add("containsImageType");
        properties.add("ImageTypeHasTypeArray");
        properties.add("containsOverprint");
        properties.add("OverprintHasTypeBoolean");
        properties.add("containsPosition");
        properties.add("PositionHasTypeArray");
        properties.add("containsResolution");
        properties.add("ResolutionHasTypeArray");
        properties.add("containsSize");
        properties.add("SizeHasTypeArray");
        properties.add("containsTags");
        properties.add("TagsHasTypeArray");
        properties.add("containsTint");
        properties.add("TintHasTypeNumber");
        properties.add("containsTransparency");
        properties.add("TransparencyHasTypeBoolean");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVersion");
        properties.add("VersionHasTypeNumber");
        properties.add("VersionNumberValue");
        mapOfProperties.put("AOPIVersion13Dict", properties);
    }

    private static void fillMapOfLinksAOPIVersion13Dict() {
        links = new ArrayList<String>();
        links.add("Color");
        links.add("CropFixed");
        links.add("F");
        links.add("GrayMap");
        links.add("ImageType");
        links.add("Position");
        links.add("Resolution");
        links.add("Size");
        links.add("Tags");
        mapOfLinks.put("AOPIVersion13Dict", links);
    }

    private static void fillMapOfSuperNamesAOPIVersion20() {
        mapOfSuperNames.put("AOPIVersion20", "AObject");
    }

    private static void fillMapOfPropertiesAOPIVersion20() {
        properties = new ArrayList<String>();
        properties.add("contains20");
        properties.add("entry20HasTypeDictionary");
        mapOfProperties.put("AOPIVersion20", properties);
    }

    private static void fillMapOfLinksAOPIVersion20() {
        links = new ArrayList<String>();
        links.add("entry20");
        mapOfLinks.put("AOPIVersion20", links);
    }

    private static void fillMapOfSuperNamesAOPIVersion20Dict() {
        mapOfSuperNames.put("AOPIVersion20Dict", "AObject");
    }

    private static void fillMapOfPropertiesAOPIVersion20Dict() {
        properties = new ArrayList<String>();
        properties.add("containsCropRect");
        properties.add("CropRectHasTypeRectangle");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsIncludedImageDimensions");
        properties.add("IncludedImageDimensionsHasTypeArray");
        properties.add("containsIncludedImageQuality");
        properties.add("IncludedImageQualityHasTypeNumber");
        properties.add("IncludedImageQualityNumberValue");
        properties.add("containsInks");
        properties.add("InksHasTypeArray");
        properties.add("InksHasTypeName");
        properties.add("InksNameValue");
        properties.add("containsMainImage");
        properties.add("MainImageHasTypeStringByte");
        properties.add("containsOverprint");
        properties.add("OverprintHasTypeBoolean");
        properties.add("containsSize");
        properties.add("SizeHasTypeArray");
        properties.add("containsTags");
        properties.add("TagsHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVersion");
        properties.add("VersionHasTypeNumber");
        properties.add("VersionNumberValue");
        properties.add("IncludedImageDimensions1IntegerValue");
        properties.add("Size0NumberValue");
        properties.add("IncludedImageDimensions0IntegerValue");
        properties.add("Size1NumberValue");
        properties.add("IncludedImageDimensions1HasTypeInteger");
        properties.add("Size0HasTypeNumber");
        properties.add("IncludedImageDimensions0HasTypeInteger");
        properties.add("Size1HasTypeNumber");
        mapOfProperties.put("AOPIVersion20Dict", properties);
    }

    private static void fillMapOfLinksAOPIVersion20Dict() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("IncludedImageDimensions");
        links.add("Inks");
        links.add("Size");
        links.add("Tags");
        mapOfLinks.put("AOPIVersion20Dict", links);
    }

    private static void fillMapOfSuperNamesAObjectReference() {
        mapOfSuperNames.put("AObjectReference", "AObject");
    }

    private static void fillMapOfPropertiesAObjectReference() {
        properties = new ArrayList<String>();
        properties.add("containsObj");
        properties.add("isObjIndirect");
        properties.add("ObjHasTypeArray");
        properties.add("ObjHasTypeDictionary");
        properties.add("ObjHasTypeStream");
        properties.add("containsPg");
        properties.add("isPgIndirect");
        properties.add("PgHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AObjectReference", properties);
    }

    private static void fillMapOfLinksAObjectReference() {
        links = new ArrayList<String>();
        links.add("Obj");
        links.add("Pg");
        mapOfLinks.put("AObjectReference", links);
    }

    private static void fillMapOfSuperNamesAObjectStream() {
        mapOfSuperNames.put("AObjectStream", "AObject");
    }

    private static void fillMapOfPropertiesAObjectStream() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsExtends");
        properties.add("isExtendsIndirect");
        properties.add("ExtendsHasTypeStream");
        properties.add("ExtendshasCycle");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFirst");
        properties.add("FirstHasTypeInteger");
        properties.add("FirstIntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsN");
        properties.add("NHasTypeInteger");
        properties.add("NIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AObjectStream", properties);
    }

    private static void fillMapOfLinksAObjectStream() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("Extends");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AObjectStream", links);
    }

    private static void fillMapOfSuperNamesAOptContentConfig() {
        mapOfSuperNames.put("AOptContentConfig", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentConfig() {
        properties = new ArrayList<String>();
        properties.add("containsAS");
        properties.add("ASHasTypeArray");
        properties.add("containsBaseState");
        properties.add("BaseStateHasTypeName");
        properties.add("BaseStateNameValue");
        properties.add("containsCreator");
        properties.add("CreatorHasTypeStringText");
        properties.add("containsIntent");
        properties.add("IntentHasTypeArray");
        properties.add("IntentHasTypeName");
        properties.add("IntentNameValue");
        properties.add("containsListMode");
        properties.add("ListModeHasTypeName");
        properties.add("ListModeNameValue");
        properties.add("containsLocked");
        properties.add("LockedHasTypeArray");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsOFF");
        properties.add("OFFHasTypeArray");
        properties.add("containsON");
        properties.add("ONHasTypeArray");
        properties.add("containsOrder");
        properties.add("OrderHasTypeArray");
        properties.add("containsRBGroups");
        properties.add("RBGroupsHasTypeArray");
        mapOfProperties.put("AOptContentConfig", properties);
    }

    private static void fillMapOfLinksAOptContentConfig() {
        links = new ArrayList<String>();
        links.add("AS");
        links.add("Intent");
        links.add("Locked");
        links.add("OFF");
        links.add("ON");
        links.add("Order");
        links.add("RBGroups");
        mapOfLinks.put("AOptContentConfig", links);
    }

    private static void fillMapOfSuperNamesAOptContentCreatorInfo() {
        mapOfSuperNames.put("AOptContentCreatorInfo", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentCreatorInfo() {
        properties = new ArrayList<String>();
        properties.add("containsCreator");
        properties.add("CreatorHasTypeStringText");
        properties.add("containsSubType");
        properties.add("SubTypeHasTypeName");
        properties.add("SubTypeNameValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("hasExtensionMalforms");
        mapOfProperties.put("AOptContentCreatorInfo", properties);
    }

    private static void fillMapOfLinksAOptContentCreatorInfo() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentCreatorInfo", links);
    }

    private static void fillMapOfSuperNamesAOptContentExport() {
        mapOfSuperNames.put("AOptContentExport", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentExport() {
        properties = new ArrayList<String>();
        properties.add("containsExportState");
        properties.add("ExportStateHasTypeName");
        properties.add("ExportStateNameValue");
        mapOfProperties.put("AOptContentExport", properties);
    }

    private static void fillMapOfLinksAOptContentExport() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentExport", links);
    }

    private static void fillMapOfSuperNamesAOptContentGroup() {
        mapOfSuperNames.put("AOptContentGroup", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentGroup() {
        properties = new ArrayList<String>();
        properties.add("containsIntent");
        properties.add("IntentHasTypeArray");
        properties.add("IntentHasTypeName");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUsage");
        properties.add("UsageHasTypeDictionary");
        mapOfProperties.put("AOptContentGroup", properties);
    }

    private static void fillMapOfLinksAOptContentGroup() {
        links = new ArrayList<String>();
        links.add("Intent");
        links.add("Usage");
        mapOfLinks.put("AOptContentGroup", links);
    }

    private static void fillMapOfSuperNamesAOptContentLanguage() {
        mapOfSuperNames.put("AOptContentLanguage", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentLanguage() {
        properties = new ArrayList<String>();
        properties.add("containsLang");
        properties.add("LangHasTypeString");
        properties.add("containsPreferred");
        properties.add("PreferredHasTypeName");
        properties.add("PreferredNameValue");
        mapOfProperties.put("AOptContentLanguage", properties);
    }

    private static void fillMapOfLinksAOptContentLanguage() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentLanguage", links);
    }

    private static void fillMapOfSuperNamesAOptContentMembership() {
        mapOfSuperNames.put("AOptContentMembership", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentMembership() {
        properties = new ArrayList<String>();
        properties.add("containsOCGs");
        properties.add("OCGsHasTypeArray");
        properties.add("OCGsHasTypeDictionary");
        properties.add("OCGsHasTypeNull");
        properties.add("containsP");
        properties.add("PHasTypeName");
        properties.add("PNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVE");
        properties.add("VEHasTypeArray");
        mapOfProperties.put("AOptContentMembership", properties);
    }

    private static void fillMapOfLinksAOptContentMembership() {
        links = new ArrayList<String>();
        links.add("OCGs");
        links.add("VE");
        mapOfLinks.put("AOptContentMembership", links);
    }

    private static void fillMapOfSuperNamesAOptContentPageElement() {
        mapOfSuperNames.put("AOptContentPageElement", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentPageElement() {
        properties = new ArrayList<String>();
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        mapOfProperties.put("AOptContentPageElement", properties);
    }

    private static void fillMapOfLinksAOptContentPageElement() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentPageElement", links);
    }

    private static void fillMapOfSuperNamesAOptContentPrint() {
        mapOfSuperNames.put("AOptContentPrint", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentPrint() {
        properties = new ArrayList<String>();
        properties.add("containsPrintState");
        properties.add("PrintStateHasTypeName");
        properties.add("PrintStateNameValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        mapOfProperties.put("AOptContentPrint", properties);
    }

    private static void fillMapOfLinksAOptContentPrint() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentPrint", links);
    }

    private static void fillMapOfSuperNamesAOptContentProperties() {
        mapOfSuperNames.put("AOptContentProperties", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentProperties() {
        properties = new ArrayList<String>();
        properties.add("containsConfigs");
        properties.add("ConfigsHasTypeArray");
        properties.add("containsD");
        properties.add("DHasTypeDictionary");
        properties.add("containsOCGs");
        properties.add("OCGsHasTypeArray");
        mapOfProperties.put("AOptContentProperties", properties);
    }

    private static void fillMapOfLinksAOptContentProperties() {
        links = new ArrayList<String>();
        links.add("Configs");
        links.add("D");
        links.add("OCGs");
        mapOfLinks.put("AOptContentProperties", links);
    }

    private static void fillMapOfSuperNamesAOptContentUsage() {
        mapOfSuperNames.put("AOptContentUsage", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentUsage() {
        properties = new ArrayList<String>();
        properties.add("containsCreatorInfo");
        properties.add("CreatorInfoHasTypeDictionary");
        properties.add("containsExport");
        properties.add("ExportHasTypeDictionary");
        properties.add("containsLanguage");
        properties.add("LanguageHasTypeDictionary");
        properties.add("containsPageElement");
        properties.add("PageElementHasTypeDictionary");
        properties.add("containsPrint");
        properties.add("PrintHasTypeDictionary");
        properties.add("containsUser");
        properties.add("UserHasTypeDictionary");
        properties.add("containsView");
        properties.add("ViewHasTypeDictionary");
        properties.add("containsZoom");
        properties.add("ZoomHasTypeDictionary");
        mapOfProperties.put("AOptContentUsage", properties);
    }

    private static void fillMapOfLinksAOptContentUsage() {
        links = new ArrayList<String>();
        links.add("CreatorInfo");
        links.add("Export");
        links.add("Language");
        links.add("PageElement");
        links.add("Print");
        links.add("User");
        links.add("View");
        links.add("Zoom");
        mapOfLinks.put("AOptContentUsage", links);
    }

    private static void fillMapOfSuperNamesAOptContentUsageApplication() {
        mapOfSuperNames.put("AOptContentUsageApplication", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentUsageApplication() {
        properties = new ArrayList<String>();
        properties.add("containsCategory");
        properties.add("CategoryHasTypeArray");
        properties.add("containsEvent");
        properties.add("EventHasTypeName");
        properties.add("EventNameValue");
        properties.add("containsOCGs");
        properties.add("OCGsHasTypeArray");
        mapOfProperties.put("AOptContentUsageApplication", properties);
    }

    private static void fillMapOfLinksAOptContentUsageApplication() {
        links = new ArrayList<String>();
        links.add("Category");
        links.add("OCGs");
        mapOfLinks.put("AOptContentUsageApplication", links);
    }

    private static void fillMapOfSuperNamesAOptContentUser() {
        mapOfSuperNames.put("AOptContentUser", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentUser() {
        properties = new ArrayList<String>();
        properties.add("containsName");
        properties.add("NameHasTypeArray");
        properties.add("NameHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AOptContentUser", properties);
    }

    private static void fillMapOfLinksAOptContentUser() {
        links = new ArrayList<String>();
        links.add("Name");
        mapOfLinks.put("AOptContentUser", links);
    }

    private static void fillMapOfSuperNamesAOptContentView() {
        mapOfSuperNames.put("AOptContentView", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentView() {
        properties = new ArrayList<String>();
        properties.add("containsViewState");
        properties.add("ViewStateHasTypeName");
        properties.add("ViewStateNameValue");
        mapOfProperties.put("AOptContentView", properties);
    }

    private static void fillMapOfLinksAOptContentView() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentView", links);
    }

    private static void fillMapOfSuperNamesAOptContentZoom() {
        mapOfSuperNames.put("AOptContentZoom", "AObject");
    }

    private static void fillMapOfPropertiesAOptContentZoom() {
        properties = new ArrayList<String>();
        properties.add("containsmax");
        properties.add("maxHasTypeNumber");
        properties.add("maxNumberValue");
        properties.add("containsmin");
        properties.add("minHasTypeNumber");
        properties.add("minNumberValue");
        mapOfProperties.put("AOptContentZoom", properties);
    }

    private static void fillMapOfLinksAOptContentZoom() {
        links = new ArrayList<String>();
        mapOfLinks.put("AOptContentZoom", links);
    }

    private static void fillMapOfSuperNamesAOutline() {
        mapOfSuperNames.put("AOutline", "AObject");
    }

    private static void fillMapOfPropertiesAOutline() {
        properties = new ArrayList<String>();
        properties.add("containsCount");
        properties.add("CountHasTypeInteger");
        properties.add("CountIntegerValue");
        properties.add("containsFirst");
        properties.add("isFirstIndirect");
        properties.add("FirstHasTypeDictionary");
        properties.add("containsLast");
        properties.add("isLastIndirect");
        properties.add("LastHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AOutline", properties);
    }

    private static void fillMapOfLinksAOutline() {
        links = new ArrayList<String>();
        links.add("First");
        links.add("Last");
        mapOfLinks.put("AOutline", links);
    }

    private static void fillMapOfSuperNamesAOutlineItem() {
        mapOfSuperNames.put("AOutlineItem", "AObject");
    }

    private static void fillMapOfPropertiesAOutlineItem() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeDictionary");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsCount");
        properties.add("CountHasTypeInteger");
        properties.add("containsDest");
        properties.add("DestHasTypeArray");
        properties.add("DestHasTypeName");
        properties.add("DestHasTypeStringByte");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsFirst");
        properties.add("isFirstIndirect");
        properties.add("FirstHasTypeDictionary");
        properties.add("containsLast");
        properties.add("isLastIndirect");
        properties.add("LastHasTypeDictionary");
        properties.add("containsNext");
        properties.add("isNextIndirect");
        properties.add("NextHasTypeDictionary");
        properties.add("containsParent");
        properties.add("isParentIndirect");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsPrev");
        properties.add("isPrevIndirect");
        properties.add("PrevHasTypeDictionary");
        properties.add("containsSE");
        properties.add("isSEIndirect");
        properties.add("SEHasTypeDictionary");
        properties.add("containsTitle");
        properties.add("TitleHasTypeStringText");
        mapOfProperties.put("AOutlineItem", properties);
    }

    private static void fillMapOfLinksAOutlineItem() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("C");
        links.add("Dest");
        links.add("First");
        links.add("Last");
        links.add("Next");
        links.add("Parent");
        links.add("Prev");
        links.add("SE");
        mapOfLinks.put("AOutlineItem", links);
    }

    private static void fillMapOfSuperNamesAOutputIntents() {
        mapOfSuperNames.put("AOutputIntents", "AObject");
    }

    private static void fillMapOfPropertiesAOutputIntents() {
        properties = new ArrayList<String>();
        properties.add("containsDestOutputProfile");
        properties.add("isDestOutputProfileIndirect");
        properties.add("DestOutputProfileHasTypeStream");
        properties.add("containsDestOutputProfileRef");
        properties.add("DestOutputProfileRefHasTypeDictionary");
        properties.add("containsInfo");
        properties.add("InfoHasTypeStringText");
        properties.add("containsMixingHints");
        properties.add("MixingHintsHasTypeDictionary");
        properties.add("containsOutputCondition");
        properties.add("OutputConditionHasTypeStringText");
        properties.add("containsOutputConditionIdentifier");
        properties.add("OutputConditionIdentifierHasTypeStringText");
        properties.add("containsRegistryName");
        properties.add("RegistryNameHasTypeStringText");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSpectralData");
        properties.add("SpectralDataHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AOutputIntents", properties);
    }

    private static void fillMapOfLinksAOutputIntents() {
        links = new ArrayList<String>();
        links.add("DestOutputProfile");
        links.add("DestOutputProfileRef");
        links.add("MixingHints");
        links.add("SpectralData");
        mapOfLinks.put("AOutputIntents", links);
    }

    private static void fillMapOfSuperNamesAPageLabel() {
        mapOfSuperNames.put("APageLabel", "AObject");
    }

    private static void fillMapOfPropertiesAPageLabel() {
        properties = new ArrayList<String>();
        properties.add("containsP");
        properties.add("PHasTypeStringText");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSt");
        properties.add("StHasTypeInteger");
        properties.add("StIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("APageLabel", properties);
    }

    private static void fillMapOfLinksAPageLabel() {
        links = new ArrayList<String>();
        mapOfLinks.put("APageLabel", links);
    }

    private static void fillMapOfSuperNamesAPageObject() {
        mapOfSuperNames.put("APageObject", "AObject");
    }

    private static void fillMapOfPropertiesAPageObject() {
        properties = new ArrayList<String>();
        properties.add("containsAA");
        properties.add("AAHasTypeDictionary");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAnnots");
        properties.add("AnnotsHasTypeArray");
        properties.add("containsArtBox");
        properties.add("ArtBoxHasTypeRectangle");
        properties.add("containsB");
        properties.add("BHasTypeArray");
        properties.add("containsBleedBox");
        properties.add("BleedBoxHasTypeRectangle");
        properties.add("containsBoxColorInfo");
        properties.add("BoxColorInfoHasTypeDictionary");
        properties.add("containsContents");
        properties.add("isContentsIndirect");
        properties.add("ContentsHasTypeArray");
        properties.add("ContentsHasTypeStream");
        properties.add("containsCropBox");
        properties.add("CropBoxHasTypeRectangle");
        properties.add("containsDPart");
        properties.add("DPartHasTypeDictionary");
        properties.add("containsDur");
        properties.add("DurHasTypeNumber");
        properties.add("containsGroup");
        properties.add("GroupHasTypeDictionary");
        properties.add("containsHid");
        properties.add("HidHasTypeBoolean");
        properties.add("containsID");
        properties.add("entryIDHasTypeStringByte");
        properties.add("containsLastModified");
        properties.add("LastModifiedHasTypeDate");
        properties.add("containsMediaBox");
        properties.add("MediaBoxHasTypeRectangle");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsOutputIntents");
        properties.add("OutputIntentsHasTypeArray");
        properties.add("containsPZ");
        properties.add("PZHasTypeNumber");
        properties.add("containsParent");
        properties.add("isParentIndirect");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsPieceInfo");
        properties.add("PieceInfoHasTypeDictionary");
        properties.add("containsPresSteps");
        properties.add("PresStepsHasTypeDictionary");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsRotate");
        properties.add("RotateHasTypeInteger");
        properties.add("RotateIntegerValue");
        properties.add("containsSeparationInfo");
        properties.add("SeparationInfoHasTypeDictionary");
        properties.add("containsStructParents");
        properties.add("StructParentsHasTypeInteger");
        properties.add("containsTabs");
        properties.add("TabsHasTypeName");
        properties.add("TabsNameValue");
        properties.add("containsTemplateInstantiated");
        properties.add("TemplateInstantiatedHasTypeName");
        properties.add("TemplateInstantiatedEntryIsIndexInNameTreetrailerCatalogNamesPages");
        properties.add("TemplateInstantiatedEntryIsIndexInNameTreetrailerCatalogNamesTemplates");
        properties.add("containsThumb");
        properties.add("isThumbIndirect");
        properties.add("ThumbHasTypeStream");
        properties.add("containsTrans");
        properties.add("TransHasTypeDictionary");
        properties.add("containsTrimBox");
        properties.add("TrimBoxHasTypeRectangle");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsUserUnit");
        properties.add("UserUnitHasTypeNumber");
        properties.add("containsVP");
        properties.add("VPHasTypeArray");
        properties.add("pageContainsStructContentItems");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("APageObject", properties);
    }

    private static void fillMapOfLinksAPageObject() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("AF");
        links.add("Annots");
        links.add("B");
        links.add("BoxColorInfo");
        links.add("Contents");
        links.add("DPart");
        links.add("Group");
        links.add("Metadata");
        links.add("OutputIntents");
        links.add("Parent");
        links.add("PieceInfo");
        links.add("PresSteps");
        links.add("Resources");
        links.add("SeparationInfo");
        links.add("Thumb");
        links.add("Trans");
        links.add("VP");
        mapOfLinks.put("APageObject", links);
    }

    private static void fillMapOfSuperNamesAPagePiece() {
        mapOfSuperNames.put("APagePiece", "AObject");
    }

    private static void fillMapOfPropertiesAPagePiece() {
        properties = new ArrayList<String>();
        mapOfProperties.put("APagePiece", properties);
    }

    private static void fillMapOfLinksAPagePiece() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("APagePiece", links);
    }

    private static void fillMapOfSuperNamesAPagePieceEntry() {
        mapOfSuperNames.put("APagePieceEntry", "AObject");
    }

    private static void fillMapOfPropertiesAPagePieceEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("APagePieceEntry", properties);
    }

    private static void fillMapOfLinksAPagePieceEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("APagePieceEntry", links);
    }

    private static void fillMapOfSuperNamesAPageTreeNode() {
        mapOfSuperNames.put("APageTreeNode", "AObject");
    }

    private static void fillMapOfPropertiesAPageTreeNode() {
        properties = new ArrayList<String>();
        properties.add("containsCount");
        properties.add("CountHasTypeInteger");
        properties.add("CountIntegerValue");
        properties.add("containsCropBox");
        properties.add("CropBoxHasTypeRectangle");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsMediaBox");
        properties.add("MediaBoxHasTypeRectangle");
        properties.add("containsParent");
        properties.add("isParentIndirect");
        properties.add("ParentHasTypeDictionary");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsRotate");
        properties.add("RotateHasTypeInteger");
        properties.add("RotateIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("APageTreeNode", properties);
    }

    private static void fillMapOfLinksAPageTreeNode() {
        links = new ArrayList<String>();
        links.add("Kids");
        links.add("Parent");
        links.add("Resources");
        mapOfLinks.put("APageTreeNode", links);
    }

    private static void fillMapOfSuperNamesAPageTreeNodeRoot() {
        mapOfSuperNames.put("APageTreeNodeRoot", "AObject");
    }

    private static void fillMapOfPropertiesAPageTreeNodeRoot() {
        properties = new ArrayList<String>();
        properties.add("containsCount");
        properties.add("CountHasTypeInteger");
        properties.add("CountIntegerValue");
        properties.add("containsCropBox");
        properties.add("CropBoxHasTypeRectangle");
        properties.add("containsKids");
        properties.add("KidsHasTypeArray");
        properties.add("containsMediaBox");
        properties.add("MediaBoxHasTypeRectangle");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsRotate");
        properties.add("RotateHasTypeInteger");
        properties.add("RotateIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("APageTreeNodeRoot", properties);
    }

    private static void fillMapOfLinksAPageTreeNodeRoot() {
        links = new ArrayList<String>();
        links.add("Kids");
        links.add("Resources");
        mapOfLinks.put("APageTreeNodeRoot", links);
    }

    private static void fillMapOfSuperNamesAPaperMetaData() {
        mapOfSuperNames.put("APaperMetaData", "AObject");
    }

    private static void fillMapOfPropertiesAPaperMetaData() {
        properties = new ArrayList<String>();
        properties.add("containsCaption");
        properties.add("CaptionHasTypeStringText");
        properties.add("containsECC");
        properties.add("ECCHasTypeInteger");
        properties.add("ECCIntegerValue");
        properties.add("containsHeight");
        properties.add("HeightHasTypeNumber");
        properties.add("HeightNumberValue");
        properties.add("containsResolution");
        properties.add("ResolutionHasTypeNumber");
        properties.add("ResolutionNumberValue");
        properties.add("containsSymbology");
        properties.add("SymbologyHasTypeName");
        properties.add("SymbologyNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVersion");
        properties.add("VersionHasTypeNumber");
        properties.add("VersionNumberValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeNumber");
        properties.add("WidthNumberValue");
        properties.add("containsXSymWidth");
        properties.add("XSymWidthHasTypeInteger");
        properties.add("XSymWidthIntegerValue");
        properties.add("containsYSymHeight");
        properties.add("YSymHeightHasTypeInteger");
        properties.add("YSymHeightIntegerValue");
        properties.add("containsnCodeWordCol");
        properties.add("nCodeWordColHasTypeNumber");
        properties.add("containsnCodeWordRow");
        properties.add("nCodeWordRowHasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("APaperMetaData", properties);
    }

    private static void fillMapOfLinksAPaperMetaData() {
        links = new ArrayList<String>();
        mapOfLinks.put("APaperMetaData", links);
    }

    private static void fillMapOfSuperNamesAPatternColorSpace() {
        mapOfSuperNames.put("APatternColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesAPatternColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeArray");
        properties.add("entry1HasTypeName");
        properties.add("entry1NameValue");
        mapOfProperties.put("APatternColorSpace", properties);
    }

    private static void fillMapOfLinksAPatternColorSpace() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("APatternColorSpace", links);
    }

    private static void fillMapOfSuperNamesAPatternMap() {
        mapOfSuperNames.put("APatternMap", "AObject");
    }

    private static void fillMapOfPropertiesAPatternMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("APatternMap", properties);
    }

    private static void fillMapOfLinksAPatternMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("APatternMap", links);
    }

    private static void fillMapOfSuperNamesAPatternMapEntry() {
        mapOfSuperNames.put("APatternMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAPatternMapEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("APatternMapEntry", properties);
    }

    private static void fillMapOfLinksAPatternMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("APatternMapEntry", links);
    }

    private static void fillMapOfSuperNamesAPatternType1() {
        mapOfSuperNames.put("APatternType1", "AObject");
    }

    private static void fillMapOfPropertiesAPatternType1() {
        properties = new ArrayList<String>();
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsPaintType");
        properties.add("PaintTypeHasTypeInteger");
        properties.add("PaintTypeIntegerValue");
        properties.add("containsPatternType");
        properties.add("PatternTypeHasTypeInteger");
        properties.add("PatternTypeIntegerValue");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsTilingType");
        properties.add("TilingTypeHasTypeInteger");
        properties.add("TilingTypeIntegerValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXStep");
        properties.add("XStepHasTypeNumber");
        properties.add("containsXUID");
        properties.add("XUIDHasTypeArray");
        properties.add("containsYStep");
        properties.add("YStepHasTypeNumber");
        mapOfProperties.put("APatternType1", properties);
    }

    private static void fillMapOfLinksAPatternType1() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Resources");
        links.add("XUID");
        mapOfLinks.put("APatternType1", links);
    }

    private static void fillMapOfSuperNamesAPatternType2() {
        mapOfSuperNames.put("APatternType2", "AObject");
    }

    private static void fillMapOfPropertiesAPatternType2() {
        properties = new ArrayList<String>();
        properties.add("containsExtGState");
        properties.add("ExtGStateHasTypeDictionary");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsPatternType");
        properties.add("PatternTypeHasTypeInteger");
        properties.add("PatternTypeIntegerValue");
        properties.add("containsShading");
        properties.add("isShadingIndirect");
        properties.add("ShadingHasTypeDictionary");
        properties.add("ShadingHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("APatternType2", properties);
    }

    private static void fillMapOfLinksAPatternType2() {
        links = new ArrayList<String>();
        links.add("ExtGState");
        links.add("Shading");
        mapOfLinks.put("APatternType2", links);
    }

    private static void fillMapOfSuperNamesAPermissions() {
        mapOfSuperNames.put("APermissions", "AObject");
    }

    private static void fillMapOfPropertiesAPermissions() {
        properties = new ArrayList<String>();
        properties.add("containsDocMDP");
        properties.add("isDocMDPIndirect");
        properties.add("DocMDPHasTypeDictionary");
        properties.add("containsUR3");
        properties.add("UR3HasTypeDictionary");
        properties.add("DocMDPReferenceArraySize");
        properties.add("UR3Reference0TransformMethodNameValue");
        properties.add("DocMDPReferenceHasTypeArray");
        mapOfProperties.put("APermissions", properties);
    }

    private static void fillMapOfLinksAPermissions() {
        links = new ArrayList<String>();
        links.add("DocMDP");
        links.add("UR3");
        mapOfLinks.put("APermissions", links);
    }

    private static void fillMapOfSuperNamesAPointData() {
        mapOfSuperNames.put("APointData", "AObject");
    }

    private static void fillMapOfPropertiesAPointData() {
        properties = new ArrayList<String>();
        properties.add("containsNames");
        properties.add("NamesHasTypeArray");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXPTS");
        properties.add("XPTSHasTypeArray");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("APointData", properties);
    }

    private static void fillMapOfLinksAPointData() {
        links = new ArrayList<String>();
        links.add("Names");
        links.add("XPTS");
        mapOfLinks.put("APointData", links);
    }

    private static void fillMapOfSuperNamesAProjectedCoordinateSystem() {
        mapOfSuperNames.put("AProjectedCoordinateSystem", "AObject");
    }

    private static void fillMapOfPropertiesAProjectedCoordinateSystem() {
        properties = new ArrayList<String>();
        properties.add("containsEPSG");
        properties.add("EPSGHasTypeInteger");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWKT");
        properties.add("WKTHasTypeStringAscii");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AProjectedCoordinateSystem", properties);
    }

    private static void fillMapOfLinksAProjectedCoordinateSystem() {
        links = new ArrayList<String>();
        mapOfLinks.put("AProjectedCoordinateSystem", links);
    }

    private static void fillMapOfSuperNamesAProjection() {
        mapOfSuperNames.put("AProjection", "AObject");
    }

    private static void fillMapOfPropertiesAProjection() {
        properties = new ArrayList<String>();
        properties.add("containsCS");
        properties.add("CSHasTypeName");
        properties.add("CSNameValue");
        properties.add("containsF");
        properties.add("FHasTypeNumber");
        properties.add("containsFOV");
        properties.add("FOVHasTypeNumber");
        properties.add("FOVNumberValue");
        properties.add("containsN");
        properties.add("NHasTypeNumber");
        properties.add("NNumberValue");
        properties.add("containsOB");
        properties.add("OBHasTypeName");
        properties.add("OBNameValue");
        properties.add("containsOS");
        properties.add("OSHasTypeNumber");
        properties.add("OSNumberValue");
        properties.add("containsPS");
        properties.add("PSHasTypeName");
        properties.add("PSHasTypeNumber");
        properties.add("PSNumberValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        mapOfProperties.put("AProjection", properties);
    }

    private static void fillMapOfLinksAProjection() {
        links = new ArrayList<String>();
        mapOfLinks.put("AProjection", links);
    }

    private static void fillMapOfSuperNamesAReference() {
        mapOfSuperNames.put("AReference", "AObject");
    }

    private static void fillMapOfPropertiesAReference() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsID");
        properties.add("entryIDHasTypeArray");
        properties.add("containsPage");
        properties.add("PageHasTypeInteger");
        properties.add("PageHasTypeStringText");
        properties.add("PageIntegerValue");
        mapOfProperties.put("AReference", properties);
    }

    private static void fillMapOfLinksAReference() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("entryID");
        mapOfLinks.put("AReference", links);
    }

    private static void fillMapOfSuperNamesARelatedFilesArray() {
        mapOfSuperNames.put("ARelatedFilesArray", "AObject");
    }

    private static void fillMapOfPropertiesARelatedFilesArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ARelatedFilesArray", properties);
    }

    private static void fillMapOfLinksARelatedFilesArray() {
        links = new ArrayList<String>();
        links.add("subArrays");
        mapOfLinks.put("ARelatedFilesArray", links);
    }

    private static void fillMapOfSuperNamesARelatedFilesArraySubArray() {
        mapOfSuperNames.put("ARelatedFilesArraySubArray", "AObject");
    }

    private static void fillMapOfPropertiesARelatedFilesArraySubArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeString");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeStream");
        mapOfProperties.put("ARelatedFilesArraySubArray", properties);
    }

    private static void fillMapOfLinksARelatedFilesArraySubArray() {
        links = new ArrayList<String>();
        links.add("entry1");
        mapOfLinks.put("ARelatedFilesArraySubArray", links);
    }

    private static void fillMapOfSuperNamesARenditionBE() {
        mapOfSuperNames.put("ARenditionBE", "AObject");
    }

    private static void fillMapOfPropertiesARenditionBE() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeDictionary");
        mapOfProperties.put("ARenditionBE", properties);
    }

    private static void fillMapOfLinksARenditionBE() {
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("ARenditionBE", links);
    }

    private static void fillMapOfSuperNamesARenditionMH() {
        mapOfSuperNames.put("ARenditionMH", "AObject");
    }

    private static void fillMapOfPropertiesARenditionMH() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeDictionary");
        mapOfProperties.put("ARenditionMH", properties);
    }

    private static void fillMapOfLinksARenditionMH() {
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("ARenditionMH", links);
    }

    private static void fillMapOfSuperNamesARenditionMedia() {
        mapOfSuperNames.put("ARenditionMedia", "AObject");
    }

    private static void fillMapOfPropertiesARenditionMedia() {
        properties = new ArrayList<String>();
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsC");
        properties.add("CHasTypeDictionary");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsN");
        properties.add("NHasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSP");
        properties.add("SPHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ARenditionMedia", properties);
    }

    private static void fillMapOfLinksARenditionMedia() {
        links = new ArrayList<String>();
        links.add("BE");
        links.add("C");
        links.add("MH");
        links.add("P");
        links.add("SP");
        mapOfLinks.put("ARenditionMedia", links);
    }

    private static void fillMapOfSuperNamesARenditionSelector() {
        mapOfSuperNames.put("ARenditionSelector", "AObject");
    }

    private static void fillMapOfPropertiesARenditionSelector() {
        properties = new ArrayList<String>();
        properties.add("containsBE");
        properties.add("BEHasTypeDictionary");
        properties.add("containsMH");
        properties.add("MHHasTypeDictionary");
        properties.add("containsN");
        properties.add("NHasTypeStringText");
        properties.add("containsR");
        properties.add("RHasTypeArray");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ARenditionSelector", properties);
    }

    private static void fillMapOfLinksARenditionSelector() {
        links = new ArrayList<String>();
        links.add("BE");
        links.add("MH");
        links.add("R");
        mapOfLinks.put("ARenditionSelector", links);
    }

    private static void fillMapOfSuperNamesARequirements3DMarkup() {
        mapOfSuperNames.put("ARequirements3DMarkup", "AObject");
    }

    private static void fillMapOfPropertiesARequirements3DMarkup() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirements3DMarkup", properties);
    }

    private static void fillMapOfLinksARequirements3DMarkup() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirements3DMarkup", links);
    }

    private static void fillMapOfSuperNamesARequirementsAcroFormInteract() {
        mapOfSuperNames.put("ARequirementsAcroFormInteract", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsAcroFormInteract() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsAcroFormInteract", properties);
    }

    private static void fillMapOfLinksARequirementsAcroFormInteract() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsAcroFormInteract", links);
    }

    private static void fillMapOfSuperNamesARequirementsAction() {
        mapOfSuperNames.put("ARequirementsAction", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsAction() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsAction", properties);
    }

    private static void fillMapOfLinksARequirementsAction() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsAction", links);
    }

    private static void fillMapOfSuperNamesARequirementsAttachment() {
        mapOfSuperNames.put("ARequirementsAttachment", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsAttachment() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsAttachment", properties);
    }

    private static void fillMapOfLinksARequirementsAttachment() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsAttachment", links);
    }

    private static void fillMapOfSuperNamesARequirementsAttachmentEditing() {
        mapOfSuperNames.put("ARequirementsAttachmentEditing", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsAttachmentEditing() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsAttachmentEditing", properties);
    }

    private static void fillMapOfLinksARequirementsAttachmentEditing() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsAttachmentEditing", links);
    }

    private static void fillMapOfSuperNamesARequirementsCollection() {
        mapOfSuperNames.put("ARequirementsCollection", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsCollection() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsCollection", properties);
    }

    private static void fillMapOfLinksARequirementsCollection() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsCollection", links);
    }

    private static void fillMapOfSuperNamesARequirementsCollectionEditing() {
        mapOfSuperNames.put("ARequirementsCollectionEditing", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsCollectionEditing() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsCollectionEditing", properties);
    }

    private static void fillMapOfLinksARequirementsCollectionEditing() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsCollectionEditing", links);
    }

    private static void fillMapOfSuperNamesARequirementsDPartInteract() {
        mapOfSuperNames.put("ARequirementsDPartInteract", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsDPartInteract() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsDPartInteract", properties);
    }

    private static void fillMapOfLinksARequirementsDPartInteract() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsDPartInteract", links);
    }

    private static void fillMapOfSuperNamesARequirementsDigSig() {
        mapOfSuperNames.put("ARequirementsDigSig", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsDigSig() {
        properties = new ArrayList<String>();
        properties.add("containsDigSig");
        properties.add("DigSigHasTypeDictionary");
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsDigSig", properties);
    }

    private static void fillMapOfLinksARequirementsDigSig() {
        links = new ArrayList<String>();
        links.add("DigSig");
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsDigSig", links);
    }

    private static void fillMapOfSuperNamesARequirementsDigSigMDP() {
        mapOfSuperNames.put("ARequirementsDigSigMDP", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsDigSigMDP() {
        properties = new ArrayList<String>();
        properties.add("containsDigSig");
        properties.add("DigSigHasTypeDictionary");
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsDigSigMDP", properties);
    }

    private static void fillMapOfLinksARequirementsDigSigMDP() {
        links = new ArrayList<String>();
        links.add("DigSig");
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsDigSigMDP", links);
    }

    private static void fillMapOfSuperNamesARequirementsDigSigValidation() {
        mapOfSuperNames.put("ARequirementsDigSigValidation", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsDigSigValidation() {
        properties = new ArrayList<String>();
        properties.add("containsDigSig");
        properties.add("DigSigHasTypeDictionary");
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsDigSigValidation", properties);
    }

    private static void fillMapOfLinksARequirementsDigSigValidation() {
        links = new ArrayList<String>();
        links.add("DigSig");
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsDigSigValidation", links);
    }

    private static void fillMapOfSuperNamesARequirementsEnableJavaScripts() {
        mapOfSuperNames.put("ARequirementsEnableJavaScripts", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsEnableJavaScripts() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsEnableJavaScripts", properties);
    }

    private static void fillMapOfLinksARequirementsEnableJavaScripts() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsEnableJavaScripts", links);
    }

    private static void fillMapOfSuperNamesARequirementsEncryption() {
        mapOfSuperNames.put("ARequirementsEncryption", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsEncryption() {
        properties = new ArrayList<String>();
        properties.add("containsEncrypt");
        properties.add("EncryptHasTypeDictionary");
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsEncryption", properties);
    }

    private static void fillMapOfLinksARequirementsEncryption() {
        links = new ArrayList<String>();
        links.add("Encrypt");
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsEncryption", links);
    }

    private static void fillMapOfSuperNamesARequirementsGeospatial2D() {
        mapOfSuperNames.put("ARequirementsGeospatial2D", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsGeospatial2D() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsGeospatial2D", properties);
    }

    private static void fillMapOfLinksARequirementsGeospatial2D() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsGeospatial2D", links);
    }

    private static void fillMapOfSuperNamesARequirementsGeospatial3D() {
        mapOfSuperNames.put("ARequirementsGeospatial3D", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsGeospatial3D() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsGeospatial3D", properties);
    }

    private static void fillMapOfLinksARequirementsGeospatial3D() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsGeospatial3D", links);
    }

    private static void fillMapOfSuperNamesARequirementsHandler() {
        mapOfSuperNames.put("ARequirementsHandler", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsHandler() {
        properties = new ArrayList<String>();
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsScript");
        properties.add("ScriptHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ARequirementsHandler", properties);
    }

    private static void fillMapOfLinksARequirementsHandler() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARequirementsHandler", links);
    }

    private static void fillMapOfSuperNamesARequirementsMarkup() {
        mapOfSuperNames.put("ARequirementsMarkup", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsMarkup() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsMarkup", properties);
    }

    private static void fillMapOfLinksARequirementsMarkup() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsMarkup", links);
    }

    private static void fillMapOfSuperNamesARequirementsMultimedia() {
        mapOfSuperNames.put("ARequirementsMultimedia", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsMultimedia() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsMultimedia", properties);
    }

    private static void fillMapOfLinksARequirementsMultimedia() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsMultimedia", links);
    }

    private static void fillMapOfSuperNamesARequirementsNavigation() {
        mapOfSuperNames.put("ARequirementsNavigation", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsNavigation() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsNavigation", properties);
    }

    private static void fillMapOfLinksARequirementsNavigation() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsNavigation", links);
    }

    private static void fillMapOfSuperNamesARequirementsOCAutoStates() {
        mapOfSuperNames.put("ARequirementsOCAutoStates", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsOCAutoStates() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsOCAutoStates", properties);
    }

    private static void fillMapOfLinksARequirementsOCAutoStates() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsOCAutoStates", links);
    }

    private static void fillMapOfSuperNamesARequirementsOCInteract() {
        mapOfSuperNames.put("ARequirementsOCInteract", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsOCInteract() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsOCInteract", properties);
    }

    private static void fillMapOfLinksARequirementsOCInteract() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsOCInteract", links);
    }

    private static void fillMapOfSuperNamesARequirementsPRC() {
        mapOfSuperNames.put("ARequirementsPRC", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsPRC() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsPRC", properties);
    }

    private static void fillMapOfLinksARequirementsPRC() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsPRC", links);
    }

    private static void fillMapOfSuperNamesARequirementsRichMedia() {
        mapOfSuperNames.put("ARequirementsRichMedia", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsRichMedia() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsRichMedia", properties);
    }

    private static void fillMapOfLinksARequirementsRichMedia() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsRichMedia", links);
    }

    private static void fillMapOfSuperNamesARequirementsSTEP() {
        mapOfSuperNames.put("ARequirementsSTEP", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsSTEP() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        properties.add("hasExtensionISO_TS_24064");
        mapOfProperties.put("ARequirementsSTEP", properties);
    }

    private static void fillMapOfLinksARequirementsSTEP() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsSTEP", links);
    }

    private static void fillMapOfSuperNamesARequirementsSeparationSimulation() {
        mapOfSuperNames.put("ARequirementsSeparationSimulation", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsSeparationSimulation() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsSeparationSimulation", properties);
    }

    private static void fillMapOfLinksARequirementsSeparationSimulation() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsSeparationSimulation", links);
    }

    private static void fillMapOfSuperNamesARequirementsTransitions() {
        mapOfSuperNames.put("ARequirementsTransitions", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsTransitions() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsTransitions", properties);
    }

    private static void fillMapOfLinksARequirementsTransitions() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsTransitions", links);
    }

    private static void fillMapOfSuperNamesARequirementsU3D() {
        mapOfSuperNames.put("ARequirementsU3D", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsU3D() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        mapOfProperties.put("ARequirementsU3D", properties);
    }

    private static void fillMapOfLinksARequirementsU3D() {
        links = new ArrayList<String>();
        links.add("RH");
        links.add("V");
        mapOfLinks.put("ARequirementsU3D", links);
    }

    private static void fillMapOfSuperNamesARequirementsglTF() {
        mapOfSuperNames.put("ARequirementsglTF", "AObject");
    }

    private static void fillMapOfPropertiesARequirementsglTF() {
        properties = new ArrayList<String>();
        properties.add("containsPenalty");
        properties.add("PenaltyHasTypeInteger");
        properties.add("PenaltyIntegerValue");
        properties.add("containsRH");
        properties.add("RHHasTypeArray");
        properties.add("RHHasTypeDictionary");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeName");
        properties.add("VNameValue");
        mapOfProperties.put("ARequirementsglTF", properties);
    }

    private static void fillMapOfLinksARequirementsglTF() {
        links = new ArrayList<String>();
        links.add("RH");
        mapOfLinks.put("ARequirementsglTF", links);
    }

    private static void fillMapOfSuperNamesAResource() {
        mapOfSuperNames.put("AResource", "AObject");
    }

    private static void fillMapOfPropertiesAResource() {
        properties = new ArrayList<String>();
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeDictionary");
        properties.add("containsExtGState");
        properties.add("ExtGStateHasTypeDictionary");
        properties.add("containsFont");
        properties.add("FontHasTypeDictionary");
        properties.add("containsPattern");
        properties.add("PatternHasTypeDictionary");
        properties.add("containsProcSet");
        properties.add("ProcSetHasTypeArray");
        properties.add("containsProperties");
        properties.add("entryPropertiesHasTypeDictionary");
        properties.add("containsShading");
        properties.add("ShadingHasTypeDictionary");
        properties.add("containsXObject");
        properties.add("XObjectHasTypeDictionary");
        mapOfProperties.put("AResource", properties);
    }

    private static void fillMapOfLinksAResource() {
        links = new ArrayList<String>();
        links.add("ColorSpace");
        links.add("ExtGState");
        links.add("Font");
        links.add("Pattern");
        links.add("ProcSet");
        links.add("entryProperties");
        links.add("Shading");
        links.add("XObject");
        mapOfLinks.put("AResource", links);
    }

    private static void fillMapOfSuperNamesARichMediaActivation() {
        mapOfSuperNames.put("ARichMediaActivation", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaActivation() {
        properties = new ArrayList<String>();
        properties.add("containsAnimation");
        properties.add("AnimationHasTypeDictionary");
        properties.add("containsCondition");
        properties.add("ConditionHasTypeName");
        properties.add("ConditionNameValue");
        properties.add("containsConfiguration");
        properties.add("isConfigurationIndirect");
        properties.add("ConfigurationHasTypeDictionary");
        properties.add("containsPresentation");
        properties.add("PresentationHasTypeDictionary");
        properties.add("containsScripts");
        properties.add("ScriptsHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsView");
        properties.add("isViewIndirect");
        properties.add("ViewHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaActivation", properties);
    }

    private static void fillMapOfLinksARichMediaActivation() {
        links = new ArrayList<String>();
        links.add("Animation");
        links.add("Configuration");
        links.add("Presentation");
        links.add("Scripts");
        links.add("View");
        mapOfLinks.put("ARichMediaActivation", links);
    }

    private static void fillMapOfSuperNamesARichMediaAnimation() {
        mapOfSuperNames.put("ARichMediaAnimation", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaAnimation() {
        properties = new ArrayList<String>();
        properties.add("containsAO");
        properties.add("AOHasTypeInteger");
        properties.add("AOIntegerValue");
        properties.add("containsPlayCount");
        properties.add("PlayCountHasTypeInteger");
        properties.add("containsSpeed");
        properties.add("SpeedHasTypeNumber");
        properties.add("SpeedNumberValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        properties.add("hasExtensionISO_TS_32007");
        mapOfProperties.put("ARichMediaAnimation", properties);
    }

    private static void fillMapOfLinksARichMediaAnimation() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARichMediaAnimation", links);
    }

    private static void fillMapOfSuperNamesARichMediaCommand() {
        mapOfSuperNames.put("ARichMediaCommand", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaCommand() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeArray");
        properties.add("AHasTypeBoolean");
        properties.add("AHasTypeInteger");
        properties.add("AHasTypeNumber");
        properties.add("AHasTypeStringText");
        properties.add("containsC");
        properties.add("CHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaCommand", properties);
    }

    private static void fillMapOfLinksARichMediaCommand() {
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("ARichMediaCommand", links);
    }

    private static void fillMapOfSuperNamesARichMediaCommandArray() {
        mapOfSuperNames.put("ARichMediaCommandArray", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaCommandArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ARichMediaCommandArray", properties);
    }

    private static void fillMapOfLinksARichMediaCommandArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ARichMediaCommandArray", links);
    }

    private static void fillMapOfSuperNamesARichMediaCommandArrayEntry() {
        mapOfSuperNames.put("ARichMediaCommandArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaCommandArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeBoolean");
        properties.add("HasTypeInteger");
        properties.add("HasTypeNumber");
        properties.add("HasTypeStringText");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaCommandArrayEntry", properties);
    }

    private static void fillMapOfLinksARichMediaCommandArrayEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARichMediaCommandArrayEntry", links);
    }

    private static void fillMapOfSuperNamesARichMediaConfiguration() {
        mapOfSuperNames.put("ARichMediaConfiguration", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaConfiguration() {
        properties = new ArrayList<String>();
        properties.add("containsInstances");
        properties.add("InstancesHasTypeArray");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaConfiguration", properties);
    }

    private static void fillMapOfLinksARichMediaConfiguration() {
        links = new ArrayList<String>();
        links.add("Instances");
        mapOfLinks.put("ARichMediaConfiguration", links);
    }

    private static void fillMapOfSuperNamesARichMediaContent() {
        mapOfSuperNames.put("ARichMediaContent", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaContent() {
        properties = new ArrayList<String>();
        properties.add("containsAssets");
        properties.add("AssetsHasTypeNameTree");
        properties.add("containsConfigurations");
        properties.add("ConfigurationsHasTypeArray");
        properties.add("ConfigurationsArraySize");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsViews");
        properties.add("ViewsHasTypeArray");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaContent", properties);
    }

    private static void fillMapOfLinksARichMediaContent() {
        links = new ArrayList<String>();
        links.add("Assets");
        links.add("Configurations");
        links.add("Views");
        mapOfLinks.put("ARichMediaContent", links);
    }

    private static void fillMapOfSuperNamesARichMediaContentNameTreeAssets() {
        mapOfSuperNames.put("ARichMediaContentNameTreeAssets", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaContentNameTreeAssets() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ARichMediaContentNameTreeAssets", properties);
    }

    private static void fillMapOfLinksARichMediaContentNameTreeAssets() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ARichMediaContentNameTreeAssets", links);
    }

    private static void fillMapOfSuperNamesARichMediaContentNameTreeAssetsEntry() {
        mapOfSuperNames.put("ARichMediaContentNameTreeAssetsEntry", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaContentNameTreeAssetsEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("ARichMediaContentNameTreeAssetsEntry", properties);
    }

    private static void fillMapOfLinksARichMediaContentNameTreeAssetsEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ARichMediaContentNameTreeAssetsEntry", links);
    }

    private static void fillMapOfSuperNamesARichMediaCuePoint() {
        mapOfSuperNames.put("ARichMediaCuePoint", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaCuePoint() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeDictionary");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTime");
        properties.add("TimeHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaCuePoint", properties);
    }

    private static void fillMapOfLinksARichMediaCuePoint() {
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("ARichMediaCuePoint", links);
    }

    private static void fillMapOfSuperNamesARichMediaDeactivation() {
        mapOfSuperNames.put("ARichMediaDeactivation", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaDeactivation() {
        properties = new ArrayList<String>();
        properties.add("containsCondition");
        properties.add("ConditionHasTypeName");
        properties.add("ConditionNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaDeactivation", properties);
    }

    private static void fillMapOfLinksARichMediaDeactivation() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARichMediaDeactivation", links);
    }

    private static void fillMapOfSuperNamesARichMediaHeight() {
        mapOfSuperNames.put("ARichMediaHeight", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaHeight() {
        properties = new ArrayList<String>();
        properties.add("containsDefault");
        properties.add("DefaultHasTypeInteger");
        properties.add("DefaultIntegerValue");
        properties.add("containsMax");
        properties.add("MaxHasTypeInteger");
        properties.add("MaxIntegerValue");
        properties.add("containsMin");
        properties.add("MinHasTypeInteger");
        properties.add("MinIntegerValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaHeight", properties);
    }

    private static void fillMapOfLinksARichMediaHeight() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARichMediaHeight", links);
    }

    private static void fillMapOfSuperNamesARichMediaInstance() {
        mapOfSuperNames.put("ARichMediaInstance", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaInstance() {
        properties = new ArrayList<String>();
        properties.add("containsAsset");
        properties.add("AssetHasTypeDictionary");
        properties.add("containsParams");
        properties.add("ParamsHasTypeDictionary");
        properties.add("containsScene");
        properties.add("SceneHasTypeInteger");
        properties.add("SceneIntegerValue");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        properties.add("hasExtensionISO_TS_32007");
        mapOfProperties.put("ARichMediaInstance", properties);
    }

    private static void fillMapOfLinksARichMediaInstance() {
        links = new ArrayList<String>();
        links.add("Asset");
        links.add("Params");
        mapOfLinks.put("ARichMediaInstance", links);
    }

    private static void fillMapOfSuperNamesARichMediaParams() {
        mapOfSuperNames.put("ARichMediaParams", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaParams() {
        properties = new ArrayList<String>();
        properties.add("containsBinding");
        properties.add("BindingHasTypeName");
        properties.add("BindingNameValue");
        properties.add("containsBindingMaterial");
        properties.add("BindingMaterialHasTypeStringText");
        properties.add("containsCuePoints");
        properties.add("CuePointsHasTypeArray");
        properties.add("containsFlashVars");
        properties.add("isFlashVarsIndirect");
        properties.add("FlashVarsHasTypeStream");
        properties.add("FlashVarsHasTypeStringText");
        properties.add("containsSettings");
        properties.add("isSettingsIndirect");
        properties.add("SettingsHasTypeStream");
        properties.add("SettingsHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaParams", properties);
    }

    private static void fillMapOfLinksARichMediaParams() {
        links = new ArrayList<String>();
        links.add("CuePoints");
        links.add("FlashVars");
        links.add("Settings");
        mapOfLinks.put("ARichMediaParams", links);
    }

    private static void fillMapOfSuperNamesARichMediaPosition() {
        mapOfSuperNames.put("ARichMediaPosition", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaPosition() {
        properties = new ArrayList<String>();
        properties.add("containsHAlign");
        properties.add("HAlignHasTypeName");
        properties.add("HAlignNameValue");
        properties.add("containsHOffset");
        properties.add("HOffsetHasTypeNumber");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsVAlign");
        properties.add("VAlignHasTypeName");
        properties.add("VAlignNameValue");
        properties.add("containsVOffset");
        properties.add("VOffsetHasTypeNumber");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaPosition", properties);
    }

    private static void fillMapOfLinksARichMediaPosition() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARichMediaPosition", links);
    }

    private static void fillMapOfSuperNamesARichMediaPresentation() {
        mapOfSuperNames.put("ARichMediaPresentation", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaPresentation() {
        properties = new ArrayList<String>();
        properties.add("containsNavigationPane");
        properties.add("NavigationPaneHasTypeBoolean");
        properties.add("containsPassContextClick");
        properties.add("PassContextClickHasTypeBoolean");
        properties.add("containsStyle");
        properties.add("StyleHasTypeName");
        properties.add("StyleNameValue");
        properties.add("containsToolbar");
        properties.add("ToolbarHasTypeBoolean");
        properties.add("containsTransparent");
        properties.add("TransparentHasTypeBoolean");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWindow");
        properties.add("WindowHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaPresentation", properties);
    }

    private static void fillMapOfLinksARichMediaPresentation() {
        links = new ArrayList<String>();
        links.add("Window");
        mapOfLinks.put("ARichMediaPresentation", links);
    }

    private static void fillMapOfSuperNamesARichMediaSettings() {
        mapOfSuperNames.put("ARichMediaSettings", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaSettings() {
        properties = new ArrayList<String>();
        properties.add("containsActivation");
        properties.add("ActivationHasTypeDictionary");
        properties.add("containsDeactivation");
        properties.add("DeactivationHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaSettings", properties);
    }

    private static void fillMapOfLinksARichMediaSettings() {
        links = new ArrayList<String>();
        links.add("Activation");
        links.add("Deactivation");
        mapOfLinks.put("ARichMediaSettings", links);
    }

    private static void fillMapOfSuperNamesARichMediaWidth() {
        mapOfSuperNames.put("ARichMediaWidth", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaWidth() {
        properties = new ArrayList<String>();
        properties.add("containsDefault");
        properties.add("DefaultHasTypeInteger");
        properties.add("DefaultIntegerValue");
        properties.add("containsMax");
        properties.add("MaxHasTypeInteger");
        properties.add("MaxIntegerValue");
        properties.add("containsMin");
        properties.add("MinHasTypeInteger");
        properties.add("MinIntegerValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaWidth", properties);
    }

    private static void fillMapOfLinksARichMediaWidth() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARichMediaWidth", links);
    }

    private static void fillMapOfSuperNamesARichMediaWindow() {
        mapOfSuperNames.put("ARichMediaWindow", "AObject");
    }

    private static void fillMapOfPropertiesARichMediaWindow() {
        properties = new ArrayList<String>();
        properties.add("containsHeight");
        properties.add("HeightHasTypeDictionary");
        properties.add("containsPosition");
        properties.add("PositionHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ARichMediaWindow", properties);
    }

    private static void fillMapOfLinksARichMediaWindow() {
        links = new ArrayList<String>();
        links.add("Height");
        links.add("Position");
        links.add("Width");
        mapOfLinks.put("ARichMediaWindow", links);
    }

    private static void fillMapOfSuperNamesARoleMap() {
        mapOfSuperNames.put("ARoleMap", "AObject");
    }

    private static void fillMapOfPropertiesARoleMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ARoleMap", properties);
    }

    private static void fillMapOfLinksARoleMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ARoleMap", links);
    }

    private static void fillMapOfSuperNamesARoleMapEntry() {
        mapOfSuperNames.put("ARoleMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesARoleMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        mapOfProperties.put("ARoleMapEntry", properties);
    }

    private static void fillMapOfLinksARoleMapEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("ARoleMapEntry", links);
    }

    private static void fillMapOfSuperNamesARoleMapNS() {
        mapOfSuperNames.put("ARoleMapNS", "AObject");
    }

    private static void fillMapOfPropertiesARoleMapNS() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ARoleMapNS", properties);
    }

    private static void fillMapOfLinksARoleMapNS() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ARoleMapNS", links);
    }

    private static void fillMapOfSuperNamesARoleMapNSEntry() {
        mapOfSuperNames.put("ARoleMapNSEntry", "AObject");
    }

    private static void fillMapOfPropertiesARoleMapNSEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeName");
        mapOfProperties.put("ARoleMapNSEntry", properties);
    }

    private static void fillMapOfLinksARoleMapNSEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ARoleMapNSEntry", links);
    }

    private static void fillMapOfSuperNamesASeparation() {
        mapOfSuperNames.put("ASeparation", "AObject");
    }

    private static void fillMapOfPropertiesASeparation() {
        properties = new ArrayList<String>();
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("containsDeviceColorant");
        properties.add("DeviceColorantHasTypeName");
        properties.add("DeviceColorantHasTypeString");
        properties.add("containsPages");
        properties.add("PagesHasTypeArray");
        mapOfProperties.put("ASeparation", properties);
    }

    private static void fillMapOfLinksASeparation() {
        links = new ArrayList<String>();
        links.add("ColorSpace");
        links.add("Pages");
        mapOfLinks.put("ASeparation", links);
    }

    private static void fillMapOfSuperNamesASeparationColorSpace() {
        mapOfSuperNames.put("ASeparationColorSpace", "AObject");
    }

    private static void fillMapOfPropertiesASeparationColorSpace() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeName");
        properties.add("entry2HasTypeArray");
        properties.add("entry2HasTypeName");
        properties.add("entry2NameValue");
        properties.add("isentry3Indirect");
        properties.add("entry3HasTypeDictionary");
        properties.add("entry3HasTypeStream");
        mapOfProperties.put("ASeparationColorSpace", properties);
    }

    private static void fillMapOfLinksASeparationColorSpace() {
        links = new ArrayList<String>();
        links.add("entry2");
        links.add("entry3");
        mapOfLinks.put("ASeparationColorSpace", links);
    }

    private static void fillMapOfSuperNamesAShadingMap() {
        mapOfSuperNames.put("AShadingMap", "AObject");
    }

    private static void fillMapOfPropertiesAShadingMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AShadingMap", properties);
    }

    private static void fillMapOfLinksAShadingMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AShadingMap", links);
    }

    private static void fillMapOfSuperNamesAShadingMapEntry() {
        mapOfSuperNames.put("AShadingMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAShadingMapEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeStream");
        mapOfProperties.put("AShadingMapEntry", properties);
    }

    private static void fillMapOfLinksAShadingMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AShadingMapEntry", links);
    }

    private static void fillMapOfSuperNamesAShadingType1() {
        mapOfSuperNames.put("AShadingType1", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType1() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        mapOfProperties.put("AShadingType1", properties);
    }

    private static void fillMapOfLinksAShadingType1() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Domain");
        links.add("Function");
        mapOfLinks.put("AShadingType1", links);
    }

    private static void fillMapOfSuperNamesAShadingType2() {
        mapOfSuperNames.put("AShadingType2", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType2() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsCoords");
        properties.add("CoordsHasTypeArray");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("containsExtend");
        properties.add("ExtendHasTypeArray");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        mapOfProperties.put("AShadingType2", properties);
    }

    private static void fillMapOfLinksAShadingType2() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Coords");
        links.add("Domain");
        links.add("Extend");
        links.add("Function");
        mapOfLinks.put("AShadingType2", links);
    }

    private static void fillMapOfSuperNamesAShadingType3() {
        mapOfSuperNames.put("AShadingType3", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType3() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsCoords");
        properties.add("CoordsHasTypeArray");
        properties.add("containsDomain");
        properties.add("DomainHasTypeArray");
        properties.add("containsExtend");
        properties.add("ExtendHasTypeArray");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        mapOfProperties.put("AShadingType3", properties);
    }

    private static void fillMapOfLinksAShadingType3() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Coords");
        links.add("Domain");
        links.add("Extend");
        links.add("Function");
        mapOfLinks.put("AShadingType3", links);
    }

    private static void fillMapOfSuperNamesAShadingType4() {
        mapOfSuperNames.put("AShadingType4", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType4() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsBitsPerCoordinate");
        properties.add("BitsPerCoordinateHasTypeInteger");
        properties.add("BitsPerCoordinateIntegerValue");
        properties.add("containsBitsPerFlag");
        properties.add("BitsPerFlagHasTypeInteger");
        properties.add("BitsPerFlagIntegerValue");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        mapOfProperties.put("AShadingType4", properties);
    }

    private static void fillMapOfLinksAShadingType4() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Function");
        mapOfLinks.put("AShadingType4", links);
    }

    private static void fillMapOfSuperNamesAShadingType5() {
        mapOfSuperNames.put("AShadingType5", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType5() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsBitsPerCoordinate");
        properties.add("BitsPerCoordinateHasTypeInteger");
        properties.add("BitsPerCoordinateIntegerValue");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        properties.add("containsVerticesPerRow");
        properties.add("VerticesPerRowHasTypeInteger");
        properties.add("VerticesPerRowIntegerValue");
        mapOfProperties.put("AShadingType5", properties);
    }

    private static void fillMapOfLinksAShadingType5() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Function");
        mapOfLinks.put("AShadingType5", links);
    }

    private static void fillMapOfSuperNamesAShadingType6() {
        mapOfSuperNames.put("AShadingType6", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType6() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsBitsPerCoordinate");
        properties.add("BitsPerCoordinateHasTypeInteger");
        properties.add("BitsPerCoordinateIntegerValue");
        properties.add("containsBitsPerFlag");
        properties.add("BitsPerFlagHasTypeInteger");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        mapOfProperties.put("AShadingType6", properties);
    }

    private static void fillMapOfLinksAShadingType6() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Function");
        mapOfLinks.put("AShadingType6", links);
    }

    private static void fillMapOfSuperNamesAShadingType7() {
        mapOfSuperNames.put("AShadingType7", "AObject");
    }

    private static void fillMapOfPropertiesAShadingType7() {
        properties = new ArrayList<String>();
        properties.add("containsAntiAlias");
        properties.add("AntiAliasHasTypeBoolean");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackground");
        properties.add("BackgroundHasTypeArray");
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsBitsPerCoordinate");
        properties.add("BitsPerCoordinateHasTypeInteger");
        properties.add("BitsPerCoordinateIntegerValue");
        properties.add("containsBitsPerFlag");
        properties.add("BitsPerFlagHasTypeInteger");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFunction");
        properties.add("isFunctionIndirect");
        properties.add("FunctionHasTypeArray");
        properties.add("FunctionHasTypeDictionary");
        properties.add("FunctionHasTypeStream");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsShadingType");
        properties.add("ShadingTypeHasTypeInteger");
        properties.add("ShadingTypeIntegerValue");
        mapOfProperties.put("AShadingType7", properties);
    }

    private static void fillMapOfLinksAShadingType7() {
        links = new ArrayList<String>();
        links.add("Background");
        links.add("ColorSpace");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Function");
        mapOfLinks.put("AShadingType7", links);
    }

    private static void fillMapOfSuperNamesASigFieldLock() {
        mapOfSuperNames.put("ASigFieldLock", "AObject");
    }

    private static void fillMapOfPropertiesASigFieldLock() {
        properties = new ArrayList<String>();
        properties.add("containsAction");
        properties.add("ActionHasTypeName");
        properties.add("ActionNameValue");
        properties.add("containsFields");
        properties.add("FieldsHasTypeArray");
        properties.add("containsP");
        properties.add("PHasTypeNumber");
        properties.add("PNumberValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ASigFieldLock", properties);
    }

    private static void fillMapOfLinksASigFieldLock() {
        links = new ArrayList<String>();
        links.add("Fields");
        mapOfLinks.put("ASigFieldLock", links);
    }

    private static void fillMapOfSuperNamesASigFieldSeedValue() {
        mapOfSuperNames.put("ASigFieldSeedValue", "AObject");
    }

    private static void fillMapOfPropertiesASigFieldSeedValue() {
        properties = new ArrayList<String>();
        properties.add("containsAddRevInfo");
        properties.add("AddRevInfoHasTypeBoolean");
        properties.add("containsAppearanceFilter");
        properties.add("AppearanceFilterHasTypeStringText");
        properties.add("containsCert");
        properties.add("CertHasTypeDictionary");
        properties.add("containsDigestMethod");
        properties.add("DigestMethodHasTypeArray");
        properties.add("containsFf");
        properties.add("FfHasTypeBitmask");
        properties.add("FfBitmaskValue");
        properties.add("containsFilter");
        properties.add("FilterHasTypeName");
        properties.add("containsLegalAttestation");
        properties.add("LegalAttestationHasTypeArray");
        properties.add("containsLockDocument");
        properties.add("LockDocumentHasTypeName");
        properties.add("LockDocumentNameValue");
        properties.add("containsMDP");
        properties.add("MDPHasTypeDictionary");
        properties.add("containsReasons");
        properties.add("ReasonsHasTypeArray");
        properties.add("containsSubFilter");
        properties.add("SubFilterHasTypeArray");
        properties.add("containsTimeStamp");
        properties.add("TimeStampHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        properties.add("VIntegerValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("ASigFieldSeedValue", properties);
    }

    private static void fillMapOfLinksASigFieldSeedValue() {
        links = new ArrayList<String>();
        links.add("Cert");
        links.add("DigestMethod");
        links.add("LegalAttestation");
        links.add("MDP");
        links.add("Reasons");
        links.add("SubFilter");
        links.add("TimeStamp");
        mapOfLinks.put("ASigFieldSeedValue", links);
    }

    private static void fillMapOfSuperNamesASignature() {
        mapOfSuperNames.put("ASignature", "AObject");
    }

    private static void fillMapOfPropertiesASignature() {
        properties = new ArrayList<String>();
        properties.add("containsByteRange");
        properties.add("ByteRangeHasTypeArray");
        properties.add("containsCert");
        properties.add("CertHasTypeArray");
        properties.add("CertHasTypeStringByte");
        properties.add("containsChanges");
        properties.add("ChangesHasTypeArray");
        properties.add("containsContactInfo");
        properties.add("ContactInfoHasTypeStringText");
        properties.add("containsContents");
        properties.add("ContentsHasTypeStringByte");
        properties.add("isContentsHexString");
        properties.add("containsFilter");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("containsLocation");
        properties.add("LocationHasTypeStringText");
        properties.add("containsM");
        properties.add("MHasTypeDate");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsProp_AuthTime");
        properties.add("Prop_AuthTimeHasTypeInteger");
        properties.add("Prop_AuthTimeIntegerValue");
        properties.add("containsProp_AuthType");
        properties.add("Prop_AuthTypeHasTypeName");
        properties.add("containsProp_Build");
        properties.add("Prop_BuildHasTypeDictionary");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("containsReason");
        properties.add("ReasonHasTypeStringText");
        properties.add("containsReference");
        properties.add("ReferenceHasTypeArray");
        properties.add("containsSubFilter");
        properties.add("SubFilterHasTypeName");
        properties.add("SubFilterNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeInteger");
        mapOfProperties.put("ASignature", properties);
    }

    private static void fillMapOfLinksASignature() {
        links = new ArrayList<String>();
        links.add("ByteRange");
        links.add("Cert");
        links.add("Changes");
        links.add("Prop_Build");
        links.add("Reference");
        mapOfLinks.put("ASignature", links);
    }

    private static void fillMapOfSuperNamesASignatureBuildDataAppDict() {
        mapOfSuperNames.put("ASignatureBuildDataAppDict", "AObject");
    }

    private static void fillMapOfPropertiesASignatureBuildDataAppDict() {
        properties = new ArrayList<String>();
        properties.add("containsDate");
        properties.add("DateHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsNonEFontNoWarn");
        properties.add("NonEFontNoWarnHasTypeBoolean");
        properties.add("containsOS");
        properties.add("OSHasTypeArray");
        properties.add("containsPreRelease");
        properties.add("PreReleaseHasTypeBoolean");
        properties.add("containsR");
        properties.add("RHasTypeNumber");
        properties.add("containsREx");
        properties.add("RExHasTypeStringText");
        properties.add("containsTrustedMode");
        properties.add("TrustedModeHasTypeBoolean");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        mapOfProperties.put("ASignatureBuildDataAppDict", properties);
    }

    private static void fillMapOfLinksASignatureBuildDataAppDict() {
        links = new ArrayList<String>();
        links.add("OS");
        mapOfLinks.put("ASignatureBuildDataAppDict", links);
    }

    private static void fillMapOfSuperNamesASignatureBuildDataDict() {
        mapOfSuperNames.put("ASignatureBuildDataDict", "AObject");
    }

    private static void fillMapOfPropertiesASignatureBuildDataDict() {
        properties = new ArrayList<String>();
        properties.add("containsDate");
        properties.add("DateHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsNonEFontNoWarn");
        properties.add("NonEFontNoWarnHasTypeBoolean");
        properties.add("containsOS");
        properties.add("OSHasTypeArray");
        properties.add("containsPreRelease");
        properties.add("PreReleaseHasTypeBoolean");
        properties.add("containsR");
        properties.add("RHasTypeNumber");
        properties.add("containsTrustedMode");
        properties.add("TrustedModeHasTypeBoolean");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        mapOfProperties.put("ASignatureBuildDataDict", properties);
    }

    private static void fillMapOfLinksASignatureBuildDataDict() {
        links = new ArrayList<String>();
        links.add("OS");
        mapOfLinks.put("ASignatureBuildDataDict", links);
    }

    private static void fillMapOfSuperNamesASignatureBuildDataSigQDict() {
        mapOfSuperNames.put("ASignatureBuildDataSigQDict", "AObject");
    }

    private static void fillMapOfPropertiesASignatureBuildDataSigQDict() {
        properties = new ArrayList<String>();
        properties.add("containsDate");
        properties.add("DateHasTypeStringText");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsNonEFontNoWarn");
        properties.add("NonEFontNoWarnHasTypeBoolean");
        properties.add("containsOS");
        properties.add("OSHasTypeArray");
        properties.add("containsPreRelease");
        properties.add("PreReleaseHasTypeBoolean");
        properties.add("containsPreview");
        properties.add("PreviewHasTypeBoolean");
        properties.add("containsR");
        properties.add("RHasTypeNumber");
        properties.add("containsTrustedMode");
        properties.add("TrustedModeHasTypeBoolean");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        mapOfProperties.put("ASignatureBuildDataSigQDict", properties);
    }

    private static void fillMapOfLinksASignatureBuildDataSigQDict() {
        links = new ArrayList<String>();
        links.add("OS");
        mapOfLinks.put("ASignatureBuildDataSigQDict", links);
    }

    private static void fillMapOfSuperNamesASignatureBuildPropDict() {
        mapOfSuperNames.put("ASignatureBuildPropDict", "AObject");
    }

    private static void fillMapOfPropertiesASignatureBuildPropDict() {
        properties = new ArrayList<String>();
        properties.add("containsApp");
        properties.add("isAppIndirect");
        properties.add("AppHasTypeDictionary");
        properties.add("containsFilter");
        properties.add("isFilterIndirect");
        properties.add("FilterHasTypeDictionary");
        properties.add("containsPubSec");
        properties.add("isPubSecIndirect");
        properties.add("PubSecHasTypeDictionary");
        properties.add("containsSigQ");
        properties.add("isSigQIndirect");
        properties.add("SigQHasTypeDictionary");
        mapOfProperties.put("ASignatureBuildPropDict", properties);
    }

    private static void fillMapOfLinksASignatureBuildPropDict() {
        links = new ArrayList<String>();
        links.add("App");
        links.add("Filter");
        links.add("PubSec");
        links.add("SigQ");
        mapOfLinks.put("ASignatureBuildPropDict", links);
    }

    private static void fillMapOfSuperNamesASignatureReferenceDocMDP() {
        mapOfSuperNames.put("ASignatureReferenceDocMDP", "AObject");
    }

    private static void fillMapOfPropertiesASignatureReferenceDocMDP() {
        properties = new ArrayList<String>();
        properties.add("containsData");
        properties.add("isDataIndirect");
        properties.add("DataHasTypeArray");
        properties.add("DataHasTypeBoolean");
        properties.add("DataHasTypeDictionary");
        properties.add("DataHasTypeInteger");
        properties.add("DataHasTypeName");
        properties.add("DataHasTypeStream");
        properties.add("DataHasTypeString");
        properties.add("containsDigestMethod");
        properties.add("DigestMethodHasTypeName");
        properties.add("DigestMethodNameValue");
        properties.add("containsTransformMethod");
        properties.add("TransformMethodHasTypeName");
        properties.add("TransformMethodNameValue");
        properties.add("containsTransformParams");
        properties.add("TransformParamsHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionISO_TS_32001");
        mapOfProperties.put("ASignatureReferenceDocMDP", properties);
    }

    private static void fillMapOfLinksASignatureReferenceDocMDP() {
        links = new ArrayList<String>();
        links.add("Data");
        links.add("TransformParams");
        mapOfLinks.put("ASignatureReferenceDocMDP", links);
    }

    private static void fillMapOfSuperNamesASignatureReferenceFieldMDP() {
        mapOfSuperNames.put("ASignatureReferenceFieldMDP", "AObject");
    }

    private static void fillMapOfPropertiesASignatureReferenceFieldMDP() {
        properties = new ArrayList<String>();
        properties.add("containsData");
        properties.add("isDataIndirect");
        properties.add("DataHasTypeArray");
        properties.add("DataHasTypeBoolean");
        properties.add("DataHasTypeDictionary");
        properties.add("DataHasTypeInteger");
        properties.add("DataHasTypeName");
        properties.add("DataHasTypeStream");
        properties.add("DataHasTypeString");
        properties.add("containsDigestMethod");
        properties.add("DigestMethodHasTypeName");
        properties.add("DigestMethodNameValue");
        properties.add("containsTransformMethod");
        properties.add("TransformMethodHasTypeName");
        properties.add("TransformMethodNameValue");
        properties.add("containsTransformParams");
        properties.add("TransformParamsHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionISO_TS_32001");
        mapOfProperties.put("ASignatureReferenceFieldMDP", properties);
    }

    private static void fillMapOfLinksASignatureReferenceFieldMDP() {
        links = new ArrayList<String>();
        links.add("Data");
        links.add("TransformParams");
        mapOfLinks.put("ASignatureReferenceFieldMDP", links);
    }

    private static void fillMapOfSuperNamesASignatureReferenceIdentity() {
        mapOfSuperNames.put("ASignatureReferenceIdentity", "AObject");
    }

    private static void fillMapOfPropertiesASignatureReferenceIdentity() {
        properties = new ArrayList<String>();
        properties.add("containsData");
        properties.add("isDataIndirect");
        properties.add("DataHasTypeArray");
        properties.add("DataHasTypeBoolean");
        properties.add("DataHasTypeDictionary");
        properties.add("DataHasTypeInteger");
        properties.add("DataHasTypeName");
        properties.add("DataHasTypeStream");
        properties.add("DataHasTypeString");
        properties.add("containsDigestMethod");
        properties.add("DigestMethodHasTypeName");
        properties.add("DigestMethodNameValue");
        properties.add("containsTransformMethod");
        properties.add("TransformMethodHasTypeName");
        properties.add("TransformMethodNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionISO_TS_32001");
        mapOfProperties.put("ASignatureReferenceIdentity", properties);
    }

    private static void fillMapOfLinksASignatureReferenceIdentity() {
        links = new ArrayList<String>();
        links.add("Data");
        mapOfLinks.put("ASignatureReferenceIdentity", links);
    }

    private static void fillMapOfSuperNamesASignatureReferenceUR() {
        mapOfSuperNames.put("ASignatureReferenceUR", "AObject");
    }

    private static void fillMapOfPropertiesASignatureReferenceUR() {
        properties = new ArrayList<String>();
        properties.add("containsData");
        properties.add("isDataIndirect");
        properties.add("DataHasTypeArray");
        properties.add("DataHasTypeBoolean");
        properties.add("DataHasTypeDictionary");
        properties.add("DataHasTypeInteger");
        properties.add("DataHasTypeName");
        properties.add("DataHasTypeStream");
        properties.add("DataHasTypeString");
        properties.add("containsDigestMethod");
        properties.add("DigestMethodHasTypeName");
        properties.add("DigestMethodNameValue");
        properties.add("containsTransformMethod");
        properties.add("TransformMethodHasTypeName");
        properties.add("TransformMethodNameValue");
        properties.add("containsTransformParams");
        properties.add("TransformParamsHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionISO_TS_32001");
        mapOfProperties.put("ASignatureReferenceUR", properties);
    }

    private static void fillMapOfLinksASignatureReferenceUR() {
        links = new ArrayList<String>();
        links.add("Data");
        links.add("TransformParams");
        mapOfLinks.put("ASignatureReferenceUR", links);
    }

    private static void fillMapOfSuperNamesASlideShow() {
        mapOfSuperNames.put("ASlideShow", "AObject");
    }

    private static void fillMapOfPropertiesASlideShow() {
        properties = new ArrayList<String>();
        properties.add("containsResources");
        properties.add("ResourcesHasTypeNameTree");
        properties.add("containsStartResource");
        properties.add("StartResourceHasTypeStringByte");
        properties.add("StartResourceEntryIsIndexInNameTreeResources");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ASlideShow", properties);
    }

    private static void fillMapOfLinksASlideShow() {
        links = new ArrayList<String>();
        links.add("Resources");
        mapOfLinks.put("ASlideShow", links);
    }

    private static void fillMapOfSuperNamesASlideShowNameTreeResources() {
        mapOfSuperNames.put("ASlideShowNameTreeResources", "AObject");
    }

    private static void fillMapOfPropertiesASlideShowNameTreeResources() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ASlideShowNameTreeResources", properties);
    }

    private static void fillMapOfLinksASlideShowNameTreeResources() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ASlideShowNameTreeResources", links);
    }

    private static void fillMapOfSuperNamesASlideShowNameTreeResourcesEntry() {
        mapOfSuperNames.put("ASlideShowNameTreeResourcesEntry", "AObject");
    }

    private static void fillMapOfPropertiesASlideShowNameTreeResourcesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStream");
        mapOfProperties.put("ASlideShowNameTreeResourcesEntry", properties);
    }

    private static void fillMapOfLinksASlideShowNameTreeResourcesEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ASlideShowNameTreeResourcesEntry", links);
    }

    private static void fillMapOfSuperNamesASoftMaskAlpha() {
        mapOfSuperNames.put("ASoftMaskAlpha", "AObject");
    }

    private static void fillMapOfPropertiesASoftMaskAlpha() {
        properties = new ArrayList<String>();
        properties.add("containsBC");
        properties.add("BCHasTypeArray");
        properties.add("containsG");
        properties.add("isGIndirect");
        properties.add("GHasTypeStream");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsTR");
        properties.add("isTRIndirect");
        properties.add("TRHasTypeDictionary");
        properties.add("TRHasTypeName");
        properties.add("TRHasTypeStream");
        properties.add("TRNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ASoftMaskAlpha", properties);
    }

    private static void fillMapOfLinksASoftMaskAlpha() {
        links = new ArrayList<String>();
        links.add("BC");
        links.add("G");
        links.add("TR");
        mapOfLinks.put("ASoftMaskAlpha", links);
    }

    private static void fillMapOfSuperNamesASoftMaskLuminosity() {
        mapOfSuperNames.put("ASoftMaskLuminosity", "AObject");
    }

    private static void fillMapOfPropertiesASoftMaskLuminosity() {
        properties = new ArrayList<String>();
        properties.add("containsBC");
        properties.add("BCHasTypeArray");
        properties.add("containsG");
        properties.add("isGIndirect");
        properties.add("GHasTypeStream");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsTR");
        properties.add("isTRIndirect");
        properties.add("TRHasTypeDictionary");
        properties.add("TRHasTypeName");
        properties.add("TRHasTypeStream");
        properties.add("TRNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("GGroupSNameValue");
        properties.add("containsGGroupCS");
        mapOfProperties.put("ASoftMaskLuminosity", properties);
    }

    private static void fillMapOfLinksASoftMaskLuminosity() {
        links = new ArrayList<String>();
        links.add("BC");
        links.add("G");
        links.add("TR");
        mapOfLinks.put("ASoftMaskLuminosity", links);
    }

    private static void fillMapOfSuperNamesASoftwareIdentifier() {
        mapOfSuperNames.put("ASoftwareIdentifier", "AObject");
    }

    private static void fillMapOfPropertiesASoftwareIdentifier() {
        properties = new ArrayList<String>();
        properties.add("containsH");
        properties.add("HHasTypeArray");
        properties.add("containsHI");
        properties.add("HIHasTypeBoolean");
        properties.add("containsL");
        properties.add("LHasTypeArray");
        properties.add("containsLI");
        properties.add("LIHasTypeBoolean");
        properties.add("containsOS");
        properties.add("OSHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsU");
        properties.add("UHasTypeStringAscii");
        mapOfProperties.put("ASoftwareIdentifier", properties);
    }

    private static void fillMapOfLinksASoftwareIdentifier() {
        links = new ArrayList<String>();
        links.add("H");
        links.add("L");
        links.add("OS");
        mapOfLinks.put("ASoftwareIdentifier", links);
    }

    private static void fillMapOfSuperNamesASolidities() {
        mapOfSuperNames.put("ASolidities", "AObject");
    }

    private static void fillMapOfPropertiesASolidities() {
        properties = new ArrayList<String>();
        properties.add("containsDefault");
        properties.add("DefaultHasTypeNumber");
        properties.add("DefaultNumberValue");
        mapOfProperties.put("ASolidities", properties);
    }

    private static void fillMapOfLinksASolidities() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ASolidities", links);
    }

    private static void fillMapOfSuperNamesASoliditiesEntry() {
        mapOfSuperNames.put("ASoliditiesEntry", "AObject");
    }

    private static void fillMapOfPropertiesASoliditiesEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeNumber");
        properties.add("NumberValue");
        mapOfProperties.put("ASoliditiesEntry", properties);
    }

    private static void fillMapOfLinksASoliditiesEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("ASoliditiesEntry", links);
    }

    private static void fillMapOfSuperNamesASoundObject() {
        mapOfSuperNames.put("ASoundObject", "AObject");
    }

    private static void fillMapOfPropertiesASoundObject() {
        properties = new ArrayList<String>();
        properties.add("containsB");
        properties.add("BHasTypeInteger");
        properties.add("BIntegerValue");
        properties.add("containsC");
        properties.add("CHasTypeInteger");
        properties.add("CIntegerValue");
        properties.add("containsCO");
        properties.add("COHasTypeName");
        properties.add("containsCP");
        properties.add("isCPIndirect");
        properties.add("CPHasTypeArray");
        properties.add("CPHasTypeDictionary");
        properties.add("CPHasTypeStream");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsE");
        properties.add("EHasTypeName");
        properties.add("ENameValue");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsR");
        properties.add("RHasTypeNumber");
        properties.add("RNumberValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ASoundObject", properties);
    }

    private static void fillMapOfLinksASoundObject() {
        links = new ArrayList<String>();
        links.add("CP");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("ASoundObject", links);
    }

    private static void fillMapOfSuperNamesASourceInformation() {
        mapOfSuperNames.put("ASourceInformation", "AObject");
    }

    private static void fillMapOfPropertiesASourceInformation() {
        properties = new ArrayList<String>();
        properties.add("containsAU");
        properties.add("AUHasTypeDictionary");
        properties.add("AUHasTypeStringAscii");
        properties.add("containsC");
        properties.add("isCIndirect");
        properties.add("CHasTypeDictionary");
        properties.add("containsE");
        properties.add("EHasTypeDate");
        properties.add("containsS");
        properties.add("SHasTypeInteger");
        properties.add("SIntegerValue");
        properties.add("containsTS");
        properties.add("TSHasTypeDate");
        properties.add("parentSNameValue");
        mapOfProperties.put("ASourceInformation", properties);
    }

    private static void fillMapOfLinksASourceInformation() {
        links = new ArrayList<String>();
        links.add("AU");
        links.add("C");
        mapOfLinks.put("ASourceInformation", links);
    }

    private static void fillMapOfSuperNamesASpectralData() {
        mapOfSuperNames.put("ASpectralData", "AObject");
    }

    private static void fillMapOfPropertiesASpectralData() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ASpectralData", properties);
    }

    private static void fillMapOfLinksASpectralData() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ASpectralData", links);
    }

    private static void fillMapOfSuperNamesASpectralDataEntry() {
        mapOfSuperNames.put("ASpectralDataEntry", "AObject");
    }

    private static void fillMapOfPropertiesASpectralDataEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("ASpectralDataEntry", properties);
    }

    private static void fillMapOfLinksASpectralDataEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("ASpectralDataEntry", links);
    }

    private static void fillMapOfSuperNamesAStream() {
        mapOfSuperNames.put("AStream", "AObject");
    }

    private static void fillMapOfPropertiesAStream() {
        properties = new ArrayList<String>();
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        mapOfProperties.put("AStream", properties);
    }

    private static void fillMapOfLinksAStream() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AStream", links);
    }

    private static void fillMapOfSuperNamesAStructElem() {
        mapOfSuperNames.put("AStructElem", "AObject");
    }

    private static void fillMapOfPropertiesAStructElem() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("isAIndirect");
        properties.add("AHasTypeArray");
        properties.add("AHasTypeDictionary");
        properties.add("AHasTypeStream");
        properties.add("AArraySize");
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsActualText");
        properties.add("ActualTextHasTypeStringText");
        properties.add("containsAlt");
        properties.add("AltHasTypeStringText");
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("CHasTypeName");
        properties.add("containsE");
        properties.add("EHasTypeStringText");
        properties.add("containsID");
        properties.add("entryIDHasTypeStringByte");
        properties.add("containsK");
        properties.add("KHasTypeArray");
        properties.add("KHasTypeDictionary");
        properties.add("KHasTypeInteger");
        properties.add("containsLang");
        properties.add("LangHasTypeStringText");
        properties.add("containsNS");
        properties.add("isNSIndirect");
        properties.add("NSHasTypeDictionary");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeDictionary");
        properties.add("containsPg");
        properties.add("isPgIndirect");
        properties.add("PgHasTypeDictionary");
        properties.add("containsPhoneme");
        properties.add("PhonemeHasTypeStringText");
        properties.add("containsPhoneticAlphabet");
        properties.add("PhoneticAlphabetHasTypeName");
        properties.add("containsR");
        properties.add("RHasTypeInteger");
        properties.add("RIntegerValue");
        properties.add("containsRef");
        properties.add("RefHasTypeArray");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AStructElem", properties);
    }

    private static void fillMapOfLinksAStructElem() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("AF");
        links.add("C");
        links.add("K");
        links.add("NS");
        links.add("P");
        links.add("Pg");
        links.add("Ref");
        mapOfLinks.put("AStructElem", links);
    }

    private static void fillMapOfSuperNamesAStructTreeRoot() {
        mapOfSuperNames.put("AStructTreeRoot", "AObject");
    }

    private static void fillMapOfPropertiesAStructTreeRoot() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsClassMap");
        properties.add("ClassMapHasTypeDictionary");
        properties.add("containsIDTree");
        properties.add("IDTreeHasTypeNameTree");
        properties.add("containsK");
        properties.add("KHasTypeArray");
        properties.add("KHasTypeDictionary");
        properties.add("containsNamespaces");
        properties.add("NamespacesHasTypeArray");
        properties.add("containsParentTree");
        properties.add("ParentTreeHasTypeNumberTree");
        properties.add("containsParentTreeNextKey");
        properties.add("ParentTreeNextKeyHasTypeInteger");
        properties.add("containsPronunciationLexicon");
        properties.add("isPronunciationLexiconIndirect");
        properties.add("PronunciationLexiconHasTypeArray");
        properties.add("PronunciationLexiconHasTypeDictionary");
        properties.add("PronunciationLexiconHasTypeString");
        properties.add("containsRoleMap");
        properties.add("RoleMapHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AStructTreeRoot", properties);
    }

    private static void fillMapOfLinksAStructTreeRoot() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("ClassMap");
        links.add("IDTree");
        links.add("K");
        links.add("Namespaces");
        links.add("ParentTree");
        links.add("PronunciationLexicon");
        links.add("RoleMap");
        mapOfLinks.put("AStructTreeRoot", links);
    }

    private static void fillMapOfSuperNamesAStructTreeRootNameTreeIDTree() {
        mapOfSuperNames.put("AStructTreeRootNameTreeIDTree", "AObject");
    }

    private static void fillMapOfPropertiesAStructTreeRootNameTreeIDTree() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AStructTreeRootNameTreeIDTree", properties);
    }

    private static void fillMapOfLinksAStructTreeRootNameTreeIDTree() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AStructTreeRootNameTreeIDTree", links);
    }

    private static void fillMapOfSuperNamesAStructTreeRootNameTreeIDTreeEntry() {
        mapOfSuperNames.put("AStructTreeRootNameTreeIDTreeEntry", "AObject");
    }

    private static void fillMapOfPropertiesAStructTreeRootNameTreeIDTreeEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AStructTreeRootNameTreeIDTreeEntry", properties);
    }

    private static void fillMapOfLinksAStructTreeRootNameTreeIDTreeEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AStructTreeRootNameTreeIDTreeEntry", links);
    }

    private static void fillMapOfSuperNamesAStructTreeRootNumberTreeParentTree() {
        mapOfSuperNames.put("AStructTreeRootNumberTreeParentTree", "AObject");
    }

    private static void fillMapOfPropertiesAStructTreeRootNumberTreeParentTree() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AStructTreeRootNumberTreeParentTree", properties);
    }

    private static void fillMapOfLinksAStructTreeRootNumberTreeParentTree() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AStructTreeRootNumberTreeParentTree", links);
    }

    private static void fillMapOfSuperNamesAStructTreeRootNumberTreeParentTreeEntry() {
        mapOfSuperNames.put("AStructTreeRootNumberTreeParentTreeEntry", "AObject");
    }

    private static void fillMapOfPropertiesAStructTreeRootNumberTreeParentTreeEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AStructTreeRootNumberTreeParentTreeEntry", properties);
    }

    private static void fillMapOfLinksAStructTreeRootNumberTreeParentTreeEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AStructTreeRootNumberTreeParentTreeEntry", links);
    }

    private static void fillMapOfSuperNamesAStructureAttributesDict() {
        mapOfSuperNames.put("AStructureAttributesDict", "AObject");
    }

    private static void fillMapOfPropertiesAStructureAttributesDict() {
        properties = new ArrayList<String>();
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsBackgroundColor");
        properties.add("BackgroundColorHasTypeArray");
        properties.add("containsBaselineShift");
        properties.add("BaselineShiftHasTypeNumber");
        properties.add("containsBlockAlign");
        properties.add("BlockAlignHasTypeName");
        properties.add("BlockAlignNameValue");
        properties.add("containsBorderColor");
        properties.add("BorderColorHasTypeArray");
        properties.add("containsBorderStyle");
        properties.add("BorderStyleHasTypeArray");
        properties.add("BorderStyleHasTypeName");
        properties.add("BorderStyleNameValue");
        properties.add("containsBorderThickness");
        properties.add("BorderThicknessHasTypeArray");
        properties.add("BorderThicknessHasTypeNumber");
        properties.add("containsChecked");
        properties.add("CheckedHasTypeName");
        properties.add("CheckedNameValue");
        properties.add("containsColSpan");
        properties.add("ColSpanHasTypeInteger");
        properties.add("containsColor");
        properties.add("ColorHasTypeArray");
        properties.add("containsColumnCount");
        properties.add("ColumnCountHasTypeInteger");
        properties.add("containsColumnGap");
        properties.add("ColumnGapHasTypeArray");
        properties.add("ColumnGapHasTypeNumber");
        properties.add("containsColumnWidths");
        properties.add("ColumnWidthsHasTypeArray");
        properties.add("ColumnWidthsHasTypeNumber");
        properties.add("containsContents");
        properties.add("ContentsHasTypeArray");
        properties.add("ContentsHasTypeStringText");
        properties.add("containsContinuedForm");
        properties.add("ContinuedFormHasTypeStringByte");
        properties.add("containsContinuedList");
        properties.add("ContinuedListHasTypeBoolean");
        properties.add("containsDesc");
        properties.add("DescHasTypeStringText");
        properties.add("containsEndIndent");
        properties.add("EndIndentHasTypeNumber");
        properties.add("containsGlyphOrientationVertical");
        properties.add("GlyphOrientationVerticalHasTypeInteger");
        properties.add("GlyphOrientationVerticalHasTypeName");
        properties.add("GlyphOrientationVerticalIntegerValue");
        properties.add("GlyphOrientationVerticalNameValue");
        properties.add("containsHeaders");
        properties.add("HeadersHasTypeArray");
        properties.add("containsHeight");
        properties.add("HeightHasTypeName");
        properties.add("HeightHasTypeNumber");
        properties.add("containsInlineAlign");
        properties.add("InlineAlignHasTypeName");
        properties.add("InlineAlignNameValue");
        properties.add("containsLineHeight");
        properties.add("LineHeightHasTypeName");
        properties.add("LineHeightHasTypeNumber");
        properties.add("LineHeightNameValue");
        properties.add("containsListNumbering");
        properties.add("ListNumberingHasTypeName");
        properties.add("ListNumberingNameValue");
        properties.add("containsNS");
        properties.add("isNSIndirect");
        properties.add("NSHasTypeDictionary");
        properties.add("containsO");
        properties.add("OHasTypeName");
        properties.add("ONameValue");
        properties.add("containsP");
        properties.add("PHasTypeArray");
        properties.add("containsPadding");
        properties.add("PaddingHasTypeArray");
        properties.add("PaddingHasTypeNumber");
        properties.add("containsPlacement");
        properties.add("PlacementHasTypeName");
        properties.add("PlacementNameValue");
        properties.add("containsRole");
        properties.add("RoleHasTypeName");
        properties.add("RoleNameValue");
        properties.add("containsRowSpan");
        properties.add("RowSpanHasTypeInteger");
        properties.add("containsRubyAlign");
        properties.add("RubyAlignHasTypeName");
        properties.add("RubyAlignNameValue");
        properties.add("containsRubyPosition");
        properties.add("RubyPositionHasTypeName");
        properties.add("RubyPositionNameValue");
        properties.add("containsScope");
        properties.add("ScopeHasTypeName");
        properties.add("ScopeNameValue");
        properties.add("containsShort");
        properties.add("ShortHasTypeStringText");
        properties.add("containsSpaceAfter");
        properties.add("SpaceAfterHasTypeNumber");
        properties.add("containsSpaceBefore");
        properties.add("SpaceBeforeHasTypeNumber");
        properties.add("containsStartIndent");
        properties.add("StartIndentHasTypeNumber");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsSummary");
        properties.add("SummaryHasTypeStringText");
        properties.add("containsTBorderStyle");
        properties.add("TBorderStyleHasTypeArray");
        properties.add("TBorderStyleHasTypeName");
        properties.add("TBorderStyleNameValue");
        properties.add("containsTPadding");
        properties.add("TPaddingHasTypeArray");
        properties.add("TPaddingHasTypeInteger");
        properties.add("containsTextAlign");
        properties.add("TextAlignHasTypeName");
        properties.add("TextAlignNameValue");
        properties.add("containsTextDecorationColor");
        properties.add("TextDecorationColorHasTypeArray");
        properties.add("containsTextDecorationThickness");
        properties.add("TextDecorationThicknessHasTypeNumber");
        properties.add("containsTextDecorationType");
        properties.add("TextDecorationTypeHasTypeName");
        properties.add("TextDecorationTypeNameValue");
        properties.add("containsTextIndent");
        properties.add("TextIndentHasTypeNumber");
        properties.add("containsTextPosition");
        properties.add("TextPositionHasTypeName");
        properties.add("TextPositionNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeName");
        properties.add("WidthHasTypeNumber");
        properties.add("containsWritingMode");
        properties.add("WritingModeHasTypeName");
        properties.add("WritingModeNameValue");
        properties.add("containschecked");
        properties.add("checkedHasTypeName");
        properties.add("checkedNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AStructureAttributesDict", properties);
    }

    private static void fillMapOfLinksAStructureAttributesDict() {
        links = new ArrayList<String>();
        links.add("BackgroundColor");
        links.add("BorderColor");
        links.add("BorderStyle");
        links.add("BorderThickness");
        links.add("Color");
        links.add("ColumnGap");
        links.add("ColumnWidths");
        links.add("Contents");
        links.add("Headers");
        links.add("NS");
        links.add("P");
        links.add("Padding");
        links.add("TBorderStyle");
        links.add("TPadding");
        links.add("TextDecorationColor");
        mapOfLinks.put("AStructureAttributesDict", links);
    }

    private static void fillMapOfSuperNamesAStyleDict() {
        mapOfSuperNames.put("AStyleDict", "AObject");
    }

    private static void fillMapOfPropertiesAStyleDict() {
        properties = new ArrayList<String>();
        properties.add("containsPanose");
        properties.add("PanoseHasTypeStringByte");
        properties.add("PanoseStringSize");
        mapOfProperties.put("AStyleDict", properties);
    }

    private static void fillMapOfLinksAStyleDict() {
        links = new ArrayList<String>();
        mapOfLinks.put("AStyleDict", links);
    }

    private static void fillMapOfSuperNamesASubjectDN() {
        mapOfSuperNames.put("ASubjectDN", "AObject");
    }

    private static void fillMapOfPropertiesASubjectDN() {
        properties = new ArrayList<String>();
        mapOfProperties.put("ASubjectDN", properties);
    }

    private static void fillMapOfLinksASubjectDN() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("ASubjectDN", links);
    }

    private static void fillMapOfSuperNamesASubjectDNEntry() {
        mapOfSuperNames.put("ASubjectDNEntry", "AObject");
    }

    private static void fillMapOfPropertiesASubjectDNEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeStringText");
        mapOfProperties.put("ASubjectDNEntry", properties);
    }

    private static void fillMapOfLinksASubjectDNEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("ASubjectDNEntry", links);
    }

    private static void fillMapOfSuperNamesATarget() {
        mapOfSuperNames.put("ATarget", "AObject");
    }

    private static void fillMapOfPropertiesATarget() {
        properties = new ArrayList<String>();
        properties.add("containsA");
        properties.add("AHasTypeInteger");
        properties.add("AHasTypeStringText");
        properties.add("AIntegerValue");
        properties.add("AStringTextValue");
        properties.add("containsN");
        properties.add("NHasTypeStringByte");
        properties.add("NEntryIsIndexInNameTreetrailerCatalogNamesEmbeddedFiles");
        properties.add("containsP");
        properties.add("PHasTypeInteger");
        properties.add("PHasTypeStringByte");
        properties.add("PIntegerValue");
        properties.add("PEntryIsIndexInNameTreetrailerCatalogNamesDests");
        properties.add("containsR");
        properties.add("RHasTypeName");
        properties.add("RNameValue");
        properties.add("containsT");
        properties.add("THasTypeDictionary");
        properties.add("pagePAnnotsArraySize");
        properties.add("pagePAnnotsHasTypeArray");
        mapOfProperties.put("ATarget", properties);
    }

    private static void fillMapOfLinksATarget() {
        links = new ArrayList<String>();
        links.add("T");
        mapOfLinks.put("ATarget", links);
    }

    private static void fillMapOfSuperNamesAThread() {
        mapOfSuperNames.put("AThread", "AObject");
    }

    private static void fillMapOfPropertiesAThread() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("isFIndirect");
        properties.add("FHasTypeDictionary");
        properties.add("containsI");
        properties.add("IHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AThread", properties);
    }

    private static void fillMapOfLinksAThread() {
        links = new ArrayList<String>();
        links.add("F");
        links.add("I");
        links.add("Metadata");
        mapOfLinks.put("AThread", links);
    }

    private static void fillMapOfSuperNamesAThumbnail() {
        mapOfSuperNames.put("AThumbnail", "AObject");
    }

    private static void fillMapOfPropertiesAThumbnail() {
        properties = new ArrayList<String>();
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsHeight");
        properties.add("HeightHasTypeInteger");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeInteger");
        mapOfProperties.put("AThumbnail", properties);
    }

    private static void fillMapOfLinksAThumbnail() {
        links = new ArrayList<String>();
        links.add("ColorSpace");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        mapOfLinks.put("AThumbnail", links);
    }

    private static void fillMapOfSuperNamesATimeStampDict() {
        mapOfSuperNames.put("ATimeStampDict", "AObject");
    }

    private static void fillMapOfPropertiesATimeStampDict() {
        properties = new ArrayList<String>();
        properties.add("containsFf");
        properties.add("FfHasTypeInteger");
        properties.add("FfIntegerValue");
        properties.add("containsURL");
        properties.add("URLHasTypeStringAscii");
        mapOfProperties.put("ATimeStampDict", properties);
    }

    private static void fillMapOfLinksATimeStampDict() {
        links = new ArrayList<String>();
        mapOfLinks.put("ATimeStampDict", links);
    }

    private static void fillMapOfSuperNamesATimespan() {
        mapOfSuperNames.put("ATimespan", "AObject");
    }

    private static void fillMapOfPropertiesATimespan() {
        properties = new ArrayList<String>();
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        mapOfProperties.put("ATimespan", properties);
    }

    private static void fillMapOfLinksATimespan() {
        links = new ArrayList<String>();
        mapOfLinks.put("ATimespan", links);
    }

    private static void fillMapOfSuperNamesATrailerIDArray() {
        mapOfSuperNames.put("ATrailerIDArray", "AObject");
    }

    private static void fillMapOfPropertiesATrailerIDArray() {
        properties = new ArrayList<String>();
        properties.add("isentry0Indirect");
        properties.add("entry0HasTypeStringByte");
        properties.add("isentry1Indirect");
        properties.add("entry1HasTypeStringByte");
        properties.add("containstrailerEncrypt");
        mapOfProperties.put("ATrailerIDArray", properties);
    }

    private static void fillMapOfLinksATrailerIDArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("ATrailerIDArray", links);
    }

    private static void fillMapOfSuperNamesATransition() {
        mapOfSuperNames.put("ATransition", "AObject");
    }

    private static void fillMapOfPropertiesATransition() {
        properties = new ArrayList<String>();
        properties.add("containsB");
        properties.add("BHasTypeBoolean");
        properties.add("containsD");
        properties.add("DHasTypeNumber");
        properties.add("DNumberValue");
        properties.add("containsDi");
        properties.add("DiHasTypeInteger");
        properties.add("DiHasTypeName");
        properties.add("DiIntegerValue");
        properties.add("DiNameValue");
        properties.add("containsDm");
        properties.add("DmHasTypeName");
        properties.add("DmNameValue");
        properties.add("containsM");
        properties.add("MHasTypeName");
        properties.add("MNameValue");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSS");
        properties.add("SSHasTypeNumber");
        properties.add("SSNumberValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("ATransition", properties);
    }

    private static void fillMapOfLinksATransition() {
        links = new ArrayList<String>();
        mapOfLinks.put("ATransition", links);
    }

    private static void fillMapOfSuperNamesATrapRegion() {
        mapOfSuperNames.put("ATrapRegion", "AObject");
    }

    private static void fillMapOfPropertiesATrapRegion() {
        properties = new ArrayList<String>();
        properties.add("containsTP");
        properties.add("TPHasTypeName");
        properties.add("containsTZ");
        properties.add("TZHasTypeArray");
        mapOfProperties.put("ATrapRegion", properties);
    }

    private static void fillMapOfLinksATrapRegion() {
        links = new ArrayList<String>();
        links.add("TZ");
        mapOfLinks.put("ATrapRegion", links);
    }

    private static void fillMapOfSuperNamesAURI() {
        mapOfSuperNames.put("AURI", "AObject");
    }

    private static void fillMapOfPropertiesAURI() {
        properties = new ArrayList<String>();
        properties.add("containsBase");
        properties.add("BaseHasTypeStringAscii");
        mapOfProperties.put("AURI", properties);
    }

    private static void fillMapOfLinksAURI() {
        links = new ArrayList<String>();
        mapOfLinks.put("AURI", links);
    }

    private static void fillMapOfSuperNamesAURLAlias() {
        mapOfSuperNames.put("AURLAlias", "AObject");
    }

    private static void fillMapOfPropertiesAURLAlias() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("CArraySize");
        properties.add("containsU");
        properties.add("UHasTypeStringAscii");
        mapOfProperties.put("AURLAlias", properties);
    }

    private static void fillMapOfLinksAURLAlias() {
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("AURLAlias", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamAnnotsArray() {
        mapOfSuperNames.put("AURTransformParamAnnotsArray", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamAnnotsArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AURTransformParamAnnotsArray", properties);
    }

    private static void fillMapOfLinksAURTransformParamAnnotsArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AURTransformParamAnnotsArray", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamAnnotsArrayEntry() {
        mapOfSuperNames.put("AURTransformParamAnnotsArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamAnnotsArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AURTransformParamAnnotsArrayEntry", properties);
    }

    private static void fillMapOfLinksAURTransformParamAnnotsArrayEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AURTransformParamAnnotsArrayEntry", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamDocumentArray() {
        mapOfSuperNames.put("AURTransformParamDocumentArray", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamDocumentArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AURTransformParamDocumentArray", properties);
    }

    private static void fillMapOfLinksAURTransformParamDocumentArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AURTransformParamDocumentArray", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamDocumentArrayEntry() {
        mapOfSuperNames.put("AURTransformParamDocumentArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamDocumentArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AURTransformParamDocumentArrayEntry", properties);
    }

    private static void fillMapOfLinksAURTransformParamDocumentArrayEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AURTransformParamDocumentArrayEntry", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamEFArray() {
        mapOfSuperNames.put("AURTransformParamEFArray", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamEFArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AURTransformParamEFArray", properties);
    }

    private static void fillMapOfLinksAURTransformParamEFArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AURTransformParamEFArray", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamEFArrayEntry() {
        mapOfSuperNames.put("AURTransformParamEFArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamEFArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AURTransformParamEFArrayEntry", properties);
    }

    private static void fillMapOfLinksAURTransformParamEFArrayEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AURTransformParamEFArrayEntry", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamFormArray() {
        mapOfSuperNames.put("AURTransformParamFormArray", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamFormArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AURTransformParamFormArray", properties);
    }

    private static void fillMapOfLinksAURTransformParamFormArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AURTransformParamFormArray", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamFormArrayEntry() {
        mapOfSuperNames.put("AURTransformParamFormArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamFormArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AURTransformParamFormArrayEntry", properties);
    }

    private static void fillMapOfLinksAURTransformParamFormArrayEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AURTransformParamFormArrayEntry", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamSignatureArray() {
        mapOfSuperNames.put("AURTransformParamSignatureArray", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamSignatureArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AURTransformParamSignatureArray", properties);
    }

    private static void fillMapOfLinksAURTransformParamSignatureArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AURTransformParamSignatureArray", links);
    }

    private static void fillMapOfSuperNamesAURTransformParamSignatureArrayEntry() {
        mapOfSuperNames.put("AURTransformParamSignatureArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParamSignatureArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeName");
        properties.add("NameValue");
        mapOfProperties.put("AURTransformParamSignatureArrayEntry", properties);
    }

    private static void fillMapOfLinksAURTransformParamSignatureArrayEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("AURTransformParamSignatureArrayEntry", links);
    }

    private static void fillMapOfSuperNamesAURTransformParameters() {
        mapOfSuperNames.put("AURTransformParameters", "AObject");
    }

    private static void fillMapOfPropertiesAURTransformParameters() {
        properties = new ArrayList<String>();
        properties.add("containsAnnots");
        properties.add("AnnotsHasTypeArray");
        properties.add("containsDocument");
        properties.add("DocumentHasTypeArray");
        properties.add("containsEF");
        properties.add("EFHasTypeArray");
        properties.add("containsForm");
        properties.add("FormHasTypeArray");
        properties.add("containsMsg");
        properties.add("MsgHasTypeStringText");
        properties.add("containsP");
        properties.add("PHasTypeBoolean");
        properties.add("containsSignature");
        properties.add("SignatureHasTypeArray");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsV");
        properties.add("VHasTypeName");
        mapOfProperties.put("AURTransformParameters", properties);
    }

    private static void fillMapOfLinksAURTransformParameters() {
        links = new ArrayList<String>();
        links.add("Annots");
        links.add("Document");
        links.add("EF");
        links.add("Form");
        links.add("Signature");
        mapOfLinks.put("AURTransformParameters", links);
    }

    private static void fillMapOfSuperNamesAUserProperty() {
        mapOfSuperNames.put("AUserProperty", "AObject");
    }

    private static void fillMapOfPropertiesAUserProperty() {
        properties = new ArrayList<String>();
        properties.add("containsF");
        properties.add("FHasTypeStringText");
        properties.add("containsH");
        properties.add("HHasTypeBoolean");
        properties.add("containsN");
        properties.add("NHasTypeStringText");
        properties.add("containsV");
        properties.add("isVIndirect");
        properties.add("VHasTypeArray");
        properties.add("VHasTypeBoolean");
        properties.add("VHasTypeDictionary");
        properties.add("VHasTypeName");
        properties.add("VHasTypeNull");
        properties.add("VHasTypeNumber");
        properties.add("VHasTypeStream");
        properties.add("VHasTypeString");
        properties.add("trailerCatalogMarkInfoUserPropertiesBooleanValue");
        mapOfProperties.put("AUserProperty", properties);
    }

    private static void fillMapOfLinksAUserProperty() {
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("AUserProperty", links);
    }

    private static void fillMapOfSuperNamesAVRI() {
        mapOfSuperNames.put("AVRI", "AObject");
    }

    private static void fillMapOfPropertiesAVRI() {
        properties = new ArrayList<String>();
        properties.add("containsCRL");
        properties.add("CRLHasTypeArray");
        properties.add("containsCert");
        properties.add("CertHasTypeArray");
        properties.add("containsOCSP");
        properties.add("OCSPHasTypeArray");
        properties.add("containsTS");
        properties.add("isTSIndirect");
        properties.add("TSHasTypeStream");
        properties.add("containsTU");
        properties.add("TUHasTypeDate");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("parentCRLsArraySize");
        properties.add("parentOCSPsArraySize");
        properties.add("parentCRLsHasTypeArray");
        properties.add("parentOCSPsHasTypeArray");
        mapOfProperties.put("AVRI", properties);
    }

    private static void fillMapOfLinksAVRI() {
        links = new ArrayList<String>();
        links.add("CRL");
        links.add("Cert");
        links.add("OCSP");
        links.add("TS");
        mapOfLinks.put("AVRI", links);
    }

    private static void fillMapOfSuperNamesAVRIMap() {
        mapOfSuperNames.put("AVRIMap", "AObject");
    }

    private static void fillMapOfPropertiesAVRIMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AVRIMap", properties);
    }

    private static void fillMapOfLinksAVRIMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AVRIMap", links);
    }

    private static void fillMapOfSuperNamesAVRIMapEntry() {
        mapOfSuperNames.put("AVRIMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAVRIMapEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AVRIMapEntry", properties);
    }

    private static void fillMapOfLinksAVRIMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AVRIMapEntry", links);
    }

    private static void fillMapOfSuperNamesAViewParams() {
        mapOfSuperNames.put("AViewParams", "AObject");
    }

    private static void fillMapOfPropertiesAViewParams() {
        properties = new ArrayList<String>();
        properties.add("containsData");
        properties.add("isDataIndirect");
        properties.add("DataHasTypeStream");
        properties.add("DataHasTypeStringText");
        properties.add("containsInstance");
        properties.add("InstanceHasTypeDictionary");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AViewParams", properties);
    }

    private static void fillMapOfLinksAViewParams() {
        links = new ArrayList<String>();
        links.add("Data");
        links.add("Instance");
        mapOfLinks.put("AViewParams", links);
    }

    private static void fillMapOfSuperNamesAViewerPreferences() {
        mapOfSuperNames.put("AViewerPreferences", "AObject");
    }

    private static void fillMapOfPropertiesAViewerPreferences() {
        properties = new ArrayList<String>();
        properties.add("containsCenterWindow");
        properties.add("CenterWindowHasTypeBoolean");
        properties.add("containsDirection");
        properties.add("DirectionHasTypeName");
        properties.add("DirectionNameValue");
        properties.add("containsDisplayDocTitle");
        properties.add("DisplayDocTitleHasTypeBoolean");
        properties.add("containsDuplex");
        properties.add("DuplexHasTypeName");
        properties.add("DuplexNameValue");
        properties.add("containsEnforce");
        properties.add("EnforceHasTypeArray");
        properties.add("containsFitWindow");
        properties.add("FitWindowHasTypeBoolean");
        properties.add("containsHideMenubar");
        properties.add("HideMenubarHasTypeBoolean");
        properties.add("containsHideToolbar");
        properties.add("HideToolbarHasTypeBoolean");
        properties.add("containsHideWindowUI");
        properties.add("HideWindowUIHasTypeBoolean");
        properties.add("containsNonFullScreenPageMode");
        properties.add("NonFullScreenPageModeHasTypeName");
        properties.add("NonFullScreenPageModeNameValue");
        properties.add("containsNumCopies");
        properties.add("NumCopiesHasTypeInteger");
        properties.add("NumCopiesIntegerValue");
        properties.add("containsPickTrayByPDFSize");
        properties.add("PickTrayByPDFSizeHasTypeBoolean");
        properties.add("containsPrintArea");
        properties.add("PrintAreaHasTypeName");
        properties.add("PrintAreaNameValue");
        properties.add("containsPrintClip");
        properties.add("PrintClipHasTypeName");
        properties.add("PrintClipNameValue");
        properties.add("containsPrintPageRange");
        properties.add("PrintPageRangeHasTypeArray");
        properties.add("containsPrintScaling");
        properties.add("PrintScalingHasTypeName");
        properties.add("PrintScalingNameValue");
        properties.add("containsViewArea");
        properties.add("ViewAreaHasTypeName");
        properties.add("ViewAreaNameValue");
        properties.add("containsViewClip");
        properties.add("ViewClipHasTypeName");
        properties.add("ViewClipNameValue");
        properties.add("trailerCatalogPageModeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AViewerPreferences", properties);
    }

    private static void fillMapOfLinksAViewerPreferences() {
        links = new ArrayList<String>();
        links.add("Enforce");
        links.add("PrintPageRange");
        mapOfLinks.put("AViewerPreferences", links);
    }

    private static void fillMapOfSuperNamesAViewport() {
        mapOfSuperNames.put("AViewport", "AObject");
    }

    private static void fillMapOfPropertiesAViewport() {
        properties = new ArrayList<String>();
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsName");
        properties.add("NameHasTypeStringText");
        properties.add("containsPtData");
        properties.add("PtDataHasTypeDictionary");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AViewport", properties);
    }

    private static void fillMapOfLinksAViewport() {
        links = new ArrayList<String>();
        links.add("Measure");
        links.add("PtData");
        mapOfLinks.put("AViewport", links);
    }

    private static void fillMapOfSuperNamesAVisibilityExpressionArray() {
        mapOfSuperNames.put("AVisibilityExpressionArray", "AObject");
    }

    private static void fillMapOfPropertiesAVisibilityExpressionArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeName");
        properties.add("entry0NameValue");
        properties.add("entry1HasTypeArray");
        properties.add("entry1HasTypeDictionary");
        mapOfProperties.put("AVisibilityExpressionArray", properties);
    }

    private static void fillMapOfLinksAVisibilityExpressionArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        links.add("entry1");
        mapOfLinks.put("AVisibilityExpressionArray", links);
    }

    private static void fillMapOfSuperNamesAVisibilityExpressionArrayEntry() {
        mapOfSuperNames.put("AVisibilityExpressionArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesAVisibilityExpressionArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("HasTypeArray");
        properties.add("HasTypeDictionary");
        mapOfProperties.put("AVisibilityExpressionArrayEntry", properties);
    }

    private static void fillMapOfLinksAVisibilityExpressionArrayEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AVisibilityExpressionArrayEntry", links);
    }

    private static void fillMapOfSuperNamesAWebCaptureCommand() {
        mapOfSuperNames.put("AWebCaptureCommand", "AObject");
    }

    private static void fillMapOfPropertiesAWebCaptureCommand() {
        properties = new ArrayList<String>();
        properties.add("containsCT");
        properties.add("CTHasTypeStringAscii");
        properties.add("containsF");
        properties.add("FHasTypeBitmask");
        properties.add("FBitmaskValue");
        properties.add("containsH");
        properties.add("HHasTypeString");
        properties.add("containsL");
        properties.add("LHasTypeInteger");
        properties.add("LIntegerValue");
        properties.add("containsP");
        properties.add("isPIndirect");
        properties.add("PHasTypeStream");
        properties.add("PHasTypeString");
        properties.add("containsS");
        properties.add("SHasTypeDictionary");
        properties.add("containsURL");
        properties.add("URLHasTypeStringAscii");
        mapOfProperties.put("AWebCaptureCommand", properties);
    }

    private static void fillMapOfLinksAWebCaptureCommand() {
        links = new ArrayList<String>();
        links.add("P");
        links.add("S");
        mapOfLinks.put("AWebCaptureCommand", links);
    }

    private static void fillMapOfSuperNamesAWebCaptureCommandSettings() {
        mapOfSuperNames.put("AWebCaptureCommandSettings", "AObject");
    }

    private static void fillMapOfPropertiesAWebCaptureCommandSettings() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeDictionary");
        properties.add("containsG");
        properties.add("GHasTypeDictionary");
        mapOfProperties.put("AWebCaptureCommandSettings", properties);
    }

    private static void fillMapOfLinksAWebCaptureCommandSettings() {
        links = new ArrayList<String>();
        links.add("C");
        links.add("G");
        mapOfLinks.put("AWebCaptureCommandSettings", links);
    }

    private static void fillMapOfSuperNamesAWebCaptureImageSet() {
        mapOfSuperNames.put("AWebCaptureImageSet", "AObject");
    }

    private static void fillMapOfPropertiesAWebCaptureImageSet() {
        properties = new ArrayList<String>();
        properties.add("containsCT");
        properties.add("CTHasTypeString");
        properties.add("containsID");
        properties.add("entryIDHasTypeString");
        properties.add("containsO");
        properties.add("OHasTypeArray");
        properties.add("OArraySize");
        properties.add("containsR");
        properties.add("RHasTypeArray");
        properties.add("RHasTypeInteger");
        properties.add("RIntegerValue");
        properties.add("RArraySize");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSI");
        properties.add("SIHasTypeArray");
        properties.add("SIHasTypeDictionary");
        properties.add("containsTS");
        properties.add("TSHasTypeDate");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AWebCaptureImageSet", properties);
    }

    private static void fillMapOfLinksAWebCaptureImageSet() {
        links = new ArrayList<String>();
        links.add("O");
        links.add("R");
        links.add("SI");
        mapOfLinks.put("AWebCaptureImageSet", links);
    }

    private static void fillMapOfSuperNamesAWebCaptureInfo() {
        mapOfSuperNames.put("AWebCaptureInfo", "AObject");
    }

    private static void fillMapOfPropertiesAWebCaptureInfo() {
        properties = new ArrayList<String>();
        properties.add("containsC");
        properties.add("CHasTypeArray");
        properties.add("containsV");
        properties.add("VHasTypeNumber");
        properties.add("VNumberValue");
        mapOfProperties.put("AWebCaptureInfo", properties);
    }

    private static void fillMapOfLinksAWebCaptureInfo() {
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("AWebCaptureInfo", links);
    }

    private static void fillMapOfSuperNamesAWebCapturePageSet() {
        mapOfSuperNames.put("AWebCapturePageSet", "AObject");
    }

    private static void fillMapOfPropertiesAWebCapturePageSet() {
        properties = new ArrayList<String>();
        properties.add("containsCT");
        properties.add("CTHasTypeStringAscii");
        properties.add("containsID");
        properties.add("entryIDHasTypeStringByte");
        properties.add("containsO");
        properties.add("OHasTypeArray");
        properties.add("containsS");
        properties.add("SHasTypeName");
        properties.add("SNameValue");
        properties.add("containsSI");
        properties.add("SIHasTypeArray");
        properties.add("SIHasTypeDictionary");
        properties.add("containsT");
        properties.add("THasTypeStringText");
        properties.add("containsTID");
        properties.add("TIDHasTypeStringByte");
        properties.add("containsTS");
        properties.add("TSHasTypeDate");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AWebCapturePageSet", properties);
    }

    private static void fillMapOfLinksAWebCapturePageSet() {
        links = new ArrayList<String>();
        links.add("O");
        links.add("SI");
        mapOfLinks.put("AWebCapturePageSet", links);
    }

    private static void fillMapOfSuperNamesAWhitepointArray() {
        mapOfSuperNames.put("AWhitepointArray", "AObject");
    }

    private static void fillMapOfPropertiesAWhitepointArray() {
        properties = new ArrayList<String>();
        properties.add("entry0HasTypeNumber");
        properties.add("entry0NumberValue");
        properties.add("entry1HasTypeNumber");
        properties.add("entry1NumberValue");
        properties.add("entry2HasTypeNumber");
        properties.add("entry2NumberValue");
        mapOfProperties.put("AWhitepointArray", properties);
    }

    private static void fillMapOfLinksAWhitepointArray() {
        links = new ArrayList<String>();
        mapOfLinks.put("AWhitepointArray", links);
    }

    private static void fillMapOfSuperNamesAXObjectFormPS() {
        mapOfSuperNames.put("AXObjectFormPS", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectFormPS() {
        properties = new ArrayList<String>();
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLevel1");
        properties.add("isLevel1Indirect");
        properties.add("Level1HasTypeStream");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AXObjectFormPS", properties);
    }

    private static void fillMapOfLinksAXObjectFormPS() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Level1");
        mapOfLinks.put("AXObjectFormPS", links);
    }

    private static void fillMapOfSuperNamesAXObjectFormPSpassthrough() {
        mapOfSuperNames.put("AXObjectFormPSpassthrough", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectFormPSpassthrough() {
        properties = new ArrayList<String>();
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFormType");
        properties.add("FormTypeHasTypeInteger");
        properties.add("FormTypeIntegerValue");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsLevel1");
        properties.add("isLevel1Indirect");
        properties.add("Level1HasTypeStream");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsPS");
        properties.add("isPSIndirect");
        properties.add("PSHasTypeStream");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsSubtype2");
        properties.add("Subtype2HasTypeName");
        properties.add("Subtype2NameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        mapOfProperties.put("AXObjectFormPSpassthrough", properties);
    }

    private static void fillMapOfLinksAXObjectFormPSpassthrough() {
        links = new ArrayList<String>();
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Level1");
        links.add("PS");
        mapOfLinks.put("AXObjectFormPSpassthrough", links);
    }

    private static void fillMapOfSuperNamesAXObjectFormPrinterMark() {
        mapOfSuperNames.put("AXObjectFormPrinterMark", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectFormPrinterMark() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsColorants");
        properties.add("ColorantsHasTypeDictionary");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFormType");
        properties.add("FormTypeHasTypeInteger");
        properties.add("FormTypeIntegerValue");
        properties.add("containsGroup");
        properties.add("GroupHasTypeDictionary");
        properties.add("containsLastModified");
        properties.add("LastModifiedHasTypeDate");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMarkStyle");
        properties.add("MarkStyleHasTypeStringText");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOPI");
        properties.add("OPIHasTypeDictionary");
        properties.add("containsPieceInfo");
        properties.add("PieceInfoHasTypeDictionary");
        properties.add("containsPtData");
        properties.add("PtDataHasTypeDictionary");
        properties.add("containsRef");
        properties.add("RefHasTypeDictionary");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsStructParents");
        properties.add("StructParentsHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AXObjectFormPrinterMark", properties);
    }

    private static void fillMapOfLinksAXObjectFormPrinterMark() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("Colorants");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Group");
        links.add("Measure");
        links.add("Metadata");
        links.add("OC");
        links.add("OPI");
        links.add("PieceInfo");
        links.add("PtData");
        links.add("Ref");
        links.add("Resources");
        mapOfLinks.put("AXObjectFormPrinterMark", links);
    }

    private static void fillMapOfSuperNamesAXObjectFormTrapNet() {
        mapOfSuperNames.put("AXObjectFormTrapNet", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectFormTrapNet() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFormType");
        properties.add("FormTypeHasTypeInteger");
        properties.add("FormTypeIntegerValue");
        properties.add("containsGroup");
        properties.add("GroupHasTypeDictionary");
        properties.add("containsLastModified");
        properties.add("LastModifiedHasTypeDate");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOPI");
        properties.add("OPIHasTypeDictionary");
        properties.add("containsPCM");
        properties.add("PCMHasTypeName");
        properties.add("PCMNameValue");
        properties.add("containsPieceInfo");
        properties.add("PieceInfoHasTypeDictionary");
        properties.add("containsPtData");
        properties.add("PtDataHasTypeDictionary");
        properties.add("containsRef");
        properties.add("RefHasTypeDictionary");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsSeparationColorNames");
        properties.add("SeparationColorNamesHasTypeArray");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsStructParents");
        properties.add("StructParentsHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsTrapRegions");
        properties.add("TrapRegionsHasTypeArray");
        properties.add("containsTrapStyles");
        properties.add("TrapStylesHasTypeStringText");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AXObjectFormTrapNet", properties);
    }

    private static void fillMapOfLinksAXObjectFormTrapNet() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Group");
        links.add("Measure");
        links.add("Metadata");
        links.add("OC");
        links.add("OPI");
        links.add("PieceInfo");
        links.add("PtData");
        links.add("Ref");
        links.add("Resources");
        links.add("SeparationColorNames");
        links.add("TrapRegions");
        mapOfLinks.put("AXObjectFormTrapNet", links);
    }

    private static void fillMapOfSuperNamesAXObjectFormType1() {
        mapOfSuperNames.put("AXObjectFormType1", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectFormType1() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsBBox");
        properties.add("BBoxHasTypeRectangle");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsFormType");
        properties.add("FormTypeHasTypeInteger");
        properties.add("FormTypeIntegerValue");
        properties.add("containsGTS_Encapsulated");
        properties.add("GTS_EncapsulatedHasTypeBoolean");
        properties.add("containsGTS_Env");
        properties.add("GTS_EnvHasTypeStringText");
        properties.add("containsGTS_Scope");
        properties.add("GTS_ScopeHasTypeName");
        properties.add("GTS_ScopeNameValue");
        properties.add("containsGTS_XID");
        properties.add("GTS_XIDHasTypeString");
        properties.add("containsGroup");
        properties.add("GroupHasTypeDictionary");
        properties.add("containsLastModified");
        properties.add("LastModifiedHasTypeDate");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMatrix");
        properties.add("MatrixHasTypeMatrix");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOPI");
        properties.add("OPIHasTypeDictionary");
        properties.add("containsPieceInfo");
        properties.add("PieceInfoHasTypeDictionary");
        properties.add("containsPtData");
        properties.add("PtDataHasTypeDictionary");
        properties.add("containsRef");
        properties.add("RefHasTypeDictionary");
        properties.add("containsResources");
        properties.add("ResourcesHasTypeDictionary");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsStructParents");
        properties.add("StructParentsHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsXUID");
        properties.add("XUIDHasTypeArray");
        properties.add("hasExtensionADBE_Extn3");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("AXObjectFormType1", properties);
    }

    private static void fillMapOfLinksAXObjectFormType1() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Group");
        links.add("Measure");
        links.add("Metadata");
        links.add("OC");
        links.add("OPI");
        links.add("PieceInfo");
        links.add("PtData");
        links.add("Ref");
        links.add("Resources");
        links.add("XUID");
        mapOfLinks.put("AXObjectFormType1", links);
    }

    private static void fillMapOfSuperNamesAXObjectImage() {
        mapOfSuperNames.put("AXObjectImage", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectImage() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAlternates");
        properties.add("AlternatesHasTypeArray");
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeArray");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("FilterEntriesString");
        properties.add("containsGTS_Encapsulated");
        properties.add("GTS_EncapsulatedHasTypeBoolean");
        properties.add("containsGTS_Env");
        properties.add("GTS_EnvHasTypeStringText");
        properties.add("containsGTS_Scope");
        properties.add("GTS_ScopeHasTypeName");
        properties.add("GTS_ScopeNameValue");
        properties.add("containsGTS_XID");
        properties.add("GTS_XIDHasTypeString");
        properties.add("containsHeight");
        properties.add("HeightHasTypeInteger");
        properties.add("containsID");
        properties.add("entryIDHasTypeStringByte");
        properties.add("containsImageMask");
        properties.add("ImageMaskHasTypeBoolean");
        properties.add("ImageMaskBooleanValue");
        properties.add("containsIntent");
        properties.add("IntentHasTypeName");
        properties.add("containsInterpolate");
        properties.add("InterpolateHasTypeBoolean");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMask");
        properties.add("isMaskIndirect");
        properties.add("MaskHasTypeArray");
        properties.add("MaskHasTypeStream");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOPI");
        properties.add("OPIHasTypeDictionary");
        properties.add("containsPtData");
        properties.add("PtDataHasTypeDictionary");
        properties.add("containsSMask");
        properties.add("isSMaskIndirect");
        properties.add("SMaskHasTypeStream");
        properties.add("containsSMaskInData");
        properties.add("SMaskInDataHasTypeInteger");
        properties.add("SMaskInDataIntegerValue");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeInteger");
        properties.add("imageIsStructContentItem");
        properties.add("hasExtensionADBE_Extn3");
        properties.add("hasExtensionPDF_VT2");
        mapOfProperties.put("AXObjectImage", properties);
    }

    private static void fillMapOfLinksAXObjectImage() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("Alternates");
        links.add("ColorSpace");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Mask");
        links.add("Measure");
        links.add("Metadata");
        links.add("OC");
        links.add("OPI");
        links.add("PtData");
        links.add("SMask");
        mapOfLinks.put("AXObjectImage", links);
    }

    private static void fillMapOfSuperNamesAXObjectImageMask() {
        mapOfSuperNames.put("AXObjectImageMask", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectImageMask() {
        properties = new ArrayList<String>();
        properties.add("containsAF");
        properties.add("AFHasTypeArray");
        properties.add("AFHasTypeDictionary");
        properties.add("containsAlternates");
        properties.add("AlternatesHasTypeArray");
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("DecodeArraySize");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("containsHeight");
        properties.add("HeightHasTypeInteger");
        properties.add("containsID");
        properties.add("entryIDHasTypeString");
        properties.add("containsImageMask");
        properties.add("ImageMaskHasTypeBoolean");
        properties.add("ImageMaskBooleanValue");
        properties.add("containsIntent");
        properties.add("IntentHasTypeName");
        properties.add("containsInterpolate");
        properties.add("InterpolateHasTypeBoolean");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMeasure");
        properties.add("MeasureHasTypeDictionary");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsOC");
        properties.add("OCHasTypeDictionary");
        properties.add("containsOPI");
        properties.add("OPIHasTypeDictionary");
        properties.add("containsPtData");
        properties.add("PtDataHasTypeDictionary");
        properties.add("containsSMask");
        properties.add("isSMaskIndirect");
        properties.add("SMaskHasTypeStream");
        properties.add("containsSMaskInData");
        properties.add("SMaskInDataHasTypeInteger");
        properties.add("containsStructParent");
        properties.add("StructParentHasTypeInteger");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeInteger");
        properties.add("imageIsStructContentItem");
        properties.add("Decode1IntegerValue");
        properties.add("Decode0IntegerValue");
        properties.add("hasExtensionADBE_Extn3");
        mapOfProperties.put("AXObjectImageMask", properties);
    }

    private static void fillMapOfLinksAXObjectImageMask() {
        links = new ArrayList<String>();
        links.add("AF");
        links.add("Alternates");
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Measure");
        links.add("Metadata");
        links.add("OC");
        links.add("OPI");
        links.add("PtData");
        links.add("SMask");
        mapOfLinks.put("AXObjectImageMask", links);
    }

    private static void fillMapOfSuperNamesAXObjectImageSoftMask() {
        mapOfSuperNames.put("AXObjectImageSoftMask", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectImageSoftMask() {
        properties = new ArrayList<String>();
        properties.add("containsBitsPerComponent");
        properties.add("BitsPerComponentHasTypeInteger");
        properties.add("BitsPerComponentIntegerValue");
        properties.add("containsColorSpace");
        properties.add("ColorSpaceHasTypeName");
        properties.add("ColorSpaceNameValue");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecode");
        properties.add("DecodeHasTypeArray");
        properties.add("containsDecodeParms");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("FilterEntriesString");
        properties.add("containsHeight");
        properties.add("HeightHasTypeInteger");
        properties.add("HeightIntegerValue");
        properties.add("containsImageMask");
        properties.add("ImageMaskHasTypeBoolean");
        properties.add("ImageMaskBooleanValue");
        properties.add("containsIntent");
        properties.add("IntentHasTypeName");
        properties.add("containsInterpolate");
        properties.add("InterpolateHasTypeBoolean");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("containsMatte");
        properties.add("MatteHasTypeArray");
        properties.add("MatteArraySize");
        properties.add("containsMetadata");
        properties.add("isMetadataIndirect");
        properties.add("MetadataHasTypeStream");
        properties.add("containsName");
        properties.add("NameHasTypeName");
        properties.add("containsSubtype");
        properties.add("SubtypeHasTypeName");
        properties.add("SubtypeNameValue");
        properties.add("containsType");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsWidth");
        properties.add("WidthHasTypeInteger");
        properties.add("WidthIntegerValue");
        properties.add("parentWidthIntegerValue");
        properties.add("parentHeightIntegerValue");
        properties.add("parentWidthHasTypeInteger");
        properties.add("parentHeightHasTypeInteger");
        mapOfProperties.put("AXObjectImageSoftMask", properties);
    }

    private static void fillMapOfLinksAXObjectImageSoftMask() {
        links = new ArrayList<String>();
        links.add("Decode");
        links.add("DecodeParms");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("Matte");
        links.add("Metadata");
        mapOfLinks.put("AXObjectImageSoftMask", links);
    }

    private static void fillMapOfSuperNamesAXObjectMap() {
        mapOfSuperNames.put("AXObjectMap", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("AXObjectMap", properties);
    }

    private static void fillMapOfLinksAXObjectMap() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("AXObjectMap", links);
    }

    private static void fillMapOfSuperNamesAXObjectMapEntry() {
        mapOfSuperNames.put("AXObjectMapEntry", "AObject");
    }

    private static void fillMapOfPropertiesAXObjectMapEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeStream");
        mapOfProperties.put("AXObjectMapEntry", properties);
    }

    private static void fillMapOfLinksAXObjectMapEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("AXObjectMapEntry", links);
    }

    private static void fillMapOfSuperNamesAXRefStream() {
        mapOfSuperNames.put("AXRefStream", "AObject");
    }

    private static void fillMapOfPropertiesAXRefStream() {
        properties = new ArrayList<String>();
        properties.add("containsAuthCode");
        properties.add("isAuthCodeIndirect");
        properties.add("AuthCodeHasTypeDictionary");
        properties.add("containsDL");
        properties.add("DLHasTypeInteger");
        properties.add("DLIntegerValue");
        properties.add("containsDecodeParms");
        properties.add("isDecodeParmsIndirect");
        properties.add("DecodeParmsHasTypeArray");
        properties.add("DecodeParmsHasTypeDictionary");
        properties.add("DecodeParmsArraySize");
        properties.add("containsEncrypt");
        properties.add("EncryptHasTypeDictionary");
        properties.add("containsF");
        properties.add("FHasTypeDictionary");
        properties.add("FHasTypeString");
        properties.add("containsFDecodeParms");
        properties.add("FDecodeParmsHasTypeArray");
        properties.add("FDecodeParmsHasTypeDictionary");
        properties.add("FDecodeParmsArraySize");
        properties.add("containsFFilter");
        properties.add("FFilterHasTypeArray");
        properties.add("FFilterHasTypeName");
        properties.add("FFilterNameValue");
        properties.add("FFilterArraySize");
        properties.add("containsFilter");
        properties.add("isFilterIndirect");
        properties.add("FilterHasTypeArray");
        properties.add("FilterHasTypeName");
        properties.add("FilterNameValue");
        properties.add("FilterArraySize");
        properties.add("FilterEntriesString");
        properties.add("containsID");
        properties.add("isentryIDIndirect");
        properties.add("entryIDHasTypeArray");
        properties.add("containsIndex");
        properties.add("isIndexIndirect");
        properties.add("IndexHasTypeArray");
        properties.add("isIndexArraySortAscending2");
        properties.add("IndexArraySize");
        properties.add("containsInfo");
        properties.add("isInfoIndirect");
        properties.add("InfoHasTypeDictionary");
        properties.add("containsLength");
        properties.add("LengthHasTypeInteger");
        properties.add("LengthIntegerValue");
        properties.add("containsPrev");
        properties.add("isPrevIndirect");
        properties.add("PrevHasTypeInteger");
        properties.add("PrevIntegerValue");
        properties.add("containsRoot");
        properties.add("isRootIndirect");
        properties.add("RootHasTypeDictionary");
        properties.add("containsSize");
        properties.add("isSizeIndirect");
        properties.add("SizeHasTypeInteger");
        properties.add("SizeIntegerValue");
        properties.add("containsType");
        properties.add("isTypeIndirect");
        properties.add("TypeHasTypeName");
        properties.add("TypeNameValue");
        properties.add("containsW");
        properties.add("isWIndirect");
        properties.add("WHasTypeArray");
        properties.add("EncryptVIntegerValue");
        properties.add("EncryptVHasTypeInteger");
        properties.add("containstrailerInfoModDate");
        properties.add("containstrailerCatalogPieceInfo");
        properties.add("hasExtensionISO_TS_32004");
        mapOfProperties.put("AXRefStream", properties);
    }

    private static void fillMapOfLinksAXRefStream() {
        links = new ArrayList<String>();
        links.add("AuthCode");
        links.add("DecodeParms");
        links.add("Encrypt");
        links.add("F");
        links.add("FDecodeParms");
        links.add("FFilter");
        links.add("Filter");
        links.add("entryID");
        links.add("Index");
        links.add("Info");
        links.add("Root");
        links.add("W");
        mapOfLinks.put("AXRefStream", links);
    }

    private static void fillMapOfSuperNamesA_UniversalArray() {
        mapOfSuperNames.put("A_UniversalArray", "AObject");
    }

    private static void fillMapOfPropertiesA_UniversalArray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("A_UniversalArray", properties);
    }

    private static void fillMapOfLinksA_UniversalArray() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("A_UniversalArray", links);
    }

    private static void fillMapOfSuperNamesA_UniversalArrayEntry() {
        mapOfSuperNames.put("A_UniversalArrayEntry", "AObject");
    }

    private static void fillMapOfPropertiesA_UniversalArrayEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeArray");
        properties.add("HasTypeBoolean");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeName");
        properties.add("HasTypeNull");
        properties.add("HasTypeNumber");
        properties.add("HasTypeStream");
        properties.add("HasTypeString");
        mapOfProperties.put("A_UniversalArrayEntry", properties);
    }

    private static void fillMapOfLinksA_UniversalArrayEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("A_UniversalArrayEntry", links);
    }

    private static void fillMapOfSuperNamesA_UniversalDictionary() {
        mapOfSuperNames.put("A_UniversalDictionary", "AObject");
    }

    private static void fillMapOfPropertiesA_UniversalDictionary() {
        properties = new ArrayList<String>();
        mapOfProperties.put("A_UniversalDictionary", properties);
    }

    private static void fillMapOfLinksA_UniversalDictionary() {
        links = new ArrayList<String>();
        links.add("Entries");
        mapOfLinks.put("A_UniversalDictionary", links);
    }

    private static void fillMapOfSuperNamesA_UniversalDictionaryEntry() {
        mapOfSuperNames.put("A_UniversalDictionaryEntry", "AObject");
    }

    private static void fillMapOfPropertiesA_UniversalDictionaryEntry() {
        properties = new ArrayList<String>();
        properties.add("isIndirect");
        properties.add("HasTypeArray");
        properties.add("HasTypeBoolean");
        properties.add("HasTypeDictionary");
        properties.add("HasTypeName");
        properties.add("HasTypeNull");
        properties.add("HasTypeNumber");
        properties.add("HasTypeStream");
        properties.add("HasTypeString");
        mapOfProperties.put("A_UniversalDictionaryEntry", properties);
    }

    private static void fillMapOfLinksA_UniversalDictionaryEntry() {
        links = new ArrayList<String>();
        links.add("Entry");
        mapOfLinks.put("A_UniversalDictionaryEntry", links);
    }

    private static void fillMapOfSuperNamesPDObject() {
        mapOfSuperNames.put("PDObject", "Object");
    }

    private static void fillMapOfPropertiesPDObject() {
        properties = new ArrayList<String>();
        properties.add("entries");
        mapOfProperties.put("PDObject", properties);
    }

    private static void fillMapOfLinksPDObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDObject", links);
    }

    private static void fillMapOfSuperNamesPDDocument() {
        mapOfSuperNames.put("PDDocument", "PDObject");
    }

    private static void fillMapOfPropertiesPDDocument() {
        properties = new ArrayList<String>();
        properties.add("containsAlternatePresentations");
        properties.add("validPDF");
        properties.add("containsAA");
        properties.add("outputColorSpace");
        properties.add("Version");
        properties.add("mostCommonOrientation");
        mapOfProperties.put("PDDocument", properties);
    }

    private static void fillMapOfLinksPDDocument() {
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("pages");
        links.add("metadata");
        links.add("AcroForm");
        links.add("AA");
        links.add("OpenAction");
        links.add("Outlines");
        links.add("OCProperties");
        links.add("StructTreeRoot");
        links.add("Lang");
        links.add("Perms");
        mapOfLinks.put("PDDocument", links);
    }

    private static void fillMapOfSuperNamesPDPage() {
        mapOfSuperNames.put("PDPage", "PDObject");
    }

    private static void fillMapOfPropertiesPDPage() {
        properties = new ArrayList<String>();
        properties.add("containsPresSteps");
        properties.add("containsTransparency");
        properties.add("containsGroupCS");
        properties.add("containsAA");
        properties.add("Tabs");
        properties.add("orientation");
        properties.add("outputColorSpace");
        properties.add("pageNumber");
        mapOfProperties.put("PDPage", properties);
    }

    private static void fillMapOfLinksPDPage() {
        links = new ArrayList<String>();
        links.add("outputIntents");
        links.add("AA");
        links.add("transparencyColorSpace");
        links.add("contentStream");
        links.add("annots");
        links.add("parentTransparencyColorSpace");
        links.add("Group");
        links.add("MediaBox");
        links.add("CropBox");
        links.add("BleedBox");
        links.add("TrimBox");
        links.add("ArtBox");
        links.add("resources");
        mapOfLinks.put("PDPage", links);
    }

    private static void fillMapOfSuperNamesTransparencyColorSpace() {
        mapOfSuperNames.put("TransparencyColorSpace", "Object");
    }

    private static void fillMapOfPropertiesTransparencyColorSpace() {
        properties = new ArrayList<String>();
        properties.add("colorSpaceType");
        mapOfProperties.put("TransparencyColorSpace", properties);
    }

    private static void fillMapOfLinksTransparencyColorSpace() {
        links = new ArrayList<String>();
        mapOfLinks.put("TransparencyColorSpace", links);
    }

    private static void fillMapOfSuperNamesOutputIntents() {
        mapOfSuperNames.put("OutputIntents", "Object");
    }

    private static void fillMapOfPropertiesOutputIntents() {
        properties = new ArrayList<String>();
        properties.add("sameOutputProfileIndirect");
        properties.add("outputProfileIndirects");
        mapOfProperties.put("OutputIntents", properties);
    }

    private static void fillMapOfLinksOutputIntents() {
        links = new ArrayList<String>();
        links.add("outputIntents");
        mapOfLinks.put("OutputIntents", links);
    }

    private static void fillMapOfSuperNamesPDContentStream() {
        mapOfSuperNames.put("PDContentStream", "PDObject");
    }

    private static void fillMapOfPropertiesPDContentStream() {
        properties = new ArrayList<String>();
        properties.add("undefinedResourceNames");
        properties.add("inheritedResourceNames");
        mapOfProperties.put("PDContentStream", properties);
    }

    private static void fillMapOfLinksPDContentStream() {
        links = new ArrayList<String>();
        links.add("operators");
        links.add("resources");
        mapOfLinks.put("PDContentStream", links);
    }

    private static void fillMapOfSuperNamesPDSemanticContentStream() {
        mapOfSuperNames.put("PDSemanticContentStream", "PDContentStream");
    }

    private static void fillMapOfPropertiesPDSemanticContentStream() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSemanticContentStream", properties);
    }

    private static void fillMapOfLinksPDSemanticContentStream() {
        links = new ArrayList<String>();
        links.add("content");
        mapOfLinks.put("PDSemanticContentStream", links);
    }

    private static void fillMapOfSuperNamesPDResource() {
        mapOfSuperNames.put("PDResource", "PDObject");
    }

    private static void fillMapOfPropertiesPDResource() {
        properties = new ArrayList<String>();
        properties.add("isInherited");
        mapOfProperties.put("PDResource", properties);
    }

    private static void fillMapOfLinksPDResource() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDResource", links);
    }

    private static void fillMapOfSuperNamesPDColorSpace() {
        mapOfSuperNames.put("PDColorSpace", "PDResource");
    }

    private static void fillMapOfPropertiesPDColorSpace() {
        properties = new ArrayList<String>();
        properties.add("nrComponents");
        mapOfProperties.put("PDColorSpace", properties);
    }

    private static void fillMapOfLinksPDColorSpace() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDColorSpace", links);
    }

    private static void fillMapOfSuperNamesPDAdditionalActions() {
        mapOfSuperNames.put("PDAdditionalActions", "PDObject");
    }

    private static void fillMapOfPropertiesPDAdditionalActions() {
        properties = new ArrayList<String>();
        properties.add("parentType");
        mapOfProperties.put("PDAdditionalActions", properties);
    }

    private static void fillMapOfLinksPDAdditionalActions() {
        links = new ArrayList<String>();
        links.add("Actions");
        mapOfLinks.put("PDAdditionalActions", links);
    }

    private static void fillMapOfSuperNamesPDDeviceGray() {
        mapOfSuperNames.put("PDDeviceGray", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDDeviceGray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceGray", properties);
    }

    private static void fillMapOfLinksPDDeviceGray() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceGray", links);
    }

    private static void fillMapOfSuperNamesPDDeviceRGB() {
        mapOfSuperNames.put("PDDeviceRGB", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDDeviceRGB() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceRGB", properties);
    }

    private static void fillMapOfLinksPDDeviceRGB() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceRGB", links);
    }

    private static void fillMapOfSuperNamesPDDeviceCMYK() {
        mapOfSuperNames.put("PDDeviceCMYK", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDDeviceCMYK() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceCMYK", properties);
    }

    private static void fillMapOfLinksPDDeviceCMYK() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceCMYK", links);
    }

    private static void fillMapOfSuperNamesPDICCBased() {
        mapOfSuperNames.put("PDICCBased", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDICCBased() {
        properties = new ArrayList<String>();
        properties.add("ICCProfileIndirect");
        properties.add("currentTransparencyProfileIndirect");
        properties.add("ICCProfileMD5");
        properties.add("currentTransparencyICCProfileMD5");
        mapOfProperties.put("PDICCBased", properties);
    }

    private static void fillMapOfLinksPDICCBased() {
        links = new ArrayList<String>();
        links.add("iccProfile");
        mapOfLinks.put("PDICCBased", links);
    }

    private static void fillMapOfSuperNamesPDICCBasedCMYK() {
        mapOfSuperNames.put("PDICCBasedCMYK", "PDICCBased");
    }

    private static void fillMapOfPropertiesPDICCBasedCMYK() {
        properties = new ArrayList<String>();
        properties.add("OPM");
        properties.add("overprintFlag");
        mapOfProperties.put("PDICCBasedCMYK", properties);
    }

    private static void fillMapOfLinksPDICCBasedCMYK() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDICCBasedCMYK", links);
    }

    private static void fillMapOfSuperNamesPDLab() {
        mapOfSuperNames.put("PDLab", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDLab() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLab", properties);
    }

    private static void fillMapOfLinksPDLab() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDLab", links);
    }

    private static void fillMapOfSuperNamesPDCalGray() {
        mapOfSuperNames.put("PDCalGray", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDCalGray() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalGray", properties);
    }

    private static void fillMapOfLinksPDCalGray() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalGray", links);
    }

    private static void fillMapOfSuperNamesPDCalRGB() {
        mapOfSuperNames.put("PDCalRGB", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDCalRGB() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalRGB", properties);
    }

    private static void fillMapOfLinksPDCalRGB() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalRGB", links);
    }

    private static void fillMapOfSuperNamesPDSeparation() {
        mapOfSuperNames.put("PDSeparation", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDSeparation() {
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("areTintAndAlternateConsistent");
        mapOfProperties.put("PDSeparation", properties);
    }

    private static void fillMapOfLinksPDSeparation() {
        links = new ArrayList<String>();
        links.add("tintTransform");
        links.add("alternate");
        links.add("colorantName");
        mapOfLinks.put("PDSeparation", links);
    }

    private static void fillMapOfSuperNamesPDDeviceN() {
        mapOfSuperNames.put("PDDeviceN", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDDeviceN() {
        properties = new ArrayList<String>();
        properties.add("areColorantsPresent");
        mapOfProperties.put("PDDeviceN", properties);
    }

    private static void fillMapOfLinksPDDeviceN() {
        links = new ArrayList<String>();
        links.add("tintTransform");
        links.add("alternate");
        links.add("colorantNames");
        links.add("Colorants");
        links.add("processColor");
        mapOfLinks.put("PDDeviceN", links);
    }

    private static void fillMapOfSuperNamesPDIndexed() {
        mapOfSuperNames.put("PDIndexed", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDIndexed() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDIndexed", properties);
    }

    private static void fillMapOfLinksPDIndexed() {
        links = new ArrayList<String>();
        links.add("base");
        mapOfLinks.put("PDIndexed", links);
    }

    private static void fillMapOfSuperNamesPDPattern() {
        mapOfSuperNames.put("PDPattern", "PDColorSpace");
    }

    private static void fillMapOfPropertiesPDPattern() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPattern", properties);
    }

    private static void fillMapOfLinksPDPattern() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDPattern", links);
    }

    private static void fillMapOfSuperNamesPDTilingPattern() {
        mapOfSuperNames.put("PDTilingPattern", "PDPattern");
    }

    private static void fillMapOfPropertiesPDTilingPattern() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTilingPattern", properties);
    }

    private static void fillMapOfLinksPDTilingPattern() {
        links = new ArrayList<String>();
        links.add("contentStream");
        mapOfLinks.put("PDTilingPattern", links);
    }

    private static void fillMapOfSuperNamesPDShadingPattern() {
        mapOfSuperNames.put("PDShadingPattern", "PDPattern");
    }

    private static void fillMapOfPropertiesPDShadingPattern() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShadingPattern", properties);
    }

    private static void fillMapOfLinksPDShadingPattern() {
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("PDShadingPattern", links);
    }

    private static void fillMapOfSuperNamesPDFont() {
        mapOfSuperNames.put("PDFont", "PDResource");
    }

    private static void fillMapOfPropertiesPDFont() {
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("Subtype");
        properties.add("fontName");
        properties.add("isSymbolic");
        properties.add("renderingMode");
        properties.add("fontFileSubtype");
        properties.add("isItalic");
        mapOfProperties.put("PDFont", properties);
    }

    private static void fillMapOfLinksPDFont() {
        links = new ArrayList<String>();
        links.add("BaseFont");
        links.add("fontFile");
        mapOfLinks.put("PDFont", links);
    }

    private static void fillMapOfSuperNamesPDSimpleFont() {
        mapOfSuperNames.put("PDSimpleFont", "PDFont");
    }

    private static void fillMapOfPropertiesPDSimpleFont() {
        properties = new ArrayList<String>();
        properties.add("isStandard");
        properties.add("FirstChar");
        properties.add("LastChar");
        properties.add("Widths_size");
        properties.add("Encoding");
        properties.add("containsDifferences");
        mapOfProperties.put("PDSimpleFont", properties);
    }

    private static void fillMapOfLinksPDSimpleFont() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDSimpleFont", links);
    }

    private static void fillMapOfSuperNamesPDTrueTypeFont() {
        mapOfSuperNames.put("PDTrueTypeFont", "PDSimpleFont");
    }

    private static void fillMapOfPropertiesPDTrueTypeFont() {
        properties = new ArrayList<String>();
        properties.add("differencesAreUnicodeCompliant");
        mapOfProperties.put("PDTrueTypeFont", properties);
    }

    private static void fillMapOfLinksPDTrueTypeFont() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrueTypeFont", links);
    }

    private static void fillMapOfSuperNamesPDType1Font() {
        mapOfSuperNames.put("PDType1Font", "PDSimpleFont");
    }

    private static void fillMapOfPropertiesPDType1Font() {
        properties = new ArrayList<String>();
        properties.add("CharSet");
        properties.add("charSetListsAllGlyphs");
        mapOfProperties.put("PDType1Font", properties);
    }

    private static void fillMapOfLinksPDType1Font() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDType1Font", links);
    }

    private static void fillMapOfSuperNamesPDType3Font() {
        mapOfSuperNames.put("PDType3Font", "PDSimpleFont");
    }

    private static void fillMapOfPropertiesPDType3Font() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Font", properties);
    }

    private static void fillMapOfLinksPDType3Font() {
        links = new ArrayList<String>();
        links.add("charStrings");
        mapOfLinks.put("PDType3Font", links);
    }

    private static void fillMapOfSuperNamesPDCIDFont() {
        mapOfSuperNames.put("PDCIDFont", "PDFont");
    }

    private static void fillMapOfPropertiesPDCIDFont() {
        properties = new ArrayList<String>();
        properties.add("CIDToGIDMap");
        properties.add("containsCIDSet");
        properties.add("cidSetListsAllGlyphs");
        mapOfProperties.put("PDCIDFont", properties);
    }

    private static void fillMapOfLinksPDCIDFont() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDCIDFont", links);
    }

    private static void fillMapOfSuperNamesPDType0Font() {
        mapOfSuperNames.put("PDType0Font", "PDFont");
    }

    private static void fillMapOfPropertiesPDType0Font() {
        properties = new ArrayList<String>();
        properties.add("CIDFontOrdering");
        properties.add("CMapOrdering");
        properties.add("CIDFontRegistry");
        properties.add("CMapRegistry");
        properties.add("CIDFontSupplement");
        properties.add("CMapSupplement");
        properties.add("cmapName");
        mapOfProperties.put("PDType0Font", properties);
    }

    private static void fillMapOfLinksPDType0Font() {
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        mapOfLinks.put("PDType0Font", links);
    }

    private static void fillMapOfSuperNamesPDCMap() {
        mapOfSuperNames.put("PDCMap", "PDObject");
    }

    private static void fillMapOfPropertiesPDCMap() {
        properties = new ArrayList<String>();
        properties.add("CMapName");
        mapOfProperties.put("PDCMap", properties);
    }

    private static void fillMapOfLinksPDCMap() {
        links = new ArrayList<String>();
        links.add("UseCMap");
        links.add("embeddedFile");
        mapOfLinks.put("PDCMap", links);
    }

    private static void fillMapOfSuperNamesPDReferencedCMap() {
        mapOfSuperNames.put("PDReferencedCMap", "PDCMap");
    }

    private static void fillMapOfPropertiesPDReferencedCMap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDReferencedCMap", properties);
    }

    private static void fillMapOfLinksPDReferencedCMap() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDReferencedCMap", links);
    }

    private static void fillMapOfSuperNamesPDXObject() {
        mapOfSuperNames.put("PDXObject", "PDResource");
    }

    private static void fillMapOfPropertiesPDXObject() {
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("containsOPI");
        properties.add("containsSMask");
        mapOfProperties.put("PDXObject", properties);
    }

    private static void fillMapOfLinksPDXObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDXObject", links);
    }

    private static void fillMapOfSuperNamesPDXImage() {
        mapOfSuperNames.put("PDXImage", "PDXObject");
    }

    private static void fillMapOfPropertiesPDXImage() {
        properties = new ArrayList<String>();
        properties.add("Interpolate");
        properties.add("containsAlternates");
        properties.add("BitsPerComponent");
        mapOfProperties.put("PDXImage", properties);
    }

    private static void fillMapOfLinksPDXImage() {
        links = new ArrayList<String>();
        links.add("imageCS");
        links.add("Alternates");
        links.add("Intent");
        links.add("jpxStream");
        links.add("SMask");
        mapOfLinks.put("PDXImage", links);
    }

    private static void fillMapOfSuperNamesPDSMaskImage() {
        mapOfSuperNames.put("PDSMaskImage", "PDXImage");
    }

    private static void fillMapOfPropertiesPDSMaskImage() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSMaskImage", properties);
    }

    private static void fillMapOfLinksPDSMaskImage() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDSMaskImage", links);
    }

    private static void fillMapOfSuperNamesPDInlineImage() {
        mapOfSuperNames.put("PDInlineImage", "PDXImage");
    }

    private static void fillMapOfPropertiesPDInlineImage() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDInlineImage", properties);
    }

    private static void fillMapOfLinksPDInlineImage() {
        links = new ArrayList<String>();
        links.add("F");
        mapOfLinks.put("PDInlineImage", links);
    }

    private static void fillMapOfSuperNamesPDXForm() {
        mapOfSuperNames.put("PDXForm", "PDXObject");
    }

    private static void fillMapOfPropertiesPDXForm() {
        properties = new ArrayList<String>();
        properties.add("Subtype2");
        properties.add("containsPS");
        properties.add("containsRef");
        properties.add("isUniqueSemanticParent");
        mapOfProperties.put("PDXForm", properties);
    }

    private static void fillMapOfLinksPDXForm() {
        links = new ArrayList<String>();
        links.add("transparencyColorSpace");
        links.add("contentStream");
        links.add("parentTransparencyColorSpace");
        links.add("Group");
        mapOfLinks.put("PDXForm", links);
    }

    private static void fillMapOfSuperNamesPDResources() {
        mapOfSuperNames.put("PDResources", "PDObject");
    }

    private static void fillMapOfPropertiesPDResources() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDResources", properties);
    }

    private static void fillMapOfLinksPDResources() {
        links = new ArrayList<String>();
        links.add("resourcesNames");
        mapOfLinks.put("PDResources", links);
    }

    private static void fillMapOfSuperNamesPDGroup() {
        mapOfSuperNames.put("PDGroup", "PDObject");
    }

    private static void fillMapOfPropertiesPDGroup() {
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDGroup", properties);
    }

    private static void fillMapOfLinksPDGroup() {
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDGroup", links);
    }

    private static void fillMapOfSuperNamesPDExtGState() {
        mapOfSuperNames.put("PDExtGState", "PDResource");
    }

    private static void fillMapOfPropertiesPDExtGState() {
        properties = new ArrayList<String>();
        properties.add("TR");
        properties.add("TR2");
        properties.add("containsHTP");
        properties.add("containsHTO");
        properties.add("SMask");
        properties.add("BM");
        properties.add("ca");
        properties.add("CA");
        mapOfProperties.put("PDExtGState", properties);
    }

    private static void fillMapOfLinksPDExtGState() {
        links = new ArrayList<String>();
        links.add("HT");
        links.add("bm");
        links.add("RI");
        links.add("customFunctions");
        mapOfLinks.put("PDExtGState", links);
    }

    private static void fillMapOfSuperNamesPDHalftone() {
        mapOfSuperNames.put("PDHalftone", "PDObject");
    }

    private static void fillMapOfPropertiesPDHalftone() {
        properties = new ArrayList<String>();
        properties.add("HalftoneType");
        properties.add("HalftoneName");
        properties.add("colorantName");
        properties.add("TransferFunction");
        mapOfProperties.put("PDHalftone", properties);
    }

    private static void fillMapOfLinksPDHalftone() {
        links = new ArrayList<String>();
        links.add("customFunction");
        links.add("halftones");
        mapOfLinks.put("PDHalftone", links);
    }

    private static void fillMapOfSuperNamesPDShading() {
        mapOfSuperNames.put("PDShading", "PDResource");
    }

    private static void fillMapOfPropertiesPDShading() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShading", properties);
    }

    private static void fillMapOfLinksPDShading() {
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDShading", links);
    }

    private static void fillMapOfSuperNamesPDAnnot() {
        mapOfSuperNames.put("PDAnnot", "PDObject");
    }

    private static void fillMapOfPropertiesPDAnnot() {
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("CA");
        properties.add("F");
        properties.add("AP");
        properties.add("FT");
        properties.add("N_type");
        properties.add("containsC");
        properties.add("containsIC");
        properties.add("width");
        properties.add("height");
        properties.add("containsA");
        properties.add("containsAA");
        properties.add("structParentType");
        properties.add("structParentStandardType");
        properties.add("Contents");
        properties.add("Alt");
        properties.add("isOutsideCropBox");
        mapOfProperties.put("PDAnnot", properties);
    }

    private static void fillMapOfLinksPDAnnot() {
        links = new ArrayList<String>();
        links.add("appearance");
        links.add("A");
        links.add("AA");
        links.add("Lang");
        links.add("BM");
        mapOfLinks.put("PDAnnot", links);
    }

    private static void fillMapOfSuperNamesPDMarkupAnnot() {
        mapOfSuperNames.put("PDMarkupAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDMarkupAnnot() {
        properties = new ArrayList<String>();
        properties.add("RC");
        properties.add("containsRC");
        mapOfProperties.put("PDMarkupAnnot", properties);
    }

    private static void fillMapOfLinksPDMarkupAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDMarkupAnnot", links);
    }

    private static void fillMapOfSuperNamesPD3DAnnot() {
        mapOfSuperNames.put("PD3DAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPD3DAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PD3DAnnot", properties);
    }

    private static void fillMapOfLinksPD3DAnnot() {
        links = new ArrayList<String>();
        links.add("stream3D");
        mapOfLinks.put("PD3DAnnot", links);
    }

    private static void fillMapOfSuperNamesPDFileAttachmentAnnot() {
        mapOfSuperNames.put("PDFileAttachmentAnnot", "PDMarkupAnnot");
    }

    private static void fillMapOfPropertiesPDFileAttachmentAnnot() {
        properties = new ArrayList<String>();
        properties.add("containsFS");
        properties.add("AFRelationship");
        mapOfProperties.put("PDFileAttachmentAnnot", properties);
    }

    private static void fillMapOfLinksPDFileAttachmentAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDFileAttachmentAnnot", links);
    }

    private static void fillMapOfSuperNamesPDInkAnnot() {
        mapOfSuperNames.put("PDInkAnnot", "PDMarkupAnnot");
    }

    private static void fillMapOfPropertiesPDInkAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDInkAnnot", properties);
    }

    private static void fillMapOfLinksPDInkAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDInkAnnot", links);
    }

    private static void fillMapOfSuperNamesPDLinkAnnot() {
        mapOfSuperNames.put("PDLinkAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDLinkAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLinkAnnot", properties);
    }

    private static void fillMapOfLinksPDLinkAnnot() {
        links = new ArrayList<String>();
        links.add("Dest");
        mapOfLinks.put("PDLinkAnnot", links);
    }

    private static void fillMapOfSuperNamesPDMovieAnnot() {
        mapOfSuperNames.put("PDMovieAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDMovieAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDMovieAnnot", properties);
    }

    private static void fillMapOfLinksPDMovieAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDMovieAnnot", links);
    }

    private static void fillMapOfSuperNamesPDPopupAnnot() {
        mapOfSuperNames.put("PDPopupAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDPopupAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPopupAnnot", properties);
    }

    private static void fillMapOfLinksPDPopupAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDPopupAnnot", links);
    }

    private static void fillMapOfSuperNamesPDPrinterMarkAnnot() {
        mapOfSuperNames.put("PDPrinterMarkAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDPrinterMarkAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPrinterMarkAnnot", properties);
    }

    private static void fillMapOfLinksPDPrinterMarkAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDPrinterMarkAnnot", links);
    }

    private static void fillMapOfSuperNamesPDRichMediaAnnot() {
        mapOfSuperNames.put("PDRichMediaAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDRichMediaAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDRichMediaAnnot", properties);
    }

    private static void fillMapOfLinksPDRichMediaAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDRichMediaAnnot", links);
    }

    private static void fillMapOfSuperNamesPDRubberStampAnnot() {
        mapOfSuperNames.put("PDRubberStampAnnot", "PDMarkupAnnot");
    }

    private static void fillMapOfPropertiesPDRubberStampAnnot() {
        properties = new ArrayList<String>();
        properties.add("Name");
        mapOfProperties.put("PDRubberStampAnnot", properties);
    }

    private static void fillMapOfLinksPDRubberStampAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDRubberStampAnnot", links);
    }

    private static void fillMapOfSuperNamesPDScreenAnnot() {
        mapOfSuperNames.put("PDScreenAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDScreenAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDScreenAnnot", properties);
    }

    private static void fillMapOfLinksPDScreenAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDScreenAnnot", links);
    }

    private static void fillMapOfSuperNamesPDSoundAnnot() {
        mapOfSuperNames.put("PDSoundAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDSoundAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSoundAnnot", properties);
    }

    private static void fillMapOfLinksPDSoundAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDSoundAnnot", links);
    }

    private static void fillMapOfSuperNamesPDTrapNetAnnot() {
        mapOfSuperNames.put("PDTrapNetAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDTrapNetAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTrapNetAnnot", properties);
    }

    private static void fillMapOfLinksPDTrapNetAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDTrapNetAnnot", links);
    }

    private static void fillMapOfSuperNamesPDWidgetAnnot() {
        mapOfSuperNames.put("PDWidgetAnnot", "PDAnnot");
    }

    private static void fillMapOfPropertiesPDWidgetAnnot() {
        properties = new ArrayList<String>();
        properties.add("TU");
        mapOfProperties.put("PDWidgetAnnot", properties);
    }

    private static void fillMapOfLinksPDWidgetAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDWidgetAnnot", links);
    }

    private static void fillMapOfSuperNamesPDDestination() {
        mapOfSuperNames.put("PDDestination", "PDObject");
    }

    private static void fillMapOfPropertiesPDDestination() {
        properties = new ArrayList<String>();
        properties.add("isStructDestination");
        mapOfProperties.put("PDDestination", properties);
    }

    private static void fillMapOfLinksPDDestination() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDDestination", links);
    }

    private static void fillMapOfSuperNamesPD3DStream() {
        mapOfSuperNames.put("PD3DStream", "PDObject");
    }

    private static void fillMapOfPropertiesPD3DStream() {
        properties = new ArrayList<String>();
        properties.add("Subtype");
        mapOfProperties.put("PD3DStream", properties);
    }

    private static void fillMapOfLinksPD3DStream() {
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PD3DStream", links);
    }

    private static void fillMapOfSuperNamesPDAcroForm() {
        mapOfSuperNames.put("PDAcroForm", "PDObject");
    }

    private static void fillMapOfPropertiesPDAcroForm() {
        properties = new ArrayList<String>();
        properties.add("NeedAppearances");
        properties.add("containsXFA");
        properties.add("dynamicRender");
        mapOfProperties.put("PDAcroForm", properties);
    }

    private static void fillMapOfLinksPDAcroForm() {
        links = new ArrayList<String>();
        links.add("formFields");
        mapOfLinks.put("PDAcroForm", links);
    }

    private static void fillMapOfSuperNamesPDFormField() {
        mapOfSuperNames.put("PDFormField", "PDObject");
    }

    private static void fillMapOfPropertiesPDFormField() {
        properties = new ArrayList<String>();
        properties.add("FT");
        properties.add("containsAA");
        properties.add("TU");
        properties.add("Ff");
        mapOfProperties.put("PDFormField", properties);
    }

    private static void fillMapOfLinksPDFormField() {
        links = new ArrayList<String>();
        links.add("AA");
        links.add("Lang");
        mapOfLinks.put("PDFormField", links);
    }

    private static void fillMapOfSuperNamesPDTextField() {
        mapOfSuperNames.put("PDTextField", "PDFormField");
    }

    private static void fillMapOfPropertiesPDTextField() {
        properties = new ArrayList<String>();
        properties.add("V");
        properties.add("RV");
        properties.add("containsRV");
        mapOfProperties.put("PDTextField", properties);
    }

    private static void fillMapOfLinksPDTextField() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDTextField", links);
    }

    private static void fillMapOfSuperNamesPDSignatureField() {
        mapOfSuperNames.put("PDSignatureField", "PDFormField");
    }

    private static void fillMapOfPropertiesPDSignatureField() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSignatureField", properties);
    }

    private static void fillMapOfLinksPDSignatureField() {
        links = new ArrayList<String>();
        links.add("V");
        mapOfLinks.put("PDSignatureField", links);
    }

    private static void fillMapOfSuperNamesPDSignature() {
        mapOfSuperNames.put("PDSignature", "PDObject");
    }

    private static void fillMapOfPropertiesPDSignature() {
        properties = new ArrayList<String>();
        properties.add("doesByteRangeCoverEntireDocument");
        mapOfProperties.put("PDSignature", properties);
    }

    private static void fillMapOfLinksPDSignature() {
        links = new ArrayList<String>();
        links.add("Contents");
        links.add("Reference");
        mapOfLinks.put("PDSignature", links);
    }

    private static void fillMapOfSuperNamesPDAction() {
        mapOfSuperNames.put("PDAction", "PDObject");
    }

    private static void fillMapOfPropertiesPDAction() {
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDAction", properties);
    }

    private static void fillMapOfLinksPDAction() {
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("PDAction", links);
    }

    private static void fillMapOfSuperNamesPDRenditionAction() {
        mapOfSuperNames.put("PDRenditionAction", "PDAction");
    }

    private static void fillMapOfPropertiesPDRenditionAction() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDRenditionAction", properties);
    }

    private static void fillMapOfLinksPDRenditionAction() {
        links = new ArrayList<String>();
        links.add("C");
        mapOfLinks.put("PDRenditionAction", links);
    }

    private static void fillMapOfSuperNamesPDEncryption() {
        mapOfSuperNames.put("PDEncryption", "PDObject");
    }

    private static void fillMapOfPropertiesPDEncryption() {
        properties = new ArrayList<String>();
        properties.add("P");
        mapOfProperties.put("PDEncryption", properties);
    }

    private static void fillMapOfLinksPDEncryption() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDEncryption", links);
    }

    private static void fillMapOfSuperNamesPDMediaClip() {
        mapOfSuperNames.put("PDMediaClip", "PDObject");
    }

    private static void fillMapOfPropertiesPDMediaClip() {
        properties = new ArrayList<String>();
        properties.add("CT");
        properties.add("Alt");
        properties.add("hasCorrectAlt");
        mapOfProperties.put("PDMediaClip", properties);
    }

    private static void fillMapOfLinksPDMediaClip() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDMediaClip", links);
    }

    private static void fillMapOfSuperNamesPDNamedAction() {
        mapOfSuperNames.put("PDNamedAction", "PDAction");
    }

    private static void fillMapOfPropertiesPDNamedAction() {
        properties = new ArrayList<String>();
        properties.add("N");
        mapOfProperties.put("PDNamedAction", properties);
    }

    private static void fillMapOfLinksPDNamedAction() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDNamedAction", links);
    }

    private static void fillMapOfSuperNamesPDGoToAction() {
        mapOfSuperNames.put("PDGoToAction", "PDAction");
    }

    private static void fillMapOfPropertiesPDGoToAction() {
        properties = new ArrayList<String>();
        properties.add("containsStructDestination");
        mapOfProperties.put("PDGoToAction", properties);
    }

    private static void fillMapOfLinksPDGoToAction() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDGoToAction", links);
    }

    private static void fillMapOfSuperNamesPDGoToRemoteAction() {
        mapOfSuperNames.put("PDGoToRemoteAction", "PDAction");
    }

    private static void fillMapOfPropertiesPDGoToRemoteAction() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDGoToRemoteAction", properties);
    }

    private static void fillMapOfLinksPDGoToRemoteAction() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDGoToRemoteAction", links);
    }

    private static void fillMapOfSuperNamesPDMetadata() {
        mapOfSuperNames.put("PDMetadata", "PDObject");
    }

    private static void fillMapOfPropertiesPDMetadata() {
        properties = new ArrayList<String>();
        properties.add("Filter");
        mapOfProperties.put("PDMetadata", properties);
    }

    private static void fillMapOfLinksPDMetadata() {
        links = new ArrayList<String>();
        links.add("XMPPackage");
        links.add("stream");
        mapOfLinks.put("PDMetadata", links);
    }

    private static void fillMapOfSuperNamesPDOutputIntent() {
        mapOfSuperNames.put("PDOutputIntent", "PDObject");
    }

    private static void fillMapOfPropertiesPDOutputIntent() {
        properties = new ArrayList<String>();
        properties.add("destOutputProfileIndirect");
        properties.add("containsDestOutputProfileRef");
        properties.add("OutputConditionIdentifier");
        properties.add("S");
        properties.add("ICCProfileMD5");
        mapOfProperties.put("PDOutputIntent", properties);
    }

    private static void fillMapOfLinksPDOutputIntent() {
        links = new ArrayList<String>();
        links.add("destProfile");
        mapOfLinks.put("PDOutputIntent", links);
    }

    private static void fillMapOfSuperNamesPDOCProperties() {
        mapOfSuperNames.put("PDOCProperties", "PDObject");
    }

    private static void fillMapOfPropertiesPDOCProperties() {
        properties = new ArrayList<String>();
        properties.add("containsConfigs");
        mapOfProperties.put("PDOCProperties", properties);
    }

    private static void fillMapOfLinksPDOCProperties() {
        links = new ArrayList<String>();
        links.add("D");
        links.add("Configs");
        mapOfLinks.put("PDOCProperties", links);
    }

    private static void fillMapOfSuperNamesPDOCConfig() {
        mapOfSuperNames.put("PDOCConfig", "PDObject");
    }

    private static void fillMapOfPropertiesPDOCConfig() {
        properties = new ArrayList<String>();
        properties.add("Name");
        properties.add("hasDuplicateName");
        properties.add("AS");
        properties.add("OCGsNotContainedInOrder");
        mapOfProperties.put("PDOCConfig", properties);
    }

    private static void fillMapOfLinksPDOCConfig() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDOCConfig", links);
    }

    private static void fillMapOfSuperNamesPDOutline() {
        mapOfSuperNames.put("PDOutline", "PDObject");
    }

    private static void fillMapOfPropertiesPDOutline() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOutline", properties);
    }

    private static void fillMapOfLinksPDOutline() {
        links = new ArrayList<String>();
        links.add("A");
        links.add("Title");
        links.add("Dest");
        mapOfLinks.put("PDOutline", links);
    }

    private static void fillMapOfSuperNamesPDStructTreeNode() {
        mapOfSuperNames.put("PDStructTreeNode", "PDObject");
    }

    private static void fillMapOfPropertiesPDStructTreeNode() {
        properties = new ArrayList<String>();
        properties.add("kidsStandardTypes");
        properties.add("hasContentItems");
        mapOfProperties.put("PDStructTreeNode", properties);
    }

    private static void fillMapOfLinksPDStructTreeNode() {
        links = new ArrayList<String>();
        links.add("K");
        mapOfLinks.put("PDStructTreeNode", links);
    }

    private static void fillMapOfSuperNamesPDStructTreeRoot() {
        mapOfSuperNames.put("PDStructTreeRoot", "PDStructTreeNode");
    }

    private static void fillMapOfPropertiesPDStructTreeRoot() {
        properties = new ArrayList<String>();
        properties.add("firstChildStandardTypeNamespaceURL");
        properties.add("topLevelFirstElementStandardType");
        mapOfProperties.put("PDStructTreeRoot", properties);
    }

    private static void fillMapOfLinksPDStructTreeRoot() {
        links = new ArrayList<String>();
        links.add("roleMapNames");
        mapOfLinks.put("PDStructTreeRoot", links);
    }

    private static void fillMapOfSuperNamesPDStructElem() {
        mapOfSuperNames.put("PDStructElem", "PDStructTreeNode");
    }

    private static void fillMapOfPropertiesPDStructElem() {
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("parentStandardType");
        properties.add("valueS");
        properties.add("standardType");
        properties.add("parentLang");
        properties.add("isRemappedStandardType");
        properties.add("Alt");
        properties.add("ActualText");
        properties.add("E");
        properties.add("circularMappingExist");
        properties.add("roleMapToSameNamespaceTag");
        mapOfProperties.put("PDStructElem", properties);
    }

    private static void fillMapOfLinksPDStructElem() {
        links = new ArrayList<String>();
        links.add("S");
        links.add("Lang");
        links.add("actualText");
        mapOfLinks.put("PDStructElem", links);
    }

    private static void fillMapOfSuperNamesPDPerms() {
        mapOfSuperNames.put("PDPerms", "PDObject");
    }

    private static void fillMapOfPropertiesPDPerms() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPerms", properties);
    }

    private static void fillMapOfLinksPDPerms() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDPerms", links);
    }

    private static void fillMapOfSuperNamesPDSigRef() {
        mapOfSuperNames.put("PDSigRef", "PDObject");
    }

    private static void fillMapOfPropertiesPDSigRef() {
        properties = new ArrayList<String>();
        properties.add("permsContainDocMDP");
        mapOfProperties.put("PDSigRef", properties);
    }

    private static void fillMapOfLinksPDSigRef() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDSigRef", links);
    }

    private static void fillMapOfSuperNamesPDFunction() {
        mapOfSuperNames.put("PDFunction", "PDObject");
    }

    private static void fillMapOfPropertiesPDFunction() {
        properties = new ArrayList<String>();
        properties.add("FunctionType");
        mapOfProperties.put("PDFunction", properties);
    }

    private static void fillMapOfLinksPDFunction() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDFunction", links);
    }

    private static void fillMapOfSuperNamesPDType0Function() {
        mapOfSuperNames.put("PDType0Function", "PDFunction");
    }

    private static void fillMapOfPropertiesPDType0Function() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType0Function", properties);
    }

    private static void fillMapOfLinksPDType0Function() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDType0Function", links);
    }

    private static void fillMapOfSuperNamesPDType2Function() {
        mapOfSuperNames.put("PDType2Function", "PDFunction");
    }

    private static void fillMapOfPropertiesPDType2Function() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType2Function", properties);
    }

    private static void fillMapOfLinksPDType2Function() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDType2Function", links);
    }

    private static void fillMapOfSuperNamesPDType3Function() {
        mapOfSuperNames.put("PDType3Function", "PDFunction");
    }

    private static void fillMapOfPropertiesPDType3Function() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Function", properties);
    }

    private static void fillMapOfLinksPDType3Function() {
        links = new ArrayList<String>();
        links.add("Functions");
        mapOfLinks.put("PDType3Function", links);
    }

    private static void fillMapOfSuperNamesPDType4Function() {
        mapOfSuperNames.put("PDType4Function", "PDFunction");
    }

    private static void fillMapOfPropertiesPDType4Function() {
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType4Function", properties);
    }

    private static void fillMapOfLinksPDType4Function() {
        links = new ArrayList<String>();
        links.add("operators");
        mapOfLinks.put("PDType4Function", links);
    }

    private static void fillMapOfSuperNamesXMPObject() {
        mapOfSuperNames.put("XMPObject", "Object");
    }

    private static void fillMapOfPropertiesXMPObject() {
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPObject", properties);
    }

    private static void fillMapOfLinksXMPObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("XMPObject", links);
    }

    private static void fillMapOfSuperNamesXMPPackage() {
        mapOfSuperNames.put("XMPPackage", "XMPObject");
    }

    private static void fillMapOfPropertiesXMPPackage() {
        properties = new ArrayList<String>();
        properties.add("isSerializationValid");
        properties.add("actualEncoding");
        properties.add("bytes");
        properties.add("encoding");
        mapOfProperties.put("XMPPackage", properties);
    }

    private static void fillMapOfLinksXMPPackage() {
        links = new ArrayList<String>();
        links.add("Properties");
        links.add("ExtensionSchemasContainers");
        mapOfLinks.put("XMPPackage", links);
    }

    private static void fillMapOfSuperNamesMainXMPPackage() {
        mapOfSuperNames.put("MainXMPPackage", "XMPPackage");
    }

    private static void fillMapOfPropertiesMainXMPPackage() {
        properties = new ArrayList<String>();
        properties.add("dc_title");
        mapOfProperties.put("MainXMPPackage", properties);
    }

    private static void fillMapOfLinksMainXMPPackage() {
        links = new ArrayList<String>();
        links.add("Identification");
        links.add("UAIdentification");
        mapOfLinks.put("MainXMPPackage", links);
    }

    private static void fillMapOfSuperNamesXMPProperty() {
        mapOfSuperNames.put("XMPProperty", "XMPObject");
    }

    private static void fillMapOfPropertiesXMPProperty() {
        properties = new ArrayList<String>();
        properties.add("isPredefinedInXMP2004");
        properties.add("isPredefinedInXMP2005");
        properties.add("isDefinedInCurrentPackage");
        properties.add("isDefinedInMainPackage");
        properties.add("isValueTypeCorrect");
        properties.add("predefinedType");
        mapOfProperties.put("XMPProperty", properties);
    }

    private static void fillMapOfLinksXMPProperty() {
        links = new ArrayList<String>();
        mapOfLinks.put("XMPProperty", links);
    }

    private static void fillMapOfSuperNamesXMPMMHistoryProperty() {
        mapOfSuperNames.put("XMPMMHistoryProperty", "XMPProperty");
    }

    private static void fillMapOfPropertiesXMPMMHistoryProperty() {
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPMMHistoryProperty", properties);
    }

    private static void fillMapOfLinksXMPMMHistoryProperty() {
        links = new ArrayList<String>();
        links.add("ResourceEvents");
        mapOfLinks.put("XMPMMHistoryProperty", links);
    }

    private static void fillMapOfSuperNamesXMPLangAlt() {
        mapOfSuperNames.put("XMPLangAlt", "XMPProperty");
    }

    private static void fillMapOfPropertiesXMPLangAlt() {
        properties = new ArrayList<String>();
        properties.add("xDefault");
        mapOfProperties.put("XMPLangAlt", properties);
    }

    private static void fillMapOfLinksXMPLangAlt() {
        links = new ArrayList<String>();
        mapOfLinks.put("XMPLangAlt", links);
    }

    private static void fillMapOfSuperNamesXMPMMHistoryResourceEvent() {
        mapOfSuperNames.put("XMPMMHistoryResourceEvent", "XMPObject");
    }

    private static void fillMapOfPropertiesXMPMMHistoryResourceEvent() {
        properties = new ArrayList<String>();
        properties.add("action");
        properties.add("parameters");
        properties.add("when");
        mapOfProperties.put("XMPMMHistoryResourceEvent", properties);
    }

    private static void fillMapOfLinksXMPMMHistoryResourceEvent() {
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMMHistoryResourceEvent", links);
    }

    private static void fillMapOfSuperNamesPDFAIdentification() {
        mapOfSuperNames.put("PDFAIdentification", "XMPObject");
    }

    private static void fillMapOfPropertiesPDFAIdentification() {
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("conformance");
        properties.add("rev");
        properties.add("partPrefix");
        properties.add("conformancePrefix");
        properties.add("amdPrefix");
        properties.add("corrPrefix");
        properties.add("revPrefix");
        mapOfProperties.put("PDFAIdentification", properties);
    }

    private static void fillMapOfLinksPDFAIdentification() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAIdentification", links);
    }

    private static void fillMapOfSuperNamesPDFUAIdentification() {
        mapOfSuperNames.put("PDFUAIdentification", "XMPObject");
    }

    private static void fillMapOfPropertiesPDFUAIdentification() {
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("rev");
        properties.add("partPrefix");
        properties.add("amdPrefix");
        properties.add("corrPrefix");
        properties.add("revPrefix");
        mapOfProperties.put("PDFUAIdentification", properties);
    }

    private static void fillMapOfLinksPDFUAIdentification() {
        links = new ArrayList<String>();
        mapOfLinks.put("PDFUAIdentification", links);
    }

    private static void fillMapOfSuperNamesExtensionSchemaObject() {
        mapOfSuperNames.put("ExtensionSchemaObject", "XMPObject");
    }

    private static void fillMapOfPropertiesExtensionSchemaObject() {
        properties = new ArrayList<String>();
        properties.add("containsUndefinedFields");
        properties.add("undefinedFields");
        mapOfProperties.put("ExtensionSchemaObject", properties);
    }

    private static void fillMapOfLinksExtensionSchemaObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaObject", links);
    }

    private static void fillMapOfSuperNamesExtensionSchemasContainer() {
        mapOfSuperNames.put("ExtensionSchemasContainer", "XMPObject");
    }

    private static void fillMapOfPropertiesExtensionSchemasContainer() {
        properties = new ArrayList<String>();
        properties.add("prefix");
        properties.add("isValidBag");
        mapOfProperties.put("ExtensionSchemasContainer", properties);
    }

    private static void fillMapOfLinksExtensionSchemasContainer() {
        links = new ArrayList<String>();
        links.add("ExtensionSchemaDefinitions");
        mapOfLinks.put("ExtensionSchemasContainer", links);
    }

    private static void fillMapOfSuperNamesExtensionSchemaDefinition() {
        mapOfSuperNames.put("ExtensionSchemaDefinition", "ExtensionSchemaObject");
    }

    private static void fillMapOfPropertiesExtensionSchemaDefinition() {
        properties = new ArrayList<String>();
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isPropertyValidSeq");
        properties.add("isSchemaValidText");
        properties.add("isValueTypeValidSeq");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("propertyPrefix");
        properties.add("schemaPrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaDefinition", properties);
    }

    private static void fillMapOfLinksExtensionSchemaDefinition() {
        links = new ArrayList<String>();
        links.add("ExtensionSchemaProperties");
        links.add("ExtensionSchemaValueTypes");
        mapOfLinks.put("ExtensionSchemaDefinition", links);
    }

    private static void fillMapOfSuperNamesExtensionSchemaProperty() {
        mapOfSuperNames.put("ExtensionSchemaProperty", "ExtensionSchemaObject");
    }

    private static void fillMapOfPropertiesExtensionSchemaProperty() {
        properties = new ArrayList<String>();
        properties.add("category");
        properties.add("isCategoryValidText");
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("categoryPrefix");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaProperty", properties);
    }

    private static void fillMapOfLinksExtensionSchemaProperty() {
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaProperty", links);
    }

    private static void fillMapOfSuperNamesExtensionSchemaValueType() {
        mapOfSuperNames.put("ExtensionSchemaValueType", "ExtensionSchemaObject");
    }

    private static void fillMapOfPropertiesExtensionSchemaValueType() {
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isFieldValidSeq");
        properties.add("isNamespaceURIValidURI");
        properties.add("isPrefixValidText");
        properties.add("isTypeValidText");
        properties.add("descriptionPrefix");
        properties.add("fieldPrefix");
        properties.add("namespaceURIPrefix");
        properties.add("prefixPrefix");
        properties.add("typePrefix");
        mapOfProperties.put("ExtensionSchemaValueType", properties);
    }

    private static void fillMapOfLinksExtensionSchemaValueType() {
        links = new ArrayList<String>();
        links.add("ExtensionSchemaFields");
        mapOfLinks.put("ExtensionSchemaValueType", links);
    }

    private static void fillMapOfSuperNamesExtensionSchemaField() {
        mapOfSuperNames.put("ExtensionSchemaField", "ExtensionSchemaObject");
    }

    private static void fillMapOfPropertiesExtensionSchemaField() {
        properties = new ArrayList<String>();
        properties.add("isDescriptionValidText");
        properties.add("isNameValidText");
        properties.add("isValueTypeValidText");
        properties.add("isValueTypeDefined");
        properties.add("descriptionPrefix");
        properties.add("namePrefix");
        properties.add("valueTypePrefix");
        mapOfProperties.put("ExtensionSchemaField", properties);
    }

    private static void fillMapOfLinksExtensionSchemaField() {
        links = new ArrayList<String>();
        mapOfLinks.put("ExtensionSchemaField", links);
    }

    private static void fillMapOfSuperNamesOperator() {
        mapOfSuperNames.put("Operator", "Object");
    }

    private static void fillMapOfPropertiesOperator() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Operator", properties);
    }

    private static void fillMapOfLinksOperator() {
        links = new ArrayList<String>();
        mapOfLinks.put("Operator", links);
    }

    private static void fillMapOfSuperNamesOpGeneralGS() {
        mapOfSuperNames.put("OpGeneralGS", "Operator");
    }

    private static void fillMapOfPropertiesOpGeneralGS() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpGeneralGS", properties);
    }

    private static void fillMapOfLinksOpGeneralGS() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpGeneralGS", links);
    }

    private static void fillMapOfSuperNamesOp_w_line_width() {
        mapOfSuperNames.put("Op_w_line_width", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_w_line_width() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_w_line_width", properties);
    }

    private static void fillMapOfLinksOp_w_line_width() {
        links = new ArrayList<String>();
        links.add("lineWidth");
        mapOfLinks.put("Op_w_line_width", links);
    }

    private static void fillMapOfSuperNamesOp_J_line_cap() {
        mapOfSuperNames.put("Op_J_line_cap", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_J_line_cap() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_J_line_cap", properties);
    }

    private static void fillMapOfLinksOp_J_line_cap() {
        links = new ArrayList<String>();
        links.add("lineCap");
        mapOfLinks.put("Op_J_line_cap", links);
    }

    private static void fillMapOfSuperNamesOp_j_line_join() {
        mapOfSuperNames.put("Op_j_line_join", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_j_line_join() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_j_line_join", properties);
    }

    private static void fillMapOfLinksOp_j_line_join() {
        links = new ArrayList<String>();
        links.add("lineJoin");
        mapOfLinks.put("Op_j_line_join", links);
    }

    private static void fillMapOfSuperNamesOp_M_miter_limit() {
        mapOfSuperNames.put("Op_M_miter_limit", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_M_miter_limit() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_M_miter_limit", properties);
    }

    private static void fillMapOfLinksOp_M_miter_limit() {
        links = new ArrayList<String>();
        links.add("miterLimit");
        mapOfLinks.put("Op_M_miter_limit", links);
    }

    private static void fillMapOfSuperNamesOp_d() {
        mapOfSuperNames.put("Op_d", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_d() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d", properties);
    }

    private static void fillMapOfLinksOp_d() {
        links = new ArrayList<String>();
        links.add("dashArray");
        links.add("dashPhase");
        mapOfLinks.put("Op_d", links);
    }

    private static void fillMapOfSuperNamesOp_ri() {
        mapOfSuperNames.put("Op_ri", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_ri() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ri", properties);
    }

    private static void fillMapOfLinksOp_ri() {
        links = new ArrayList<String>();
        links.add("renderingIntent");
        mapOfLinks.put("Op_ri", links);
    }

    private static void fillMapOfSuperNamesOp_i() {
        mapOfSuperNames.put("Op_i", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_i() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_i", properties);
    }

    private static void fillMapOfLinksOp_i() {
        links = new ArrayList<String>();
        links.add("flatness");
        mapOfLinks.put("Op_i", links);
    }

    private static void fillMapOfSuperNamesOp_gs() {
        mapOfSuperNames.put("Op_gs", "OpGeneralGS");
    }

    private static void fillMapOfPropertiesOp_gs() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_gs", properties);
    }

    private static void fillMapOfLinksOp_gs() {
        links = new ArrayList<String>();
        links.add("extGState");
        mapOfLinks.put("Op_gs", links);
    }

    private static void fillMapOfSuperNamesOpSpecialGS() {
        mapOfSuperNames.put("OpSpecialGS", "Operator");
    }

    private static void fillMapOfPropertiesOpSpecialGS() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSpecialGS", properties);
    }

    private static void fillMapOfLinksOpSpecialGS() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpSpecialGS", links);
    }

    private static void fillMapOfSuperNamesOp_q_gsave() {
        mapOfSuperNames.put("Op_q_gsave", "OpSpecialGS");
    }

    private static void fillMapOfPropertiesOp_q_gsave() {
        properties = new ArrayList<String>();
        properties.add("nestingLevel");
        mapOfProperties.put("Op_q_gsave", properties);
    }

    private static void fillMapOfLinksOp_q_gsave() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_q_gsave", links);
    }

    private static void fillMapOfSuperNamesOp_Q_grestore() {
        mapOfSuperNames.put("Op_Q_grestore", "OpSpecialGS");
    }

    private static void fillMapOfPropertiesOp_Q_grestore() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Q_grestore", properties);
    }

    private static void fillMapOfLinksOp_Q_grestore() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Q_grestore", links);
    }

    private static void fillMapOfSuperNamesOp_cm() {
        mapOfSuperNames.put("Op_cm", "OpSpecialGS");
    }

    private static void fillMapOfPropertiesOp_cm() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_cm", properties);
    }

    private static void fillMapOfLinksOp_cm() {
        links = new ArrayList<String>();
        links.add("matrix");
        mapOfLinks.put("Op_cm", links);
    }

    private static void fillMapOfSuperNamesOpPathConstruction() {
        mapOfSuperNames.put("OpPathConstruction", "Operator");
    }

    private static void fillMapOfPropertiesOpPathConstruction() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathConstruction", properties);
    }

    private static void fillMapOfLinksOpPathConstruction() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathConstruction", links);
    }

    private static void fillMapOfSuperNamesOp_m_moveto() {
        mapOfSuperNames.put("Op_m_moveto", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_m_moveto() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_m_moveto", properties);
    }

    private static void fillMapOfLinksOp_m_moveto() {
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_m_moveto", links);
    }

    private static void fillMapOfSuperNamesOp_l() {
        mapOfSuperNames.put("Op_l", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_l() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_l", properties);
    }

    private static void fillMapOfLinksOp_l() {
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_l", links);
    }

    private static void fillMapOfSuperNamesOp_c() {
        mapOfSuperNames.put("Op_c", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_c() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_c", properties);
    }

    private static void fillMapOfLinksOp_c() {
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_c", links);
    }

    private static void fillMapOfSuperNamesOp_v() {
        mapOfSuperNames.put("Op_v", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_v() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_v", properties);
    }

    private static void fillMapOfLinksOp_v() {
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_v", links);
    }

    private static void fillMapOfSuperNamesOp_y() {
        mapOfSuperNames.put("Op_y", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_y() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_y", properties);
    }

    private static void fillMapOfLinksOp_y() {
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_y", links);
    }

    private static void fillMapOfSuperNamesOp_h() {
        mapOfSuperNames.put("Op_h", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_h() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_h", properties);
    }

    private static void fillMapOfLinksOp_h() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_h", links);
    }

    private static void fillMapOfSuperNamesOp_re() {
        mapOfSuperNames.put("Op_re", "OpPathConstruction");
    }

    private static void fillMapOfPropertiesOp_re() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_re", properties);
    }

    private static void fillMapOfLinksOp_re() {
        links = new ArrayList<String>();
        links.add("rectBox");
        mapOfLinks.put("Op_re", links);
    }

    private static void fillMapOfSuperNamesOpPathPaint() {
        mapOfSuperNames.put("OpPathPaint", "Operator");
    }

    private static void fillMapOfPropertiesOpPathPaint() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathPaint", properties);
    }

    private static void fillMapOfLinksOpPathPaint() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathPaint", links);
    }

    private static void fillMapOfSuperNamesOp_s_close_stroke() {
        mapOfSuperNames.put("Op_s_close_stroke", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_s_close_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_s_close_stroke", properties);
    }

    private static void fillMapOfLinksOp_s_close_stroke() {
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_s_close_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_S_stroke() {
        mapOfSuperNames.put("Op_S_stroke", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_S_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_S_stroke", properties);
    }

    private static void fillMapOfLinksOp_S_stroke() {
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_S_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_f_fill() {
        mapOfSuperNames.put("Op_f_fill", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_f_fill() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_f_fill", properties);
    }

    private static void fillMapOfLinksOp_f_fill() {
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_f_fill", links);
    }

    private static void fillMapOfSuperNamesOp_F_fill_obsolete() {
        mapOfSuperNames.put("Op_F_fill_obsolete", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_F_fill_obsolete() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_F_fill_obsolete", properties);
    }

    private static void fillMapOfLinksOp_F_fill_obsolete() {
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_F_fill_obsolete", links);
    }

    private static void fillMapOfSuperNamesOp_FStar() {
        mapOfSuperNames.put("Op_FStar", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_FStar() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_FStar", properties);
    }

    private static void fillMapOfLinksOp_FStar() {
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_FStar", links);
    }

    private static void fillMapOfSuperNamesOp_B_fill_stroke() {
        mapOfSuperNames.put("Op_B_fill_stroke", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_B_fill_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_B_fill_stroke", properties);
    }

    private static void fillMapOfLinksOp_B_fill_stroke() {
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_B_fill_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_BStar_eofill_stroke() {
        mapOfSuperNames.put("Op_BStar_eofill_stroke", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_BStar_eofill_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BStar_eofill_stroke", properties);
    }

    private static void fillMapOfLinksOp_BStar_eofill_stroke() {
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_BStar_eofill_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_b_closepath_fill_stroke() {
        mapOfSuperNames.put("Op_b_closepath_fill_stroke", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_b_closepath_fill_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_b_closepath_fill_stroke", properties);
    }

    private static void fillMapOfLinksOp_b_closepath_fill_stroke() {
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_b_closepath_fill_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_bstar_closepath_eofill_stroke() {
        mapOfSuperNames.put("Op_bstar_closepath_eofill_stroke", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_bstar_closepath_eofill_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_bstar_closepath_eofill_stroke", properties);
    }

    private static void fillMapOfLinksOp_bstar_closepath_eofill_stroke() {
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_bstar_closepath_eofill_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_n() {
        mapOfSuperNames.put("Op_n", "OpPathPaint");
    }

    private static void fillMapOfPropertiesOp_n() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_n", properties);
    }

    private static void fillMapOfLinksOp_n() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_n", links);
    }

    private static void fillMapOfSuperNamesOpClip() {
        mapOfSuperNames.put("OpClip", "Operator");
    }

    private static void fillMapOfPropertiesOpClip() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpClip", properties);
    }

    private static void fillMapOfLinksOpClip() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpClip", links);
    }

    private static void fillMapOfSuperNamesOp_W_clip() {
        mapOfSuperNames.put("Op_W_clip", "OpClip");
    }

    private static void fillMapOfPropertiesOp_W_clip() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_W_clip", properties);
    }

    private static void fillMapOfLinksOp_W_clip() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_W_clip", links);
    }

    private static void fillMapOfSuperNamesOp_WStar() {
        mapOfSuperNames.put("Op_WStar", "OpClip");
    }

    private static void fillMapOfPropertiesOp_WStar() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_WStar", properties);
    }

    private static void fillMapOfLinksOp_WStar() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_WStar", links);
    }

    private static void fillMapOfSuperNamesOpTextObject() {
        mapOfSuperNames.put("OpTextObject", "Operator");
    }

    private static void fillMapOfPropertiesOpTextObject() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextObject", properties);
    }

    private static void fillMapOfLinksOpTextObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextObject", links);
    }

    private static void fillMapOfSuperNamesOp_ET() {
        mapOfSuperNames.put("Op_ET", "OpTextObject");
    }

    private static void fillMapOfPropertiesOp_ET() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ET", properties);
    }

    private static void fillMapOfLinksOp_ET() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_ET", links);
    }

    private static void fillMapOfSuperNamesOp_BT() {
        mapOfSuperNames.put("Op_BT", "OpTextObject");
    }

    private static void fillMapOfPropertiesOp_BT() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BT", properties);
    }

    private static void fillMapOfLinksOp_BT() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BT", links);
    }

    private static void fillMapOfSuperNamesOpTextState() {
        mapOfSuperNames.put("OpTextState", "Operator");
    }

    private static void fillMapOfPropertiesOpTextState() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextState", properties);
    }

    private static void fillMapOfLinksOpTextState() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextState", links);
    }

    private static void fillMapOfSuperNamesOp_Tz() {
        mapOfSuperNames.put("Op_Tz", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Tz() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tz", properties);
    }

    private static void fillMapOfLinksOp_Tz() {
        links = new ArrayList<String>();
        links.add("scale");
        mapOfLinks.put("Op_Tz", links);
    }

    private static void fillMapOfSuperNamesOp_Tr() {
        mapOfSuperNames.put("Op_Tr", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Tr() {
        properties = new ArrayList<String>();
        properties.add("renderingMode");
        mapOfProperties.put("Op_Tr", properties);
    }

    private static void fillMapOfLinksOp_Tr() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Tr", links);
    }

    private static void fillMapOfSuperNamesOp_Tc() {
        mapOfSuperNames.put("Op_Tc", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Tc() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tc", properties);
    }

    private static void fillMapOfLinksOp_Tc() {
        links = new ArrayList<String>();
        links.add("charSpace");
        mapOfLinks.put("Op_Tc", links);
    }

    private static void fillMapOfSuperNamesOp_Tf() {
        mapOfSuperNames.put("Op_Tf", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Tf() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tf", properties);
    }

    private static void fillMapOfLinksOp_Tf() {
        links = new ArrayList<String>();
        links.add("size");
        links.add("fontName");
        mapOfLinks.put("Op_Tf", links);
    }

    private static void fillMapOfSuperNamesOp_Tl() {
        mapOfSuperNames.put("Op_Tl", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Tl() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tl", properties);
    }

    private static void fillMapOfLinksOp_Tl() {
        links = new ArrayList<String>();
        links.add("leading");
        mapOfLinks.put("Op_Tl", links);
    }

    private static void fillMapOfSuperNamesOp_Ts() {
        mapOfSuperNames.put("Op_Ts", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Ts() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Ts", properties);
    }

    private static void fillMapOfLinksOp_Ts() {
        links = new ArrayList<String>();
        links.add("rise");
        mapOfLinks.put("Op_Ts", links);
    }

    private static void fillMapOfSuperNamesOp_Tw() {
        mapOfSuperNames.put("Op_Tw", "OpTextState");
    }

    private static void fillMapOfPropertiesOp_Tw() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tw", properties);
    }

    private static void fillMapOfLinksOp_Tw() {
        links = new ArrayList<String>();
        links.add("wordSpace");
        mapOfLinks.put("Op_Tw", links);
    }

    private static void fillMapOfSuperNamesOpTextPosition() {
        mapOfSuperNames.put("OpTextPosition", "Operator");
    }

    private static void fillMapOfPropertiesOpTextPosition() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextPosition", properties);
    }

    private static void fillMapOfLinksOpTextPosition() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextPosition", links);
    }

    private static void fillMapOfSuperNamesOp_Td() {
        mapOfSuperNames.put("Op_Td", "OpTextPosition");
    }

    private static void fillMapOfPropertiesOp_Td() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Td", properties);
    }

    private static void fillMapOfLinksOp_Td() {
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_Td", links);
    }

    private static void fillMapOfSuperNamesOp_TD_Big() {
        mapOfSuperNames.put("Op_TD_Big", "OpTextPosition");
    }

    private static void fillMapOfPropertiesOp_TD_Big() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TD_Big", properties);
    }

    private static void fillMapOfLinksOp_TD_Big() {
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_TD_Big", links);
    }

    private static void fillMapOfSuperNamesOp_Tm() {
        mapOfSuperNames.put("Op_Tm", "OpTextPosition");
    }

    private static void fillMapOfPropertiesOp_Tm() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tm", properties);
    }

    private static void fillMapOfLinksOp_Tm() {
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_Tm", links);
    }

    private static void fillMapOfSuperNamesOp_T_Star() {
        mapOfSuperNames.put("Op_T_Star", "OpTextPosition");
    }

    private static void fillMapOfPropertiesOp_T_Star() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_T_Star", properties);
    }

    private static void fillMapOfLinksOp_T_Star() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_T_Star", links);
    }

    private static void fillMapOfSuperNamesOpTextShow() {
        mapOfSuperNames.put("OpTextShow", "Operator");
    }

    private static void fillMapOfPropertiesOpTextShow() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextShow", properties);
    }

    private static void fillMapOfLinksOpTextShow() {
        links = new ArrayList<String>();
        links.add("font");
        links.add("usedGlyphs");
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("OpTextShow", links);
    }

    private static void fillMapOfSuperNamesOp_Tj() {
        mapOfSuperNames.put("Op_Tj", "OpTextShow");
    }

    private static void fillMapOfPropertiesOp_Tj() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tj", properties);
    }

    private static void fillMapOfLinksOp_Tj() {
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Tj", links);
    }

    private static void fillMapOfSuperNamesOp_TJ_Big() {
        mapOfSuperNames.put("Op_TJ_Big", "OpTextShow");
    }

    private static void fillMapOfPropertiesOp_TJ_Big() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TJ_Big", properties);
    }

    private static void fillMapOfLinksOp_TJ_Big() {
        links = new ArrayList<String>();
        links.add("specialStrings");
        mapOfLinks.put("Op_TJ_Big", links);
    }

    private static void fillMapOfSuperNamesOp_Quote() {
        mapOfSuperNames.put("Op_Quote", "OpTextShow");
    }

    private static void fillMapOfPropertiesOp_Quote() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Quote", properties);
    }

    private static void fillMapOfLinksOp_Quote() {
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Quote", links);
    }

    private static void fillMapOfSuperNamesOp_DoubleQuote() {
        mapOfSuperNames.put("Op_DoubleQuote", "OpTextShow");
    }

    private static void fillMapOfPropertiesOp_DoubleQuote() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DoubleQuote", properties);
    }

    private static void fillMapOfLinksOp_DoubleQuote() {
        links = new ArrayList<String>();
        links.add("showString");
        links.add("wordSpacing");
        links.add("characterSpacing");
        mapOfLinks.put("Op_DoubleQuote", links);
    }

    private static void fillMapOfSuperNamesOpType3Font() {
        mapOfSuperNames.put("OpType3Font", "Operator");
    }

    private static void fillMapOfPropertiesOpType3Font() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpType3Font", properties);
    }

    private static void fillMapOfLinksOpType3Font() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpType3Font", links);
    }

    private static void fillMapOfSuperNamesOp_d0() {
        mapOfSuperNames.put("Op_d0", "OpType3Font");
    }

    private static void fillMapOfPropertiesOp_d0() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d0", properties);
    }

    private static void fillMapOfLinksOp_d0() {
        links = new ArrayList<String>();
        links.add("horizontalDisplacement");
        links.add("verticalDisplacement");
        mapOfLinks.put("Op_d0", links);
    }

    private static void fillMapOfSuperNamesOp_d1() {
        mapOfSuperNames.put("Op_d1", "OpType3Font");
    }

    private static void fillMapOfPropertiesOp_d1() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d1", properties);
    }

    private static void fillMapOfLinksOp_d1() {
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_d1", links);
    }

    private static void fillMapOfSuperNamesOpSetColor() {
        mapOfSuperNames.put("OpSetColor", "Operator");
    }

    private static void fillMapOfPropertiesOpSetColor() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSetColor", properties);
    }

    private static void fillMapOfLinksOpSetColor() {
        links = new ArrayList<String>();
        links.add("colorValues");
        mapOfLinks.put("OpSetColor", links);
    }

    private static void fillMapOfSuperNamesOp_SC_stroke() {
        mapOfSuperNames.put("Op_SC_stroke", "OpSetColor");
    }

    private static void fillMapOfPropertiesOp_SC_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_SC_stroke", properties);
    }

    private static void fillMapOfLinksOp_SC_stroke() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_SC_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_sc_fill() {
        mapOfSuperNames.put("Op_sc_fill", "OpSetColor");
    }

    private static void fillMapOfPropertiesOp_sc_fill() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sc_fill", properties);
    }

    private static void fillMapOfLinksOp_sc_fill() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_sc_fill", links);
    }

    private static void fillMapOfSuperNamesOpColor() {
        mapOfSuperNames.put("OpColor", "OpSetColor");
    }

    private static void fillMapOfPropertiesOpColor() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpColor", properties);
    }

    private static void fillMapOfLinksOpColor() {
        links = new ArrayList<String>();
        links.add("colorSpace");
        links.add("patternName");
        mapOfLinks.put("OpColor", links);
    }

    private static void fillMapOfSuperNamesOp_SCN_stroke() {
        mapOfSuperNames.put("Op_SCN_stroke", "OpColor");
    }

    private static void fillMapOfPropertiesOp_SCN_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_SCN_stroke", properties);
    }

    private static void fillMapOfLinksOp_SCN_stroke() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_SCN_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_scn_fill() {
        mapOfSuperNames.put("Op_scn_fill", "OpColor");
    }

    private static void fillMapOfPropertiesOp_scn_fill() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_scn_fill", properties);
    }

    private static void fillMapOfLinksOp_scn_fill() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_scn_fill", links);
    }

    private static void fillMapOfSuperNamesOp_G_stroke() {
        mapOfSuperNames.put("Op_G_stroke", "OpColor");
    }

    private static void fillMapOfPropertiesOp_G_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_G_stroke", properties);
    }

    private static void fillMapOfLinksOp_G_stroke() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_G_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_g_fill() {
        mapOfSuperNames.put("Op_g_fill", "OpColor");
    }

    private static void fillMapOfPropertiesOp_g_fill() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_g_fill", properties);
    }

    private static void fillMapOfLinksOp_g_fill() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_g_fill", links);
    }

    private static void fillMapOfSuperNamesOp_RG_stroke() {
        mapOfSuperNames.put("Op_RG_stroke", "OpColor");
    }

    private static void fillMapOfPropertiesOp_RG_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_RG_stroke", properties);
    }

    private static void fillMapOfLinksOp_RG_stroke() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_RG_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_rg_fill() {
        mapOfSuperNames.put("Op_rg_fill", "OpColor");
    }

    private static void fillMapOfPropertiesOp_rg_fill() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_rg_fill", properties);
    }

    private static void fillMapOfLinksOp_rg_fill() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_rg_fill", links);
    }

    private static void fillMapOfSuperNamesOp_K_stroke() {
        mapOfSuperNames.put("Op_K_stroke", "OpColor");
    }

    private static void fillMapOfPropertiesOp_K_stroke() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_K_stroke", properties);
    }

    private static void fillMapOfLinksOp_K_stroke() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_K_stroke", links);
    }

    private static void fillMapOfSuperNamesOp_k_fill() {
        mapOfSuperNames.put("Op_k_fill", "OpColor");
    }

    private static void fillMapOfPropertiesOp_k_fill() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_k_fill", properties);
    }

    private static void fillMapOfLinksOp_k_fill() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_k_fill", links);
    }

    private static void fillMapOfSuperNamesOpShading() {
        mapOfSuperNames.put("OpShading", "Operator");
    }

    private static void fillMapOfPropertiesOpShading() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpShading", properties);
    }

    private static void fillMapOfLinksOpShading() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpShading", links);
    }

    private static void fillMapOfSuperNamesOp_sh() {
        mapOfSuperNames.put("Op_sh", "OpShading");
    }

    private static void fillMapOfPropertiesOp_sh() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sh", properties);
    }

    private static void fillMapOfLinksOp_sh() {
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("Op_sh", links);
    }

    private static void fillMapOfSuperNamesOpInlineImage() {
        mapOfSuperNames.put("OpInlineImage", "Operator");
    }

    private static void fillMapOfPropertiesOpInlineImage() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpInlineImage", properties);
    }

    private static void fillMapOfLinksOpInlineImage() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpInlineImage", links);
    }

    private static void fillMapOfSuperNamesOp_BI() {
        mapOfSuperNames.put("Op_BI", "OpInlineImage");
    }

    private static void fillMapOfPropertiesOp_BI() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BI", properties);
    }

    private static void fillMapOfLinksOp_BI() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BI", links);
    }

    private static void fillMapOfSuperNamesOp_ID() {
        mapOfSuperNames.put("Op_ID", "OpInlineImage");
    }

    private static void fillMapOfPropertiesOp_ID() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ID", properties);
    }

    private static void fillMapOfLinksOp_ID() {
        links = new ArrayList<String>();
        links.add("inlineImageDictionary");
        mapOfLinks.put("Op_ID", links);
    }

    private static void fillMapOfSuperNamesOp_EI() {
        mapOfSuperNames.put("Op_EI", "OpInlineImage");
    }

    private static void fillMapOfPropertiesOp_EI() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EI", properties);
    }

    private static void fillMapOfLinksOp_EI() {
        links = new ArrayList<String>();
        links.add("inlineImage");
        mapOfLinks.put("Op_EI", links);
    }

    private static void fillMapOfSuperNamesOpXObject() {
        mapOfSuperNames.put("OpXObject", "Operator");
    }

    private static void fillMapOfPropertiesOpXObject() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpXObject", properties);
    }

    private static void fillMapOfLinksOpXObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpXObject", links);
    }

    private static void fillMapOfSuperNamesOp_Do() {
        mapOfSuperNames.put("Op_Do", "OpXObject");
    }

    private static void fillMapOfPropertiesOp_Do() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Do", properties);
    }

    private static void fillMapOfLinksOp_Do() {
        links = new ArrayList<String>();
        links.add("xObject");
        mapOfLinks.put("Op_Do", links);
    }

    private static void fillMapOfSuperNamesOpMarkedContent() {
        mapOfSuperNames.put("OpMarkedContent", "Operator");
    }

    private static void fillMapOfPropertiesOpMarkedContent() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpMarkedContent", properties);
    }

    private static void fillMapOfLinksOpMarkedContent() {
        links = new ArrayList<String>();
        links.add("actualText");
        mapOfLinks.put("OpMarkedContent", links);
    }

    private static void fillMapOfSuperNamesOp_MP() {
        mapOfSuperNames.put("Op_MP", "OpMarkedContent");
    }

    private static void fillMapOfPropertiesOp_MP() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_MP", properties);
    }

    private static void fillMapOfLinksOp_MP() {
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_MP", links);
    }

    private static void fillMapOfSuperNamesOp_DP() {
        mapOfSuperNames.put("Op_DP", "OpMarkedContent");
    }

    private static void fillMapOfPropertiesOp_DP() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DP", properties);
    }

    private static void fillMapOfLinksOp_DP() {
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_DP", links);
    }

    private static void fillMapOfSuperNamesOp_BMC() {
        mapOfSuperNames.put("Op_BMC", "OpMarkedContent");
    }

    private static void fillMapOfPropertiesOp_BMC() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BMC", properties);
    }

    private static void fillMapOfLinksOp_BMC() {
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_BMC", links);
    }

    private static void fillMapOfSuperNamesOp_BDC() {
        mapOfSuperNames.put("Op_BDC", "OpMarkedContent");
    }

    private static void fillMapOfPropertiesOp_BDC() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BDC", properties);
    }

    private static void fillMapOfLinksOp_BDC() {
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        links.add("Lang");
        mapOfLinks.put("Op_BDC", links);
    }

    private static void fillMapOfSuperNamesOp_EMC() {
        mapOfSuperNames.put("Op_EMC", "OpMarkedContent");
    }

    private static void fillMapOfPropertiesOp_EMC() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EMC", properties);
    }

    private static void fillMapOfLinksOp_EMC() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EMC", links);
    }

    private static void fillMapOfSuperNamesOpCompatibility() {
        mapOfSuperNames.put("OpCompatibility", "Operator");
    }

    private static void fillMapOfPropertiesOpCompatibility() {
        properties = new ArrayList<String>();
        mapOfProperties.put("OpCompatibility", properties);
    }

    private static void fillMapOfLinksOpCompatibility() {
        links = new ArrayList<String>();
        mapOfLinks.put("OpCompatibility", links);
    }

    private static void fillMapOfSuperNamesOp_BX() {
        mapOfSuperNames.put("Op_BX", "OpCompatibility");
    }

    private static void fillMapOfPropertiesOp_BX() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BX", properties);
    }

    private static void fillMapOfLinksOp_BX() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BX", links);
    }

    private static void fillMapOfSuperNamesOp_EX() {
        mapOfSuperNames.put("Op_EX", "OpCompatibility");
    }

    private static void fillMapOfPropertiesOp_EX() {
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EX", properties);
    }

    private static void fillMapOfLinksOp_EX() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EX", links);
    }

    private static void fillMapOfSuperNamesOp_Undefined() {
        mapOfSuperNames.put("Op_Undefined", "OpCompatibility");
    }

    private static void fillMapOfPropertiesOp_Undefined() {
        properties = new ArrayList<String>();
        properties.add("name");
        mapOfProperties.put("Op_Undefined", properties);
    }

    private static void fillMapOfLinksOp_Undefined() {
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Undefined", links);
    }

    private static void fillMapOfSuperNamesGlyph() {
        mapOfSuperNames.put("Glyph", "Object");
    }

    private static void fillMapOfPropertiesGlyph() {
        properties = new ArrayList<String>();
        properties.add("name");
        properties.add("widthFromDictionary");
        properties.add("widthFromFontProgram");
        properties.add("isGlyphPresent");
        properties.add("toUnicode");
        properties.add("renderingMode");
        properties.add("unicodePUA");
        properties.add("actualTextPresent");
        mapOfProperties.put("Glyph", properties);
    }

    private static void fillMapOfLinksGlyph() {
        links = new ArrayList<String>();
        mapOfLinks.put("Glyph", links);
    }

    private static void fillMapOfSuperNamesCIDGlyph() {
        mapOfSuperNames.put("CIDGlyph", "Glyph");
    }

    private static void fillMapOfPropertiesCIDGlyph() {
        properties = new ArrayList<String>();
        properties.add("CID");
        mapOfProperties.put("CIDGlyph", properties);
    }

    private static void fillMapOfLinksCIDGlyph() {
        links = new ArrayList<String>();
        mapOfLinks.put("CIDGlyph", links);
    }

    private static void fillMapOfSuperNamesSENonStandard() {
        mapOfSuperNames.put("SENonStandard", "PDStructElem");
    }

    private static void fillMapOfPropertiesSENonStandard() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SENonStandard", properties);
    }

    private static void fillMapOfLinksSENonStandard() {
        links = new ArrayList<String>();
        mapOfLinks.put("SENonStandard", links);
    }

    private static void fillMapOfSuperNamesSEDocument() {
        mapOfSuperNames.put("SEDocument", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEDocument() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDocument", properties);
    }

    private static void fillMapOfLinksSEDocument() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEDocument", links);
    }

    private static void fillMapOfSuperNamesSEPart() {
        mapOfSuperNames.put("SEPart", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEPart() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEPart", properties);
    }

    private static void fillMapOfLinksSEPart() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEPart", links);
    }

    private static void fillMapOfSuperNamesSEDiv() {
        mapOfSuperNames.put("SEDiv", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEDiv() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDiv", properties);
    }

    private static void fillMapOfLinksSEDiv() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEDiv", links);
    }

    private static void fillMapOfSuperNamesSECaption() {
        mapOfSuperNames.put("SECaption", "PDStructElem");
    }

    private static void fillMapOfPropertiesSECaption() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SECaption", properties);
    }

    private static void fillMapOfLinksSECaption() {
        links = new ArrayList<String>();
        mapOfLinks.put("SECaption", links);
    }

    private static void fillMapOfSuperNamesSEH() {
        mapOfSuperNames.put("SEH", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEH() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEH", properties);
    }

    private static void fillMapOfLinksSEH() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEH", links);
    }

    private static void fillMapOfSuperNamesSEP() {
        mapOfSuperNames.put("SEP", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEP() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEP", properties);
    }

    private static void fillMapOfLinksSEP() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEP", links);
    }

    private static void fillMapOfSuperNamesSEL() {
        mapOfSuperNames.put("SEL", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEL() {
        properties = new ArrayList<String>();
        properties.add("ListNumbering");
        properties.add("containsLabels");
        mapOfProperties.put("SEL", properties);
    }

    private static void fillMapOfLinksSEL() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEL", links);
    }

    private static void fillMapOfSuperNamesSELI() {
        mapOfSuperNames.put("SELI", "PDStructElem");
    }

    private static void fillMapOfPropertiesSELI() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SELI", properties);
    }

    private static void fillMapOfLinksSELI() {
        links = new ArrayList<String>();
        mapOfLinks.put("SELI", links);
    }

    private static void fillMapOfSuperNamesSELbl() {
        mapOfSuperNames.put("SELbl", "PDStructElem");
    }

    private static void fillMapOfPropertiesSELbl() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SELbl", properties);
    }

    private static void fillMapOfLinksSELbl() {
        links = new ArrayList<String>();
        mapOfLinks.put("SELbl", links);
    }

    private static void fillMapOfSuperNamesSELBody() {
        mapOfSuperNames.put("SELBody", "PDStructElem");
    }

    private static void fillMapOfPropertiesSELBody() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SELBody", properties);
    }

    private static void fillMapOfLinksSELBody() {
        links = new ArrayList<String>();
        mapOfLinks.put("SELBody", links);
    }

    private static void fillMapOfSuperNamesSETable() {
        mapOfSuperNames.put("SETable", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETable() {
        properties = new ArrayList<String>();
        properties.add("useHeadersAndIdOrScope");
        properties.add("columnSpan");
        properties.add("rowSpan");
        properties.add("numberOfRowWithWrongColumnSpan");
        properties.add("numberOfColumnWithWrongRowSpan");
        properties.add("wrongColumnSpan");
        mapOfProperties.put("SETable", properties);
    }

    private static void fillMapOfLinksSETable() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETable", links);
    }

    private static void fillMapOfSuperNamesSETR() {
        mapOfSuperNames.put("SETR", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETR() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETR", properties);
    }

    private static void fillMapOfLinksSETR() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETR", links);
    }

    private static void fillMapOfSuperNamesSETableCell() {
        mapOfSuperNames.put("SETableCell", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETableCell() {
        properties = new ArrayList<String>();
        properties.add("ColSpan");
        properties.add("RowSpan");
        properties.add("hasIntersection");
        mapOfProperties.put("SETableCell", properties);
    }

    private static void fillMapOfLinksSETableCell() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETableCell", links);
    }

    private static void fillMapOfSuperNamesSETH() {
        mapOfSuperNames.put("SETH", "SETableCell");
    }

    private static void fillMapOfPropertiesSETH() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETH", properties);
    }

    private static void fillMapOfLinksSETH() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETH", links);
    }

    private static void fillMapOfSuperNamesSETD() {
        mapOfSuperNames.put("SETD", "SETableCell");
    }

    private static void fillMapOfPropertiesSETD() {
        properties = new ArrayList<String>();
        properties.add("hasConnectedHeader");
        properties.add("unknownHeaders");
        mapOfProperties.put("SETD", properties);
    }

    private static void fillMapOfLinksSETD() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETD", links);
    }

    private static void fillMapOfSuperNamesSESpan() {
        mapOfSuperNames.put("SESpan", "PDStructElem");
    }

    private static void fillMapOfPropertiesSESpan() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SESpan", properties);
    }

    private static void fillMapOfLinksSESpan() {
        links = new ArrayList<String>();
        mapOfLinks.put("SESpan", links);
    }

    private static void fillMapOfSuperNamesSELink() {
        mapOfSuperNames.put("SELink", "PDStructElem");
    }

    private static void fillMapOfPropertiesSELink() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SELink", properties);
    }

    private static void fillMapOfLinksSELink() {
        links = new ArrayList<String>();
        mapOfLinks.put("SELink", links);
    }

    private static void fillMapOfSuperNamesSEArt() {
        mapOfSuperNames.put("SEArt", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEArt() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEArt", properties);
    }

    private static void fillMapOfLinksSEArt() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEArt", links);
    }

    private static void fillMapOfSuperNamesSESect() {
        mapOfSuperNames.put("SESect", "PDStructElem");
    }

    private static void fillMapOfPropertiesSESect() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SESect", properties);
    }

    private static void fillMapOfLinksSESect() {
        links = new ArrayList<String>();
        mapOfLinks.put("SESect", links);
    }

    private static void fillMapOfSuperNamesSEBlockQuote() {
        mapOfSuperNames.put("SEBlockQuote", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEBlockQuote() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEBlockQuote", properties);
    }

    private static void fillMapOfLinksSEBlockQuote() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEBlockQuote", links);
    }

    private static void fillMapOfSuperNamesSETOC() {
        mapOfSuperNames.put("SETOC", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETOC() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETOC", properties);
    }

    private static void fillMapOfLinksSETOC() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETOC", links);
    }

    private static void fillMapOfSuperNamesSETOCI() {
        mapOfSuperNames.put("SETOCI", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETOCI() {
        properties = new ArrayList<String>();
        properties.add("containsRef");
        mapOfProperties.put("SETOCI", properties);
    }

    private static void fillMapOfLinksSETOCI() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETOCI", links);
    }

    private static void fillMapOfSuperNamesSEIndex() {
        mapOfSuperNames.put("SEIndex", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEIndex() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEIndex", properties);
    }

    private static void fillMapOfLinksSEIndex() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEIndex", links);
    }

    private static void fillMapOfSuperNamesSENonStruct() {
        mapOfSuperNames.put("SENonStruct", "PDStructElem");
    }

    private static void fillMapOfPropertiesSENonStruct() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SENonStruct", properties);
    }

    private static void fillMapOfLinksSENonStruct() {
        links = new ArrayList<String>();
        mapOfLinks.put("SENonStruct", links);
    }

    private static void fillMapOfSuperNamesSEPrivate() {
        mapOfSuperNames.put("SEPrivate", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEPrivate() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEPrivate", properties);
    }

    private static void fillMapOfLinksSEPrivate() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEPrivate", links);
    }

    private static void fillMapOfSuperNamesSEQuote() {
        mapOfSuperNames.put("SEQuote", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEQuote() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEQuote", properties);
    }

    private static void fillMapOfLinksSEQuote() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEQuote", links);
    }

    private static void fillMapOfSuperNamesSENote() {
        mapOfSuperNames.put("SENote", "PDStructElem");
    }

    private static void fillMapOfPropertiesSENote() {
        properties = new ArrayList<String>();
        properties.add("noteID");
        properties.add("hasDuplicateNoteID");
        mapOfProperties.put("SENote", properties);
    }

    private static void fillMapOfLinksSENote() {
        links = new ArrayList<String>();
        mapOfLinks.put("SENote", links);
    }

    private static void fillMapOfSuperNamesSEReference() {
        mapOfSuperNames.put("SEReference", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEReference() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEReference", properties);
    }

    private static void fillMapOfLinksSEReference() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEReference", links);
    }

    private static void fillMapOfSuperNamesSEBibEntry() {
        mapOfSuperNames.put("SEBibEntry", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEBibEntry() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEBibEntry", properties);
    }

    private static void fillMapOfLinksSEBibEntry() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEBibEntry", links);
    }

    private static void fillMapOfSuperNamesSECode() {
        mapOfSuperNames.put("SECode", "PDStructElem");
    }

    private static void fillMapOfPropertiesSECode() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SECode", properties);
    }

    private static void fillMapOfLinksSECode() {
        links = new ArrayList<String>();
        mapOfLinks.put("SECode", links);
    }

    private static void fillMapOfSuperNamesSEHn() {
        mapOfSuperNames.put("SEHn", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEHn() {
        properties = new ArrayList<String>();
        properties.add("hasCorrectNestingLevel");
        properties.add("nestingLevel");
        mapOfProperties.put("SEHn", properties);
    }

    private static void fillMapOfLinksSEHn() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEHn", links);
    }

    private static void fillMapOfSuperNamesSEFigure() {
        mapOfSuperNames.put("SEFigure", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEFigure() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEFigure", properties);
    }

    private static void fillMapOfLinksSEFigure() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEFigure", links);
    }

    private static void fillMapOfSuperNamesSEFormula() {
        mapOfSuperNames.put("SEFormula", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEFormula() {
        properties = new ArrayList<String>();
        properties.add("isMathFormula");
        mapOfProperties.put("SEFormula", properties);
    }

    private static void fillMapOfLinksSEFormula() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEFormula", links);
    }

    private static void fillMapOfSuperNamesSEMathMLStructElem() {
        mapOfSuperNames.put("SEMathMLStructElem", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEMathMLStructElem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEMathMLStructElem", properties);
    }

    private static void fillMapOfLinksSEMathMLStructElem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEMathMLStructElem", links);
    }

    private static void fillMapOfSuperNamesSEContentItem() {
        mapOfSuperNames.put("SEContentItem", "Object");
    }

    private static void fillMapOfPropertiesSEContentItem() {
        properties = new ArrayList<String>();
        properties.add("parentsTags");
        properties.add("parentStructureTag");
        properties.add("parentStandardTag");
        mapOfProperties.put("SEContentItem", properties);
    }

    private static void fillMapOfLinksSEContentItem() {
        links = new ArrayList<String>();
        links.add("contentItem");
        mapOfLinks.put("SEContentItem", links);
    }

    private static void fillMapOfSuperNamesSESimpleContentItem() {
        mapOfSuperNames.put("SESimpleContentItem", "SEContentItem");
    }

    private static void fillMapOfPropertiesSESimpleContentItem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SESimpleContentItem", properties);
    }

    private static void fillMapOfLinksSESimpleContentItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SESimpleContentItem", links);
    }

    private static void fillMapOfSuperNamesSEMarkedContent() {
        mapOfSuperNames.put("SEMarkedContent", "SEContentItem");
    }

    private static void fillMapOfPropertiesSEMarkedContent() {
        properties = new ArrayList<String>();
        properties.add("tag");
        properties.add("structureTag");
        properties.add("E");
        properties.add("Alt");
        properties.add("ActualText");
        properties.add("inheritedLang");
        mapOfProperties.put("SEMarkedContent", properties);
    }

    private static void fillMapOfLinksSEMarkedContent() {
        links = new ArrayList<String>();
        links.add("Lang");
        mapOfLinks.put("SEMarkedContent", links);
    }

    private static void fillMapOfSuperNamesSEUnmarkedContent() {
        mapOfSuperNames.put("SEUnmarkedContent", "SEContentItem");
    }

    private static void fillMapOfPropertiesSEUnmarkedContent() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEUnmarkedContent", properties);
    }

    private static void fillMapOfLinksSEUnmarkedContent() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEUnmarkedContent", links);
    }

    private static void fillMapOfSuperNamesSETextItem() {
        mapOfSuperNames.put("SETextItem", "SESimpleContentItem");
    }

    private static void fillMapOfPropertiesSETextItem() {
        properties = new ArrayList<String>();
        properties.add("fontName");
        properties.add("scaleFactor");
        properties.add("Lang");
        mapOfProperties.put("SETextItem", properties);
    }

    private static void fillMapOfLinksSETextItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETextItem", links);
    }

    private static void fillMapOfSuperNamesSELineArtItem() {
        mapOfSuperNames.put("SELineArtItem", "SESimpleContentItem");
    }

    private static void fillMapOfPropertiesSELineArtItem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SELineArtItem", properties);
    }

    private static void fillMapOfLinksSELineArtItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SELineArtItem", links);
    }

    private static void fillMapOfSuperNamesSEShadingItem() {
        mapOfSuperNames.put("SEShadingItem", "SESimpleContentItem");
    }

    private static void fillMapOfPropertiesSEShadingItem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEShadingItem", properties);
    }

    private static void fillMapOfLinksSEShadingItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEShadingItem", links);
    }

    private static void fillMapOfSuperNamesSEImageItem() {
        mapOfSuperNames.put("SEImageItem", "SESimpleContentItem");
    }

    private static void fillMapOfPropertiesSEImageItem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEImageItem", properties);
    }

    private static void fillMapOfLinksSEImageItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEImageItem", links);
    }

    private static void fillMapOfSuperNamesSEInlineImageItem() {
        mapOfSuperNames.put("SEInlineImageItem", "SEImageItem");
    }

    private static void fillMapOfPropertiesSEInlineImageItem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEInlineImageItem", properties);
    }

    private static void fillMapOfLinksSEInlineImageItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEInlineImageItem", links);
    }

    private static void fillMapOfSuperNamesSEImageXObjectItem() {
        mapOfSuperNames.put("SEImageXObjectItem", "SEImageItem");
    }

    private static void fillMapOfPropertiesSEImageXObjectItem() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEImageXObjectItem", properties);
    }

    private static void fillMapOfLinksSEImageXObjectItem() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEImageXObjectItem", links);
    }

    private static void fillMapOfSuperNamesSEForm() {
        mapOfSuperNames.put("SEForm", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEForm() {
        properties = new ArrayList<String>();
        properties.add("roleAttribute");
        properties.add("hasOneInteractiveChild");
        properties.add("widgetAnnotsCount");
        mapOfProperties.put("SEForm", properties);
    }

    private static void fillMapOfLinksSEForm() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEForm", links);
    }

    private static void fillMapOfSuperNamesSETHead() {
        mapOfSuperNames.put("SETHead", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETHead() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETHead", properties);
    }

    private static void fillMapOfLinksSETHead() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETHead", links);
    }

    private static void fillMapOfSuperNamesSETBody() {
        mapOfSuperNames.put("SETBody", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETBody() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETBody", properties);
    }

    private static void fillMapOfLinksSETBody() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETBody", links);
    }

    private static void fillMapOfSuperNamesSETFoot() {
        mapOfSuperNames.put("SETFoot", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETFoot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETFoot", properties);
    }

    private static void fillMapOfLinksSETFoot() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETFoot", links);
    }

    private static void fillMapOfSuperNamesSEAnnot() {
        mapOfSuperNames.put("SEAnnot", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEAnnot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEAnnot", properties);
    }

    private static void fillMapOfLinksSEAnnot() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEAnnot", links);
    }

    private static void fillMapOfSuperNamesSERuby() {
        mapOfSuperNames.put("SERuby", "PDStructElem");
    }

    private static void fillMapOfPropertiesSERuby() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SERuby", properties);
    }

    private static void fillMapOfLinksSERuby() {
        links = new ArrayList<String>();
        mapOfLinks.put("SERuby", links);
    }

    private static void fillMapOfSuperNamesSEWarichu() {
        mapOfSuperNames.put("SEWarichu", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEWarichu() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWarichu", properties);
    }

    private static void fillMapOfLinksSEWarichu() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEWarichu", links);
    }

    private static void fillMapOfSuperNamesSERB() {
        mapOfSuperNames.put("SERB", "PDStructElem");
    }

    private static void fillMapOfPropertiesSERB() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SERB", properties);
    }

    private static void fillMapOfLinksSERB() {
        links = new ArrayList<String>();
        mapOfLinks.put("SERB", links);
    }

    private static void fillMapOfSuperNamesSERT() {
        mapOfSuperNames.put("SERT", "PDStructElem");
    }

    private static void fillMapOfPropertiesSERT() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SERT", properties);
    }

    private static void fillMapOfLinksSERT() {
        links = new ArrayList<String>();
        mapOfLinks.put("SERT", links);
    }

    private static void fillMapOfSuperNamesSERP() {
        mapOfSuperNames.put("SERP", "PDStructElem");
    }

    private static void fillMapOfPropertiesSERP() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SERP", properties);
    }

    private static void fillMapOfLinksSERP() {
        links = new ArrayList<String>();
        mapOfLinks.put("SERP", links);
    }

    private static void fillMapOfSuperNamesSEWT() {
        mapOfSuperNames.put("SEWT", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEWT() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWT", properties);
    }

    private static void fillMapOfLinksSEWT() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEWT", links);
    }

    private static void fillMapOfSuperNamesSEWP() {
        mapOfSuperNames.put("SEWP", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEWP() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEWP", properties);
    }

    private static void fillMapOfLinksSEWP() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEWP", links);
    }

    private static void fillMapOfSuperNamesSEDocumentFragment() {
        mapOfSuperNames.put("SEDocumentFragment", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEDocumentFragment() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEDocumentFragment", properties);
    }

    private static void fillMapOfLinksSEDocumentFragment() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEDocumentFragment", links);
    }

    private static void fillMapOfSuperNamesSEAside() {
        mapOfSuperNames.put("SEAside", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEAside() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEAside", properties);
    }

    private static void fillMapOfLinksSEAside() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEAside", links);
    }

    private static void fillMapOfSuperNamesSETitle() {
        mapOfSuperNames.put("SETitle", "PDStructElem");
    }

    private static void fillMapOfPropertiesSETitle() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SETitle", properties);
    }

    private static void fillMapOfLinksSETitle() {
        links = new ArrayList<String>();
        mapOfLinks.put("SETitle", links);
    }

    private static void fillMapOfSuperNamesSEFENote() {
        mapOfSuperNames.put("SEFENote", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEFENote() {
        properties = new ArrayList<String>();
        properties.add("NoteType");
        properties.add("orphanRefs");
        mapOfProperties.put("SEFENote", properties);
    }

    private static void fillMapOfLinksSEFENote() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEFENote", links);
    }

    private static void fillMapOfSuperNamesSESub() {
        mapOfSuperNames.put("SESub", "PDStructElem");
    }

    private static void fillMapOfPropertiesSESub() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SESub", properties);
    }

    private static void fillMapOfLinksSESub() {
        links = new ArrayList<String>();
        mapOfLinks.put("SESub", links);
    }

    private static void fillMapOfSuperNamesSEEm() {
        mapOfSuperNames.put("SEEm", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEEm() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEEm", properties);
    }

    private static void fillMapOfLinksSEEm() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEEm", links);
    }

    private static void fillMapOfSuperNamesSEStrong() {
        mapOfSuperNames.put("SEStrong", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEStrong() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEStrong", properties);
    }

    private static void fillMapOfLinksSEStrong() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEStrong", links);
    }

    private static void fillMapOfSuperNamesSEArtifact() {
        mapOfSuperNames.put("SEArtifact", "PDStructElem");
    }

    private static void fillMapOfPropertiesSEArtifact() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SEArtifact", properties);
    }

    private static void fillMapOfLinksSEArtifact() {
        links = new ArrayList<String>();
        mapOfLinks.put("SEArtifact", links);
    }

    private static void fillMapOfSuperNamesCosObject() {
        mapOfSuperNames.put("CosObject", "Object");
    }

    private static void fillMapOfPropertiesCosObject() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosObject", properties);
    }

    private static void fillMapOfLinksCosObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosObject", links);
    }

    private static void fillMapOfSuperNamesCosDocument() {
        mapOfSuperNames.put("CosDocument", "CosObject");
    }

    private static void fillMapOfPropertiesCosDocument() {
        properties = new ArrayList<String>();
        properties.add("nrIndirects");
        properties.add("headerVersion");
        properties.add("isOptionalContentPresent");
        properties.add("postEOFDataSize");
        properties.add("doesInfoMatchXMP");
        properties.add("firstPageID");
        properties.add("lastID");
        properties.add("firstPageIDValue");
        properties.add("lastIDValue");
        properties.add("isLinearized");
        properties.add("headerOffset");
        properties.add("header");
        properties.add("headerByte1");
        properties.add("headerByte2");
        properties.add("headerByte3");
        properties.add("headerByte4");
        properties.add("Marked");
        properties.add("Requirements");
        properties.add("NeedsRendering");
        properties.add("containsEmbeddedFiles");
        properties.add("Suspects");
        properties.add("DisplayDocTitle");
        properties.add("containsInfo");
        properties.add("containsPieceInfo");
        properties.add("MarkInfo");
        properties.add("ViewerPreferences");
        mapOfProperties.put("CosDocument", properties);
    }

    private static void fillMapOfLinksCosDocument() {
        links = new ArrayList<String>();
        links.add("EmbeddedFiles");
        links.add("xref");
        links.add("trailer");
        links.add("indirectObjects");
        links.add("document");
        links.add("doc");
        mapOfLinks.put("CosDocument", links);
    }

    private static void fillMapOfSuperNamesCosIndirect() {
        mapOfSuperNames.put("CosIndirect", "CosObject");
    }

    private static void fillMapOfPropertiesCosIndirect() {
        properties = new ArrayList<String>();
        properties.add("spacingCompliesPDFA");
        mapOfProperties.put("CosIndirect", properties);
    }

    private static void fillMapOfLinksCosIndirect() {
        links = new ArrayList<String>();
        links.add("directObject");
        mapOfLinks.put("CosIndirect", links);
    }

    private static void fillMapOfSuperNamesCosNull() {
        mapOfSuperNames.put("CosNull", "CosObject");
    }

    private static void fillMapOfPropertiesCosNull() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosNull", properties);
    }

    private static void fillMapOfLinksCosNull() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosNull", links);
    }

    private static void fillMapOfSuperNamesCosBool() {
        mapOfSuperNames.put("CosBool", "CosObject");
    }

    private static void fillMapOfPropertiesCosBool() {
        properties = new ArrayList<String>();
        properties.add("value");
        mapOfProperties.put("CosBool", properties);
    }

    private static void fillMapOfLinksCosBool() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosBool", links);
    }

    private static void fillMapOfSuperNamesCosNumber() {
        mapOfSuperNames.put("CosNumber", "CosObject");
    }

    private static void fillMapOfPropertiesCosNumber() {
        properties = new ArrayList<String>();
        properties.add("stringValue");
        properties.add("intValue");
        properties.add("realValue");
        mapOfProperties.put("CosNumber", properties);
    }

    private static void fillMapOfLinksCosNumber() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosNumber", links);
    }

    private static void fillMapOfSuperNamesCosReal() {
        mapOfSuperNames.put("CosReal", "CosNumber");
    }

    private static void fillMapOfPropertiesCosReal() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosReal", properties);
    }

    private static void fillMapOfLinksCosReal() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosReal", links);
    }

    private static void fillMapOfSuperNamesCosInteger() {
        mapOfSuperNames.put("CosInteger", "CosNumber");
    }

    private static void fillMapOfPropertiesCosInteger() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosInteger", properties);
    }

    private static void fillMapOfLinksCosInteger() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosInteger", links);
    }

    private static void fillMapOfSuperNamesCosName() {
        mapOfSuperNames.put("CosName", "CosObject");
    }

    private static void fillMapOfPropertiesCosName() {
        properties = new ArrayList<String>();
        properties.add("internalRepresentation");
        mapOfProperties.put("CosName", properties);
    }

    private static void fillMapOfLinksCosName() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosName", links);
    }

    private static void fillMapOfSuperNamesCosBM() {
        mapOfSuperNames.put("CosBM", "CosName");
    }

    private static void fillMapOfPropertiesCosBM() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosBM", properties);
    }

    private static void fillMapOfLinksCosBM() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosBM", links);
    }

    private static void fillMapOfSuperNamesCosActualText() {
        mapOfSuperNames.put("CosActualText", "CosString");
    }

    private static void fillMapOfPropertiesCosActualText() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosActualText", properties);
    }

    private static void fillMapOfLinksCosActualText() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosActualText", links);
    }

    private static void fillMapOfSuperNamesCosUnicodeName() {
        mapOfSuperNames.put("CosUnicodeName", "CosName");
    }

    private static void fillMapOfPropertiesCosUnicodeName() {
        properties = new ArrayList<String>();
        properties.add("isValidUtf8");
        properties.add("unicodeValue");
        mapOfProperties.put("CosUnicodeName", properties);
    }

    private static void fillMapOfLinksCosUnicodeName() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosUnicodeName", links);
    }

    private static void fillMapOfSuperNamesCosRenderingIntent() {
        mapOfSuperNames.put("CosRenderingIntent", "CosName");
    }

    private static void fillMapOfPropertiesCosRenderingIntent() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosRenderingIntent", properties);
    }

    private static void fillMapOfLinksCosRenderingIntent() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosRenderingIntent", links);
    }

    private static void fillMapOfSuperNamesCosFilter() {
        mapOfSuperNames.put("CosFilter", "CosName");
    }

    private static void fillMapOfPropertiesCosFilter() {
        properties = new ArrayList<String>();
        properties.add("decodeParms");
        mapOfProperties.put("CosFilter", properties);
    }

    private static void fillMapOfLinksCosFilter() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosFilter", links);
    }

    private static void fillMapOfSuperNamesCosIIFilter() {
        mapOfSuperNames.put("CosIIFilter", "CosName");
    }

    private static void fillMapOfPropertiesCosIIFilter() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosIIFilter", properties);
    }

    private static void fillMapOfLinksCosIIFilter() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosIIFilter", links);
    }

    private static void fillMapOfSuperNamesCosString() {
        mapOfSuperNames.put("CosString", "CosObject");
    }

    private static void fillMapOfPropertiesCosString() {
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("isHex");
        properties.add("containsOnlyHex");
        properties.add("hexCount");
        properties.add("containsPUA");
        mapOfProperties.put("CosString", properties);
    }

    private static void fillMapOfLinksCosString() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosString", links);
    }

    private static void fillMapOfSuperNamesCosTextString() {
        mapOfSuperNames.put("CosTextString", "CosString");
    }

    private static void fillMapOfPropertiesCosTextString() {
        properties = new ArrayList<String>();
        properties.add("unicodeValue");
        mapOfProperties.put("CosTextString", properties);
    }

    private static void fillMapOfLinksCosTextString() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosTextString", links);
    }

    private static void fillMapOfSuperNamesCosLang() {
        mapOfSuperNames.put("CosLang", "CosTextString");
    }

    private static void fillMapOfPropertiesCosLang() {
        properties = new ArrayList<String>();
        mapOfProperties.put("CosLang", properties);
    }

    private static void fillMapOfLinksCosLang() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosLang", links);
    }

    private static void fillMapOfSuperNamesCosDict() {
        mapOfSuperNames.put("CosDict", "CosObject");
    }

    private static void fillMapOfPropertiesCosDict() {
        properties = new ArrayList<String>();
        properties.add("size");
        properties.add("keysString");
        mapOfProperties.put("CosDict", properties);
    }

    private static void fillMapOfLinksCosDict() {
        links = new ArrayList<String>();
        links.add("keys");
        links.add("values");
        links.add("metadata");
        mapOfLinks.put("CosDict", links);
    }

    private static void fillMapOfSuperNamesCosStream() {
        mapOfSuperNames.put("CosStream", "CosDict");
    }

    private static void fillMapOfPropertiesCosStream() {
        properties = new ArrayList<String>();
        properties.add("Length");
        properties.add("realLength");
        properties.add("F");
        properties.add("FFilter");
        properties.add("FDecodeParms");
        properties.add("streamKeywordCRLFCompliant");
        properties.add("endstreamKeywordEOLCompliant");
        mapOfProperties.put("CosStream", properties);
    }

    private static void fillMapOfLinksCosStream() {
        links = new ArrayList<String>();
        links.add("filters");
        mapOfLinks.put("CosStream", links);
    }

    private static void fillMapOfSuperNamesCosFileSpecification() {
        mapOfSuperNames.put("CosFileSpecification", "CosDict");
    }

    private static void fillMapOfPropertiesCosFileSpecification() {
        properties = new ArrayList<String>();
        properties.add("containsEF");
        properties.add("containsDesc");
        properties.add("F");
        properties.add("UF");
        properties.add("AFRelationship");
        properties.add("isAssociatedFile");
        mapOfProperties.put("CosFileSpecification", properties);
    }

    private static void fillMapOfLinksCosFileSpecification() {
        links = new ArrayList<String>();
        links.add("EF");
        mapOfLinks.put("CosFileSpecification", links);
    }

    private static void fillMapOfSuperNamesCosTrailer() {
        mapOfSuperNames.put("CosTrailer", "CosDict");
    }

    private static void fillMapOfPropertiesCosTrailer() {
        properties = new ArrayList<String>();
        properties.add("isEncrypted");
        mapOfProperties.put("CosTrailer", properties);
    }

    private static void fillMapOfLinksCosTrailer() {
        links = new ArrayList<String>();
        links.add("Encrypt");
        links.add("Info");
        mapOfLinks.put("CosTrailer", links);
    }

    private static void fillMapOfSuperNamesCosInfo() {
        mapOfSuperNames.put("CosInfo", "CosDict");
    }

    private static void fillMapOfPropertiesCosInfo() {
        properties = new ArrayList<String>();
        properties.add("ModDate");
        properties.add("XMPModifyDate");
        properties.add("doModDatesMatch");
        properties.add("CreationDate");
        properties.add("XMPCreateDate");
        properties.add("doCreationDatesMatch");
        properties.add("Title");
        properties.add("XMPTitle");
        properties.add("Author");
        properties.add("XMPCreator");
        properties.add("XMPCreatorSize");
        properties.add("Subject");
        properties.add("XMPDescription");
        properties.add("Producer");
        properties.add("XMPProducer");
        properties.add("Creator");
        properties.add("XMPCreatorTool");
        properties.add("Keywords");
        properties.add("XMPKeywords");
        mapOfProperties.put("CosInfo", properties);
    }

    private static void fillMapOfLinksCosInfo() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosInfo", links);
    }

    private static void fillMapOfSuperNamesCosArray() {
        mapOfSuperNames.put("CosArray", "CosObject");
    }

    private static void fillMapOfPropertiesCosArray() {
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosArray", properties);
    }

    private static void fillMapOfLinksCosArray() {
        links = new ArrayList<String>();
        links.add("elements");
        mapOfLinks.put("CosArray", links);
    }

    private static void fillMapOfSuperNamesCosBBox() {
        mapOfSuperNames.put("CosBBox", "CosArray");
    }

    private static void fillMapOfPropertiesCosBBox() {
        properties = new ArrayList<String>();
        properties.add("top");
        properties.add("bottom");
        properties.add("left");
        properties.add("right");
        mapOfProperties.put("CosBBox", properties);
    }

    private static void fillMapOfLinksCosBBox() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosBBox", links);
    }

    private static void fillMapOfSuperNamesCosXRef() {
        mapOfSuperNames.put("CosXRef", "CosObject");
    }

    private static void fillMapOfPropertiesCosXRef() {
        properties = new ArrayList<String>();
        properties.add("subsectionHeaderSpaceSeparated");
        properties.add("xrefEOLMarkersComplyPDFA");
        mapOfProperties.put("CosXRef", properties);
    }

    private static void fillMapOfLinksCosXRef() {
        links = new ArrayList<String>();
        mapOfLinks.put("CosXRef", links);
    }

    private static void fillMapOfSuperNamesSAObject() {
        mapOfSuperNames.put("SAObject", "Object");
    }

    private static void fillMapOfPropertiesSAObject() {
        properties = new ArrayList<String>();
        properties.add("structureID");
        properties.add("errorCodes");
        properties.add("errorArguments");
        mapOfProperties.put("SAObject", properties);
    }

    private static void fillMapOfLinksSAObject() {
        links = new ArrayList<String>();
        mapOfLinks.put("SAObject", links);
    }

    private static void fillMapOfSuperNamesSAPDFDocument() {
        mapOfSuperNames.put("SAPDFDocument", "Object");
    }

    private static void fillMapOfPropertiesSAPDFDocument() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPDFDocument", properties);
    }

    private static void fillMapOfLinksSAPDFDocument() {
        links = new ArrayList<String>();
        links.add("pages");
        links.add("repeatedCharacters");
        links.add("lists");
        links.add("StructTreeRoot");
        mapOfLinks.put("SAPDFDocument", links);
    }

    private static void fillMapOfSuperNamesSAStructTreeRoot() {
        mapOfSuperNames.put("SAStructTreeRoot", "Object");
    }

    private static void fillMapOfPropertiesSAStructTreeRoot() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SAStructTreeRoot", properties);
    }

    private static void fillMapOfLinksSAStructTreeRoot() {
        links = new ArrayList<String>();
        links.add("children");
        mapOfLinks.put("SAStructTreeRoot", links);
    }

    private static void fillMapOfSuperNamesSAStructElem() {
        mapOfSuperNames.put("SAStructElem", "SAObject");
    }

    private static void fillMapOfPropertiesSAStructElem() {
        properties = new ArrayList<String>();
        properties.add("valueS");
        properties.add("correctSemanticScore");
        properties.add("correctType");
        properties.add("standardType");
        properties.add("isTableElem");
        properties.add("isTableChild");
        properties.add("isListElem");
        properties.add("isListChild");
        properties.add("isLeafElem");
        properties.add("parentsStandardTypes");
        properties.add("kidsStandardTypes");
        properties.add("parentStandardType");
        properties.add("hasLowestDepthError");
        properties.add("page");
        properties.add("lastPage");
        mapOfProperties.put("SAStructElem", properties);
    }

    private static void fillMapOfLinksSAStructElem() {
        links = new ArrayList<String>();
        links.add("children");
        mapOfLinks.put("SAStructElem", links);
    }

    private static void fillMapOfSuperNamesSAChunk() {
        mapOfSuperNames.put("SAChunk", "Object");
    }

    private static void fillMapOfPropertiesSAChunk() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SAChunk", properties);
    }

    private static void fillMapOfLinksSAChunk() {
        links = new ArrayList<String>();
        mapOfLinks.put("SAChunk", links);
    }

    private static void fillMapOfSuperNamesSAPage() {
        mapOfSuperNames.put("SAPage", "Object");
    }

    private static void fillMapOfPropertiesSAPage() {
        properties = new ArrayList<String>();
        mapOfProperties.put("SAPage", properties);
    }

    private static void fillMapOfLinksSAPage() {
        links = new ArrayList<String>();
        links.add("annots");
        links.add("tableBorders");
        mapOfLinks.put("SAPage", links);
    }

    private static void fillMapOfSuperNamesSAAnnotation() {
        mapOfSuperNames.put("SAAnnotation", "Object");
    }

    private static void fillMapOfPropertiesSAAnnotation() {
        properties = new ArrayList<String>();
        properties.add("textValue");
        properties.add("F");
        properties.add("Contents");
        properties.add("Alt");
        properties.add("isOutsideCropBox");
        mapOfProperties.put("SAAnnotation", properties);
    }

    private static void fillMapOfLinksSAAnnotation() {
        links = new ArrayList<String>();
        mapOfLinks.put("SAAnnotation", links);
    }

    private static void fillMapOfSuperNamesSARepeatedCharacters() {
        mapOfSuperNames.put("SARepeatedCharacters", "Object");
    }

    private static void fillMapOfPropertiesSARepeatedCharacters() {
        properties = new ArrayList<String>();
        properties.add("isNonSpace");
        properties.add("numberOfRepeatedCharacters");
        mapOfProperties.put("SARepeatedCharacters", properties);
    }

    private static void fillMapOfLinksSARepeatedCharacters() {
        links = new ArrayList<String>();
        mapOfLinks.put("SARepeatedCharacters", links);
    }

    private static void fillMapOfSuperNamesSALinkAnnotation() {
        mapOfSuperNames.put("SALinkAnnotation", "SAAnnotation");
    }

    private static void fillMapOfPropertiesSALinkAnnotation() {
        properties = new ArrayList<String>();
        properties.add("textValueIsLink");
        properties.add("contentsIsLink");
        properties.add("altIsLink");
        mapOfProperties.put("SALinkAnnotation", properties);
    }

    private static void fillMapOfLinksSALinkAnnotation() {
        links = new ArrayList<String>();
        mapOfLinks.put("SALinkAnnotation", links);
    }

    private static void fillMapOfSuperNamesSATextChunk() {
        mapOfSuperNames.put("SATextChunk", "SAChunk");
    }

    private static void fillMapOfPropertiesSATextChunk() {
        properties = new ArrayList<String>();
        properties.add("textSize");
        properties.add("contrastRatio");
        properties.add("textWeight");
        properties.add("hasSpecialStyle");
        properties.add("hasSpecialBackground");
        properties.add("isUn