/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSFilters;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosFilter;
import org.verapdf.model.coslayer.CosFilter;
import org.verapdf.model.coslayer.CosStream;

public class GFCosStream
extends GFCosDict
implements CosStream {
    private static final Logger LOGGER = Logger.getLogger(GFCosStream.class.getCanonicalName());
    public static final String FILTERS = "filters";
    public static final String COS_STREAM_TYPE = "CosStream";
    public static final String F_DECODE_PARMS = "FDecodeParms";
    private final Long length;
    private final Long realLength;
    private final String fileSpec;
    private final String fFilter;
    private final String fDecodeParams;
    private final boolean streamKeywordCRLFCompliant;
    private final boolean endstreamKeywordEOLCompliant;

    public GFCosStream(COSStream stream) {
        super(stream, COS_STREAM_TYPE);
        this.length = GFCosStream.parseLength(stream);
        COSObject fileSpec = stream.getKey(ASAtom.F);
        this.fileSpec = fileSpec.empty() ? null : fileSpec.toString();
        this.fFilter = GFCosStream.parseFilters(stream.getKey(ASAtom.F_FILTER).get());
        COSObject fDecodeParams = stream.getKey(ASAtom.F_DECODE_PARMS);
        this.fDecodeParams = fDecodeParams.empty() ? null : fDecodeParams.toString();
        this.streamKeywordCRLFCompliant = stream.isStreamKeywordCRLFCompliant();
        this.endstreamKeywordEOLCompliant = stream.isEndstreamKeywordCRLFCompliant();
        this.realLength = stream.getRealStreamSize();
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Long getrealLength() {
        return this.realLength;
    }

    @Override
    public String getF() {
        return this.fileSpec;
    }

    @Override
    public String getFFilter() {
        return this.fFilter;
    }

    @Override
    public String getFDecodeParms() {
        return this.fDecodeParams;
    }

    @Override
    public Boolean getstreamKeywordCRLFCompliant() {
        return this.streamKeywordCRLFCompliant;
    }

    @Override
    public Boolean getendstreamKeywordEOLCompliant() {
        return this.endstreamKeywordEOLCompliant;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "filters": {
                return this.getFilters();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosFilter> getFilters() {
        COSFilters filters = ((COSStream)this.baseObject).getFilters();
        if (filters == null || filters.getFilters().isEmpty()) {
            return Collections.emptyList();
        }
        COSObject decodeParmsObject = this.baseObject.getKey(ASAtom.DECODE_PARMS);
        COSBase decodeParms = null;
        if (decodeParmsObject != null) {
            decodeParms = decodeParmsObject.get();
        }
        ArrayList<CosFilter> result = new ArrayList<CosFilter>();
        if (filters.getFilters().size() == 1) {
            if (decodeParms instanceof COSArray) {
                decodeParms = decodeParms.at(0).get();
            }
            ASAtom filter = filters.getFilters().get(0);
            COSName filterName = (COSName)COSName.fromValue(filter);
            result.add(GFCosStream.createFilter(filterName, decodeParms));
        } else if (filters.size() > 1) {
            List<ASAtom> filtersList = filters.getFilters();
            int i = 0;
            for (ASAtom filter : filtersList) {
                if (decodeParms == null) {
                    result.add(GFCosStream.createFilter((COSName)COSName.fromValue(filter), null));
                } else if (decodeParms.getType() == COSObjType.COS_ARRAY && decodeParms.size() > i) {
                    decodeParms = decodeParms.at(i).get();
                    result.add(GFCosStream.createFilter((COSName)COSName.fromValue(filter), decodeParms));
                } else {
                    LOGGER.log(Level.FINE, "Invalid decodeParms type. Ignoring decodeParms.");
                }
                ++i;
            }
        }
        return result;
    }

    private static CosFilter createFilter(COSName filter, COSBase decodeParms) {
        if (decodeParms == null) {
            return new GFCosFilter(filter, null);
        }
        if (decodeParms instanceof COSDictionary) {
            return new GFCosFilter(filter, (COSDictionary)decodeParms);
        }
        LOGGER.log(Level.FINE, "Invalid decodeParms type. Ignoring decodeParms.");
        return new GFCosFilter(filter, null);
    }

    private static Long parseLength(COSStream stream) {
        COSBase number = stream.getKey(ASAtom.LENGTH).getDirectBase();
        return number instanceof COSNumber ? number.getInteger() : null;
    }

    private static String parseFilters(COSBase base) {
        if (base == null) {
            return null;
        }
        if (base.getType() == COSObjType.COS_NAME) {
            return base.getString();
        }
        if (base.getType() == COSObjType.COS_ARRAY) {
            StringBuilder filters = new StringBuilder();
            for (COSObject filter : (COSArray)base) {
                if (filter.getType() == COSObjType.COS_NAME) {
                    filters.append(filter.getName()).append(" ");
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Incorrect type for stream filter " + filter.getClass().getName());
            }
            return filters.substring(0, filters.length() - 1);
        }
        LOGGER.log(Level.SEVERE, "Incorrect type for stream filter " + base.getClass().getName());
        return null;
    }
}

