/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFABlackpointArray;
import org.verapdf.gf.model.impl.arlington.GFALabRangeArray;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAWhitepointArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ABlackpointArray;
import org.verapdf.model.alayer.ALabDict;
import org.verapdf.model.alayer.ALabRangeArray;
import org.verapdf.model.alayer.AWhitepointArray;
import org.verapdf.model.baselayer.Object;

public class GFALabDict
extends GFAObject
implements ALabDict {
    public GFALabDict(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ALabDict");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "BlackPoint": {
                return this.getBlackPoint();
            }
            case "Range": {
                return this.getRange();
            }
            case "WhitePoint": {
                return this.getWhitePoint();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ABlackpointArray> getBlackPoint() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getBlackPoint1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ABlackpointArray> getBlackPoint1_1() {
        COSObject object = this.getBlackPointValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFABlackpointArray> list = new ArrayList<GFABlackpointArray>(1);
            list.add(new GFABlackpointArray((COSArray)object.getDirectBase(), this.baseObject, "BlackPoint"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ALabRangeArray> getRange() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getRange1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ALabRangeArray> getRange1_1() {
        COSObject object = this.getRangeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFALabRangeArray> list = new ArrayList<GFALabRangeArray>(1);
            list.add(new GFALabRangeArray((COSArray)object.getDirectBase(), this.baseObject, "Range"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AWhitepointArray> getWhitePoint() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWhitePoint1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<AWhitepointArray> getWhitePoint1_1() {
        COSObject object = this.getWhitePointValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAWhitepointArray> list = new ArrayList<GFAWhitepointArray>(1);
            list.add(new GFAWhitepointArray((COSArray)object.getDirectBase(), this.baseObject, "WhitePoint"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsBlackPoint() {
        return this.baseObject.knownKey(ASAtom.getASAtom("BlackPoint"));
    }

    public COSObject getBlackPointValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("BlackPoint"));
        return object;
    }

    @Override
    public String getBlackPointType() {
        COSObject BlackPoint = this.getBlackPointValue();
        return this.getObjectType(BlackPoint);
    }

    @Override
    public Boolean getBlackPointHasTypeArray() {
        COSObject BlackPoint = this.getBlackPointValue();
        return GFALabDict.getHasTypeArray(BlackPoint);
    }

    @Override
    public Boolean getcontainsRange() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Range"));
    }

    public COSObject getRangeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Range"));
        return object;
    }

    @Override
    public String getRangeType() {
        COSObject Range = this.getRangeValue();
        return this.getObjectType(Range);
    }

    @Override
    public Boolean getRangeHasTypeArray() {
        COSObject Range = this.getRangeValue();
        return GFALabDict.getHasTypeArray(Range);
    }

    @Override
    public Boolean getcontainsWhitePoint() {
        return this.baseObject.knownKey(ASAtom.getASAtom("WhitePoint"));
    }

    public COSObject getWhitePointValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("WhitePoint"));
        return object;
    }

    @Override
    public String getWhitePointType() {
        COSObject WhitePoint = this.getWhitePointValue();
        return this.getObjectType(WhitePoint);
    }

    @Override
    public Boolean getWhitePointHasTypeArray() {
        COSObject WhitePoint = this.getWhitePointValue();
        return GFALabDict.getHasTypeArray(WhitePoint);
    }
}

