/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDAnnot;
import org.verapdf.gf.model.impl.pd.GFPDDestination;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.pdlayer.PDLinkAnnot;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDDestination;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.StaticResources;

public class GFPDLinkAnnot
extends GFPDAnnot
implements PDLinkAnnot {
    public static final Logger LOGGER = Logger.getLogger(GFPDLinkAnnot.class.getCanonicalName());
    public static final String LINK_ANNOTATION_TYPE = "PDLinkAnnot";
    public static final String DEST = "Dest";
    private String differentTargetAnnotObjectKey;
    private String sameTargetAnnotObjectKey;

    public GFPDLinkAnnot(PDAnnotation annot, PDResourcesHandler pageResources, PDPage page) {
        super(annot, pageResources, page, LINK_ANNOTATION_TYPE);
        if (PDFFlavours.isPDFUA2RelatedFlavour(StaticContainers.getFlavour())) {
            this.calculateStructDestinationProperties();
        }
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Dest": {
                return this.getDestination();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDDestination> getDestination() {
        COSObject destination = ((PDAnnotation)this.simplePDObject).getDestination();
        if (!destination.empty() && !this.simplePDObject.knownKey(ASAtom.A)) {
            ArrayList<GFPDDestination> destinations = new ArrayList<GFPDDestination>(1);
            destinations.add(new GFPDDestination(new PDDestination(destination)));
            return Collections.unmodifiableList(destinations);
        }
        return Collections.emptyList();
    }

    private void calculateStructDestinationProperties() {
        COSObject parent = this.getParentDictionary();
        if (parent == null || parent.getKey() == null) {
            return;
        }
        COSKey structParentKey = parent.getKey();
        COSObject structDestination = this.getStructureDestinationObject();
        if (structDestination == null || structDestination.getKey() == null) {
            return;
        }
        COSKey structDestinationKey = structDestination.getKey();
        Set structParentsSet = StaticContainers.getDestinationToStructParentsMap().computeIfAbsent(structDestinationKey, k -> new HashSet());
        for (COSKey cOSKey : structParentsSet) {
            if (structParentKey.equals(cOSKey)) continue;
            this.sameTargetAnnotObjectKey = cOSKey.toString();
            break;
        }
        for (Map.Entry entry : StaticContainers.getDestinationToStructParentsMap().entrySet()) {
            if (structDestinationKey.equals(entry.getKey())) continue;
            for (COSKey structParentObjectKey : (Set)entry.getValue()) {
                if (!structParentKey.equals(structParentObjectKey)) continue;
                this.differentTargetAnnotObjectKey = structParentObjectKey.toString();
                break;
            }
            if (this.differentTargetAnnotObjectKey == null) continue;
            break;
        }
        structParentsSet.add(structParentKey);
    }

    private COSObject getStructureDestinationObject() {
        COSObject dests;
        COSObject destination = this.simpleCOSObject;
        if (this.simpleCOSObject.knownKey(ASAtom.A).booleanValue()) {
            PDAction action = ((PDAnnotation)this.simplePDObject).getA();
            if (ASAtom.GO_TO.equals(action.getSubtype())) {
                destination = action.getDestination();
            }
        } else if (this.simpleCOSObject.knownKey(ASAtom.DEST).booleanValue()) {
            destination = ((PDAnnotation)this.simplePDObject).getDestination();
        }
        if (destination == null) {
            return null;
        }
        if (destination.getType() == COSObjType.COS_STRING) {
            PDNamesDictionary namesDictionary = StaticResources.getDocument().getCatalog().getNamesDictionary();
            if (namesDictionary == null) {
                return null;
            }
            PDNameTreeNode dests2 = namesDictionary.getDests();
            if (dests2 != null) {
                COSObject dest = dests2.getObject(destination.getString());
                if (dest == null) {
                    LOGGER.log(Level.WARNING, "Named destination " + destination.getString() + " not found in the Dests name tree in the Names dictionary");
                    return null;
                }
                destination = dest;
            }
        } else if (destination.getType() == COSObjType.COS_NAME && (dests = StaticResources.getDocument().getCatalog().getDests()) != null) {
            COSObject dest = dests.getKey(destination.getName());
            if (dest == null) {
                LOGGER.log(Level.WARNING, "Named destination " + destination.getName() + " not found in the Dests dictionary in the catalog");
                return null;
            }
            destination = dest;
        }
        if (destination.getType() == COSObjType.COS_DICT) {
            return destination.getKey(ASAtom.SD);
        }
        if (destination.getType() == COSObjType.COS_ARRAY && destination.size() > 0) {
            return destination.at(0).getKey(ASAtom.S);
        }
        return null;
    }

    @Override
    public String getdifferentTargetAnnotObjectKey() {
        return this.differentTargetAnnotObjectKey;
    }

    @Override
    public String getsameTargetAnnotObjectKey() {
        return this.sameTargetAnnotObjectKey;
    }
}

