/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.foundry;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.extensions.ExtensionObjectType;
import org.verapdf.gf.model.GFModelParser;
import org.verapdf.metadata.fixer.gf.GFMetadataFixerImpl;
import org.verapdf.pdfa.AbstractFoundry;
import org.verapdf.pdfa.MetadataFixer;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;

class VeraFoundry
extends AbstractFoundry {
    private static final ReleaseDetails greenfieldDetails = ReleaseDetails.addDetailsFromResource("org/verapdf/release/validation-model.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/foundry#verapdf");
    private static final ComponentDetails details = Components.veraDetails(id, "VeraPDF Foundry", greenfieldDetails.getVersion(), "veraPDF greenfield foundry instance.");
    private static final VeraPDFFoundry instance = new VeraFoundry();

    private VeraFoundry() {
    }

    @Override
    public ComponentDetails getDetails() {
        return details;
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream) throws ModelParsingException, EncryptedPdfException {
        return this.createParser(pdfStream, PDFAFlavour.NO_FLAVOUR);
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfStream, flavour);
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfStream, flavour, defaultFlavour);
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream, PDFAFlavour flavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfStream, flavour, password);
    }

    @Override
    public PDFAParser createParser(InputStream pdfStream, PDFAFlavour flavour, PDFAFlavour defaultFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(pdfStream, flavour, defaultFlavour, password, enabledExtensions);
    }

    @Override
    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(file, pdfaFlavour);
    }

    @Override
    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour, PDFAFlavour defaultPdfaFlavour) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(file, pdfaFlavour, defaultPdfaFlavour);
    }

    @Override
    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour, String password) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(file, pdfaFlavour, password);
    }

    @Override
    public PDFAParser createParser(File file, PDFAFlavour pdfaFlavour, PDFAFlavour defaultPdfaFlavour, String password, EnumSet<ExtensionObjectType> enabledExtensions) throws ModelParsingException, EncryptedPdfException {
        return GFModelParser.createModelWithFlavour(file, pdfaFlavour, defaultPdfaFlavour, password, enabledExtensions);
    }

    @Override
    public PDFAParser createParser(File file) throws ModelParsingException, EncryptedPdfException {
        return this.createParser(file, PDFAFlavour.NO_FLAVOUR);
    }

    @Override
    public MetadataFixer createMetadataFixer() {
        return new GFMetadataFixerImpl();
    }

    @Override
    public String getParserId() {
        return "GreenField";
    }

    public static ReleaseDetails getReleaseDetails() {
        return greenfieldDetails;
    }

    static VeraPDFFoundry getInstance() {
        return instance;
    }
}

