/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.ACryptFilterPublicKey;
import org.verapdf.model.baselayer.Object;

public class GFACryptFilterPublicKey
extends GFAObject
implements ACryptFilterPublicKey {
    public GFACryptFilterPublicKey(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACryptFilterPublicKey");
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Recipients": {
                return this.getRecipients();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStringsByte> getRecipients() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getRecipients1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients1_5() {
        COSObject object = this.getRecipientsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSArray)object.getDirectBase(), this.baseObject, "Recipients"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsAuthEvent() {
        return this.baseObject.knownKey(ASAtom.getASAtom("AuthEvent"));
    }

    public COSObject getAuthEventDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("DocOpen");
            }
        }
        return null;
    }

    public COSObject getAuthEventValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("AuthEvent"));
        if (object == null || object.empty()) {
            object = this.getAuthEventDefaultValue();
        }
        return object;
    }

    @Override
    public String getAuthEventType() {
        COSObject AuthEvent = this.getAuthEventValue();
        return this.getObjectType(AuthEvent);
    }

    @Override
    public Boolean getAuthEventHasTypeName() {
        COSObject AuthEvent = this.getAuthEventValue();
        return GFACryptFilterPublicKey.getHasTypeName(AuthEvent);
    }

    @Override
    public String getAuthEventNameValue() {
        COSObject AuthEvent = this.getAuthEventValue();
        return GFACryptFilterPublicKey.getNameValue(AuthEvent);
    }

    @Override
    public Boolean getcontainsCFM() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CFM"));
    }

    public COSObject getCFMDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct("None");
            }
        }
        return null;
    }

    public COSObject getCFMValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CFM"));
        if (object == null || object.empty()) {
            object = this.getCFMDefaultValue();
        }
        return object;
    }

    @Override
    public String getCFMType() {
        COSObject CFM = this.getCFMValue();
        return this.getObjectType(CFM);
    }

    @Override
    public Boolean getCFMHasTypeName() {
        COSObject CFM = this.getCFMValue();
        return GFACryptFilterPublicKey.getHasTypeName(CFM);
    }

    @Override
    public String getCFMNameValue() {
        COSObject CFM = this.getCFMValue();
        return GFACryptFilterPublicKey.getNameValue(CFM);
    }

    @Override
    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom("EncryptMetadata"));
    }

    public COSObject getEncryptMetadataDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct(true);
            }
        }
        return null;
    }

    public COSObject getEncryptMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("EncryptMetadata"));
        if (object == null || object.empty()) {
            object = this.getEncryptMetadataDefaultValue();
        }
        return object;
    }

    @Override
    public String getEncryptMetadataType() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return this.getObjectType(EncryptMetadata);
    }

    @Override
    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject EncryptMetadata = this.getEncryptMetadataValue();
        return GFACryptFilterPublicKey.getHasTypeBoolean(EncryptMetadata);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        return object;
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFACryptFilterPublicKey.getHasTypeInteger(Length);
    }

    @Override
    public Long getLengthIntegerValue() {
        COSObject Length = this.getLengthValue();
        return GFACryptFilterPublicKey.getIntegerValue(Length);
    }

    @Override
    public Boolean getcontainsRecipients() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Recipients"));
    }

    public COSObject getRecipientsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Recipients"));
        return object;
    }

    @Override
    public String getRecipientsType() {
        COSObject Recipients = this.getRecipientsValue();
        return this.getObjectType(Recipients);
    }

    @Override
    public Boolean getRecipientsHasTypeArray() {
        COSObject Recipients = this.getRecipientsValue();
        return GFACryptFilterPublicKey.getHasTypeArray(Recipients);
    }

    @Override
    public Boolean getRecipientsHasTypeStringByte() {
        COSObject Recipients = this.getRecipientsValue();
        return GFACryptFilterPublicKey.getHasTypeStringByte(Recipients);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFACryptFilterPublicKey.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFACryptFilterPublicKey.getNameValue(Type2);
    }
}

