/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFACIDSystemInfo;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.ACIDSystemInfo;
import org.verapdf.model.alayer.ACMapStream;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AStream;

public class GFACMapStream
extends GFAObject
implements ACMapStream {
    public GFACMapStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACMapStream");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "CIDSystemInfo": {
                return this.getCIDSystemInfo();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "UseCMap": {
                return this.getUseCMap();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACIDSystemInfo> getCIDSystemInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCIDSystemInfo1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<ACIDSystemInfo> getCIDSystemInfo1_2() {
        COSObject object = this.getCIDSystemInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACIDSystemInfo> list = new ArrayList<GFACIDSystemInfo>(1);
            list.add(new GFACIDSystemInfo((COSDictionary)object.getDirectBase(), this.baseObject, "CIDSystemInfo"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getDecodeParms1_2();
            }
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_2() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_2(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_2(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getF1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_2() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSDictionary)object.getDirectBase(), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getFDecodeParms1_2();
            }
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_2() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_2(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_2(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSArray)object.getDirectBase(), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFFilter1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_2() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFilter1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_2() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSArray)object.getDirectBase(), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getUseCMap() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getUseCMap1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getUseCMap1_2() {
        COSObject object = this.getUseCMapValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "UseCMap"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCIDSystemInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CIDSystemInfo"));
    }

    public COSObject getCIDSystemInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CIDSystemInfo"));
        return object;
    }

    @Override
    public String getCIDSystemInfoType() {
        COSObject CIDSystemInfo2 = this.getCIDSystemInfoValue();
        return this.getObjectType(CIDSystemInfo2);
    }

    @Override
    public Boolean getCIDSystemInfoHasTypeDictionary() {
        COSObject CIDSystemInfo2 = this.getCIDSystemInfoValue();
        return GFACMapStream.getHasTypeDictionary(CIDSystemInfo2);
    }

    @Override
    public Boolean getcontainsCMapName() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CMapName"));
    }

    public COSObject getCMapNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CMapName"));
        return object;
    }

    @Override
    public String getCMapNameType() {
        COSObject CMapName = this.getCMapNameValue();
        return this.getObjectType(CMapName);
    }

    @Override
    public Boolean getCMapNameHasTypeName() {
        COSObject CMapName = this.getCMapNameValue();
        return GFACMapStream.getHasTypeName(CMapName);
    }

    @Override
    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DL"));
        return object;
    }

    @Override
    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    @Override
    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFACMapStream.getHasTypeInteger(DL);
    }

    @Override
    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFACMapStream.getIntegerValue(DL);
    }

    @Override
    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DecodeParms"));
        return object;
    }

    @Override
    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFACMapStream.getHasTypeArray(DecodeParms);
    }

    @Override
    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFACMapStream.getHasTypeDictionary(DecodeParms);
    }

    @Override
    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFACMapStream.getArraySize(DecodeParms);
    }

    @Override
    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom("F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("F"));
        return object;
    }

    @Override
    public String getFType() {
        COSObject F2 = this.getFValue();
        return this.getObjectType(F2);
    }

    @Override
    public Boolean getFHasTypeDictionary() {
        COSObject F2 = this.getFValue();
        return GFACMapStream.getHasTypeDictionary(F2);
    }

    @Override
    public Boolean getFHasTypeString() {
        COSObject F2 = this.getFValue();
        return GFACMapStream.getHasTypeString(F2);
    }

    @Override
    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FDecodeParms"));
        return object;
    }

    @Override
    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFACMapStream.getHasTypeArray(FDecodeParms);
    }

    @Override
    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFACMapStream.getHasTypeDictionary(FDecodeParms);
    }

    @Override
    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFACMapStream.getArraySize(FDecodeParms);
    }

    @Override
    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("FFilter"));
        return object;
    }

    @Override
    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFACMapStream.getHasTypeArray(FFilter);
    }

    @Override
    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFACMapStream.getHasTypeName(FFilter);
    }

    @Override
    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFACMapStream.getNameValue(FFilter);
    }

    @Override
    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFACMapStream.getArraySize(FFilter);
    }

    @Override
    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Filter"));
        return object;
    }

    @Override
    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFACMapStream.getHasTypeArray(Filter2);
    }

    @Override
    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFACMapStream.getHasTypeName(Filter2);
    }

    @Override
    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFACMapStream.getNameValue(Filter2);
    }

    @Override
    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFACMapStream.getArraySize(Filter2);
    }

    @Override
    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Length"));
        return object;
    }

    @Override
    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    @Override
    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFACMapStream.getHasTypeInteger(Length);
    }

    @Override
    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
        return object;
    }

    @Override
    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    @Override
    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFACMapStream.getHasTypeName(Type2);
    }

    @Override
    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFACMapStream.getNameValue(Type2);
    }

    @Override
    public Boolean getcontainsUseCMap() {
        return this.baseObject.knownKey(ASAtom.getASAtom("UseCMap"));
    }

    public COSObject getUseCMapValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("UseCMap"));
        return object;
    }

    @Override
    public Boolean getisUseCMapIndirect() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFACMapStream.getisIndirect(UseCMap);
    }

    @Override
    public String getUseCMapType() {
        COSObject UseCMap = this.getUseCMapValue();
        return this.getObjectType(UseCMap);
    }

    @Override
    public Boolean getUseCMapHasTypeName() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFACMapStream.getHasTypeName(UseCMap);
    }

    @Override
    public Boolean getUseCMapHasTypeStream() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFACMapStream.getHasTypeStream(UseCMap);
    }

    @Override
    public String getUseCMapNameValue() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFACMapStream.getNameValue(UseCMap);
    }

    @Override
    public Boolean getcontainsWMode() {
        return this.baseObject.knownKey(ASAtom.getASAtom("WMode"));
    }

    public COSObject getWModeDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct(0L);
            }
        }
        return null;
    }

    public COSObject getWModeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("WMode"));
        if (object == null || object.empty()) {
            object = this.getWModeDefaultValue();
        }
        return object;
    }

    @Override
    public String getWModeType() {
        COSObject WMode = this.getWModeValue();
        return this.getObjectType(WMode);
    }

    @Override
    public Boolean getWModeHasTypeInteger() {
        COSObject WMode = this.getWModeValue();
        return GFACMapStream.getHasTypeInteger(WMode);
    }

    @Override
    public Long getWModeIntegerValue() {
        COSObject WMode = this.getWModeValue();
        return GFACMapStream.getIntegerValue(WMode);
    }
}

